/*
 * Decompiled with CFR 0.152.
 */
public class Actor {
    public int m_posX;
    public int m_posY;
    public int m_OriPosX;
    public int m_OriPosY;
    public int m_destPosX;
    public int m_destPosY;
    public long m_TimeCount;
    public long m_TimeCount2;
    public int m_speed;
    public int m_vX;
    public int m_vY;
    public int m_tag1;
    public int m_tag2;
    public int m_tag3;
    public int m_tag4;
    public int m_tag5;
    public int m_tag6;
    public int m_tag7;
    public int m_tag8;
    public int m_tag9;
    public int m_type;
    public boolean m_visible = true;
    public int m_freeType;
    public int m_idInPool;
    public int m_palette;
    public boolean m_isActive;
    public int m_animationId;
    public int m_actionId;
    public int m_crtAFrame;
    public boolean m_isAnimFinished;
    public int m_crtAFrameTime;
    public boolean m_isNeedLoop = true;
    public static int[] SNOW_PAD_USED_FLAG = new int[5];
    public static int[] SNOW_PAD_MAP = new int[]{130, 8200, 516, 2049, 1040};
    public static int[] animalPlaceGoal = new int[4];
    public int[] m_extraParams;

    public void resetActor() {
        this.m_posX = 160;
        this.m_posY = 120;
        this.m_vY = 0;
        this.m_vX = 0;
        this.m_type = 0;
        this.m_palette = 0;
        this.m_animationId = -1;
        this.m_actionId = -1;
        this.m_extraParams = null;
        this.m_visible = true;
    }

    public void initActor(int iType, int param1, int param2, int param3, int param4) {
        this.m_type = iType;
        this.m_tag6 = 0;
        this.m_tag5 = 0;
        this.m_tag4 = 0;
        this.m_tag3 = 0;
        this.m_tag2 = 0;
        this.m_tag1 = 0;
        if (this.m_type == 1) {
            // empty if block
        }
        if (this.m_type == 2) {
            this.initSnowActor();
        } else if (this.m_type == 3) {
            this.initNumHunterBall(param1, param2, param3, param4);
        } else if (this.m_type == 4) {
            this.initOpenSeasonAnimal(param1, param2, param3, param4);
        } else if (this.m_type == 5) {
            this.initOpenSeasonBosk(param1, param2, param3, param4);
        } else if (this.m_type == 6) {
            this.initRacerCar();
        } else if (this.m_type == 7) {
            this.initAnimalCount(param1, param2, param3);
        } else if (this.m_type == 8) {
            this.initFrog(param1, param2, param3, param4);
        } else if (this.m_type == 9) {
            this.initFly(param1, param2, param3);
        } else if (this.m_type == 10) {
            this.initNumOrderBall(param1, param2, param3, param4);
        } else if (this.m_type == 11) {
            this.initLetter(param1, param2, param3, param4);
        } else if (13 == this.m_type) {
            this.initButterFly(param1, param2);
        }
    }

    public void setPosition(int iX, int iY) {
        this.m_posX = iX;
        this.m_posY = iY;
    }

    public void initLetter(int str, int speed, int num, int length) {
        this.m_tag1 = str;
        int add = Util.math_rand(0, 100) < 50 ? 1 : -1;
        this.m_tag2 = add * Util.math_rand3(speed * 4096 / 3, speed * 4096);
        this.m_tag3 = Util.math_rand3(0, 1474560);
        int r_step = Util.I2F(50) / length;
        this.m_tag4 = r_step * (num + 1);
        this.getLetterPosition(this.m_tag3);
    }

    public void getLetterPosition(int angle) {
        this.m_posX = Define.LETTER_CENTER_X + this.m_tag4 * Util.math_cos(angle) / 4096;
        this.m_posY = Define.LETTER_CENTER_Y + this.m_tag4 * Util.math_sin(angle) / 4096;
    }

    public void updateLetter() {
        int angleAdd = (int)Game.s_lastFrameCostTime * this.m_tag2 / 1000;
        this.m_tag3 += angleAdd;
        this.m_tag3 %= 0x200000;
        this.getLetterPosition(this.m_tag3);
    }

    public void drawLetter() {
        Game.DrawMultiText(new Character((char)this.m_tag1).toString(), Util.F2I(this.m_posX), Util.F2I(this.m_posY), 20496, 0);
    }

    public void initButterFly(int id, int width) {
        this.m_tag5 = width - 3;
        this.getButterFlyDest(this.m_tag5);
        this.m_posX = this.m_destPosX;
        this.m_posY = this.m_destPosY;
        this.m_speed = Util.math_rand3(Util.I2F(3) / 2, Util.I2F(3));
        this.setAnim(67, 0 + id);
    }

    public void updateButterFly() {
        if (this.m_tag4 == 0) {
            if (this.GoToBySpeed()) {
                this.m_tag4 = 1;
            }
        } else if (this.m_tag4 <= 3) {
            ++this.m_tag4;
        } else {
            this.getButterFlyDest(this.m_tag5);
        }
    }

    public void getButterFlyDest(int width) {
        this.m_destPosX = Util.I2F(Util.math_rand3(Define.BUTTERFLY_AREA[width][0], 320 - Define.BUTTERFLY_AREA[width][0]));
        this.m_destPosY = Util.I2F(Util.math_rand3(Define.BUTTERFLY_AREA[width][1], Define.BUTTERFLY_AREA[width][2]));
        this.m_tag4 = 0;
        this.m_tag1 = this.m_destPosX > this.m_posX ? 1 : 0;
    }

    public void drawButterFly() {
        this.drawAnimation(Util.F2I(this.m_posX), Util.F2I(this.m_posY), this.m_tag1);
    }

    public void initFrog(int id, int posX, int posY, int keybinding) {
        this.m_tag1 = id;
        this.m_tag2 = keybinding;
        this.m_posX = posX;
        this.m_posY = posY;
        this.m_tag3 = 0;
        this.m_tag4 = 0;
        this.setAnim(84, 0 + id);
    }

    public void initFly(int color, int isgoal, int id) {
        this.m_tag1 = color;
        this.m_tag2 = isgoal;
        this.m_tag3 = id;
        this.m_tag4 = 0;
        this.getFlyWrongDest();
        this.m_posX = this.m_destPosX;
        this.m_posY = this.m_destPosY;
        this.m_speed = Util.math_rand3(Util.I2F(2), Util.I2F(4));
        this.setAnim(84, 12 + this.m_tag1 * 2);
    }

    public void getFlyWrongDest() {
        this.m_destPosX = Util.I2F(Util.math_rand3(120, 220));
        this.m_destPosY = Util.I2F(Util.math_rand3(80, 160));
        this.m_tag5 = -1;
    }

    public void getFlyCorrectDest() {
        if (this.m_tag5 >= 0) {
            Game.Frog_Dest[this.m_tag5] = 0;
            this.m_tag5 = -1;
        }
        int maxCorrectDest = 2;
        if (Game.s_CurLevel >= 33) {
            maxCorrectDest = 3;
        }
        if (Game.s_CurLevel >= 66) {
            maxCorrectDest = 4;
        }
        int destNum = 0;
        for (int i2 = 0; i2 < maxCorrectDest; ++i2) {
            destNum += Game.Frog_Dest[i2];
        }
        if (destNum == maxCorrectDest) {
            this.getFlyWrongDest();
        } else {
            int dest = 0;
            while (Game.Frog_Dest[dest = Util.math_rand3(0, maxCorrectDest - 1)] == 1) {
            }
            this.m_destPosX = Define.FrogGoalPoint[dest * 2];
            this.m_destPosY = Define.FrogGoalPoint[dest * 2 + 1];
            Game.Frog_Dest[dest] = 1;
            this.m_tag5 = dest;
        }
    }

    public void updateFrog() {
        if (this.m_actionId == 0 + this.m_tag1) {
            if (this.m_tag4 == 1) {
                this.setAction(8 + this.m_tag1);
            } else {
                boolean isFlyToEat = false;
                for (int i2 = 0; i2 < Game.s_actPool1.m_actorsInUsing.size(); ++i2) {
                    Actor tmp = (Actor)Game.s_actPool1.m_actorsInUsing.elementAt(i2);
                    if (tmp.m_tag5 != this.m_tag1 || tmp.m_posX != tmp.m_destPosX || tmp.m_posY != tmp.m_destPosY) continue;
                    this.setAction(4 + this.m_tag1);
                    this.m_tag3 = tmp.m_tag1;
                    Game.Frog_Dest[tmp.m_tag5] = 0;
                    for (int j = 0; j < Game.Frog_Eated[this.m_tag1].length; ++j) {
                        if (Game.Frog_Eated[this.m_tag1][j] >= 0) continue;
                        Game.Frog_Eated[this.m_tag1][j] = tmp.m_tag3;
                        break;
                    }
                    tmp.m_isActive = false;
                    isFlyToEat = true;
                    if (tmp.m_tag3 == Game.Frog_Goal) {
                        Game.Frog_Eat_Goal = this.m_tag1;
                    }
                    break;
                }
            }
        } else {
            this.m_tag4 = 0;
        }
    }

    public boolean GoToBySpeed() {
        if (this.m_posX < this.m_destPosX) {
            this.m_posX += this.m_speed;
            if (this.m_posX > this.m_destPosX) {
                this.m_posX = this.m_destPosX;
            }
        }
        if (this.m_posX > this.m_destPosX) {
            this.m_posX -= this.m_speed;
            if (this.m_posX < this.m_destPosX) {
                this.m_posX = this.m_destPosX;
            }
        }
        if (this.m_posY < this.m_destPosY) {
            this.m_posY += this.m_speed;
            if (this.m_posY > this.m_destPosY) {
                this.m_posY = this.m_destPosY;
            }
        }
        if (this.m_posY > this.m_destPosY) {
            this.m_posY -= this.m_speed;
            if (this.m_posY < this.m_destPosY) {
                this.m_posY = this.m_destPosY;
            }
        }
        return this.m_posX == this.m_destPosX && this.m_posY == this.m_destPosY;
    }

    public void updateFly() {
        if (this.m_tag4 == 0) {
            if (this.GoToBySpeed()) {
                this.m_tag4 = 1;
            }
        } else if (this.m_tag4 == 1) {
            ++this.m_tag4;
            if (this.m_tag5 < 0 && Util.math_rand3(0, 100) < Game.Frog_Level_Info[Game.s_CurLevel][3]) {
                int maxCorrectDest = 2;
                if (Game.s_CurLevel >= 33) {
                    maxCorrectDest = 3;
                } else if (Game.s_CurLevel >= 66) {
                    maxCorrectDest = 4;
                }
                int id = Util.math_rand3(0, maxCorrectDest - 1);
                Actor tmpFrog = (Actor)Game.s_actPool2.m_actorsInUsing.elementAt(id);
                tmpFrog.m_tag4 = 1;
            }
        } else if (this.m_tag4 <= 3) {
            ++this.m_tag4;
        } else {
            this.m_tag4 = 0;
            if (Util.math_rand3(0, 100) < Game.Frog_Level_Info[Game.s_CurLevel][2]) {
                this.getFlyCorrectDest();
            } else if (Game.Frog_Level_Info[Game.s_CurLevel][2] > 1 && Game.s_actPool1.m_actorsInUsing.size() == 1) {
                this.getFlyCorrectDest();
            } else {
                this.getFlyWrongDest();
            }
        }
    }

    public void drawFrog() {
        block16: {
            int offy;
            int offx;
            block17: {
                block19: {
                    block18: {
                        if (this.m_actionId != 22 + this.m_tag1) {
                            if ((4 + this.m_tag1 == this.m_actionId || 8 + this.m_tag1 == this.m_actionId) && this.m_isAnimFinished) {
                                this.setAction(0 + this.m_tag1);
                            }
                            Game.s_sprites[this.m_animationId].setCurrentPalette(this.m_tag3);
                        } else {
                            Game.s_sprites[this.m_animationId].setCurrentPalette(Game.Frog_Goal_Color);
                        }
                        this.drawAnimation(Util.F2I(this.m_posX), Util.F2I(this.m_posY));
                        if (Game.s_miniGameState == 3 && Game.s_gameLevelResult == 0 || Game.s_gameLevelResult != 0 && Game.Open_Season_Choosed == this.m_tag1) {
                            offx = 0;
                            offy = -10;
                            int action = 1;
                            if (this.m_tag1 == 0) {
                                action = 2;
                                offx = 20;
                                offy = 10;
                            } else if (this.m_tag1 == 1) {
                                action = 3;
                                offx = -20;
                                offy = 10;
                            } else if (this.m_tag1 == 3) {
                                action = 0;
                                offy = 30;
                            }
                            Game.DrawAnimation(83, action, Game.s_frameCount, Util.F2I(this.m_posX) + offx, Util.F2I(this.m_posY) + offy);
                        }
                        if (Game.frogResultDelay <= 0) break block16;
                        offx = 0;
                        offy = 10;
                        if (this.m_tag1 == 0) {
                            offx = -5;
                            offy = 10;
                        } else if (this.m_tag1 == 1) {
                            offx = 5;
                            offy = 10;
                        } else if (this.m_tag1 == 3) {
                            offy = 10;
                        }
                        if (this.m_tag1 != Game.Open_Season_Choosed) break block17;
                        if (Game.frogResultDelay >= 15) break block18;
                        Game.DrawAnimation(83, 14, 0L, Util.F2I(this.m_posX) + offx, Util.F2I(this.m_posY) + offy);
                        break block16;
                    }
                    if (Game.s_gameLevelResult != 1) break block19;
                    Game.DrawAnimation(83, 15, 0L, Util.F2I(this.m_posX) + offx, Util.F2I(this.m_posY) + offy);
                    break block16;
                }
                if (Game.s_gameLevelResult != -1) break block16;
                Game.DrawAnimation(83, 16, 0L, Util.F2I(this.m_posX) + offx, Util.F2I(this.m_posY) + offy);
                break block16;
            }
            if (Game.s_gameLevelResult == -1 && Game.frogResultDelay >= 15) {
                for (int i2 = 0; i2 < Game.Frog_Eated[this.m_tag1].length; ++i2) {
                    if (Game.Frog_Eated[this.m_tag1][i2] != Game.Frog_Goal) continue;
                    Game.DrawAnimation(83, 15, 0L, Util.F2I(this.m_posX) + offx, Util.F2I(this.m_posY) + offy);
                }
            }
        }
    }

    public void drawFly() {
        if (this.m_destPosX > this.m_posX && this.m_actionId == 13 + this.m_tag1 * 2) {
            this.setAction(12 + this.m_tag1 * 2);
        }
        if (this.m_destPosX < this.m_posX && this.m_actionId == 12 + this.m_tag1 * 2) {
            this.setAction(13 + this.m_tag1 * 2);
        }
        this.drawAnimation(Util.F2I(this.m_posX), Util.F2I(this.m_posY));
    }

    public void updateGhost() {
        int iMazeWidth = Game.mazeColCount * Game.width;
        int iMazeHeight = Game.mazeRowCount * Game.width;
        int iXS = 320 - iMazeWidth >> 1;
        int iYS = (240 - iMazeHeight >> 1) + 10;
        int iLstX = Game.s_lstCol * Game.width;
        int iLstY = Game.s_lstRow * Game.width;
        int iCrtX = Game.s_crtCol * Game.width;
        int iCrtY = Game.s_crtRow * Game.width;
        iCrtX = Game.width / 2 + iXS + iCrtX + (iLstX - iCrtX) * Game.s_mazeManMoveFrame / 4;
        iCrtY = Game.width / 2 + iYS + iCrtY + (iLstY - iCrtY) * Game.s_mazeManMoveFrame / 4;
        if (this.m_tag1 == 0) {
            boolean bTrace;
            this.m_tag1 = 1;
            int iRand = Util.math_rand(0, 100);
            boolean bl = bTrace = Util.math_rand(0, 100) < 30;
            if (iRand < 50) {
                this.m_tag2 = bTrace ? (this.m_posX < iCrtX ? 1 : -1) : (Util.math_rand(0, 100) >= 50 ? 1 : -1);
                this.m_tag3 = 0;
            } else {
                this.m_tag2 = 0;
                this.m_tag3 = bTrace ? (this.m_posY < iCrtY ? 1 : -1) : (Util.math_rand(0, 100) >= 50 ? 1 : -1);
            }
            this.m_tag4 = Util.math_rand(1000, 2000);
        }
        if (this.m_tag1 == 1) {
            this.m_tag4 = (int)((long)this.m_tag4 - Game.s_lastFrameCostTime);
            if (this.m_tag4 <= 0) {
                this.m_tag1 = 0;
            }
            if (this.m_tag2 == -1 && this.m_posX <= iXS + 16 || this.m_tag2 == 1 && this.m_posX >= iXS + iMazeWidth - 16) {
                this.m_tag1 = 0;
            }
            if (this.m_tag3 == -1 && this.m_posY <= iYS + 16 || this.m_tag3 == 1 && this.m_posY >= iYS + iMazeHeight - 16) {
                this.m_tag1 = 0;
            }
            if (this.m_tag1 == 1) {
                this.m_posX += this.m_tag2 * 2;
                this.m_posY += this.m_tag3 * 2;
            }
        }
        if ((iCrtX - this.m_posX) * (iCrtX - this.m_posX) + (iCrtY - this.m_posY) * (iCrtY - this.m_posY) < Game.width * Game.width / 3) {
            Game.s_gameLevelResult = -1;
            Game.switchSubState(11);
        }
    }

    public void drawGhost() {
        this.drawAnimation(this.m_posX, this.m_posY);
    }

    public void initRacerCar() {
        this.m_posY = 0x2004000;
        this.m_posX = 160;
        this.m_vY = 0;
    }

    public void updateRacerCar() {
        if (this.m_vY != this.m_tag2) {
            int iDV = (int)((long)this.m_tag1 * Game.s_lastFrameCostTime) / 1000;
            this.m_vY = Util.approach(this.m_vY, iDV, this.m_tag2);
        }
        this.m_posY = (int)((long)this.m_posY + (long)this.m_vY * Game.s_lastFrameCostTime / 1000L);
    }

    public void drawRacerCar() {
        int iY = Game.racerMY2SY(this.m_posY);
        if (iY > 240) {
            return;
        }
        if (iY < -40) {
            return;
        }
        if (this.m_posX == 160) {
            Game.DrawAnimation(53, 0, Game.getCrtStateFrame(), this.m_posX, iY);
        } else {
            Game.DrawAnimation(53, 3, Game.getCrtStateFrame(), this.m_posX, iY);
        }
    }

    public void initAnimalCount(int type, int Y, int LorR) {
        this.m_tag1 = type;
        this.m_OriPosY = this.m_destPosY = Y;
        this.m_posY = this.m_destPosY;
        this.m_OriPosX = LorR == 0 ? Util.I2F(-30) : Util.I2F(350);
        this.m_posX = this.m_OriPosX;
        this.m_destPosX = LorR == 1 ? Util.I2F(-30) : Util.I2F(350);
        this.m_isActive = true;
        this.m_TimeCount = 0L;
        this.m_tag3 = Util.math_rand3(Game.Animal_Count_Level_Info[Game.s_CurLevel][2], Game.Animal_Count_Level_Info[Game.s_CurLevel][1]);
        if (this.m_posX < 0) {
            this.setAnim(82, Define.AnimalCountAction[this.m_tag1 * 2]);
        } else {
            this.setAnim(82, Define.AnimalCountAction[this.m_tag1 * 2 + 1]);
        }
    }

    public void drawAnimalCount() {
        this.drawAnimation(Util.F2I(this.m_posX), Util.F2I(this.m_posY));
    }

    public void updateAnimalCount() {
        if (this.GoTo(this.m_tag3, this.m_destPosX, this.m_destPosY)) {
            this.m_isActive = false;
        }
    }

    public void initSnowActor() {
    }

    public void drawSnow() {
        Game.s_sprites[39].m_crtAlpha = Game.s_snowAlpha;
        Game.s_sprites[39].paintFrame(Game.s_g, this.m_actionId + 0, this.m_posX, this.m_posY, 0);
    }

    public void updateSnow() {
    }

    public void initNumOrderBall(int pos, int color, int num, int pos2) {
        int l = Game.Number_Order_w * 30 + (Game.Number_Order_w - 1) * 4 - 30;
        int x = 160 - l / 2;
        if (Game.Number_Order_h == 1 || pos < Game.Number_Order_w) {
            this.m_posX = x + pos * 34;
            this.m_posY = 105;
        } else {
            this.m_posX = x + (pos - Game.Number_Order_w) * 34;
            this.m_posY = 140;
        }
        this.m_tag1 = color;
        this.m_tag2 = num;
        this.m_tag3 = pos;
        if (this.m_tag2 <= 18 && this.m_tag2 > 1 && Util.math_rand3(0, 100) < 30 && Game.s_CurLevel >= 10) {
            this.m_tag4 = 1;
            do {
                this.m_tag5 = Util.math_rand3(1, this.m_tag2 - 1);
            } while (this.m_tag2 - this.m_tag5 > 9 || this.m_tag5 > 9);
            this.m_tag6 = this.m_tag2 - this.m_tag5;
        } else {
            this.m_tag4 = 0;
        }
        this.setAnim(78, 2);
    }

    public void initNumHunterBall(int pos, int color, int num, int pos2) {
        int l = Game.Num_Hunter_TotalBallNumber * 20 + (Game.Num_Hunter_TotalBallNumber - 1) * 4 - 20;
        int x = 160 - l / 2;
        this.m_OriPosX = this.m_posX = x + pos2 * 24;
        this.m_posY = 170;
        this.m_tag1 = color;
        this.m_tag2 = num;
        this.m_tag3 = pos;
        this.setAnim(78, 2);
    }

    public void drawBall() {
        Game.s_sprites[78].setCurrentPalette(this.m_tag1);
        if (Game.s_crtGameState == 19) {
            if (this.m_tag2 <= 18) {
                Game.s_sprites[78].paintFrame(Game.s_g, 46, this.m_posX, this.m_posY, 0);
            } else if (this.m_tag2 <= 40) {
                Game.s_sprites[78].paintFrame(Game.s_g, 45, this.m_posX, this.m_posY, 0);
            } else {
                Game.s_sprites[78].paintFrame(Game.s_g, 0, this.m_posX, this.m_posY, 0);
            }
        } else {
            Game.s_sprites[78].paintFrame(Game.s_g, 0, this.m_posX, this.m_posY, 0);
        }
        if (this.m_tag4 == 0) {
            if (this.m_tag2 < 10) {
                Game.s_sprites[78].paintFrame(Game.s_g, 1 + this.m_tag2, this.m_posX, this.m_posY, 0);
            } else {
                Game.s_sprites[78].paintFrame(Game.s_g, 11 + this.m_tag2 / 10, this.m_posX, this.m_posY, 0);
                Game.s_sprites[78].paintFrame(Game.s_g, 21 + this.m_tag2 % 10, this.m_posX, this.m_posY, 0);
            }
        } else {
            Game.s_sprites[78].paintFrame(Game.s_g, 11 + this.m_tag5, this.m_posX - 6, this.m_posY, 0);
            Game.s_sprites[78].paintFrame(Game.s_g, 21 + this.m_tag6, this.m_posX + 6, this.m_posY, 0);
            Game.s_sprites[78].paintFrame(Game.s_g, 47, this.m_posX, this.m_posY, 0);
        }
    }

    public void drawNumHunterBall() {
        if (Game.Num_Hunter_MapChoosed[this.m_tag3] == 0) {
            this.drawBall();
        } else {
            Game.s_sprites[78].setCurrentPalette(this.m_tag1);
            this.drawAnimation(this.m_posX, this.m_posY);
        }
    }

    public void updateNumHunterBall() {
    }

    public void initOpenSeasonAnimal(int type, int place, int id, int isGoal) {
        this.m_tag1 = type;
        this.m_tag2 = id;
        this.m_tag5 = isGoal;
        this.m_tag3 = Game.Open_Season_ShiftTime;
        Actor a2 = (Actor)Game.s_actPool2.m_actorsInUsing.elementAt(place);
        this.m_OriPosX = this.m_destPosX = a2.m_posX;
        this.m_posX = this.m_destPosX;
        this.m_OriPosY = this.m_destPosY = a2.m_posY;
        this.m_posY = this.m_destPosY;
        this.setAnim(82, 6 + type * 8);
        this.m_tag6 = place;
        this.m_tag7 = 0;
        this.m_tag8 = Util.math_rand3(200, 1000);
        this.m_TimeCount2 = System.currentTimeMillis();
    }

    public void setGoal() {
        do {
            this.m_tag4 = Util.math_rand3(0, Game.s_actPool2.m_actorsInUsing.size() - 1);
        } while (this.m_tag4 == this.m_tag6 || animalPlaceGoal[this.m_tag4] >= 2);
        int n = this.m_tag6;
        animalPlaceGoal[n] = animalPlaceGoal[n] - 1;
        if (Util.math_rand3(0, 100) < Game.Open_Season_Runback / Game.s_actPool1.m_actorsInUsing.size()) {
            this.m_tag7 = 1;
        }
        if (this.m_tag7 == 0) {
            int n2 = this.m_tag4;
            animalPlaceGoal[n2] = animalPlaceGoal[n2] + 1;
        } else {
            int n3 = this.m_tag6;
            animalPlaceGoal[n3] = animalPlaceGoal[n3] + 1;
        }
        this.m_OriPosX = this.m_posX;
        this.m_OriPosY = this.m_posY;
        if (this.m_tag7 == 0) {
            this.m_destPosX = ((Actor)Game.s_actPool2.m_actorsInUsing.elementAt((int)this.m_tag4)).m_posX;
            this.m_destPosY = ((Actor)Game.s_actPool2.m_actorsInUsing.elementAt((int)this.m_tag4)).m_posY;
        } else {
            this.m_destPosX = (((Actor)Game.s_actPool2.m_actorsInUsing.elementAt((int)this.m_tag4)).m_posX + this.m_OriPosX) / 2;
            this.m_destPosY = (((Actor)Game.s_actPool2.m_actorsInUsing.elementAt((int)this.m_tag4)).m_posY + this.m_OriPosY) / 2;
        }
        this.m_TimeCount = 0L;
        this.m_tag9 = Util.math_rand3(Game.Open_Season_Level_Info[Game.s_CurLevel][1] / 2, Game.Open_Season_Level_Info[Game.s_CurLevel][1]);
    }

    public void initOpenSeasonBosk(int id, int posX, int posY, int keybinding) {
        this.m_tag1 = id;
        this.m_tag2 = keybinding;
        this.m_posX = posX;
        this.m_posY = posY;
        this.setAnim(81, 0 + this.m_tag1 * 2);
    }

    public void drawOpenSeasonAnimal() {
        if (!(this.m_posX == this.m_destPosX && this.m_posY == this.m_destPosY || this.m_posX == this.m_OriPosX && this.m_posY == this.m_OriPosY)) {
            int action = 0;
            if (this.m_OriPosX == this.m_destPosX) {
                action = this.m_OriPosY > this.m_destPosY ? 0 : 4;
            } else if (this.m_OriPosY == this.m_destPosY) {
                action = this.m_OriPosX < this.m_destPosX ? 2 : 6;
            } else if (this.m_OriPosX < this.m_destPosX && this.m_OriPosY < this.m_destPosY) {
                action = 3;
            } else if (this.m_OriPosX < this.m_destPosX && this.m_OriPosY > this.m_destPosY) {
                action = 1;
            } else if (this.m_OriPosX > this.m_destPosX && this.m_OriPosY < this.m_destPosY) {
                action = 5;
            } else if (this.m_OriPosX > this.m_destPosX && this.m_OriPosY > this.m_destPosY) {
                action = 7;
            }
            if (this.m_actionId != (action += 6 + this.m_tag1 * 8)) {
                this.setAction(action);
            }
            this.drawAnimation(Util.F2I(this.m_posX), Util.F2I(this.m_posY));
        }
    }

    public void updateOpenSeasonAnimal() {
        if (this.m_posX == this.m_destPosX && this.m_posY == this.m_destPosY) {
            if (System.currentTimeMillis() - this.m_TimeCount2 > (long)this.m_tag8 && this.m_tag3 > 0) {
                this.m_tag8 = Util.math_rand3(200, 1000);
                --this.m_tag3;
                this.setGoal();
            } else {
                return;
            }
        }
        if (this.GoTo(this.m_tag9, this.m_destPosX, this.m_destPosY)) {
            if (this.m_tag7 == 1) {
                this.m_tag7 = 0;
                this.m_destPosX = ((Actor)Game.s_actPool2.m_actorsInUsing.elementAt((int)this.m_tag6)).m_posX;
                this.m_destPosY = ((Actor)Game.s_actPool2.m_actorsInUsing.elementAt((int)this.m_tag6)).m_posY;
                this.m_OriPosX = this.m_posX;
                this.m_OriPosY = this.m_posY;
                this.m_tag4 = this.m_tag6;
                this.m_TimeCount = 0L;
            } else {
                this.m_OriPosX = this.m_posX;
                this.m_OriPosY = this.m_posY;
                Actor bosk = (Actor)Game.s_actPool2.m_actorsInUsing.elementAt(this.m_tag4);
                bosk.setAction(1 + bosk.m_tag1 * 2);
                this.m_tag6 = this.m_tag4;
                this.m_TimeCount2 = System.currentTimeMillis();
            }
        }
    }

    public void drawOpenSeasonBosk() {
        if (1 + this.m_tag1 * 2 == this.m_actionId && this.m_isAnimFinished) {
            this.setAction(0 + this.m_tag1 * 2);
        }
        this.drawAnimation(Util.F2I(this.m_posX), Util.F2I(this.m_posY));
        if (Game.s_miniGameState == 3 || Game.s_miniGameState == 4 && Game.Open_Season_Choosed == this.m_tag1) {
            int offx = 0;
            int offy = 28;
            int action = 0;
            if (this.m_tag1 == 0) {
                action = 2;
                offx = 28;
                offy = 0;
            } else if (this.m_tag1 == 1) {
                action = 3;
                offx = -28;
                offy = 0;
            } else if (this.m_tag1 == 3) {
                action = 1;
                offx = 0;
                offy = -28;
            }
            Game.DrawAnimation(83, action, Game.s_frameCount, Util.F2I(this.m_posX) + offx, Util.F2I(this.m_posY) + offy);
        }
        if (this.m_tag1 == Game.Open_Season_Choosed && Game.s_miniGameState == 4) {
            if (Game.s_gameLevelResult == 1) {
                Game.DrawAnimation(83, 15, 0L, Util.F2I(this.m_posX), Util.F2I(this.m_posY) + -10);
            } else if (Game.s_gameLevelResult == -1) {
                Game.DrawAnimation(83, 16, 0L, Util.F2I(this.m_posX), Util.F2I(this.m_posY) + -10);
            } else {
                Game.DrawAnimation(83, 14, 0L, Util.F2I(this.m_posX), Util.F2I(this.m_posY) + -10);
            }
        }
        if (Game.s_gameLevelResult == -1 && Game.s_miniGameState == 4 && Game.s_actPool1.getActor((int)Game.Open_Season_Goal).m_tag6 == this.m_tag1) {
            Game.DrawAnimation(83, 15, 0L, Util.F2I(this.m_posX), Util.F2I(this.m_posY) + -10);
        }
    }

    public boolean GoTo(long time, int destX, int destY) {
        this.m_TimeCount += Game.s_lastFrameCostTime;
        if (this.m_TimeCount > time) {
            this.m_TimeCount = time;
        }
        this.m_posX = this.m_OriPosX + (int)((long)(destX - this.m_OriPosX) * this.m_TimeCount / time);
        this.m_posY = this.m_OriPosY + (int)((long)(destY - this.m_OriPosY) * this.m_TimeCount / time);
        return this.m_posX == destX && this.m_posY == destY;
    }

    public void draw() {
        if (!this.m_visible) {
            return;
        }
        if (0 == this.m_type || 1 == this.m_type) {
            if (1 == this.m_type) {
                this.updateEffect();
            }
            if (this.m_tag6 >= 0) {
                Game.s_sprites[this.m_animationId].setCurrentPalette(this.m_tag6);
            }
            this.drawAnimation(this.m_posX, this.m_posY);
        }
        if (2 == this.m_type) {
            this.drawSnow();
        } else if (3 == this.m_type || 10 == this.m_type) {
            this.drawNumHunterBall();
        } else if (4 == this.m_type) {
            this.drawOpenSeasonAnimal();
        } else if (5 == this.m_type) {
            this.drawOpenSeasonBosk();
        } else if (6 == this.m_type) {
            this.drawRacerCar();
        } else if (7 == this.m_type) {
            this.drawAnimalCount();
        } else if (8 == this.m_type) {
            this.drawFrog();
        } else if (9 == this.m_type) {
            this.drawFly();
        } else if (11 == this.m_type) {
            this.drawLetter();
        } else if (12 == this.m_type) {
            this.drawGhost();
        } else if (13 == this.m_type) {
            this.drawButterFly();
        } else if (14 == this.m_type) {
            this.drawParticle();
        }
    }

    public void drawParticle() {
        int iY = Util.F2I(this.m_posY);
        int iX = Util.F2I(this.m_posX);
        Game.s_sprites[this.m_animationId].m_crtAlpha = this.m_tag5;
        if (Game.s_hAcc == 0) {
            iX = Game.s_gravity != 0 ? (iX += Util.TF2F(Util.fixedMul(Util.math_sin(this.m_tag6), 24576))) : (iX += Util.TF2F(Util.fixedMul(Util.math_sin(this.m_tag6), 81920)));
        }
        this.drawAnimation(iX, iY);
    }

    public void updateParticle() {
        this.m_tag5 += 10;
        if (this.m_tag5 >= 255) {
            this.m_tag5 = 255;
        }
        this.m_posX += this.m_tag1;
        this.m_posY += this.m_tag2;
    }

    public void setMoveTarget(int iX, int iY, int iTgtX, int iTgtY, int iStep) {
        this.setPosition(iX, iY);
        this.m_tag2 = Util.I2F(iX);
        this.m_tag3 = Util.I2F(iY);
        this.m_tag4 = Util.I2F(iTgtX);
        this.m_tag5 = Util.I2F(iTgtY);
        this.m_tag1 = iStep;
    }

    public void updateEffect() {
        if (this.m_tag1 != 0) {
            int[] vCrt = new int[]{this.m_tag2, this.m_tag3};
            int[] vGoal = new int[]{this.m_tag4, this.m_tag5};
            Util.vector_approch(vCrt, this.m_tag1, vGoal);
            this.m_tag2 = vCrt[0];
            this.m_tag3 = vCrt[1];
            this.m_posX = Util.F2I(vCrt[0]);
            this.m_posY = Util.F2I(vCrt[1]);
        }
    }

    public void update() {
        if (0 == this.m_type) {
            // empty if block
        }
        if (2 == this.m_type) {
            this.updateSnow();
        } else if (3 == this.m_type) {
            this.updateNumHunterBall();
        } else if (4 == this.m_type) {
            this.updateOpenSeasonAnimal();
        } else if (6 == this.m_type) {
            this.updateRacerCar();
        } else if (7 == this.m_type) {
            this.updateAnimalCount();
        } else if (9 == this.m_type) {
            this.updateFly();
        } else if (8 == this.m_type) {
            this.updateFrog();
        } else if (11 == this.m_type) {
            this.updateLetter();
        } else if (this.m_type == 12) {
            this.updateGhost();
        } else if (13 == this.m_type) {
            this.updateButterFly();
        } else if (this.m_type == 14) {
            this.updateParticle();
        }
    }

    public void setAction(int iAction) {
        if (iAction == this.m_actionId) {
            return;
        }
        this.m_actionId = iAction;
        this.m_crtAFrame = 0;
        this.m_crtAFrameTime = 0;
        this.m_isAnimFinished = false;
    }

    public boolean isAnimFinished() {
        return this.m_isAnimFinished;
    }

    public void setAnim(int iAnim, int iAction) {
        if (iAction == this.m_actionId && this.m_animationId == iAnim) {
            return;
        }
        this.m_animationId = iAnim;
        this.m_actionId = iAction;
        this.m_crtAFrame = 0;
        this.m_crtAFrameTime = 0;
        this.m_isAnimFinished = false;
    }

    public void setForceAnim(int iAnim, int iAction) {
        this.m_animationId = iAnim;
        this.m_actionId = iAction;
        this.m_crtAFrame = 0;
        this.m_crtAFrameTime = 0;
        this.m_isAnimFinished = false;
    }

    public void updateAnimObject() {
        int iAnim = this.m_animationId;
        int iAction = this.m_actionId;
        this.m_isAnimFinished = false;
        int time = Game.s_sprites[iAnim].GetAFrameTime(iAction, this.m_crtAFrame);
        if (time == 0) {
            return;
        }
        ++this.m_crtAFrameTime;
        if (time > this.m_crtAFrameTime) {
            return;
        }
        this.m_crtAFrameTime = 0;
        ++this.m_crtAFrame;
        if (this.m_crtAFrame >= Game.s_sprites[iAnim].GetAFrames(iAction)) {
            this.m_crtAFrame = this.m_isNeedLoop ? 0 : this.m_crtAFrame - 1;
            this.m_isAnimFinished = true;
        }
    }

    public void drawAnimation(int posX, int posY) {
        this.drawAnimation(posX, posY, 0);
    }

    public void drawAnimation(int posX, int posY, int Flag) {
        int iX = posX;
        int iY = posY;
        int iAnim = this.m_animationId;
        int iValue = this.m_actionId;
        if (Game.s_g != null) {
            Game.s_sprites[iAnim].paintAFrame(Game.s_g, iValue, this.m_crtAFrame, iX, iY, Flag);
        }
        this.updateAnimObject();
    }
}

