/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceImage {
    public static final boolean USE_CLIPPING = false;
    private Image image;
    public int manipulation = 0;
    public int clip_x;
    public int clip_y;
    public short width;
    public short height;
    public static final int[] MANIPS = new int[]{0, 2, 1, 3};
    private static final int MAX_SCALE = 200;
    public int scaled_width;
    public int scaled_height;
    private int old_scaled_width;
    private int old_scaled_height;
    private int[] pixels;
    private int[] scaled;

    public DeviceImage(String string) {
        string = string + ".png";
        this.createImage(Engine.getResource(string), string);
    }

    public DeviceImage(byte[] byArray, String string) {
        this.createImage(byArray, string);
    }

    private void createImage(byte[] byArray, String string) {
        try {
            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.image = deviceImage.image;
        this.clip_x = n;
        this.clip_y = n2;
        this.width = (short)Math.min(n3, this.image.getWidth() - this.clip_x);
        this.height = (short)Math.min(n4, this.image.getHeight() - this.clip_y);
    }

    public DeviceImage[] divide(int n) {
        int n2 = this.width / n;
        short s = this.height;
        return this.divide(n2, s);
    }

    public DeviceImage[] divide(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5++] = new DeviceImage(this, j * n, i * n2, n, n2);
            }
        }
        return deviceImageArray;
    }

    public void drawImage(Graphics graphics, int n, int n2) {
        graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, this.manipulation, n, n2, 20);
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n, n2, 20);
    }

    public DeviceImage[] divideScaled(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5] = new DeviceImage(this, j * n, i * n2, n, n2);
                deviceImageArray[n5].createScaled(j * n, i * n2);
                ++n5;
            }
        }
        return deviceImageArray;
    }

    public void createScaled(int n, int n2) {
        this.pixels = new int[this.width * this.height];
        this.scaled = new int[this.width * 200 / 100 * (this.height * 200 / 100)];
        this.image.getRGB(this.pixels, 0, (int)this.width, n, n2, (int)this.width, (int)this.height);
        this.old_scaled_height = -1;
        this.old_scaled_width = -1;
        this.resize(100);
    }

    public void drawImageScaled(Graphics graphics, int n, int n2) {
        graphics.drawRGB(this.scaled, 0, this.scaled_width, n, n2, this.scaled_width, this.scaled_height, true);
    }

    public void resize(int n, int n2) {
        this.scaled_width = n;
        this.scaled_height = n2;
        this.scale(this.pixels, this.width, this.height, this.scaled, this.scaled_width, this.scaled_height, this.scaled_width, this.scaled_height, 0, 0);
    }

    public void resize(int n) {
        if (n > 200) {
            n = 200;
        }
        this.scaled_width = this.width * n / 100;
        this.scaled_height = this.height * n / 100;
        if (this.old_scaled_width == this.scaled_width && this.old_scaled_height == this.scaled_height) {
            return;
        }
        this.old_scaled_width = this.scaled_width;
        this.old_scaled_height = this.scaled_height;
        this.resize(this.scaled_width, this.scaled_height);
    }

    private void scale(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 1;
        boolean bl = true;
        int n10 = 0;
        int n11 = 0;
        if (n3 == 0 || n4 == 0) {
            return;
        }
        int n12 = Math.abs(n3);
        int n13 = Math.abs(n4);
        int n14 = (n << 16) / n12;
        int n15 = (n2 << 16) / n13;
        if (n3 > 0 && n4 > 0) {
            n11 = n5 - n12;
        } else if (n3 > 0 && n4 < 0) {
            n11 = -n5 - n12;
        } else if (n3 < 0 && n4 > 0) {
            n11 = n5 + n12;
        } else if (n3 < 0 && n4 < 0) {
            n11 = -n5 + n12;
        }
        int n16 = 0;
        int n17 = n7 + n8 * n5;
        for (int i = 0; i < n13; ++i) {
            int n18 = 0;
            for (int j = 0; j < n12; ++j) {
                nArray2[n17] = nArray[(n18 >> 16) + n16];
                n17 += n9;
                n18 += n14;
            }
            n17 += n11;
            n16 += ((n10 += n15) >> 16) * n;
            n10 &= 0xFFFF;
        }
    }
}

