/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class DeviceSound
implements Constants,
PlayerListener {
    private static Player currentSound;
    private static String[] MIDI_FILES;
    private static boolean[] LOOPS;
    private static int[] SOUND_MAPPING;

    public void init() {
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string == "endOfMedia") {
            try {
                if (Engine.lastSound != -1) {
                    this.play(Engine.lastSound);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void play(int n) {
        if (n >= SOUND_MAPPING.length) {
            return;
        }
        int n2 = SOUND_MAPPING[n];
        String string = MIDI_FILES[n2];
        String string2 = null;
        boolean bl = false;
        if (string.endsWith("mid")) {
            string2 = "audio/midi";
            Engine.lastSound = LOOPS[n2] ? n2 : -1;
        } else if (string.endsWith("amr")) {
            string2 = "audio/amr";
            bl = true;
        }
        if (!Engine.soundOn || Engine.hideNotify) {
            return;
        }
        try {
            this.stop();
            currentSound = Manager.createPlayer((InputStream)((Object)((Object)Main.instance)).getClass().getResourceAsStream("/" + string), (String)string2);
            currentSound.realize();
            currentSound.prefetch();
            currentSound.setLoopCount(LOOPS[n2] ? -1 : 1);
            if (bl) {
                currentSound.addPlayerListener((PlayerListener)this);
            }
            do {
                currentSound.start();
            } while (!bl && currentSound.getState() != 400);
        }
        catch (Exception exception) {
            Engine.debugWrite("Error play, " + exception.getMessage(), true);
            Engine.retry_playing = true;
            Engine.retry_sound_idx = n;
        }
    }

    public void stop() {
        try {
            if (currentSound != null) {
                currentSound.stop();
                currentSound.close();
                currentSound = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean resume() {
        int n = Engine.lastSound;
        if (Engine.soundOn && n != -1 && !this.isSoundPlaying()) {
            this.play(n);
            return this.isSoundPlaying();
        }
        return true;
    }

    private boolean isSoundPlaying() {
        return currentSound != null && currentSound.getState() == 400;
    }

    static {
        MIDI_FILES = new String[]{"splash.mid", "e1.mid", "e2.mid", "e3.mid", "Win.mid", "Lose.mid", "wingame.mid", "giggle1.amr", "giggle2.amr", "giggle3.amr"};
        LOOPS = new boolean[]{true, true, true, true, false, false, false, false, false, false};
        SOUND_MAPPING = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }
}

