/*
 * Decompiled with CFR 0.152.
 */
public class Menu
implements Constants {
    public Menu next;
    public Menu previous;
    public String title;
    public String[] text;
    public int cursor;
    public int type;
    public int[] xpos;
    public int[] width;
    public static final int MENU_ROOT = 0;
    public static final int MENU_SUB = 1;
    public static final int FORM = 2;
    int text_strip_w;

    public Menu(String string, String[] stringArray, int n) {
        this.title = string;
        this.text = stringArray;
        this.type = n;
        this.xpos = new int[stringArray.length];
        this.width = new int[stringArray.length];
        this.resetItemPos();
        this.setItemMaxWidth();
    }

    public void setItemMaxWidth() {
        this.text_strip_w = (Device.USE_BMP_FONT & 1) != 0 ? Engine.getStringWidth(this.text[0] + "W") : Device.FONT.stringWidth(this.text[0] + "W");
        if (this.text.length > 1) {
            int n;
            for (n = 0; n < this.text.length - 1; ++n) {
                int n2 = (Device.USE_BMP_FONT & 1) != 0 ? Engine.getStringWidth(this.text[n + 1] + "WW") : Device.FONT.stringWidth(this.text[n + 1] + "WW");
                if (this.text_strip_w >= n2) continue;
                this.text_strip_w = n2;
            }
            for (n = 0; n < this.text.length; ++n) {
                this.width[n] = this.text_strip_w;
            }
        }
    }

    public int length() {
        if (this.text == null) {
            return 0;
        }
        return this.text.length;
    }

    public void updateItem(String string) {
        this.text[this.cursor] = string;
    }

    public void resetItemPos() {
        for (int i = 0; i < this.xpos.length; ++i) {
            this.xpos[i] = -this.text_strip_w + i * -10;
        }
    }

    public boolean allItemsOnScreen() {
        if (this.type == 2) {
            return true;
        }
        for (int i = 0; i < this.xpos.length; ++i) {
            if (this.xpos[i] >= 0) continue;
            return false;
        }
        return true;
    }

    public void tickItems() {
        for (int i = 0; i < this.xpos.length; ++i) {
            int n = i;
            this.xpos[n] = this.xpos[n] + 24;
            if (this.xpos[i] < 0) continue;
            this.xpos[i] = 0;
        }
    }
}

