/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GameObject
implements Constants {
    public int x;
    public int y;
    public int width;
    public int height;
    public int xoffset;
    public int yoffset;
    public int pipeType = -1;
    public boolean reversal;
    public int startTrigger = -1;
    public int stopTrigger = -1;
    public static DeviceImage[] images;
    public static final int TYPE_GIRL = 0;
    public static final int TYPE_RAPID_GAUGE = 1;
    public static final int TYPE_CAMERA = 2;
    public static final int TYPE_CANNON = 3;
    public static final int TYPE_LOADED_IMAGE = 4;
    public static final int TYPE_PIPE_SECTION = 5;
    public static final int PIPE_CIRCLE_0 = 0;
    public static final int PIPE_CIRCLE_1 = 1;
    public static final int PIPE_CIRCLE_2 = 2;
    public static final int PIPE_CIRCLE_3 = 3;
    public static final int PIPE_CIRCLE_4 = 4;
    public static final int PIPE_CIRCLE_5 = 5;
    public static final int PIPE_CIRCLE_6 = 6;
    public static final int PIPE_CIRCLE_7 = 7;
    public static final int PIPE_W_TO_E = 8;
    public static final int PIPE_N_TO_S = 9;
    public static final int PIPE_NW_TO_SE = 10;
    public static final int PIPE_NE_TO_SW = 11;
    public static final int PIPE_N_TO_S_CHEVRON = 12;
    public static final int PIPE_BOWL_UPPER = 13;

    public void paint(Graphics graphics, int n, int n2) {
        images[this.pipeType].drawImage(graphics, GameWorld.gameUnitsToPixels(this.x + this.xoffset + n), GameWorld.gameUnitsToPixels(this.y + this.yoffset + n2));
    }

    public int getTargetX(int n) {
        return this.x + this.xoffset + GameWorld.instance.pipeData[n][this.pipeType];
    }

    public int getTargetY(int n) {
        return this.y + this.yoffset + GameWorld.instance.pipeData[n][this.pipeType];
    }

    public int getDrawX() {
        return this.x + this.xoffset;
    }

    public int getDrawY() {
        return this.y + this.yoffset;
    }

    public boolean isOnScreen(int n, int n2) {
        int n3 = GameWorld.gameUnitsToPixels(this.x + this.xoffset + n);
        int n4 = GameWorld.gameUnitsToPixels(this.y + this.yoffset + n2);
        return n3 + GameWorld.gameUnitsToPixels(this.width) >= 0 && n3 <= 240 && n4 + GameWorld.gameUnitsToPixels(this.height) >= 0 && n4 <= 320;
    }

    public void triggerStart() {
        if (this.startTrigger != -1) {
            int n = this.startTrigger & 0xFF;
            int n2 = this.startTrigger >> 8;
            if (n == 1) {
                int n3 = this.getTriggerFrame();
                int n4 = GameWorld.gameUnitsToPixels(this.getTriggerX()) + GameWorld.ARROW_X_OFF[n3];
                int n5 = GameWorld.gameUnitsToPixels(this.getTriggerY()) + GameWorld.ARROW_Y_OFF[n3];
                GameWorld.instance.initArrow(0, n3, n4, n5);
            } else if (n == 2) {
                GameWorld.instance.initCameraState();
            } else if (n == 3) {
                int n6 = n - 1;
                int n7 = this.getTriggerFrame();
                DeviceImage deviceImage = GameWorld.instance.objectImages[n6][n7];
                int n8 = this.getTriggerX() + GameWorld.pixels(deviceImage.width >> 1);
                int n9 = this.getTriggerY() + GameWorld.pixels(deviceImage.height >> 1);
                GameWorld.instance.initCannon(n2, n8, n9, n7);
            }
        }
    }

    public void triggerStop() {
        int n;
        if (this.stopTrigger != -1 && (n = this.stopTrigger & 0xFF) == 3) {
            GameWorld.instance.stopCannon();
        }
    }

    public int getStartTrigger() {
        return this.startTrigger == -1 ? -1 : this.startTrigger & 0xFF;
    }

    public int getTriggerX() {
        int n = this.startTrigger & 0xFF;
        int n2 = this.startTrigger >> 8;
        if (n == 1) {
            return GameWorld.instance.objGauges[n2];
        }
        return GameWorld.instance.objDisplay[n2];
    }

    public int getTriggerY() {
        int n = this.startTrigger & 0xFF;
        int n2 = this.startTrigger >> 8;
        if (n == 1) {
            return GameWorld.instance.objGauges[n2 + 1];
        }
        return GameWorld.instance.objDisplay[n2 + 1];
    }

    public int getTriggerFrame() {
        int n = this.startTrigger & 0xFF;
        int n2 = this.startTrigger >> 8;
        if (n == 1) {
            return GameWorld.instance.objGauges[n2 + 2];
        }
        return GameWorld.instance.objDisplay[n2 + 2];
    }
}

