/*
 * Decompiled with CFR 0.152.
 */
package mobi.util;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import mobi.midp.MobiStatic;

public class ImageParser {
    public static String GRAPHIC_TAG_BEGIN = "<GRAPHIC>";
    public static String GRAPHIC_TAG_END = "</GRAPHIC>";
    private StringBuffer data;
    String titleId;
    int index;
    int start;
    int end;
    int x;
    int y;
    Vector vector = new Vector();

    public StringBuffer getData() {
        return this.data;
    }

    public Vector getVector() {
        return this.vector;
    }

    public ImageParser(StringBuffer data, String titleId) {
        this.data = data;
        this.titleId = titleId;
    }

    public String processImages() {
        String graphicTag;
        while ((graphicTag = this.stripTag()) != null) {
            String imageString = this.getImageString(graphicTag);
            if (imageString == null) {
                this.index += graphicTag.length();
                continue;
            }
            this.end += GRAPHIC_TAG_END.length();
            if (!imageString.startsWith("s_")) {
                Image image = null;
                try {
                    image = MobiStatic.getImage(imageString, this.titleId);
                    this.vector.addElement(image);
                    this.data.delete(this.start, this.end);
                    this.data.insert(this.start, "<img>" + this.vector.size() + "</img>");
                }
                catch (IOException e) {
                    this.data.delete(this.start, this.end);
                }
                continue;
            }
            this.data.delete(this.start, this.end);
        }
        return this.data.toString();
    }

    private String stripTag() {
        this.start = this.data.toString().indexOf(GRAPHIC_TAG_BEGIN, this.index);
        if (this.start == -1) {
            return null;
        }
        this.end = this.data.toString().indexOf(GRAPHIC_TAG_END, this.start);
        if (this.end == -1) {
            this.index = this.start + GRAPHIC_TAG_BEGIN.length();
            return null;
        }
        return this.data.toString().substring(this.start, this.end + GRAPHIC_TAG_END.length());
    }

    private String getImageString(String tag) {
        int start = tag.lastIndexOf(92);
        if (start == -1) {
            return null;
        }
        int end = tag.indexOf(GRAPHIC_TAG_END);
        return tag.substring(++start, end);
    }
}

