/*
 * Decompiled with CFR 0.152.
 */
package mobi.cache;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;
import mobi.cache.Entry;

public class ImageCache {
    static short counter = 1;
    static Hashtable hashtable = new Hashtable();
    static final long MEM_LIMIT = 50000L;

    public static void clear() {
        hashtable.clear();
    }

    public static Image get(String key) {
        Entry entry = (Entry)hashtable.get(key);
        if (entry == null) {
            return null;
        }
        entry.hits = (short)(entry.hits + 1);
        return entry.image;
    }

    public static void put(String key, Image image) {
        short s = counter;
        counter = (short)(s + 1);
        hashtable.put(key, new Entry(s, image));
        if (ImageCache.memory() < 50000L) {
            ImageCache.clean();
        }
    }

    private static void clean() {
        Entry lowGuy;
        Enumeration enumeration = hashtable.elements();
        if (enumeration.hasMoreElements()) {
            lowGuy = (Entry)enumeration.nextElement();
        } else {
            return;
        }
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            if (entry.hits < lowGuy.hits) {
                lowGuy = entry;
                continue;
            }
            if (entry.hits != lowGuy.hits || entry.entry >= lowGuy.entry) continue;
            lowGuy = entry;
        }
        hashtable.remove(lowGuy);
    }

    static long memory() {
        return Runtime.getRuntime().freeMemory();
    }

    private ImageCache() {
    }
}

