/*
 * Decompiled with CFR 0.152.
 */
package mobi.forms;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStoreException;
import mobi.data.AutoDrmRecordStore;
import mobi.data.Bookmark;
import mobi.data.BookmarkRecordStore;
import mobi.data.Titles;
import mobi.forms.MidpForm;
import mobi.forms.TitleForm;
import mobi.items.MenuItem;
import mobi.util.MobiIoException;
import mobi.util.ResourceBundle;
import mobi.util.ResponseCodeException;
import mobi.util.ServerException;
import mobi.util.WrongTypeException;
import org.xmlpull.v1.XmlPullParserException;

public class BookmarksForm
extends MidpForm {
    static int iteration = 0;
    static String next;
    Vector vector;
    String[] array;

    public static void resetIteration() {
        iteration = 0;
    }

    public BookmarksForm(String mobi, boolean isBack) {
        this.mobiString = mobi;
        this.isBack = isBack;
    }

    public int getIteration() {
        return iteration;
    }

    public void commandAction(Command cmd, Displayable disp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(int priority) {
        if (this.menuItem.getSelection() > this.array.length) {
            this.inCommand = false;
            return;
        }
        if (priority == 0) {
            this.handleCommand(this.menuItem.getSelection());
        } else if (priority == 16) {
            if (!this.menuItem.rightString.equals("No")) {
                this.menuItem.ALERT_TRUE = true;
                this.menuItem.setAnyKeyChild();
                this.menuItem.isPopUp = false;
                return;
            }
            int selection = this.menuItem.getSelection() + iteration * 9;
            Bookmark bookmark = (Bookmark)this.vector.elementAt(selection);
            BookmarkRecordStore store = null;
            try {
                store = new BookmarkRecordStore();
                store.delete(bookmark);
            }
            catch (RecordStoreException e) {
            }
            finally {
                if (store != null) {
                    store.close();
                }
            }
            this.midp.getHashtable().put("next", "bookmarks.mobi");
            Thread t = new Thread(this.midp);
            t.start();
        } else {
            super.commandAction(priority);
        }
    }

    public void handleCommand(int selection) {
        if (this.menuItem.menuSize() == 10 && selection == 9) {
            this.nextIteration();
        } else {
            if (selection >= this.array.length) {
                this.inCommand = false;
                this.menuItem.cancelAction();
                return;
            }
            int selected = selection + iteration * 9;
            Bookmark bookmark = (Bookmark)this.vector.elementAt(selected);
            if (titles == null || titles.size() == 0) {
                String drmKey = ResourceBundle.getNull("auto_drm");
                String carrier = ResourceBundle.getNull("carrier");
                if (carrier != null && drmKey.startsWith(carrier)) {
                    try {
                        this.getTitles(drmKey);
                    }
                    catch (Exception e) {
                        this.handleError(e);
                    }
                } else {
                    AutoDrmRecordStore autoDrm;
                    try {
                        autoDrm = new AutoDrmRecordStore();
                    }
                    catch (RecordStoreException e) {
                        return;
                    }
                    if (autoDrm.needUpdate() && !this.getAutoDrm(autoDrm.getDrmKey())) {
                        return;
                    }
                    try {
                        this.getTitlesDrm();
                    }
                    catch (Exception e) {
                        this.handleError(e);
                    }
                }
            }
            Vector titles = TitleForm.titles;
            Titles title = null;
            for (int i = 0; i < titles.size(); ++i) {
                Titles t = (Titles)titles.elementAt(i);
                if (!t.getId().equals(bookmark.getTitleId())) continue;
                title = t;
            }
            this.setTitle(title);
            this.midp.getHashtable().clear();
            this.midp.getHashtable().put("recordId", bookmark.getRecordId());
            this.midp.getHashtable().put("titleId", title.getId());
            this.midp.getHashtable().put("next", "record.mobi");
            Thread thread = new Thread(this.midp);
            thread.start();
        }
    }

    public void createForm() {
        try {
            this.getData();
        }
        catch (Exception e) {
            this.handleError(e);
            return;
        }
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < this.vector.size(); ++i) {
            Bookmark t = (Bookmark)this.vector.elementAt(i);
            names.addElement(t.getName());
        }
        this.array = this.processVector(names, iteration);
        this.menuItem = new MenuItem(this.array, this);
        if ((this.array == null || this.array.length == 0) && iteration != 0) {
            this.decrementIteration();
            this.createForm();
            return;
        }
        if (this.array == null || this.array.length == 0) {
            this.menuItem.setError(ResourceBundle.get("no_bookmarks"));
            this.commandVector.addElement("");
            this.constantVector.addElement("-51");
        } else {
            this.commandVector.addElement(cmdSubmit);
            this.constantVector.addElement(Integer.toString(0));
            this.commandVector.addElement(cmdDelete);
            this.constantVector.addElement(Integer.toString(16));
            this.menuItem.setConfirmMessage(ResourceBundle.get("delete_confirm"));
        }
        if (iteration == 0) {
            if (isBundled == 1) {
                this.commandVector.addElement(cmdMainMenu);
                this.constantVector.addElement(Integer.toString(12));
            } else {
                this.commandVector.addElement(cmdHome);
                this.constantVector.addElement(Integer.toString(10));
            }
        } else {
            this.commandVector.addElement(cmdBack);
            this.constantVector.addElement(Integer.toString(5));
        }
        this.setThreadToNull();
        this.midp.getDisplay().setCurrent((Displayable)this.menuItem);
    }

    public void getData() throws RecordStoreException, ServerException, IOException, ResponseCodeException, XmlPullParserException, WrongTypeException, MobiIoException {
        BookmarkRecordStore store = new BookmarkRecordStore();
        this.vector = store.get();
        if (titles == null || titles.size() == 0) {
            this.getTitlesDrm();
        }
    }

    public void decrementIteration() {
        --iteration;
    }

    public String getMobiAction() {
        return "bookmarks.mobi";
    }

    public void incrementIteration() {
        ++iteration;
    }
}

