/*
 * Decompiled with CFR 0.152.
 */
package mobi.midp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;
import javax.microedition.lcdui.Image;
import mobi.forms.BookmarkForm;
import mobi.forms.BookmarksForm;
import mobi.forms.CategoryForm;
import mobi.forms.CustomCategoryForm;
import mobi.forms.MainPage1Form;
import mobi.forms.MainPage2Form;
import mobi.forms.MainPage3Form;
import mobi.forms.MenuForm;
import mobi.forms.MidpForm;
import mobi.forms.NamesForm;
import mobi.forms.RecordForm;
import mobi.forms.SearchDataForm;
import mobi.forms.SearchDataResults;
import mobi.forms.SearchTitlesForm;
import mobi.forms.SearchTitlesResults;
import mobi.forms.SubjectsMainForm;
import mobi.forms.TitleForm;
import mobi.midp.MobiViewer;
import mobi.util.ResourceBundle;

public class MobiStatic {
    public static Image backGroundImage;
    public static int TIME_OUT;
    public static final String VERSION = "1";
    public static final String VERSION_TYPE = "Beta";
    public static final byte BUILD_NUM = 0;
    public static Image mobiViewerImage;
    public static Image titleImage;
    public static String appName;
    public static boolean isDataConnectionProblem;
    public static MidpForm midpForm;
    public static boolean isThreadInvoke;
    public static String backStr;

    public static String getVersion() {
        return "MobiViewer version 1 Beta Build #0";
    }

    static void findForm(String name, boolean isBack, MobiViewer viewer) {
        if (name.equals("titles.mobi")) {
            midpForm = new TitleForm();
        } else if (name.equals("mainPage1.mobi")) {
            midpForm = new MainPage1Form(name, isBack);
        } else if (name.equals("mainPage2.mobi")) {
            midpForm = new MainPage2Form(name, isBack);
        } else if (name.equals("mainPage3.mobi")) {
            midpForm = new MainPage3Form(name, isBack);
        } else if (name.equals("subjectsMain.mobi")) {
            midpForm = new SubjectsMainForm(name, isBack);
        } else if (name.equals("categories.mobi")) {
            midpForm = new CategoryForm(name, isBack);
        } else if (name.equals("names.mobi")) {
            midpForm = new NamesForm(name, isBack);
        } else if (name.equals("searchData.mobi")) {
            midpForm = new SearchDataForm(name, isBack);
        } else if (name.equals("searchTitles.mobi")) {
            midpForm = new SearchTitlesForm(name, isBack);
        } else if (name.equals("record.mobi") || name.equals("about.mobi") || name.equals("help.mobi") || name.equals("titlesDrmFormatted.mobi")) {
            midpForm = new RecordForm(name, isBack);
        } else if (name.equals("searchDataResults.mobi")) {
            midpForm = new SearchDataResults(name, isBack);
        } else if (name.equals("searchTitlesResults.mobi")) {
            midpForm = new SearchTitlesResults(name, isBack);
        } else if (name.equals("customCategory.mobi")) {
            midpForm = new CustomCategoryForm(name, isBack);
        } else if (name.equals("menu.mobi")) {
            midpForm = new MenuForm();
        } else if (name.equals("bookmark.mobi")) {
            midpForm = new BookmarkForm(name);
        } else if (name.equals("bookmarks.mobi")) {
            midpForm = new BookmarksForm(name, isBack);
        } else {
            System.err.println("No branch found for " + name);
            return;
        }
        midpForm.setMidp(viewer);
        midpForm.createForm();
    }

    public static String makeUrl(String action, Hashtable hashtable) {
        String url = ResourceBundle.get("url");
        url = url + '/' + action;
        url = url + '?';
        boolean firstTime = true;
        Enumeration e = hashtable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals("next")) continue;
            if (!firstTime) {
                url = url + '&';
            } else {
                firstTime = false;
            }
            StringBuffer buf = new StringBuffer((String)hashtable.get(key));
            StringBuffer data = new StringBuffer();
            for (int x = 0; x < buf.length(); ++x) {
                if (buf.charAt(x) == ' ') {
                    data.append("%20");
                    continue;
                }
                if (buf.charAt(x) == '#') {
                    data.append("%23");
                    continue;
                }
                if (buf.charAt(x) == '&') {
                    data.append("%26");
                    continue;
                }
                if (buf.charAt(x) == ':') {
                    data.append("%3a");
                    continue;
                }
                data.append(buf.charAt(x));
            }
            url = url + key;
            url = url + '=';
            url = url + data;
        }
        return url;
    }

    public static String createUrl(String action, MobiViewer midp) {
        midp.getHashtable().put("xml", "true");
        if (midp.getTitle() == null) {
            String locale = ResourceBundle.get("locale");
            midp.getHashtable().put("locale", locale);
        } else {
            midp.getHashtable().put("titleId", midp.getTitle().getId());
            midp.getHashtable().put("locale", midp.getTitle().getLocale());
            midp.getHashtable().put("version", VERSION);
        }
        return MobiStatic.makeUrl(action, midp.getHashtable());
    }

    public static void cleanUpGc() {
        System.gc();
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static InputStream getInputStream(String url) throws IOException {
        Connection connection = Connector.open((String)url);
        InputConnection inputConnection = (InputConnection)connection;
        return inputConnection.openInputStream();
    }

    public static byte[] getImageBytes(String url) throws IOException {
        int blocksize = 1024;
        InputStream istream = MobiStatic.getInputStream(url);
        int l = istream.available();
        byte[] buffer = new byte[l + 1];
        int length = 0;
        while ((l = istream.read(buffer, length, buffer.length - length)) != -1) {
            if ((length += l) != buffer.length) continue;
            byte[] b = new byte[buffer.length + blocksize];
            System.arraycopy(buffer, 0, b, 0, length);
            buffer = b;
        }
        byte[] bytes = new byte[length];
        System.arraycopy(buffer, 0, bytes, 0, length);
        istream.close();
        return bytes;
    }

    public static Image getImageResorce(String imageName) throws IOException {
        return Image.createImage((String)("/" + imageName));
    }

    public static void init() {
        try {
            ResourceBundle.create();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        TIME_OUT = 90;
        isDataConnectionProblem = false;
        isThreadInvoke = false;
        backStr = "";
        try {
            TIME_OUT = Integer.parseInt(ResourceBundle.get("time_out"));
            backGroundImage = MobiStatic.getImageResorce("background.png");
            mobiViewerImage = MobiStatic.getImageResorce("mobiViewer.png");
        }
        catch (IOException e) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

