/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import java.util.Hashtable;
import java.util.Vector;
import mobi.util.StringVector;

public class RecordData {
    public static final String[] TAGS2 = new String[]{"startBOLD", "startITALIC", "startimg", "starta", "startFN", "endBOLD", "endITALIC", "enda", "endFN"};
    public static final byte BOLD = 0;
    public static final byte ITALIC = 1;
    public static final byte IMAGE = 2;
    public static final byte START_LINK = 3;
    public static final byte FOOT_NOTE = 4;
    public static final byte START_TAGS = 5;
    public static final byte END_LINK = 7;
    public static final byte NOTHING = -1;
    public static final byte NORMAL = -2;
    Hashtable hashPositions = new Hashtable();
    private short totA = 0;
    private Integer[] linkUpA = null;
    private short[] linksUpsPosition = null;

    public RecordData(Hashtable hashtable) {
        this.parse(hashtable);
        this.storeLinkUps(hashtable);
    }

    private void parse(Hashtable hashtable) {
        int i;
        Vector temporaryVector = new Vector();
        for (i = 0; i < TAGS2.length; ++i) {
            String element = (String)hashtable.remove(TAGS2[i]);
            if (element == null || element.length() <= 0) continue;
            StringVector stringVector = new StringVector(element);
            for (int j = 0; j < stringVector.size(); ++j) {
                this.hashPositions.put(stringVector.elementAt(j), TAGS2[i]);
                if (TAGS2[i].equals(TAGS2[3])) {
                    this.totA = (short)(this.totA + 1);
                    temporaryVector.addElement(stringVector.elementAt(j));
                    continue;
                }
                if (!TAGS2[i].equals(TAGS2[7])) continue;
                temporaryVector.addElement(stringVector.elementAt(j));
            }
        }
        this.linksUpsPosition = new short[temporaryVector.size()];
        for (i = 0; i < temporaryVector.size(); ++i) {
            this.linksUpsPosition[i] = Short.parseShort((String)temporaryVector.elementAt(i));
        }
    }

    private void storeLinkUps(Hashtable hashtable) {
        String element = (String)hashtable.remove("linkUps");
        if (element != null && element.length() > 0) {
            StringVector stringVector = new StringVector(element);
            this.linkUpA = new Integer[stringVector.size()];
            for (int i = 0; i < stringVector.size(); ++i) {
                this.linkUpA[i] = Integer.valueOf(stringVector.elementAt(i).toString());
            }
        }
    }

    public short getACount() {
        return this.totA;
    }

    public Integer[] getLinkUps() {
        return this.linkUpA;
    }

    public short[] getLinksUpsPosition() {
        return this.linksUpsPosition;
    }

    public int isExist(int position) {
        String pos = Integer.toString(position);
        String tag = (String)this.hashPositions.get(pos);
        if (this.hashPositions.containsKey(pos) && tag != null) {
            int whichTag = -1;
            for (int i = 0; i < TAGS2.length; ++i) {
                if (!TAGS2[i].equals(tag)) continue;
                whichTag = i;
            }
            if (whichTag < 5) {
                return whichTag;
            }
            return -2;
        }
        return -1;
    }
}

