/*
 * Decompiled with CFR 0.152.
 */
package mobi.forms;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.rms.RecordStoreException;
import mobi.data.AutoDrmRecordStore;
import mobi.data.DrmRecordStore;
import mobi.data.MobiStore;
import mobi.data.Titles;
import mobi.data.TitlesDao;
import mobi.items.MenuItem;
import mobi.log.LogErrorToServer;
import mobi.midp.MobiStatic;
import mobi.midp.MobiViewer;
import mobi.util.GetData;
import mobi.util.MobiIoException;
import mobi.util.NumberedException;
import mobi.util.ResourceBundle;
import mobi.util.ResponseCodeException;
import mobi.util.ServerException;
import mobi.util.TimeOutException;
import mobi.util.WrongTypeException;
import org.xmlpull.v1.XmlPullParserException;

public abstract class MidpForm
implements CommandListener {
    public static final int RECORDS_TO_SHOW = 9;
    public static final byte BACK = 5;
    public static final byte HOME = 10;
    public static final byte SUBMIT = 0;
    public static final byte EXIT = 13;
    public static final byte NEXT = 1;
    public static final byte TITLES = 11;
    public static final byte MAIN_MENU = 12;
    public static final byte BOOKMARK = 14;
    public static final byte GOTO = 15;
    public static final byte DELETE = 16;
    public static final byte YES = 18;
    public static final byte NO = 17;
    public static final String cmdBack;
    public static final String cmdSubmit;
    public static final String cmdHome;
    public static final String cmdMainMenu;
    public static final String cmdDelete;
    public static String cmdGoto;
    static Vector titles;
    static Vector invalid;
    static Vector expired;
    public static byte isBundled;
    public Vector commandVector = new Vector();
    public Vector constantVector = new Vector();
    public MobiViewer midp;
    public byte isFlowStopped = 0;
    public String mobiString;
    Form form;
    boolean handledError;
    boolean isBack;
    boolean inCommand = false;
    boolean haveError = false;
    MenuItem menuItem;
    String alertMessage;
    Command submitCommand = new Command(cmdSubmit, 4, 0);
    Command backCommand = new Command(cmdBack, 2, 5);
    Command mainMenuCommand = new Command(cmdMainMenu, 2, 12);
    Command homeCommand = new Command(cmdHome, 2, 10);
    Command exitCommand;
    Command yesCommand;
    Command noCommand;
    Command deleteCommand;

    protected MidpForm() {
    }

    public Form getForm() {
        return this.form;
    }

    public String getMobiString() {
        return this.mobiString;
    }

    public void setMidp(MobiViewer midp) {
        this.midp = midp;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (this.midp.getHashtable().get("errorMessage") != null) {
            return;
        }
        this.commandAction(command.getPriority());
    }

    public void addWarningCommands() {
        this.yesCommand = new Command(ResourceBundle.get("yes"), 4, 18);
        this.noCommand = new Command(ResourceBundle.get("no"), 7, 17);
        this.menuItem.addCommand(this.yesCommand);
        this.menuItem.addCommand(this.noCommand);
    }

    void checkAndGetDrm() throws ServerException, IOException, ResponseCodeException, XmlPullParserException, RecordStoreException, WrongTypeException, MobiIoException {
        if (titles == null || titles.size() == 0) {
            AutoDrmRecordStore autoDrm = new AutoDrmRecordStore();
            if (!autoDrm.needUpdate() || !this.getAutoDrm(autoDrm.getDrmKey())) {
                // empty if block
            }
            this.getTitlesDrm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAutoDrm(String drmKey) {
        Vector drms;
        String tempString = "";
        this.midp.getHashtable().put("drmKey", drmKey);
        tempString = System.getProperty("microedition.platform");
        if (System.getProperty("microedition.platform") == null) {
            tempString = "NA";
        }
        this.midp.getHashtable().put("platform", tempString);
        tempString = null;
        if (tempString == null) {
            tempString = "NA";
        }
        this.midp.getHashtable().put("contact", tempString);
        String url = MobiStatic.createUrl("drmJ2me.mobi", this.midp);
        GetData getData = new GetData();
        try {
            drms = getData.getData(url, "drm");
        }
        catch (Exception e) {
            this.handleError(e);
            return false;
        }
        AutoDrmRecordStore autoDrmRecordStore = null;
        try {
            autoDrmRecordStore = new AutoDrmRecordStore();
            autoDrmRecordStore.add(drmKey);
        }
        catch (RecordStoreException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (autoDrmRecordStore != null) {
                autoDrmRecordStore.close();
            }
        }
        DrmRecordStore drmRecordStore = null;
        try {
            drmRecordStore = new DrmRecordStore();
            for (int i = 0; i < drms.size(); ++i) {
                String drm = (String)drms.elementAt(i);
                drmRecordStore.add(drm);
            }
        }
        catch (RecordStoreException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (drmRecordStore != null) {
                drmRecordStore.close();
            }
        }
        return true;
    }

    public void handleError(Exception e) {
        String errorNumber = "";
        if (e instanceof NumberedException) {
            errorNumber = " (#" + ((NumberedException)e).exceptionNumber + ") ";
        }
        this.handledError = true;
        if (e instanceof IOException) {
            this.showError(ResourceBundle.get("unable_to_connect") + errorNumber);
            return;
        }
        if (e instanceof MobiIoException) {
            this.showError(ResourceBundle.get("unable_to_connect") + errorNumber);
            return;
        }
        if (e instanceof XmlPullParserException) {
            this.showError(ResourceBundle.get("unable_to_process") + errorNumber);
            MidpForm.logError("XML parser error -> " + this.midp.getHashtable().toString(), "");
            return;
        }
        if (e instanceof WrongTypeException) {
            this.showError(ResourceBundle.get("bad_response") + errorNumber);
            return;
        }
        if (e instanceof ResponseCodeException) {
            this.showError(this.getResponseMessage(((ResponseCodeException)e).code) + errorNumber);
            MidpForm.logError(" Response code : " + ((ResponseCodeException)e).code + "Response Message : " + e.getMessage() + this.midp.getHashtable().toString() + errorNumber, "");
            return;
        }
        if (e instanceof ServerException) {
            this.showError(e.getMessage() + errorNumber);
            return;
        }
        if (e instanceof TimeOutException) {
            this.showError(ResourceBundle.get("server_time_out") + errorNumber);
            return;
        }
        if (e instanceof SecurityException) {
            MobiStatic.isDataConnectionProblem = true;
            this.showError(ResourceBundle.get("security_error"));
            return;
        }
        this.showError(ResourceBundle.get("unknown_error") + errorNumber);
    }

    private String getResponseMessage(int responseCode) {
        String returnErrorMSg = "";
        switch (responseCode) {
            case 400: {
                returnErrorMSg = ResourceBundle.get("http_bad_request");
                break;
            }
            case 401: {
                returnErrorMSg = ResourceBundle.get("http_unauthorized");
                break;
            }
            case 403: {
                returnErrorMSg = ResourceBundle.get("http_forbidden");
                break;
            }
            case 404: {
                returnErrorMSg = ResourceBundle.get("http_not_found");
                break;
            }
            case 504: {
                returnErrorMSg = ResourceBundle.get("http_gateway_time_out");
                break;
            }
            case 500: {
                returnErrorMSg = ResourceBundle.get("unable_to_process");
                break;
            }
            case 503: {
                returnErrorMSg = ResourceBundle.get("http_unavilable");
                break;
            }
            default: {
                returnErrorMSg = ResourceBundle.get("unable_to_connect");
            }
        }
        return returnErrorMSg + "(" + responseCode + ")";
    }

    public static void logError(String errorMsg, String classPath) {
        LogErrorToServer logErrorToServer = new LogErrorToServer(errorMsg, classPath);
        Thread errorLogger = new Thread(logErrorToServer);
        errorLogger.start();
    }

    public void showError(String errorMsg) {
        this.midp.getHashtable().put("errorMessage", errorMsg);
        this.midp.goBackIfError();
    }

    boolean getTitlesDrm() throws ServerException, IOException, XmlPullParserException, ResponseCodeException, WrongTypeException, MobiIoException {
        String drms = this.getDrms();
        this.midp.getHashtable().put("drms", drms);
        String url = MobiStatic.createUrl("titlesDrm.mobi", this.midp);
        GetData getData = new GetData();
        Hashtable hashtable = getData.getData(url, new TitlesDao(), "title", new String[]{"invalid", "expired"});
        titles = (Vector)hashtable.get("titles");
        invalid = (Vector)hashtable.get("invalid");
        expired = (Vector)hashtable.get("expired");
        return true;
    }

    boolean getTitles(String key) throws ServerException, IOException, XmlPullParserException, ResponseCodeException, WrongTypeException, MobiIoException {
        this.midp.getHashtable().put("key", key);
        String url = MobiStatic.createUrl("titlesKey.mobi", this.midp);
        GetData getData = new GetData();
        Hashtable hashtable = getData.getData(url, new TitlesDao(), "title", new String[]{"invalid", "expired"});
        titles = (Vector)hashtable.get("titles");
        invalid = (Vector)hashtable.get("invalid");
        expired = (Vector)hashtable.get("expired");
        return true;
    }

    public String getDrms() {
        DrmRecordStore drmRecordStore;
        try {
            drmRecordStore = new DrmRecordStore();
        }
        catch (RecordStoreException e) {
            this.midp.getHashtable().put("errrorMessage", MobiStore.getError(e));
            this.handleError();
            return null;
        }
        return drmRecordStore.getAllString();
    }

    void handleError() {
        this.haveError = true;
        this.midp.clearBackForms();
        this.midp.getHashtable().put("next", "error.mobi");
        Thread thread = new Thread(this.midp);
        thread.start();
    }

    public boolean checkResposneCode(int responseCode, String classPath) {
        if (responseCode == -1) {
            this.showError(ResourceBundle.get("unable_to_connect"));
            return true;
        }
        if (responseCode != 200) {
            this.showError(ResourceBundle.get("unable_to_connect"));
            MidpForm.logError(" Response code : " + responseCode + "device.mobi", classPath);
            return true;
        }
        return false;
    }

    public void clearCommands() {
        this.menuItem.removeCommand(this.submitCommand);
        this.menuItem.removeCommand(this.exitCommand);
        this.menuItem.removeCommand(this.deleteCommand);
        this.menuItem.removeCommand(this.mainMenuCommand);
    }

    public void clearWarningCommands() {
        this.menuItem.removeCommand(this.yesCommand);
        this.menuItem.removeCommand(this.noCommand);
    }

    public void commandAction(int priority) {
        if (priority == 12) {
            this.midp.getHashtable().put("next", "menu.mobi");
            Thread t = new Thread(this.midp);
            t.start();
        } else if (priority == 5) {
            this.midp.back();
        } else if (priority == 10) {
            this.midp.titlesHome();
        } else if (priority == 13) {
            System.out.println("calling exitapp..........");
            this.midp.exitApp();
        } else {
            this.inCommand = false;
        }
    }

    public abstract void createForm();

    public GetData getHttpData(String urlIn) throws ServerException, XmlPullParserException, ResponseCodeException, IOException, WrongTypeException, MobiIoException {
        GetData getData = new GetData();
        getData.getData(MobiStatic.createUrl(urlIn, this.midp));
        return getData;
    }

    public int getIteration() {
        return -1;
    }

    boolean getTitlesDrmFormatted() throws ServerException, IOException, ResponseCodeException, XmlPullParserException, MobiIoException, WrongTypeException {
        String drms = this.getDrms();
        this.midp.getHashtable().put("drms", drms);
        String url = MobiStatic.createUrl("titlesDrmFormatted.mobi", this.midp);
        GetData getData = new GetData();
        getData.getData(url);
        this.midp.setHashtable(getData.getHashtable());
        return true;
    }

    public void handleCommand(int selection) {
    }

    public void nextIteration() {
        this.incrementIteration();
        this.midp.nextForm(this.getMobiAction());
    }

    public void incrementIteration() {
    }

    public String getMobiAction() {
        return "";
    }

    public String[] processVector(Vector vector, int iteration) {
        Vector temp = new Vector();
        for (int x = iteration * 9; x < vector.size(); ++x) {
            temp.addElement(vector.elementAt(x));
            if (temp.size() != 9) continue;
            if (x + 1 >= vector.size()) break;
            temp.addElement(ResourceBundle.get("more"));
            break;
        }
        Object[] array = new String[temp.size()];
        temp.copyInto(array);
        return array;
    }

    boolean runDataThread(Runnable runnable) {
        Thread dataThread = new Thread(runnable);
        dataThread.start();
        int counter = 0;
        while (dataThread.isAlive()) {
            if (++counter == MobiStatic.TIME_OUT) {
                return false;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        return true;
    }

    void setAlert(String alertString, String title, Displayable displayable) {
        Alert errorAlert = new Alert(title);
        errorAlert.setString(alertString);
        if (title.equals(ResourceBundle.get("confirm"))) {
            errorAlert.setType(AlertType.CONFIRMATION);
        } else {
            errorAlert.setType(AlertType.ERROR);
        }
        errorAlert.setTimeout(-2);
        this.midp.getDisplay().setCurrent(errorAlert, displayable);
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage + " " + ResourceBundle.get("press_any_key_to_continue");
    }

    public void setForm(String mobi) {
        this.mobiString = mobi;
    }

    void setTitle(Titles title) {
        ResourceBundle.loadLocale(title.getLocale());
        if (this.midp.getTitle() == null || this.midp.getTitle().getId() != title.getId()) {
            this.midp.setTitle(title);
        }
    }

    public void decrementIteration() {
    }

    public static boolean isMultiple(String drm) {
        boolean val = false;
        val = (drm = drm.substring(drm.indexOf(",") + 1)).indexOf(",") > -1;
        return val;
    }

    static {
        isBundled = 0;
        cmdSubmit = ResourceBundle.get("submit");
        cmdBack = ResourceBundle.get("back");
        cmdHome = ResourceBundle.get("title_home");
        cmdMainMenu = ResourceBundle.get("main_menu");
        cmdDelete = ResourceBundle.get("delete");
    }
}

