/*
 * Decompiled with CFR 0.152.
 */
package mobi.forms;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStoreException;
import mobi.data.AutoDrmRecordStore;
import mobi.data.Titles;
import mobi.forms.MidpForm;
import mobi.items.MenuItem;
import mobi.util.MobiIoException;
import mobi.util.ResourceBundle;
import mobi.util.ResponseCodeException;
import mobi.util.ServerException;
import mobi.util.TimeOutException;
import mobi.util.WrongTypeException;
import org.xmlpull.v1.XmlPullParserException;

public class TitleForm
extends MidpForm
implements Runnable {
    static int iteration = 0;
    static String next = "mainPage1.mobi";

    public static void resetIteration() {
        iteration = 0;
    }

    public int getIteration() {
        return iteration;
    }

    public void run() {
        if (titles == null || titles.size() == 0) {
            String drmKey = ResourceBundle.getNull("auto_drm");
            String carrier = ResourceBundle.getNull("carrier");
            if (carrier != null && drmKey.startsWith(carrier)) {
                try {
                    this.getTitles(drmKey);
                }
                catch (Exception e) {
                    this.handleError(e);
                }
            } else {
                AutoDrmRecordStore autoDrm;
                try {
                    autoDrm = new AutoDrmRecordStore();
                }
                catch (RecordStoreException e) {
                    return;
                }
                if (autoDrm.needUpdate() && !this.getAutoDrm(autoDrm.getDrmKey())) {
                    return;
                }
                try {
                    this.getTitlesDrm();
                }
                catch (Exception e) {
                    this.handleError(e);
                }
            }
        }
    }

    public void commandAction(int priority) {
        if (priority == 0) {
            this.handleCommand(this.menuItem.getSelection());
        } else {
            super.commandAction(priority);
        }
    }

    public void handleCommand(int selection) {
        if (this.menuItem.menuSize() == 10 && selection == 9) {
            this.nextIteration();
        } else {
            if (selection >= this.menuItem.menuSize()) {
                this.inCommand = false;
                this.menuItem.cancelAction();
                return;
            }
            int selected = selection + iteration * 9;
            Titles title = (Titles)titles.elementAt(selected);
            this.setTitle(title);
            this.midp.getHashtable().put("next", next);
            Thread thread = new Thread(this.midp);
            thread.start();
        }
    }

    public void createForm() {
        String errorString = null;
        if (!this.runDataThread(this)) {
            this.handleError(new TimeOutException(8));
        }
        if (this.handledError) {
            return;
        }
        this.mobiString = "titles.mobi";
        Vector<String> names = new Vector<String>();
        if (expired != null && expired.size() != 0) {
            errorString = ResourceBundle.get("drm_expired");
        } else if (invalid != null && invalid.size() != 0) {
            errorString = ResourceBundle.get("drm_invalid");
        } else {
            for (int i = 0; i < titles.size(); ++i) {
                Titles t = (Titles)titles.elementAt(i);
                names.addElement(t.getName());
            }
            if (names.size() == 1) {
                this.midp.getHashtable().put("next", next);
                this.midp.setTitle((Titles)titles.elementAt(0));
                Thread thread = new Thread(this.midp);
                thread.start();
                return;
            }
            isBundled = 1;
        }
        String[] array = this.processVector(names, iteration);
        this.menuItem = new MenuItem(array, this);
        if (errorString != null) {
            this.menuItem.setError(ResourceBundle.get("error"));
            this.menuItem.setAppError(errorString);
            this.menuItem.addCommand(this.mainMenuCommand);
        } else {
            this.menuItem.addCommand(this.submitCommand);
            if (iteration == 0) {
                this.menuItem.addCommand(this.mainMenuCommand);
            } else {
                this.menuItem.addCommand(this.backCommand);
            }
        }
        this.menuItem.setCommandListener(this);
        this.midp.getDisplay().setCurrent((Displayable)this.menuItem);
    }

    public void decrementIteration() {
        --iteration;
    }

    public void getData() throws ServerException, IOException, RecordStoreException, ResponseCodeException, XmlPullParserException, WrongTypeException, MobiIoException {
        this.checkAndGetDrm();
    }

    public String getMobiAction() {
        return "titles.mobi";
    }

    public void incrementIteration() {
        ++iteration;
    }
}

