/*
 * Decompiled with CFR 0.152.
 */
package mobi.util;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import mobi.data.ProcessDao;
import mobi.midp.MobiStatic;
import mobi.util.GetXml;
import mobi.util.MobiIoException;
import mobi.util.ResponseCodeException;
import mobi.util.ServerException;
import mobi.util.WrongTypeException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class GetData {
    public static final String SERVER_ERROR = "server threw error";
    Hashtable hashtable = new Hashtable();
    private GetXml getXml;

    public Hashtable getHashtable() {
        return this.hashtable;
    }

    public void getData(String url) throws XmlPullParserException, ServerException, ResponseCodeException, IOException, WrongTypeException, MobiIoException {
        this.getData(url, null);
    }

    private void cleanUp(KXmlParser parser) {
        this.getXml.closeConnection();
        if (parser != null) {
            parser.close();
            parser = null;
        }
        MobiStatic.cleanUpGc();
    }

    public Vector getData(String url, String tagName) throws XmlPullParserException, ServerException, ResponseCodeException, WrongTypeException, MobiIoException {
        Vector<String> vector = new Vector<String>();
        KXmlParser parser = null;
        try {
            parser = this.getParser(url);
        }
        catch (IOException e) {
            throw new MobiIoException(e.getMessage(), 16);
        }
        if (parser == null) {
            return vector;
        }
        int eventType = 2;
        try {
            while (eventType != 1) {
                eventType = parser.next();
                if (eventType != 2) continue;
                if (tagName != null && parser.getName().equals(tagName)) {
                    vector.addElement(parser.nextText());
                    continue;
                }
                this.hashtable.put(parser.getName(), parser.nextText());
            }
        }
        catch (IOException e) {
            throw new MobiIoException(e.getMessage(), 17);
        }
        this.cleanUp(parser);
        if (this.hasErorr()) {
            String strTemp = (String)this.hashtable.get("errorMessage");
            if (strTemp == null) {
                strTemp = SERVER_ERROR;
            }
            throw new ServerException(strTemp, 2);
        }
        return vector;
    }

    private KXmlParser getParser(String url) throws IOException, XmlPullParserException, ResponseCodeException, WrongTypeException, MobiIoException {
        this.getXml = new GetXml(url);
        return this.getXml.getViaHttpConnection();
    }

    public boolean hasErorr() {
        return this.hashtable.containsKey("errorMessage");
    }

    public Hashtable getData(String url, ProcessDao processDao, String tagNameDao, String[] tagNames) throws ServerException, IOException, XmlPullParserException, ResponseCodeException, WrongTypeException, MobiIoException {
        Vector<Object> titleVector = new Vector<Object>();
        KXmlParser parser = this.getParser(url);
        int eventType = 2;
        while (eventType != 1) {
            eventType = parser.next();
            String parserTagName = parser.getName();
            if (eventType != 2) continue;
            if (parserTagName.equals(tagNameDao)) {
                titleVector.addElement(processDao.process(parser));
                continue;
            }
            this.processHash(parser, parserTagName, tagNames);
        }
        this.cleanUp(parser);
        if (this.hasErorr()) {
            String strTemp = (String)this.hashtable.get("errorMessage");
            if (strTemp == null) {
                strTemp = SERVER_ERROR;
            }
            throw new ServerException(strTemp, 3);
        }
        this.hashtable.put("titles", titleVector);
        return this.hashtable;
    }

    private void processHash(KXmlParser parser, String parserTagName, String[] tagNames) throws IOException, XmlPullParserException {
        boolean found = false;
        for (int i = 0; i < tagNames.length; ++i) {
            String tagName = tagNames[i];
            if (tagName == null || !tagName.equals(parserTagName)) continue;
            Vector<String> vector = (Vector<String>)this.hashtable.get(tagName);
            if (vector == null) {
                vector = new Vector<String>();
                this.hashtable.put(tagName, vector);
            }
            vector.addElement(parser.nextText());
            found = true;
        }
        if (!found) {
            this.hashtable.put(parserTagName, parser.nextText());
        }
    }

    public Hashtable getDataHash(String url, String[] tagNames) throws IOException, XmlPullParserException, ServerException, ResponseCodeException, WrongTypeException, MobiIoException {
        KXmlParser parser = this.getParser(url);
        int eventType = 2;
        while (eventType != 1) {
            eventType = parser.next();
            String parserTagName = parser.getName();
            if (eventType != 2) continue;
            this.processHash(parser, parserTagName, tagNames);
        }
        this.cleanUp(parser);
        if (this.hasErorr()) {
            String strTemp = (String)this.hashtable.get("errorMessage");
            if (strTemp == null) {
                strTemp = SERVER_ERROR;
            }
            throw new ServerException(strTemp, 4);
        }
        return this.hashtable;
    }

    public int getResponseCode() {
        return this.getXml.getResponseCode();
    }
}

