/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobi.forms.MidpForm;
import mobi.items.BaseItem;
import mobi.items.RecordItem;
import mobi.util.ResourceBundle;

public class ImageViewer
extends BaseItem {
    private int screenWidth;
    private int actualScreenWidth;
    private int screenHeight;
    private int actualScreenHeight;
    private int imageWidth;
    private int imageHeight;
    private int x;
    private int y;
    private int verticalY = 0;
    private int horizontalX = 0;
    private int executeCountX = 0;
    private int executeCountY = 0;
    private Image origImage;
    private Image screenBuf;
    private Image leftImage;
    private Image rightImage;
    private Image upImage;
    private Image downImage;
    private Graphics bufferGraphics;
    private MidpForm form = null;
    private String[] preCommandString;
    private String[] preConstantString;
    private RecordItem recordItem;
    private short isButtonsDraw = 1;

    public ImageViewer(Image image, MidpForm midpForm, RecordItem recItem) {
        this.recordItem = recItem;
        this.executeCountX = 0;
        this.executeCountY = 0;
        this.form = midpForm;
        this.preCommandString = new String[this.form.commandVector.size()];
        this.form.commandVector.copyInto(this.preCommandString);
        this.preConstantString = new String[this.form.constantVector.size()];
        this.form.constantVector.copyInto(this.preConstantString);
        this.setFullScreenMode(true);
        this.actualScreenWidth = this.getWidth();
        this.actualScreenHeight = this.getHeight() - this.titleImageHeight;
        this.origImage = image;
        load_flag = false;
        try {
            this.leftImage = Image.createImage((String)"/left.png");
            this.rightImage = Image.createImage((String)"/right.png");
            this.upImage = Image.createImage((String)"/up.png");
            this.downImage = Image.createImage((String)"/down.png");
        }
        catch (Exception e) {
            this.origImage = null;
        }
        if (this.origImage != null) {
            this.screenHeight = this.origImage.getWidth() <= this.actualScreenWidth ? this.actualScreenHeight : this.actualScreenHeight - this.leftImage.getHeight() - 1;
            this.screenWidth = this.origImage.getHeight() <= this.actualScreenHeight ? this.actualScreenWidth : this.actualScreenWidth - this.upImage.getWidth() - 1;
            this.imageWidth = this.origImage.getWidth();
            this.imageHeight = this.origImage.getHeight();
        }
        this.x = 0;
        this.y = 0;
    }

    protected void paint(Graphics g) {
        if (this.loading == 1) {
            this.draw_loading(g);
            return;
        }
        if (load_flag) {
            return;
        }
        g.setColor(200, 200, 200);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.origImage != null) {
            if (this.origImage.getWidth() > this.getWidth() || this.origImage.getHeight() > this.getHeight() - this.titleImageHeight) {
                g.drawImage(this.origImage, this.x, this.y, 20);
            } else {
                g.drawImage(this.origImage, this.getWidth() / 2, this.getHeight() / 2, 3);
            }
        } else {
            g.setColor(200, 0, 0);
            String imageString = ResourceBundle.get("missing_image");
            g.drawString(imageString, this.getWidth() / 2 - g.getFont().stringWidth(imageString) / 2, this.getHeight() / 2, 0);
        }
        if (this.imageWidth > this.screenWidth) {
            g.setColor(200, 200, 200);
            g.fillRect(0, this.getHeight() - this.leftImage.getHeight() - this.titleImageHeight, this.getWidth(), this.leftImage.getHeight() + this.titleImageHeight);
            g.drawImage(this.leftImage, 0, this.actualScreenHeight - this.leftImage.getHeight(), 20);
            g.drawImage(this.rightImage, this.actualScreenWidth - this.rightImage.getWidth() * 3, this.actualScreenHeight - this.rightImage.getHeight(), 20);
            g.setColor(100, 100, 100);
            g.drawRect(this.leftImage.getWidth(), this.actualScreenHeight - this.leftImage.getHeight() + 2, this.actualScreenWidth - this.rightImage.getWidth() * 4, this.leftImage.getHeight() - 4);
            g.setColor(100, 100, 150);
            g.fillRect(this.leftImage.getWidth() + this.horizontalX, this.actualScreenHeight - this.leftImage.getHeight() + 2, (this.actualScreenWidth - this.rightImage.getWidth() * 4) / 2, this.leftImage.getHeight() - 4);
        }
        if (this.imageHeight > this.screenHeight) {
            g.setColor(200, 200, 200);
            g.fillRect(this.getWidth() - this.leftImage.getHeight(), 0, this.leftImage.getHeight(), this.getHeight());
            g.drawImage(this.upImage, this.actualScreenWidth - this.upImage.getWidth(), 0, 20);
            g.drawImage(this.downImage, this.actualScreenWidth - this.downImage.getWidth(), this.actualScreenHeight - this.downImage.getHeight() * 3, 20);
            g.setColor(100, 100, 100);
            g.drawRect(this.actualScreenWidth - this.upImage.getWidth() + 2, this.upImage.getHeight(), this.upImage.getWidth() - 4, this.actualScreenHeight - this.downImage.getHeight() * 4);
            g.setColor(100, 100, 150);
            g.fillRect(this.actualScreenWidth - this.upImage.getWidth() + 2, this.upImage.getHeight() + this.verticalY, this.upImage.getWidth() - 4, (this.actualScreenHeight - this.downImage.getHeight() * 4) / 2);
        }
        if (this.isButtonsDraw == 1) {
            this.isButtonsDraw = 0;
            this.form.commandVector.removeAllElements();
            this.form.constantVector.removeAllElements();
            this.form.commandVector.addElement(ResourceBundle.get("next"));
            this.form.constantVector.addElement(Integer.toString(1));
            this.form.commandVector.addElement(MidpForm.cmdBack);
            this.form.constantVector.addElement(Integer.toString(5));
            this.drawButtons(g, this.form.commandVector);
        }
    }

    public void run() {
        while (load_flag && this.loading == 1) {
            this.callPaints();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void keyRepeated(int keyCode) {
        if (this.hasRepeatEvents()) {
            this.moveImage(this.getGameAction(keyCode));
        }
    }

    protected void keyPressed(int keyCode) {
        switch (keyCode) {
            case -6: 
            case -5: {
                this.callLoading(0);
                this.form.commandAction(1);
                break;
            }
            case -7: {
                if (this.recordItem != null) {
                    this.resetCommands();
                    this.form.midp.getDisplay().setCurrent((Displayable)this.recordItem);
                    this.recordItem.setPreviousPage();
                    break;
                }
                this.callLoading(0);
                this.form.setInCommand(false);
                this.form.commandAction(5);
            }
        }
        this.moveImage(this.getGameAction(keyCode));
    }

    private void moveImage(int gameAction) {
        boolean isRepaint = false;
        switch (gameAction) {
            case 1: {
                if (this.y >= 0) break;
                this.y += 4;
                if (this.y > 0) {
                    this.y = 0;
                }
                --this.executeCountY;
                this.verticalY -= this.getVerticalScroll();
                if (this.y == 0) {
                    this.verticalY = 0;
                }
                isRepaint = true;
                break;
            }
            case 6: {
                if (this.y <= this.screenHeight - this.imageHeight) break;
                this.y -= 4;
                if (this.y < this.screenHeight - this.imageHeight) {
                    this.y = this.screenHeight - this.imageHeight;
                }
                ++this.executeCountY;
                this.verticalY += this.getVerticalScroll();
                if (this.y == this.screenHeight - this.imageHeight) {
                    this.verticalY = this.actualScreenHeight - this.downImage.getHeight() * 4 - (this.actualScreenHeight - this.downImage.getHeight() * 4) / 2;
                }
                isRepaint = true;
                break;
            }
            case 2: {
                if (this.x >= 0) break;
                this.x += 4;
                if (this.x > 0) {
                    this.x = 0;
                }
                --this.executeCountX;
                this.horizontalX -= this.getHorizontalScroll();
                if (this.x == 0) {
                    this.horizontalX = 0;
                }
                isRepaint = true;
                break;
            }
            case 5: {
                if (this.x <= this.screenWidth - this.imageWidth) break;
                this.x -= 4;
                if (this.x < this.screenWidth - this.imageWidth) {
                    this.x = this.screenWidth - this.imageWidth;
                }
                ++this.executeCountX;
                this.horizontalX += this.getHorizontalScroll();
                if (this.x == this.screenWidth - this.imageWidth) {
                    this.horizontalX = this.actualScreenWidth - this.leftImage.getWidth() * 4 - (this.actualScreenWidth - this.rightImage.getWidth() * 4) / 2;
                }
                isRepaint = true;
            }
        }
        if (isRepaint) {
            this.isButtonsDraw = 1;
            this.repaint();
        }
    }

    private int getVerticalScroll() {
        int diff = this.imageHeight - this.screenHeight;
        int slot = diff / 4;
        int emptyBar = this.actualScreenHeight - this.upImage.getHeight() * 5 - (this.actualScreenHeight - this.downImage.getHeight() * 4) / 2;
        if (diff % 4 > 0) {
            ++slot;
        }
        int div = slot;
        int dev = emptyBar;
        int output = dev / div;
        if (dev % div > 3) {
            output += this.getRandomPart(div, dev, this.executeCountY);
        }
        return output;
    }

    private int getHorizontalScroll() {
        int diff = this.imageWidth - this.screenWidth;
        int slot = diff / 4;
        int emptyBar = this.actualScreenWidth - this.leftImage.getWidth() * 5 - (this.actualScreenWidth - this.leftImage.getWidth() * 4) / 2;
        if (diff % 4 > 0) {
            ++slot;
        }
        int div = slot;
        int dev = emptyBar;
        int output = dev / div;
        if (dev % div > 3) {
            output += this.getRandomPart(div, dev, this.executeCountX);
        }
        return output;
    }

    private int getRandomPart(int divV, int devV, int counterX) {
        int remainder;
        int output = 0;
        int div = divV;
        int dev = devV;
        for (int i = 0; i <= 3 && (remainder = dev % div) > 1; ++i) {
            int randomNo = remainder / (div / 2);
            if (randomNo >= 1) {
                if (i == 0 && counterX % 2 == 0) {
                    output += randomNo;
                }
                if (i == 1 && counterX % 4 == 0) {
                    output += randomNo;
                }
                if (i == 2 && counterX % 8 == 0) {
                    output += randomNo;
                }
                if (i == 3 && counterX % 16 == 0) {
                    output += randomNo;
                }
            }
            dev = remainder % (div / 2);
            div /= 2;
        }
        return output;
    }

    private void resetCommands() {
        this.form.commandVector.removeAllElements();
        this.form.constantVector.removeAllElements();
        for (int i = 0; i < this.preCommandString.length; ++i) {
            this.form.commandVector.addElement(this.preCommandString[i]);
            this.form.constantVector.addElement(this.preConstantString[i]);
        }
    }
}

