/*
 * Decompiled with CFR 0.152.
 */
package mobi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ResourceBundle {
    private static Hashtable hash = new Hashtable();
    private static boolean systemPropertiesLoaded = false;
    private static String locale = null;

    public static void create() throws Exception {
        if (!systemPropertiesLoaded) {
            ResourceBundle.load("system.properties");
            systemPropertiesLoaded = true;
            ResourceBundle.loadLocale(ResourceBundle.get("locale"));
        }
    }

    private static void load(String propertiesFile) throws IOException {
        InputStream inputStream = hash.getClass().getResourceAsStream("/" + propertiesFile);
        StringBuffer sb = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        int c = inputStream.read();
        while (c != -1) {
            char ch = (char)c;
            if (ch == '\n') {
                vector.addElement(sb.toString());
                sb = new StringBuffer();
            } else {
                sb.append(ch);
            }
            c = inputStream.read();
        }
        ResourceBundle.parseVector(vector);
    }

    static void parseVector(Vector vector) {
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            ResourceBundle.parseString((String)e.nextElement());
        }
    }

    static void parseString(String s) {
        int e = s.indexOf(61);
        if (e == -1) {
            return;
        }
        String name = s.substring(0, e);
        String value = s.substring(e + 1, s.length());
        hash.put(name.trim(), value.trim());
    }

    public static void loadLocale(String localeIn) {
        localeIn = localeIn.trim();
        if (locale != null && localeIn.equals(locale)) {
            return;
        }
        try {
            ResourceBundle.load("message.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String get(String name) {
        String value = ResourceBundle.getNull(name);
        if (value == null) {
            return "???" + name + "???";
        }
        return value;
    }

    public static String getNull(String name) {
        try {
            ResourceBundle.create();
        }
        catch (Exception e) {
            return null;
        }
        return (String)hash.get(name);
    }

    public static String get(String name, String values) {
        return ResourceBundle.get(name, new String[]{values});
    }

    public static String get(String name, String[] values) {
        String value = ResourceBundle.getNull(name);
        if (value == null) {
            return "???" + name + "???";
        }
        for (int i = 0; i < values.length; ++i) {
            value = ResourceBundle.replace(value, "{" + i + "}", values[i]);
        }
        return value;
    }

    private static String replace(String text, String searchStr, String replacementStr) {
        StringBuffer sb = new StringBuffer();
        int pos = text.indexOf(searchStr);
        while (pos != -1) {
            sb.append(text.substring(0, pos)).append(replacementStr);
            text = text.substring(pos + searchStr.length());
            pos = text.indexOf(searchStr);
        }
        sb.append(text);
        return sb.toString();
    }
}

