/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import mobi.forms.RecordForm;
import mobi.items.BaseItem;
import mobi.items.RecordData;
import mobi.midp.MobiStatic;
import mobi.util.ResourceBundle;
import mobi.util.WrapLine;

public class RecordItem
extends BaseItem {
    private static final int XOFFSET = 5;
    String stringData;
    short startOffsets = 0;
    String[] arrLines = null;
    RecordForm recordForm;
    RecordData recordData;
    private int yOffset = 0;
    private int currentLinkUpLine = 0;
    private int highlightedLinkUps = 0;
    private int firstVisLineNum = 0;
    private byte numOflinesPerPage = 0;
    private boolean isImage = false;
    private short currentFootNote = 0;
    private short[] lineLength = null;
    private boolean isLinkUpShown = false;
    private int postTextImageHeight = 0;
    private short imgCount = 0;
    private short numTitleLines = 0;
    private int aCount = 0;
    private Thread titleThread = null;
    boolean ScrollTitle = false;
    boolean dontReturn = false;
    short prevFootNote = 0;
    int avoidSuperScriptCollision = 0;
    int charCount;
    int halfFontHeight = 0;
    int yPosition = 0;
    int drawOnlyVisibleLines = 0;
    int widthOfDrawnChar;
    char ch;
    int xPosition;
    int yPos;
    short[] linkUpPos = null;
    int startOfLinkOfValues;
    int rectWidth;
    int rectHeight;
    int supscriptPosition;
    int yOffsetOfLastLine;
    private static int titleX = 10;

    public RecordItem(String stringData, RecordData recordData, RecordForm recordForm, String title) {
        this.stringData = stringData;
        this.recordForm = recordForm;
        this.recordData = recordData;
        this.setScreenTitle(title);
        if (this.screenTitle != null) {
            this.numTitleLines = 1;
        }
        if (bold.stringWidth(this.screenTitle) > width - bold.stringWidth("W") * 4) {
            this.TITLE_SCROLL = this.titleThread = new Thread(this);
            this.load_thread = true;
        }
        this.fontHeight = (short)normal.getHeight();
        this.setHeaderBoolean(false);
        this.setHeaderHeight((byte)(headerHeight + this.fontHeight + 2));
        this.yOffset = this.fontHeight * this.numTitleLines + 2;
        this.numOflinesPerPage = (byte)((height + headerHeight + this.getHeight() / 8) / this.fontHeight);
        if (stringData.trim().length() != 0) {
            this.wrap(stringData);
        }
        this.aCount = recordData.getACount();
    }

    private void wrap(String stringData) {
        Vector<String> lineVector = new Vector<String>();
        Vector<String> positions = new Vector<String>();
        WrapLine wrapLine = new WrapLine(bold, stringData, width - 15);
        while (wrapLine.hasMoreElements()) {
            lineVector.addElement(wrapLine.nextElement().toString());
            positions.addElement(wrapLine.getEndPosition());
        }
        this.arrLines = new String[lineVector.size()];
        this.lineLength = new short[positions.size()];
        lineVector.copyInto(this.arrLines);
        for (int i = 0; i < positions.size(); ++i) {
            this.lineLength[i] = Short.parseShort((String)positions.elementAt(i));
        }
    }

    public void run() {
        while (Thread.currentThread().equals(this.TITLE_SCROLL) || this.ScrollTitle) {
            try {
                this.callPaints();
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int gethighlightedLinkUps() {
        return this.highlightedLinkUps;
    }

    public boolean getisLinkUpShown() {
        return this.isLinkUpShown;
    }

    protected void keyPressed(int keyCode) {
        if (this.appErrorStr != null) {
            if (MobiStatic.isDataConnectionProblem) {
                MobiStatic.isDataConnectionProblem = false;
                this.recordForm.midp.exitApp();
            } else {
                this.cancelAlertMessage(this.recordForm);
            }
            return;
        }
        int dPad = this.getGameAction(keyCode);
        if (this.ALERT_TRUE) {
            this.ALERT_TRUE = false;
            this.callPaints();
            return;
        }
        if (this.appErrorStr != null) {
            return;
        }
        Integer[] linkUps = this.recordData.getLinkUps();
        try {
            int gameAction = this.getGameAction(keyCode);
            if (gameAction == 8 && keyCode != 53) {
                this.recordForm.commandAction(1);
                return;
            }
            if (dPad == 1) {
                this.dontReturn = true;
                this.executeUpKeyEvent();
            } else if (dPad == 6) {
                this.dontReturn = true;
                this.executeDownKeyEvent();
            } else if (keyCode == 35) {
                if (this.isLinkUpShown && linkUps[this.highlightedLinkUps] != null) {
                    this.recordForm.executeNext(linkUps[this.highlightedLinkUps]);
                }
            } else if (keyCode == 42) {
                this.recordForm.commandAction(14);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void keyRepeated(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: 
            case 6: {
                this.keyPressed(keyCode);
                break;
            }
        }
    }

    public void callPaints() {
        this.repaint();
        this.serviceRepaints();
    }

    private void executeUpKeyEvent() {
        if (!(this.yOffset - this.fontHeight * this.numTitleLines >= 0 || this.currentLinkUpLine >= this.firstVisLineNum + this.numOflinesPerPage - 4 && this.isLinkUpShown && this.highlightedLinkUps != 0)) {
            this.yOffset = (short)(this.yOffset + this.fontHeight);
        } else if (this.highlightedLinkUps > 0) {
            this.highlightedLinkUps = (short)(this.highlightedLinkUps - 1);
        }
        this.resetVar();
        --this.firstVisLineNum;
    }

    private void resetVar() {
        this.currentFootNote = 0;
        this.isLinkUpShown = false;
        this.callPaints();
    }

    private void executeDownKeyEvent() {
        boolean lineTillScrollAllows;
        if (this.arrLines == null) {
            return;
        }
        boolean bl = lineTillScrollAllows = this.firstVisLineNum + this.numOflinesPerPage - 2 <= this.arrLines.length;
        if (lineTillScrollAllows && (this.currentLinkUpLine >= this.firstVisLineNum + headerHeightInLines + 1 || this.aCount == 0 || !this.isLinkUpShown)) {
            this.yOffset -= this.fontHeight;
        } else if (this.highlightedLinkUps < this.aCount - 1) {
            ++this.highlightedLinkUps;
        } else if (lineTillScrollAllows && this.highlightedLinkUps == this.aCount - 1) {
            this.yOffset -= this.fontHeight;
        }
        this.resetVar();
    }

    void resetPaintVariables() {
        this.prevFootNote = 0;
        this.avoidSuperScriptCollision = 0;
        this.charCount = 0;
        this.halfFontHeight = 0;
        this.yPosition = 0;
        this.drawOnlyVisibleLines = 0;
        this.startOffsets = 0;
    }

    protected void paint(Graphics g) {
        if (!this.ScrollTitle || this.dontReturn) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, this.fontHeight + 2, width, this.getHeight());
            g.setColor(0, 0, 0);
            g.setFont(normal);
        }
        this.resetPaintVariables();
        this.setBackGroundImage(g);
        if (this.screenTitle != null && this.TITLE_SCROLL == null) {
            this.drawScreenTitle(g, this.screenTitle);
        } else if (this.screenTitle != null && this.TITLE_SCROLL != null && this.ScrollTitle) {
            this.drawScreenTitle(g, this.screenTitle);
            if (!this.dontReturn) {
                return;
            }
            this.dontReturn = false;
        }
        int y = bold.getHeight() + 2;
        g.setClip(0, y, width, height - y);
        g.setColor(0);
        int n = this.drawOnlyVisibleLines = this.firstVisLineNum < 0 ? 0 : this.firstVisLineNum;
        if (this.drawOnlyVisibleLines > 0) {
            this.startOffsets = this.lineLength[this.drawOnlyVisibleLines - 1];
        }
        for (int i = this.drawOnlyVisibleLines; i < this.arrLines.length && i < this.drawOnlyVisibleLines + this.numOflinesPerPage + 1; ++i) {
            this.charCount = 0;
            this.widthOfDrawnChar = 0;
            this.firstVisLineNum = this.yOffset / this.fontHeight * -1;
            while (this.charCount < this.arrLines[i].length()) {
                this.ch = this.arrLines[i].charAt(this.charCount++);
                if (this.ch == '\n') {
                    this.startOffsets = this.lineLength[i];
                    continue;
                }
                this.setDataFont(g, this.startOffsets);
                this.xPosition = 5 + this.widthOfDrawnChar;
                this.linkUpPos = this.recordData.getLinksUpsPosition();
                this.startOfLinkOfValues = this.linkUpPos.length / 2 + this.highlightedLinkUps;
                this.yPosition = this.yOffset + this.fontHeight * i;
                if (g.getFont() == linkUps && this.startOffsets >= this.linkUpPos[this.highlightedLinkUps] && this.startOffsets <= this.linkUpPos[this.startOfLinkOfValues]) {
                    this.currentLinkUpLine = i;
                    this.isLinkUpShown = true;
                    g.setColor(0, 255, 255);
                    this.rectWidth = g.getFont().stringWidth(this.ch + "");
                    this.rectHeight = g.getFont().getHeight();
                    g.fillRect(this.xPosition, this.yPosition, this.rectWidth, this.rectHeight);
                    g.setColor(0, 0, 0);
                }
                this.supscriptPosition = this.charCount - (1 + String.valueOf(this.currentFootNote).length());
                int n2 = this.supscriptPosition = this.supscriptPosition < 0 ? 0 : this.supscriptPosition;
                if (g.getFont() == footnotes && this.arrLines[i].charAt(this.supscriptPosition) != ':') {
                    this.halfFontHeight = this.avoidSuperScriptCollision == 1 ? (int)this.fontHeight : this.fontHeight / 2;
                    this.prevFootNote = 1;
                    this.yPosition = this.yOffset + this.fontHeight * i + this.halfFontHeight;
                } else if (this.ch != ' ' && this.prevFootNote == 1) {
                    this.yPosition = this.yOffset + this.fontHeight * i;
                    if (this.avoidSuperScriptCollision == 1) {
                        this.yPosition += this.fontHeight / 2;
                    }
                } else {
                    this.prevFootNote = 0;
                    this.yPosition = this.yOffset + this.fontHeight * i + this.halfFontHeight;
                }
                g.drawChar(this.ch, this.xPosition, this.yPosition, 20);
                this.widthOfDrawnChar += g.getFont().stringWidth(this.ch + "");
                this.startOffsets = (short)(this.startOffsets + 1);
            }
            int n3 = this.avoidSuperScriptCollision = this.prevFootNote == 1 ? 1 : 0;
            if (this.startOffsets != this.lineLength[i]) {
                this.setDataFont(g, this.startOffsets);
            }
            this.startOffsets = this.lineLength[i];
        }
        this.appErrorStr = (String)this.recordForm.midp.getHashtable().get("errorMessage");
        if (this.appErrorStr != null) {
            this.recordForm.clearCommands();
            if (!MobiStatic.isDataConnectionProblem) {
                this.appErrorStr = this.appErrorStr + " " + ResourceBundle.get("press_any_key_to_continue");
            }
            this.showAlert(g, this.appErrorStr);
        }
        if (this.ALERT_TRUE) {
            this.showAlert(g, ResourceBundle.get("last_record") + " " + ResourceBundle.get("press_any_key_to_continue"));
        }
        if (this.titleThread != null && this.load_thread) {
            this.ScrollTitle = true;
            this.load_thread = false;
            this.titleThread.start();
        }
    }

    private void setDataFont(Graphics g, int startOffsets) {
        short type = (short)this.recordData.isExist(startOffsets);
        if (type != -1) {
            this.setFont(g, type);
        }
    }

    private void setFont(Graphics g, int fontType) {
        switch (fontType) {
            case 0: {
                g.setFont(bold);
                break;
            }
            case 1: {
                g.setFont(italics);
                break;
            }
            case 3: {
                g.setColor(0, 0, 255);
                g.setFont(linkUps);
                break;
            }
            case 4: {
                this.currentFootNote = (short)(this.currentFootNote + 1);
                g.setColor(131, 1, 118);
                g.setFont(footnotes);
                break;
            }
            default: {
                g.setColor(0);
                g.setFont(normal);
            }
        }
    }

    private void drawScreenTitle(Graphics g, String title) {
        int adjust = bold.stringWidth("W") * 2;
        int imageHeight = 0;
        g.setClip(0, imageHeight, width, bold.getHeight() + 2);
        g.setColor(0xFFFFFF);
        g.fillRect(0, imageHeight, width, bold.getHeight() + 2);
        g.setFont(bold);
        g.setColor(0);
        g.setClip(adjust, imageHeight, width - adjust * 2, bold.getHeight() + 2);
        if (Thread.currentThread().equals(this.TITLE_SCROLL) || this.load_thread || this.ScrollTitle) {
            g.drawString(this.screenTitle, titleX, imageHeight + 2, 20);
            titleX = titleX + bold.stringWidth(this.screenTitle) - adjust == 0 ? width - adjust : (titleX = titleX - 1);
        } else {
            g.drawString(this.screenTitle, width / 2, imageHeight + 2, 17);
        }
    }
}

