/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import javax.microedition.lcdui.Graphics;
import mobi.forms.BookmarksForm;
import mobi.forms.MenuForm;
import mobi.forms.MidpForm;
import mobi.items.BaseItem;
import mobi.midp.MobiStatic;
import mobi.midp.MobiViewer;
import mobi.util.ResourceBundle;

public class MenuItem
extends BaseItem {
    boolean didAction;
    public int selection;
    int startArray;
    int numOfLinesPerPage;
    int currentLine;
    int topImageHeight;
    String[] array;
    MidpForm form;
    private Thread titleThread = null;
    boolean firstTime = true;
    private int yOffset = 0;
    MobiViewer mobi = null;
    boolean ScrollTitle = false;
    boolean dontReturn = false;
    long lastTime = 0L;
    private static int titleX = 10;

    public MenuItem(String[] array, MidpForm form) {
        this.setArray(array);
        this.form = form;
        this.fontHeight = (short)bold.getHeight();
        this.numOfLinesPerPage = height / this.fontHeight;
        titleX = bold.stringWidth("W") * 3;
        if (array != null) {
            this.screenTitle = "bookmarks.mobi".equals(form.getMobiAction()) ? ResourceBundle.get("bookmarks") : ("titles.mobi".equals(form.getMobiAction()) ? ResourceBundle.get("choose_title") : ("menu.mobi".equals(form.getMobiAction()) ? ResourceBundle.get("main_menu") : (MidpForm.isBundled == 1 ? form.midp.title.getName() : ResourceBundle.get("app_title"))));
            if (bold.stringWidth(this.screenTitle) > width - bold.stringWidth("W") * 6) {
                this.TITLE_SCROLL = this.titleThread = new Thread(this);
                this.load_thread = true;
            }
        }
    }

    private void setArray(String[] arrayIn) {
        if (arrayIn == null || arrayIn.length == 0) {
            return;
        }
        this.array = new String[arrayIn.length];
        for (int i = 0; i < arrayIn.length; ++i) {
            int c = i == 9 ? 0 : i + 1;
            this.array[i] = " " + c + ". " + arrayIn[i];
        }
    }

    public int getSelection() {
        return this.selection;
    }

    public void run() {
        while (Thread.currentThread().equals(this.TITLE_SCROLL) || this.ScrollTitle) {
            try {
                this.callPaints();
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void cancelAction() {
        this.didAction = false;
        this.selection = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int keyCode) {
        if (this.appErrorStr != null) {
            if (MobiStatic.isDataConnectionProblem) {
                MobiStatic.isDataConnectionProblem = false;
                this.form.midp.exitApp();
            } else {
                this.cancelAlertMessage(this.form);
            }
            return;
        }
        if (this.array == null || this.array.length == 0) {
            return;
        }
        String keyName = this.getKeyName(keyCode);
        int gameAction = this.getGameAction(keyCode);
        if (this.LOADING_SCREEN == 1) {
            return;
        }
        if (this.appErrorStr != null) {
            return;
        }
        MenuItem menuItem = this;
        synchronized (menuItem) {
            if (this.didAction) {
                return;
            }
            if (!(keyCode != this.getKeyCode(2) && keyCode != this.getKeyCode(5) || keyName.equals("4") || keyName.equals("6"))) {
                return;
            }
            if (gameAction == 8 && keyCode != 53) {
                if (!MenuForm.yes_no && !BookmarksForm.boookmarks_command) {
                    this.form.handleCommand(this.getSelection());
                } else {
                    if (MenuForm.yes_no) {
                        MenuForm.yes_no = false;
                        this.form.midp.exitApp();
                        return;
                    }
                    if (BookmarksForm.boookmarks_command) {
                        this.form.commandAction(18);
                    }
                }
                return;
            }
            boolean foundKey = false;
            if (keyCode == 42) {
                this.form.commandAction(16);
            } else if (keyCode == 48 || keyCode == 49 || keyCode == 50 || keyCode == 51 || keyCode == 52 || keyCode == 53 || keyCode == 54 || keyCode == 55 || keyCode == 56 || keyCode == 57 || keyName.equals("2") || keyName.equals("4") || keyName.equals("6") || keyName.equals("8")) {
                this.selection = this.findKey(keyCode);
                foundKey = this.selection != -1;
            } else {
                if (gameAction == 1) {
                    this.dontReturn = true;
                    if (this.decrementSelection()) {
                        this.callPaints();
                    }
                    return;
                }
                if (gameAction == 6) {
                    this.dontReturn = true;
                    if (this.incrementSelection()) {
                        this.callPaints();
                    }
                    return;
                }
            }
            if (foundKey) {
                this.repaint();
                try {
                    Thread.sleep(75L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.didAction = true;
                this.selection = this.selection == 0 ? 9 : --this.selection;
                this.form.handleCommand(this.selection);
            }
        }
    }

    protected void keyRepeated(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: 
            case 6: {
                this.keyPressed(keyCode);
                break;
            }
        }
    }

    private boolean decrementSelection() {
        if (this.currentLine <= this.startArray && this.startArray > 0) {
            --this.startArray;
            this.downArrow = true;
        } else if (this.upArrow && this.startArray <= 0) {
            this.upArrow = false;
            this.callPaints();
        }
        if (this.startArray == 0 && this.yOffset < 0) {
            this.yOffset += this.fontHeight;
        }
        if (this.selection > 0) {
            --this.selection;
            return true;
        }
        return false;
    }

    private boolean incrementSelection() {
        boolean booReturn = false;
        int arrLen = this.array.length;
        if (this.currentLine >= this.numOfLinesPerPage - 1 && this.currentLine < arrLen && this.startArray <= arrLen - this.numOfLinesPerPage) {
            this.upArrow = true;
            ++this.startArray;
            booReturn = true;
        } else if (this.downArrow && this.startArray > 0) {
            this.downArrow = false;
            this.callPaints();
        }
        if (this.selection + 1 < this.array.length) {
            ++this.selection;
            booReturn = true;
        }
        return booReturn;
    }

    public int menuSize() {
        return this.array.length;
    }

    protected void paint(Graphics g) {
        int j;
        if (!this.ScrollTitle || this.dontReturn) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, width, this.getHeight());
            g.setColor(0, 0, 0);
            g.setFont(normal);
        }
        if (this.LOADING_SCREEN == 1) {
            g.drawString(ResourceBundle.get("loading"), width / 2, height / 2, 17);
            return;
        }
        if (this.firstTime) {
            this.selection = 0;
            this.firstTime = false;
        }
        int x = 5;
        if (this.screenTitle != null && this.TITLE_SCROLL == null) {
            this.drawScreenTitle(g, this.screenTitle);
        } else if (this.screenTitle != null && this.TITLE_SCROLL != null && this.ScrollTitle) {
            this.drawScreenTitle(g, this.screenTitle);
            if (!this.dontReturn) {
                return;
            }
            this.dontReturn = false;
        }
        int y = bold.getHeight() + 2;
        y += this.yOffset;
        if (this.errorStr != null) {
            if (this.titleThread != null && this.load_thread) {
                this.ScrollTitle = true;
                this.load_thread = false;
                this.titleThread.start();
            }
            g.setClip(0, 0, width, height);
            this.drawMenu(g, 20, this.errorStr, width - 10, 5, y);
            return;
        }
        if (this.appErrorStr != null) {
            g.drawString(this.appErrorStr, width / 2, y + 5 + this.fontHeight, 17);
            this.appErrorStr = null;
        }
        this.topImageHeight = y / this.fontHeight;
        this.numOfLinesPerPage = (height - y - this.fontHeight) / this.fontHeight;
        g.setClip(0, 0, width, height);
        for (j = 0; j < this.array.length; ++j) {
        }
        for (j = this.startArray; j < this.array.length; ++j) {
            String s = this.array[j];
            if (this.selection == j) {
                g.setColor(0, 0, 255);
                g.setFont(bold);
                y = this.drawMenu(g, 20, s, width - 10, x, y);
                this.currentLine = j;
            } else {
                this.drawMenu(g, s, x, y);
            }
            y += this.fontHeight + 2;
        }
        this.appErrorStr = (String)this.form.midp.getHashtable().get("errorMessage");
        if (this.appErrorStr != null) {
            if (!MobiStatic.isDataConnectionProblem) {
                this.appErrorStr = this.appErrorStr + " " + ResourceBundle.get("press_any_key_to_continue");
            }
            this.form.clearCommands();
            this.showAlert(g, this.appErrorStr);
        }
        if (this.ALERT_TRUE) {
            this.form.clearCommands();
            this.showAlert(g, this.confirmMessage);
        }
        if (this.titleThread != null && this.load_thread) {
            this.ScrollTitle = true;
            this.load_thread = false;
            this.titleThread.start();
        }
    }

    private void drawMenu(Graphics g, String text, int x, int y) {
        int widthOfDrawingArea = width;
        g.setFont(normal);
        if (normal.stringWidth(text) > widthOfDrawingArea) {
            text = this.getDotAppendString(widthOfDrawingArea, text);
        }
        g.setColor(0, 0, 0);
        g.drawString(text, x, y, 20);
    }

    private String getDotAppendString(int screenWidth, String text) {
        int lineWidth = 0;
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if ((lineWidth += normal.stringWidth("" + ch)) >= screenWidth) break;
            strBuffer.append(ch);
        }
        strBuffer.delete(strBuffer.length() - 3, strBuffer.length()).append("...");
        return strBuffer.toString();
    }

    public void setAppError(String error) {
        this.appErrorStr = error;
    }

    public void setError(String error) {
        this.errorStr = error;
    }

    private void drawScreenTitle(Graphics g, String title) {
        int adjust = bold.stringWidth("W") * 2;
        int imageHeight = 0;
        g.setClip(0, imageHeight, width, bold.getHeight() + 2);
        g.setColor(0xFFFFFF);
        g.fillRect(0, imageHeight, width, bold.getHeight() + 2);
        g.setFont(bold);
        g.setColor(0);
        g.setClip(adjust, imageHeight, width - adjust * 2, bold.getHeight() + 2);
        if (Thread.currentThread().equals(this.TITLE_SCROLL) || this.load_thread || this.ScrollTitle) {
            g.drawString(this.screenTitle, titleX, imageHeight + 2, 20);
            titleX = titleX + bold.stringWidth(this.screenTitle) - adjust == 0 ? width - adjust : (titleX = titleX - 1);
        } else {
            g.drawString(this.screenTitle, width / 2, imageHeight + 2, 17);
        }
    }
}

