/*
 * Decompiled with CFR 0.152.
 */
package mobi.forms;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import mobi.forms.MidpForm;
import mobi.items.MenuItem;
import mobi.midp.MobiStatic;
import mobi.util.GetData;
import mobi.util.ResourceBundle;
import mobi.util.TimeOutException;

public abstract class SearchBaseResults
extends MidpForm
implements Runnable {
    static Vector ids;
    static Vector names;
    static int iteration;

    public SearchBaseResults(String mobi, boolean isBack) {
        this.mobiString = mobi;
        this.isBack = isBack;
    }

    public int getIteration() {
        return iteration;
    }

    public void run() {
        if (!this.isBack) {
            Hashtable hashtable;
            iteration = 0;
            String url = MobiStatic.createUrl(this.getAction(), this.midp);
            GetData getData = new GetData();
            try {
                hashtable = getData.getDataHash(url, new String[]{"ids", "names"});
            }
            catch (Exception e) {
                this.handleError(e);
                return;
            }
            ids = (Vector)hashtable.remove("ids");
            names = (Vector)hashtable.remove("names");
            this.midp.setHashtable(getData.getHashtable());
        }
    }

    public void commandAction(int priority) {
        if (this.inCommand) {
            return;
        }
        this.inCommand = true;
        if (priority == 0) {
            this.handleCommand(this.menuItem.getSelection());
        } else if (priority == 5 && iteration == 0) {
            priority = 10;
            super.commandAction(priority);
        } else if (priority == 5 && iteration != 0) {
            --iteration;
            this.midp.nextForm(this.getNext());
        } else {
            super.commandAction(priority);
        }
    }

    public void handleCommand(int selection) {
        if (this.menuItem.menuSize() == 10 && selection == 9) {
            this.nextIteration();
        } else {
            if (selection >= this.menuItem.menuSize()) {
                this.inCommand = false;
                this.menuItem.cancelAction();
                return;
            }
            this.midp.getHashtable().clear();
            int selected = selection + iteration * 9;
            String id = (String)ids.elementAt(selected);
            this.midp.getHashtable().put("recordId", id);
            this.midp.getHashtable().put("next", "record.mobi");
            Thread t = new Thread(this.midp);
            t.start();
        }
    }

    abstract String getNext();

    public void createForm() {
        if (!this.runDataThread(this)) {
            this.handleError(new TimeOutException(10));
        }
        if (this.handledError) {
            return;
        }
        if (ids == null) {
            this.midp.getHashtable().put("next", this.getAction());
            this.midp.getHashtable().put("noResults", "true");
            this.midp.setJumpedFlag();
            Thread t = new Thread(this.midp);
            t.start();
            return;
        }
        String[] array = this.processVector(names, iteration);
        this.menuItem = new MenuItem(array, this);
        this.menuItem.setScreenTitle(ResourceBundle.get("search_results"));
        this.menuItem.addCommand(this.submitCommand);
        this.menuItem.addCommand(this.backCommand);
        this.menuItem.setCommandListener(this);
        this.midp.getDisplay().setCurrent((Displayable)this.menuItem);
    }

    abstract String getAction();

    public void decrementIteration() {
        --iteration;
    }

    static {
        iteration = 0;
    }
}

