/*
 * Decompiled with CFR 0.152.
 */
package mobi.forms;

import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordStoreException;
import mobi.data.DrmRecordStore;
import mobi.data.MobiStore;
import mobi.forms.MidpForm;
import mobi.util.GetData;
import mobi.util.ResourceBundle;

public class DrmForm
extends MidpForm
implements Runnable {
    public static final int DRM_SIZE = 12;
    private TextField textField;

    public DrmForm(String mobi) {
        this.mobiString = mobi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.midp.getHashtable().clear();
        this.midp.getHashtable().put("drmCode", this.textField.getString());
        this.midp.getHashtable().put("platform", System.getProperty("microedition.platform"));
        GetData getData = null;
        try {
            getData = this.getHttpData("drmActivate.mobi");
        }
        catch (Exception e) {
            this.handleError(e);
        }
        String drm = (String)getData.getHashtable().get("drm");
        DrmRecordStore recordStore = null;
        try {
            recordStore = new DrmRecordStore();
            recordStore.add(drm);
        }
        catch (RecordStoreException e) {
            this.midp.getHashtable().put("errrorMessage", MobiStore.getError(e));
            this.handleError();
            return;
        }
        finally {
            if (recordStore != null) {
                recordStore.close();
            }
        }
        try {
            if (!this.getTitlesDrm()) {
                return;
            }
        }
        catch (Exception e) {
            this.handleError(e);
            return;
        }
        this.nextForm(null);
    }

    public synchronized void commandAction(int priority) {
        if (this.inCommand) {
            return;
        }
        this.inCommand = true;
        String drm = this.textField.getString();
        if (priority == 0) {
            if (drm.length() == 12) {
                Thread t = new Thread(this);
                t.start();
            } else {
                this.inCommand = false;
                return;
            }
        }
        super.commandAction(priority);
    }

    public void createForm() {
        Form frm = new Form(ResourceBundle.get("license_key"));
        this.textField = new TextField(ResourceBundle.get("enter_drm_key", "12"), "", 12, 0);
        frm.append((Item)this.textField);
        frm.addCommand(this.submitCommand);
        frm.addCommand(this.mainMenuCommand);
        frm.setCommandListener((CommandListener)this);
        this.midp.getDisplay().setCurrent((Displayable)frm);
    }

    public String getMobiAction() {
        return null;
    }

    void nextForm(String mobiForm) {
        if (mobiForm != null) {
            this.midp.getHashtable().put("next", "menu.mobi");
        }
        Thread t = new Thread(this.midp);
        t.start();
    }
}

