/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import mobi.forms.MidpForm;
import mobi.midp.MobiStatic;

public abstract class BaseItem
extends Canvas
implements Runnable {
    public static String resolution;
    static int height;
    static int width;
    Thread TITLE_SCROLL = null;
    boolean load_thread = false;
    static final byte SCROLL_DOWN = 0;
    static final byte SCROLL_UP = 1;
    static final String SELECT_STRING = "Select";
    static final String CANCEL_STRING = "Cancel";
    static final String YES_STRING = "Yes";
    static final String NO_STRING = "No";
    static byte headerHeight;
    static int headerHeightInLines;
    static final String strOptions = "Options";
    static Font small;
    static Font bold;
    static Font normal;
    static Font italics;
    static Font linkUps;
    static Font footnotes;
    public String screenTitle = null;
    public boolean ALERT_TRUE = false;
    public String leftString = "";
    public String rightString = "";
    public boolean isPopUp;
    int LOADING_SCREEN = 0;
    String errorStr;
    String appErrorStr;
    String alertMessage;
    String confirmMessage;
    int selectedCmd = 1;
    int anyKeyChild = 0;
    short fontHeight;
    boolean upArrow = false;
    boolean downArrow = false;
    private boolean headerBoolean = true;

    public static void clearScreen(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, width, height + 30);
        g.setColor(0, 0, 0);
        g.setFont(normal);
    }

    public static void setCanvasWidth(int canvasWidth) {
        width = canvasWidth;
    }

    protected BaseItem() {
        height = this.getHeight();
        width = this.getWidth();
        this.resetHeaderHeight();
    }

    private void resetHeaderHeight() {
        headerHeight = 0;
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
    }

    public void setConfirmMessage(String alertMessage) {
        this.confirmMessage = alertMessage;
    }

    public void setHeaderBoolean(boolean boo) {
        this.headerBoolean = boo;
    }

    public void setScreenTitle(String title) {
        this.screenTitle = title;
    }

    int drawScreenTitle(Graphics g, int y) {
        g.setColor(17, 60, 183);
        g.setFont(bold);
        if (this.screenTitle != null) {
            g.drawString(this.screenTitle, width / 2, y, 17);
            y = y + this.fontHeight + 2;
        }
        g.setFont(normal);
        g.setColor(0);
        return y;
    }

    int findKey(int keyCode) {
        int selection = -1;
        switch (keyCode) {
            case 48: {
                selection = 0;
                break;
            }
            case 49: {
                selection = 1;
                break;
            }
            case 50: {
                selection = 2;
                break;
            }
            case 51: {
                selection = 3;
                break;
            }
            case 52: {
                selection = 4;
                break;
            }
            case 53: {
                selection = 5;
                break;
            }
            case 54: {
                selection = 6;
                break;
            }
            case 55: {
                selection = 7;
                break;
            }
            case 56: {
                selection = 8;
                break;
            }
            case 57: {
                selection = 9;
            }
        }
        return selection;
    }

    public void resetAnyKeyChild() {
        this.anyKeyChild = 0;
    }

    public void setAnyKeyChild() {
        this.anyKeyChild = 1;
    }

    void setBackGroundImage(Graphics g) {
        if (MobiStatic.backGroundImage == null) {
            return;
        }
        int w = width / MobiStatic.backGroundImage.getWidth();
        int h = (height + bold.getHeight()) / MobiStatic.backGroundImage.getHeight();
        for (int j = 0; j < h + 1; ++j) {
            for (int i = 0; i < w + 1; ++i) {
                g.drawImage(MobiStatic.backGroundImage, MobiStatic.backGroundImage.getWidth() * i, MobiStatic.backGroundImage.getHeight() * j, 20);
            }
        }
        if (this.headerBoolean && MobiStatic.mobiViewerImage != null) {
            g.drawImage(MobiStatic.mobiViewerImage, width / 2, 0, 17);
            this.setHeaderHeight((byte)MobiStatic.mobiViewerImage.getHeight());
        }
    }

    public void setHeaderHeight(byte headerHeight) {
        BaseItem.headerHeight = headerHeight;
    }

    public void setLoadingFlag() {
        this.LOADING_SCREEN = 1;
    }

    void showAlert(Graphics g, String text) {
        int w;
        int rectX;
        int strWidth = small.stringWidth(text);
        int considerWidth = width - 4;
        int numLines = this.getNumOfLines(g, text, considerWidth);
        System.out.println("numlines..." + numLines);
        int charWidth = small.stringWidth("W");
        int textWidth = small.stringWidth(text);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        if (textWidth > width) {
            rectX = 2;
            w = width - 5;
            g.setColor(223, 223, 223);
            g.fillRoundRect(rectX, height / 2 - numLines * this.fontHeight / 2, w, this.fontHeight * numLines + this.fontHeight, 10, 10);
        } else {
            rectX = width / 2 - textWidth / 2 - 4;
            w = strWidth + charWidth * 2;
            g.setColor(223, 223, 223);
            g.fillRoundRect(rectX - charWidth / 2, height / 2 - numLines * this.fontHeight / 2, w, this.fontHeight * numLines + this.fontHeight, 10, 10);
        }
        g.setColor(255, 0, 0);
        g.setFont(small);
        this.drawMenu(g, 20, text, w - 4, rectX + 5, height / 2 - numLines * this.fontHeight / 2);
        g.setFont(normal);
    }

    public int drawMenu(Graphics g, int anchor, String s, int width, int x, int y) {
        int lastBreak = -1;
        int position = 0;
        int start = 0;
        int length = s.length();
        int k = 0;
        g.setFont(small);
        while (true) {
            if (k < length && g.getFont().stringWidth(s.substring(position, k)) <= width) {
                if (s.charAt(k) == ' ') {
                    lastBreak = k;
                }
                ++k;
                continue;
            }
            position = k == length ? k : (lastBreak < position ? k : lastBreak);
            g.drawString(s.substring(start, position), x, y, anchor);
            if (position == length) break;
            start = position;
            y += this.fontHeight + 2;
        }
        g.setFont(normal);
        return y;
    }

    int getNumOfLines(Graphics g, String s, int width) {
        int lastBreak = -1;
        int position = 0;
        int start = 0;
        int length = s.length();
        System.out.println("length:" + length + ":s" + s);
        int k = 0;
        int numOfLines = 0;
        g.setFont(small);
        while (true) {
            if (k < length && g.getFont().stringWidth(s.substring(position, k)) <= width) {
                if (s.charAt(k) == ' ') {
                    lastBreak = k;
                }
                ++k;
                continue;
            }
            position = k == length ? k : (lastBreak < position ? k : lastBreak);
            System.out.println("position...." + position);
            ++numOfLines;
            if (position == length) break;
            start = position;
        }
        g.setFont(small);
        return numOfLines;
    }

    void startThread(BaseItem threadObj) {
        Thread t = new Thread(threadObj);
        t.start();
    }

    void cancelAlertMessage(MidpForm midpForm) {
        this.appErrorStr = null;
        midpForm.midp.getHashtable().remove("errorMessage");
        this.callPaints();
    }

    public void callPaints() {
        this.repaint();
        this.serviceRepaints();
    }

    static {
        headerHeight = 0;
        headerHeightInLines = 0;
        Font defaultFont = Font.getDefaultFont();
        small = Font.getFont((int)64, (int)0, (int)8);
        bold = Font.getFont((int)64, (int)1, (int)8);
        italics = Font.getFont((int)64, (int)2, (int)8);
        normal = Font.getFont((int)64, (int)0, (int)8);
        linkUps = Font.getFont((int)64, (int)4, (int)8);
        footnotes = Font.getFont((int)64, (int)5, (int)8);
        headerHeightInLines = headerHeight / normal.getHeight();
        if (headerHeight % normal.getHeight() > 0) {
            ++headerHeightInLines;
        }
    }
}

