/*
 * Decompiled with CFR 0.152.
 */
package mobi.midp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStoreException;
import mobi.cache.ImageCache;
import mobi.data.ImageRecordStore;
import mobi.forms.BookmarkForm;
import mobi.forms.BookmarksForm;
import mobi.forms.CategoryForm;
import mobi.forms.CustomCategoryForm;
import mobi.forms.EditorForm;
import mobi.forms.ErrorForm;
import mobi.forms.MailForm;
import mobi.forms.MainPage1Form;
import mobi.forms.MainPage2Form;
import mobi.forms.MainPage3Form;
import mobi.forms.MidpForm;
import mobi.forms.NamesForm;
import mobi.forms.RecordForm;
import mobi.forms.SearchDataForm;
import mobi.forms.SearchDataResults;
import mobi.forms.SearchTitlesForm;
import mobi.forms.SearchTitlesResults;
import mobi.forms.SmsForm;
import mobi.forms.SubjectsMainForm;
import mobi.forms.TitleForm;
import mobi.midp.MobiViewer;
import mobi.util.ResourceBundle;

public class MobiStatic {
    public static int TIME_OUT = 90;
    public static final String VERSION = "1.0";
    public static final String VERSION_TYPE = "alpha";
    public static final String DEFAULT_ICON = "mobiViewer.png";
    public static final short BUILD_NUM = 14;
    public static Image mobiViewerImage;
    public static Image titleLogoImage;
    public static Image animationImage;
    public static Image upImage;
    public static Image downImage;
    public static Image rightImage;
    public static Image titleImage;
    public static Image mobiLogoImage;
    public static String appName;
    public static boolean isDataConnectionProblem;
    public static MidpForm midpForm;
    public static boolean isThreadInvoke;
    public static String backStr;
    public static Image[] numberIcons;

    public static String getVersion() {
        return "MobiViewer version 1.0 alpha Build #14";
    }

    public static void findForm(String name, boolean isBack, MobiViewer viewer) {
        if (name.equals("titles.mobi")) {
            midpForm = new TitleForm();
        } else if (name.equals("mainPage1.mobi")) {
            midpForm = new MainPage1Form(name, isBack);
        } else if (name.equals("mainPage2.mobi")) {
            midpForm = new MainPage2Form(name, isBack);
        } else if (name.equals("mainPage3.mobi")) {
            midpForm = new MainPage3Form(name, isBack);
        } else if (name.equals("subjectsMain.mobi")) {
            midpForm = new SubjectsMainForm(name, isBack);
        } else if (name.equals("categories.mobi")) {
            midpForm = new CategoryForm(name, isBack);
        } else if (name.equals("names.mobi")) {
            midpForm = new NamesForm(name, isBack);
        } else if (name.equals("searchData.mobi")) {
            midpForm = new SearchDataForm(name, isBack);
        } else if (name.equals("searchTitles.mobi")) {
            midpForm = new SearchTitlesForm(name, isBack);
        } else if (name.equals("record.mobi") || name.equals("about.mobi") || name.equals("help.mobi") || name.equals("titlesDrmFormatted.mobi")) {
            midpForm = new RecordForm(name, isBack);
        } else if (name.equals("searchDataResults.mobi")) {
            midpForm = new SearchDataResults(name, isBack);
        } else if (name.equals("searchTitlesResults.mobi")) {
            midpForm = new SearchTitlesResults(name, isBack);
        } else if (name.equals("customCategory.mobi")) {
            midpForm = new CustomCategoryForm(name, isBack);
        } else if (name.equals("bookmark.mobi")) {
            midpForm = new BookmarkForm(name);
        } else if (name.equals("bookmarks.mobi")) {
            midpForm = new BookmarksForm(name, isBack);
        } else if (name.equals("mail.mobi")) {
            midpForm = new MailForm(name);
        } else if (name.equals("sms.mobi")) {
            midpForm = new SmsForm(name);
        } else if (name.equals("editor.mobi")) {
            midpForm = new EditorForm(name);
        } else if (name.equals("error.mobi")) {
            midpForm = new ErrorForm("error.mobi");
        } else {
            return;
        }
        midpForm.setMidp(viewer);
        midpForm.createForm();
    }

    public static String makeUrl(String action, Hashtable hashtable) {
        String url = ResourceBundle.get("url");
        url = url + '/' + action;
        url = url + '?';
        boolean firstTime = true;
        Enumeration e = hashtable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals("next")) continue;
            if (!firstTime) {
                url = url + '&';
            } else {
                firstTime = false;
            }
            StringBuffer buf = null;
            try {
                buf = new StringBuffer((String)hashtable.get(key));
            }
            catch (ClassCastException ce) {
                hashtable.remove(key);
                continue;
            }
            StringBuffer data = new StringBuffer();
            for (int x = 0; x < buf.length(); ++x) {
                if (buf.charAt(x) == ' ') {
                    data.append("%20");
                    continue;
                }
                if (buf.charAt(x) == '#') {
                    data.append("%23");
                    continue;
                }
                if (buf.charAt(x) == '&') {
                    data.append("%26");
                    continue;
                }
                if (buf.charAt(x) == ':') {
                    data.append("%3a");
                    continue;
                }
                data.append(buf.charAt(x));
            }
            url = url + key;
            url = url + '=';
            url = url + data;
        }
        return url;
    }

    public static String createUrl(String action, MobiViewer midp) {
        midp.getHashtable().put("xml", "true");
        if (midp.getTitle() == null) {
            String locale = ResourceBundle.get("locale");
            midp.getHashtable().put("locale", locale);
        } else {
            midp.getHashtable().put("titleId", midp.getTitle().getId());
            midp.getHashtable().put("locale", midp.getTitle().getLocale());
        }
        return MobiStatic.makeUrl(action, midp.getHashtable());
    }

    public static Image getImage(String image, String titleId) throws IOException {
        String url = ResourceBundle.get("image_url");
        url = url + "/images/content/" + titleId + "/" + image;
        return MobiStatic.getFromNetwork(url);
    }

    public static Image getImageFromServer(String url) throws IOException {
        return MobiStatic.getFromNetwork(url);
    }

    public static void cleanUpGc() {
        System.gc();
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Image getFromNetworkOLD(String url) throws IOException {
        byte[] bytes = MobiStatic.getImageBytes(url);
        Image image = Image.createImage((byte[])bytes, (int)0, (int)bytes.length);
        bytes = null;
        MobiStatic.cleanUpGc();
        return image;
    }

    public static Image getFromNetwork(String url) throws IOException {
        Image image = null;
        try {
            byte[] bytes = MobiStatic.getImageBytes(url);
            image = Image.createImage((byte[])bytes, (int)0, (int)bytes.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static Image getFromNetworkBAD(String url) throws IOException {
        InputStream inputStream = MobiStatic.getInputStream(url);
        Image image = Image.createImage((InputStream)inputStream);
        inputStream.close();
        inputStream = null;
        System.gc();
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public static InputStream getInputStream(String url) throws IOException {
        Connection connection = Connector.open((String)url);
        InputConnection inputConnection = (InputConnection)connection;
        return inputConnection.openInputStream();
    }

    public static byte[] getImageBytes(String url) throws IOException {
        int blocksize = 1024;
        InputStream istream = MobiStatic.getInputStream(url);
        int l = istream.available();
        byte[] buffer = new byte[l + 1];
        int length = 0;
        while ((l = istream.read(buffer, length, buffer.length - length)) != -1) {
            if ((length += l) != buffer.length) continue;
            byte[] b = new byte[buffer.length + blocksize];
            System.arraycopy(buffer, 0, b, 0, length);
            buffer = b;
        }
        byte[] bytes = new byte[length];
        System.arraycopy(buffer, 0, bytes, 0, length);
        istream.close();
        return bytes;
    }

    public static Image getImage(String urlIn) {
        Image image = ImageCache.get(urlIn);
        if (image != null) {
            return image;
        }
        try {
            String url = ResourceBundle.get("image_url");
            url = url + urlIn;
            image = MobiStatic.getFromNetwork(url);
            ImageCache.put(urlIn, image);
            return image;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Image getImageResorce(String imageName) throws IOException {
        InputStream inputStream = imageName.getClass().getResourceAsStream("/" + imageName);
        return Image.createImage((InputStream)inputStream);
    }

    public static void init() {
        try {
            ResourceBundle.create();
            Thread.sleep(50L);
        }
        catch (Exception e) {
            // empty catch block
        }
        ImageRecordStore imageRecordStore = null;
        try {
            imageRecordStore = new ImageRecordStore();
        }
        catch (RecordStoreException e) {
            // empty catch block
        }
        Image[] images = null;
        try {
            images = imageRecordStore.get();
        }
        catch (RecordStoreException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        upImage = images[0];
        downImage = images[1];
        rightImage = images[2];
        mobiViewerImage = images[3];
        mobiLogoImage = images[4];
        try {
            for (int i = 0; i < 9; ++i) {
                MobiStatic.numberIcons[i] = MobiStatic.getImageResorce(i + 1 + ".png");
            }
            MobiStatic.numberIcons[9] = MobiStatic.getImageResorce("0.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        isDataConnectionProblem = false;
        isThreadInvoke = false;
        backStr = "";
        numberIcons = new Image[11];
        try {
            TIME_OUT = Integer.parseInt(ResourceBundle.get("time_out"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

