/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import mobi.forms.RecordForm;
import mobi.midp.MobiStatic;
import mobi.util.StringVector;

public class RecordData
implements Runnable {
    public static final String[] TAGS2 = new String[]{"startBOLD", "startITALIC", "startimg", "starta", "startFN", "endBOLD", "endITALIC", "enda", "endFN", "startscroll"};
    public static final byte BOLD = 0;
    public static final byte ITALIC = 1;
    public static final byte IMAGE = 2;
    public static final byte START_LINK = 3;
    public static final byte FOOT_NOTE = 4;
    public static final byte START_TAGS = 5;
    public static final byte END_LINK = 7;
    public static final byte NOTHING = -1;
    public static final byte NORMAL = -2;
    String startBold = "";
    String endBold = "";
    String startItalic = "";
    String endItalic = "";
    String starta = "";
    String enda = "";
    String startImg = "";
    String startFN = "";
    String endFN = "";
    Vector startFootNoteLinkVector = new Vector();
    Vector endFootNoteLinkVector = new Vector();
    public static Vector startFNDetails = new Vector();
    Hashtable hashPositions = new Hashtable();
    Thread imgThread = null;
    private short totA = 0;
    private String[] linkUpA = null;
    private short[] linksUpsPosition = null;
    public String[] imageUrl = null;
    private String[] footNotes = null;
    private boolean[] imageCompleteFlag;
    private Image[] images;
    private int imgIndex = 0;
    private boolean imageExist = false;
    private RecordForm recordForm;
    Vector startIHF = new Vector();
    public Vector urlIHF = new Vector();

    public boolean imagesLoaded() {
        if (this.imageUrl == null) {
            return true;
        }
        for (int i = 0; i < this.imageCompleteFlag.length; ++i) {
            if (this.imageCompleteFlag[i]) continue;
            return false;
        }
        return true;
    }

    public RecordData(Hashtable hashtable) {
        this.parse(hashtable);
        this.storeLinkUps(hashtable);
        this.storeImages(hashtable);
        this.storeFootnotes(hashtable);
        this.createCombindVector();
    }

    private void parse(Hashtable hashtable) {
        int i;
        Vector temporaryVector = new Vector();
        for (i = 0; i < TAGS2.length; ++i) {
            String element = (String)hashtable.remove(TAGS2[i]);
            if (element == null || element.length() <= 0) continue;
            StringVector stringVector = new StringVector(element);
            if (TAGS2[i].equals("startBOLD")) {
                this.startBold = element;
            } else if (TAGS2[i].equals("endBOLD")) {
                this.endBold = element;
            } else if (TAGS2[i].equals("startITALIC")) {
                this.startItalic = element;
            } else if (TAGS2[i].equals("endITALIC")) {
                this.endItalic = element;
            } else if (TAGS2[i].equals("starta")) {
                this.starta = element;
            } else if (TAGS2[i].equals("enda")) {
                this.enda = element;
            } else if (TAGS2[i].equals("startimg")) {
                this.startImg = element;
            } else if (TAGS2[i].equals("startFN")) {
                this.startFN = element;
                this.addElementWithVector(this.startFootNoteLinkVector, element.trim());
                this.totA = (short)(this.totA + 1);
            } else if (TAGS2[i].equals("endFN")) {
                this.endFN = element;
                this.addElementWithVector(this.endFootNoteLinkVector, element.trim());
            } else if (TAGS2[i].equals("startscroll")) {
                this.addElementWithVector(startFNDetails, element.trim());
            }
            for (int j = 0; j < stringVector.size(); ++j) {
                this.hashPositions.put(stringVector.elementAt(j), TAGS2[i]);
                if (TAGS2[i].equals(TAGS2[3])) {
                    this.totA = (short)(this.totA + 1);
                    temporaryVector.addElement(stringVector.elementAt(j));
                    continue;
                }
                if (!TAGS2[i].equals(TAGS2[7])) continue;
                temporaryVector.addElement(stringVector.elementAt(j));
            }
        }
        this.linksUpsPosition = new short[temporaryVector.size()];
        for (i = 0; i < temporaryVector.size(); ++i) {
            this.linksUpsPosition[i] = Short.parseShort((String)temporaryVector.elementAt(i));
        }
    }

    private void storeLinkUps(Hashtable hashtable) {
        String element = (String)hashtable.remove("linkUps");
        if (element != null && element.length() > 0) {
            StringVector stringVector = new StringVector(element);
            this.linkUpA = new String[stringVector.size()];
            for (int i = 0; i < stringVector.size(); ++i) {
                this.linkUpA[i] = stringVector.elementAt(i).toString();
            }
        }
    }

    private synchronized void storeImages(Hashtable hashtable) {
        String element = (String)hashtable.remove("images");
        if (element != null && element.length() > 0) {
            this.imageExist = true;
            StringVector stringVector = new StringVector(element);
            this.imageUrl = new String[stringVector.size()];
            stringVector.copyInto(this.imageUrl);
            this.imageCompleteFlag = new boolean[this.imageUrl.length];
            this.images = new Image[this.imageUrl.length];
        }
    }

    public void executeImage(int index, RecordForm rForm) {
        this.recordForm = rForm;
        this.imgIndex = index;
        this.imgThread = new Thread(this);
        this.imgThread.start();
    }

    public boolean isImageExist() {
        return this.imageExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        Image img = null;
        try {
            if (null != this.urlIHF.elementAt(this.recordForm.setCounter())) {
                img = MobiStatic.getImage(this.urlIHF.elementAt(this.recordForm.setCounter()).toString());
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.imageCompleteFlag[this.recordForm.getImageCounter()] = true;
            this.notify();
        }
        this.recordForm.showImage(img);
    }

    public short getACount() {
        return this.totA;
    }

    public Image[] getImages() {
        return this.images;
    }

    public String[] getLinkUps() {
        return null;
    }

    public int getStartFNDetail(int index) {
        return Integer.parseInt((String)startFNDetails.elementAt(index));
    }

    public short[] getLinksUpsPosition() {
        return this.linksUpsPosition;
    }

    public int isExist(int position) {
        String pos = Integer.toString(position);
        String tag = (String)this.hashPositions.get(pos);
        if (this.hashPositions.containsKey(pos) && tag != null) {
            int whichTag = -1;
            for (int i = 0; i < TAGS2.length; ++i) {
                if (!TAGS2[i].equals(tag)) continue;
                whichTag = i;
            }
            if (whichTag < 5) {
                return whichTag;
            }
            return -2;
        }
        return -1;
    }

    public short imageExistInLine(short startPosition, short endPosition) {
        for (int i = startPosition; i < endPosition; ++i) {
            String tag = (String)this.hashPositions.get(Integer.toString(i));
            if (tag == null || !tag.equals(TAGS2[2])) continue;
            return -2;
        }
        return -1;
    }

    private void addElementWithVector(Vector vector, String vectorData) {
        if (!vectorData.equals("")) {
            while (true) {
                if (vectorData.indexOf(",") != -1) {
                    int index = vectorData.indexOf(",");
                    vector.addElement(vectorData.substring(0, index));
                    vectorData = vectorData.substring(index + 1);
                    continue;
                }
                if (vectorData.equals("")) break;
                vector.addElement(vectorData);
                vectorData = "";
            }
        }
    }

    private void createCombindVector() {
        if (null != this.startImg && null != this.imageUrl) {
            this.setStartIHFVectors(this.startImg, this.imageUrl);
        }
        if (null != this.starta && null != this.linkUpA) {
            this.setStartIHFVectors(this.starta, this.linkUpA);
        }
        if (null != this.startFN && null != this.footNotes) {
            this.setStartIHFVectors(this.startFN, this.footNotes);
        }
        this.sortedCombindVector();
    }

    private void setStartIHFVectors(String startPoint, String[] url) {
        int i = 0;
        if (!startPoint.equals("")) {
            while (true) {
                if (startPoint.indexOf(",") != -1) {
                    int index = startPoint.indexOf(",");
                    this.startIHF.addElement(startPoint.substring(0, index));
                    startPoint = startPoint.substring(index + 1);
                    this.urlIHF.addElement(url[i]);
                } else {
                    if (startPoint.equals("")) break;
                    this.startIHF.addElement(startPoint);
                    this.urlIHF.addElement(url[i]);
                    startPoint = "";
                }
                ++i;
            }
        }
    }

    private void sortedCombindVector() {
        if (null == this.startIHF || 0 == this.startIHF.size()) {
            return;
        }
        try {
            for (int i = 0; i < this.startIHF.size(); ++i) {
                for (int j = i + 1; j < this.startIHF.size(); ++j) {
                    int y;
                    Object token = this.startIHF.elementAt(i);
                    Object dataInt = this.startIHF.elementAt(j);
                    int x = Integer.parseInt(token.toString());
                    if (x <= (y = Integer.parseInt(dataInt.toString()))) continue;
                    Object object = this.startIHF.elementAt(j);
                    this.startIHF.setElementAt(this.startIHF.elementAt(i), j);
                    this.startIHF.setElementAt(object, i);
                    object = this.urlIHF.elementAt(j);
                    this.urlIHF.setElementAt(this.urlIHF.elementAt(i), j);
                    this.urlIHF.setElementAt(object, i);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void storeFootnotes(Hashtable hashtable) {
        String element = (String)hashtable.remove("startscroll");
        if (element != null && element.length() > 0) {
            StringVector stringVector = new StringVector(element);
            this.footNotes = new String[stringVector.size()];
            for (int i = 0; i < stringVector.size(); ++i) {
                this.footNotes[i] = stringVector.elementAt(i).toString();
            }
        }
    }
}

