/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobi.forms.MidpForm;
import mobi.midp.MobiStatic;
import mobi.util.ResourceBundle;
import mobi.util.SplashCanvas;

public abstract class BaseItem
extends Canvas
implements Runnable {
    static int height;
    static int width;
    static final byte upKey = -1;
    static final byte downKey = -2;
    static final byte leftKey = -3;
    static final byte rightKey = -4;
    static final byte fireKey = -5;
    static final byte leftSoftKey = -6;
    static final byte rightSoftKey = -7;
    static final byte CLEAR = -8;
    static final byte SCROLL_DOWN = 0;
    static final byte SCROLL_UP = 1;
    static final String SELECT_STRING = "Select";
    static final String CANCEL_STRING = "Cancel";
    static final String YES_STRING = "Yes";
    static final String NO_STRING = "No";
    Thread TITLE_SCROLL = null;
    static final String strOptions = "Options";
    public static Font small;
    public static Font bold;
    public static Font normal;
    public static Font italics;
    public static Font linkUps;
    public static Font footnotes;
    public String screenTitle = null;
    public boolean ALERT_TRUE = false;
    public String leftString = "";
    public String rightString = "";
    public boolean isPopUp;
    public boolean isSubPopUp;
    String errorStr;
    String appErrorStr;
    String intialAppError;
    String alertMessage;
    String confirmMessage;
    int selectedCmd = 1;
    int anyKeyChild = 0;
    short fontHeight;
    boolean upArrow = false;
    boolean downArrow = false;
    boolean isPopUpNotOver = false;
    int popupY = this.getHeight() - bold.getHeight();
    public int moving = this.getWidth() / 2 - 36;
    Image background;
    Image whiteGround;
    boolean pauseflag = false;
    public static boolean load_flag;
    public static Thread LOADING_THREAD;
    int titleImageHeight = 0;
    byte loading = 0;
    byte scrolling = 0;
    byte isFullpage = 1;
    Thread t;
    boolean load_thread = false;

    public static void setCanvasWidth(int canvasWidth) {
        width = canvasWidth;
    }

    protected BaseItem() {
        this.setFullScreenMode(true);
        try {
            this.background = Image.createImage((String)"/bg.png");
            this.whiteGround = Image.createImage((String)"/white.png");
            this.titleImageHeight = this.background.getHeight() + 2;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        SplashCanvas.load_flag = false;
    }

    public void setConfirmMessage(String alertMessage) {
        this.confirmMessage = alertMessage;
    }

    public void setScreenTitle(String title) {
        this.screenTitle = title;
    }

    public void clearScreen(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, this.background.getHeight(), width, this.getHeight());
        g.setColor(0, 0, 0);
        g.setFont(normal);
    }

    void drawArrow(Graphics g, MidpForm midpForm) {
        int y = this.getHeight() - (this.titleImageHeight >> 1);
        if (this.upArrow && MobiStatic.upImage != null) {
            Image up = MobiStatic.upImage;
            int leftX = width / 2 - up.getWidth() - 1;
            g.drawImage(up, leftX, y, 6);
        }
        if (this.downArrow && MobiStatic.downImage != null) {
            Image down = MobiStatic.downImage;
            int rightX = width / 2 + down.getWidth() + 1;
            g.drawImage(down, rightX, y, 10);
        }
    }

    void drawButtons(Graphics g, Vector commandVector) {
        if (commandVector == null || commandVector.size() == 0) {
            return;
        }
        int x = 5;
        g.setClip(0, this.getHeight() - this.background.getHeight(), this.getWidth(), this.background.getHeight());
        this.leftString = (String)commandVector.elementAt(0);
        for (int i = 0; i < this.getWidth(); ++i) {
            g.drawImage(this.background, i, this.getHeight(), 0x20 | 4);
        }
        g.setFont(bold);
        g.setColor(255, 255, 255);
        if (commandVector.size() == 2) {
            this.rightString = (String)commandVector.elementAt(1);
        } else if (commandVector.size() > 2) {
            this.rightString = strOptions;
        }
        if (this.isPopUp || this.isSubPopUp) {
            this.leftString = SELECT_STRING;
            this.rightString = CANCEL_STRING;
        }
        if (this.ALERT_TRUE && this.anyKeyChild == 1) {
            this.leftString = YES_STRING;
            this.rightString = NO_STRING;
        }
        int bottomOptionY = this.getHeight() - this.background.getHeight() + (this.background.getHeight() - bold.getHeight()) / 2;
        g.drawString(this.leftString, x, bottomOptionY, 20);
        g.drawString(this.rightString, width - x, bottomOptionY, 24);
    }

    public void resetAnyKeyChild() {
        this.anyKeyChild = 0;
    }

    void drawPopUpMenu(Graphics g, MidpForm form) {
        int i;
        int x = 0;
        int y = this.getHeight() / 4;
        int width = this.getPopUpMenuWidth(form);
        int n = width = width < this.getWidth() ? width : this.getWidth();
        if (width < this.getWidth()) {
            x = (this.getWidth() - width) / 2;
        }
        int numOfCommands = form.commandVector.size() - 1;
        int fontHight = small.getHeight();
        int popUpHeight = numOfCommands * fontHight;
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        if (this.pauseflag) {
            for (i = 0; i < this.getWidth(); i += 8) {
                for (int j = 0; j < this.getHeight(); j += 8) {
                    g.drawImage(SplashCanvas.pause, i, j, 0x10 | 4);
                }
            }
            this.pauseflag = false;
        }
        g.setClip(x, y, width + 1, popUpHeight + fontHight + 2);
        g.setColor(187, 221, 239);
        g.drawRect(x, y, width, fontHight);
        g.setColor(170, 0, 0);
        g.fillRect(x + 1, y + 1, width - 1, fontHight - 1);
        g.setColor(255, 255, 255);
        g.setFont(bold);
        g.drawString(strOptions, this.getWidth() / 2, y + 1, 17);
        g.setColor(187, 221, 239);
        g.drawRect(x, y + fontHight + 1, width, popUpHeight);
        g.setColor(255, 255, 255);
        g.fillRect(x + 1, y + fontHight + 2, width - 1, popUpHeight - 1);
        g.setFont(small);
        for (i = 1; i <= numOfCommands; ++i) {
            if (popUpHeight <= fontHight * (i - 1)) continue;
            g.setColor(187, 221, 239);
            g.drawLine(x, y + fontHight * i, x + width, y + fontHight * i);
        }
        for (i = 1; i <= numOfCommands; ++i) {
            String str = "   " + form.commandVector.elementAt(i);
            if (popUpHeight < fontHight * i) continue;
            if (i == this.selectedCmd) {
                g.setColor(0);
                g.setFont(bold);
            } else {
                g.setFont(small);
                g.setColor(150, 150, 150);
            }
            g.drawImage(MobiStatic.numberIcons[i - 1], x + 5, y + fontHight * i + fontHight / 2 + 1, 6);
            g.drawString(str, x + MobiStatic.numberIcons[i - 1].getWidth(), y + fontHight * i + 2, 20);
        }
    }

    private int getPopUpMenuWidth(MidpForm form) {
        int output = 0;
        String str = "";
        for (int i = 1; i < form.commandVector.size(); ++i) {
            String temp = (String)form.commandVector.elementAt(i);
            str = str.length() > temp.length() ? str : temp;
        }
        output = bold.stringWidth(str) + MobiStatic.numberIcons[0].getWidth() + 15;
        output = output == 0 ? this.getWidth() - this.getWidth() / 4 : output + 5;
        return output;
    }

    int drawScreenTitle(Graphics g, int y) {
        g.setFont(bold);
        if (this.screenTitle != null) {
            g.drawString(this.screenTitle, width / 2, y, 17);
            y = y + this.fontHeight + 2;
        }
        g.setFont(normal);
        g.setColor(0);
        return y;
    }

    void executeKeyEvents() {
    }

    void startThread(BaseItem threadObj) {
        this.t = new Thread(threadObj);
        this.t.start();
    }

    void executeLSK(MidpForm form) {
        Vector vecCmd = null;
        Vector vecConst = null;
        int index = 0;
        String constIndex = "";
        if (this.isPopUp || this.isSubPopUp) {
            vecCmd = form.commandVector;
            vecConst = form.constantVector;
            String selText = (String)vecCmd.elementAt(this.selectedCmd);
            index = vecCmd.indexOf(selText);
            constIndex = (String)vecConst.elementAt(index);
            this.callLoading(Integer.parseInt(constIndex));
            form.commandAction(Integer.parseInt(constIndex));
            MobiStatic.cleanUpGc();
        } else {
            index = form.commandVector.indexOf(this.leftString);
            constIndex = (String)form.constantVector.elementAt(index);
            this.callLoading(Integer.parseInt(constIndex));
            form.commandAction(Integer.parseInt(constIndex));
        }
    }

    public void callLoading(int selectedCmd) {
        if (selectedCmd != 13 && selectedCmd != 16) {
            load_flag = true;
            this.pauseflag = true;
            this.TITLE_SCROLL = null;
            Thread t = new Thread(this);
            this.loading = 1;
            this.scrolling = 0;
            t.start();
        }
    }

    void executeRSK(MidpForm form) {
        int index = 0;
        String constIndex = "";
        if (this.rightString == null || this.rightString.length() == 0) {
            return;
        }
        index = form.commandVector.indexOf(this.rightString);
        constIndex = (String)form.constantVector.elementAt(index);
        form.commandAction(Integer.parseInt(constIndex));
    }

    void executeRSKPopUp() {
        if (this.rightString == null || this.rightString.length() == 0) {
            return;
        }
        if (!this.isPopUp && !this.isSubPopUp) {
            this.isPopUp = true;
        } else if (this.isSubPopUp) {
            this.isSubPopUp = false;
            this.isPopUp = true;
        } else {
            this.isPopUp = false;
            this.ALERT_TRUE = false;
        }
        this.repaint();
        this.serviceRepaints();
    }

    void handlePopUpAction(int keyCode, MidpForm form) {
        int index = 0;
        int selection = -1;
        String constIndex = "";
        selection = this.findKey(keyCode);
        if (selection == -1 || selection == 0) {
            return;
        }
        if (this.selectedCmd > form.commandVector.size() - 1 || selection > form.commandVector.size() - 1) {
            return;
        }
        this.selectedCmd = selection == -1 ? this.selectedCmd : selection;
        String selText = (String)form.commandVector.elementAt(this.selectedCmd);
        index = form.commandVector.indexOf(selText);
        constIndex = (String)form.constantVector.elementAt(index);
        if (Integer.parseInt(constIndex) != 13 && Integer.parseInt(constIndex) != 16) {
            this.callLoading(this.selectedCmd);
        }
        form.commandAction(Integer.parseInt(constIndex));
    }

    void showSearch(MidpForm form) {
        if (!(form.getMobiAction().equals("menu.mobi") || form.getMobiAction().equals("searchData.mobi") || form.getMobiAction().equals("searchTitles.mobi"))) {
            form.commandAction(21);
        }
    }

    int findKey(int keyCode) {
        int selection = -1;
        switch (keyCode) {
            case 48: {
                selection = 0;
                break;
            }
            case 49: {
                selection = 1;
                break;
            }
            case 50: {
                selection = 2;
                break;
            }
            case 51: {
                selection = 3;
                break;
            }
            case 52: {
                selection = 4;
                break;
            }
            case 53: {
                selection = 5;
                break;
            }
            case 54: {
                selection = 6;
                break;
            }
            case 55: {
                selection = 7;
                break;
            }
            case 56: {
                selection = 8;
                break;
            }
            case 57: {
                selection = 9;
            }
        }
        return selection;
    }

    void scrollPopUp(int direction, int size) {
        if (direction == 0) {
            ++this.selectedCmd;
            this.selectedCmd = this.selectedCmd > size - 1 ? 1 : this.selectedCmd;
        } else if (direction == 1) {
            --this.selectedCmd;
            this.selectedCmd = this.selectedCmd < 1 ? size - 1 : this.selectedCmd;
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage + " " + ResourceBundle.get("press_any_key_to_continue");
    }

    public void setAnyKeyChild() {
        this.anyKeyChild = 1;
    }

    void setBackGroundImage(Graphics g, MidpForm form) {
        height = this.getHeight() - bold.getHeight();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, width, SplashCanvas.screenHeight);
        g.setColor(0, 0, 0);
        if (MobiStatic.mobiViewerImage != null) {
            g.drawImage(MobiStatic.mobiViewerImage, width / 2, 0, 17);
        }
    }

    void showAlert(Graphics g, String text) {
        int w;
        int rectX;
        int strWidth = normal.stringWidth(text);
        int considerWidth = width - 4;
        int numLines = this.getNumOfLines(g, text, considerWidth, g.getFont());
        int charWidth = normal.stringWidth("W");
        int textWidth = normal.stringWidth(text);
        if (textWidth > width) {
            rectX = 5;
            w = width - 10;
        } else {
            rectX = width / 2 - textWidth / 2;
            w = strWidth + charWidth;
        }
        g.setColor(223, 223, 223);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        g.fillRoundRect(rectX, height / 2 - numLines * this.fontHeight / 2, w, this.fontHeight * numLines + this.fontHeight, 10, 10);
        g.setColor(255, 0, 0);
        g.setFont(small);
        this.drawMenu(g, 20, text, w - 4, rectX + 5, height / 2 - numLines * this.fontHeight / 2);
        g.setFont(normal);
    }

    public int drawMenu(Graphics g, int anchor, String s, int width, int x, int y) {
        int lastBreak = 0;
        int position = 0;
        int start = 0;
        int length = s.length();
        int k = 0;
        String hypen = "";
        while (true) {
            if (k < length && g.getFont().stringWidth(s.substring(position, k)) < width) {
                if (s.charAt(k) == ' ' || s.charAt(k) == '-' || s.charAt(k) == '_' || s.charAt(k) == '/' || s.charAt(k) == ':') {
                    lastBreak = k;
                }
                ++k;
                continue;
            }
            if (lastBreak == position && k != length) {
                lastBreak = --k;
                hypen = "-";
            } else {
                hypen = "";
            }
            position = k == length ? k : (lastBreak < position ? k : lastBreak);
            g.drawString(s.substring(start, position) + hypen, x, y + 2, anchor);
            if (position == length) break;
            start = position;
            y += this.fontHeight + 2;
        }
        g.setFont(normal);
        return y;
    }

    void setIsPopUpRunning(boolean option) {
        this.isPopUpNotOver = option;
    }

    boolean getIsPopUpRunning() {
        return this.isPopUpNotOver;
    }

    int getNumOfLines(Graphics g, String s, int width, Font font) {
        int lastBreak = -1;
        int position = 0;
        int start = 0;
        int length = s.length();
        int k = 0;
        int numOfLines = 0;
        g.setFont(font);
        while (true) {
            if (k < length && g.getFont().stringWidth(s.substring(position, k)) <= width) {
                if (s.charAt(k) == ' ') {
                    lastBreak = k;
                }
                ++k;
                continue;
            }
            position = k == length ? k : (lastBreak < position ? k : lastBreak);
            ++numOfLines;
            if (position == length) break;
            start = position;
        }
        g.setFont(normal);
        return numOfLines;
    }

    void cancelAlertMessage(MidpForm midpForm) {
        this.appErrorStr = null;
        midpForm.midp.getHashtable().remove("errorMessage");
        this.callPaints();
    }

    public void callPaints() {
        this.repaint();
        this.serviceRepaints();
    }

    public void drawIcon(Graphics g, Image img, int x, int y) {
        g.drawImage(img, x, y, 6);
    }

    public void draw_loading(Graphics g) {
        int i;
        if (this.pauseflag) {
            for (i = 0; i < this.getWidth(); i += 8) {
                for (int j = 0; j < this.getHeight(); j += 8) {
                    g.drawImage(SplashCanvas.pause, i, j, 0x10 | 4);
                }
            }
        }
        g.setColor(170, 0, 0);
        g.setFont(Font.getFont((int)64, (int)1, (int)16));
        g.drawString("L O A D I N G", this.getWidth() / 2, this.getHeight() / 2, 1 | 0x20);
        i = 0;
        int start = this.getWidth() / 2 - 36;
        while (i < 5) {
            g.drawImage(SplashCanvas.image[2], start, this.getHeight() / 2 + 10, 1 | 2);
            ++i;
            start += 18;
        }
        g.drawImage(SplashCanvas.image[1], this.moving, this.getHeight() / 2 + 10, 1 | 2);
        if (this.moving >= this.getWidth() / 2 + 24) {
            this.moving = this.getWidth() / 2 - 54;
        }
        this.moving += 18;
    }

    public String removeSpeacialChar(String string) {
        String output = string;
        boolean isBreak = false;
        int rightInt = string.indexOf("\\u");
        if (rightInt == -1) {
            return output;
        }
        output = "";
        String tempString = string;
        while (true) {
            output = output + tempString.substring(0, rightInt);
            if ((tempString = tempString.substring(rightInt)).length() == 6) {
                isBreak = true;
            }
            String convertedString = this.renderUnicodedString(tempString.substring(0, 6));
            output = output + convertedString;
            if ((tempString = tempString.substring(6)).indexOf("\\u") == -1) {
                output = output + tempString;
                break;
            }
            if (isBreak) break;
            rightInt = tempString.indexOf("\\u");
        }
        return output;
    }

    private String renderUnicodedString(String unicodedTextString) {
        StringBuffer dispUnicodedData = new StringBuffer();
        StringBuffer charMsg = new StringBuffer("\\");
        char[] unicodedTextStringArr = unicodedTextString.toCharArray();
        for (int c = 1; c < unicodedTextStringArr.length; ++c) {
            char ich = unicodedTextStringArr[c];
            char charch = ich;
            if (charch == '\\') {
                dispUnicodedData.append(this.convertStrToUnicode(charMsg.toString().substring(2)));
                charMsg = new StringBuffer();
                charMsg.append(charch);
                continue;
            }
            charMsg.append(charch);
        }
        dispUnicodedData.append(this.convertStrToUnicode(charMsg.toString().substring(2)));
        return dispUnicodedData.toString();
    }

    private String convertStrToUnicode(String value) {
        short valueAsShort = Short.parseShort(value.trim(), 16);
        return String.valueOf((char)valueAsShort);
    }

    String getDotAppendString(int screenWidth, String text) {
        int lineWidth = 0;
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if ((lineWidth += normal.stringWidth("" + ch)) >= screenWidth) break;
            strBuffer.append(ch);
        }
        strBuffer.delete(strBuffer.length() - 3, strBuffer.length()).append("...");
        return strBuffer.toString();
    }

    static {
        load_flag = false;
        LOADING_THREAD = null;
        small = Font.getFont((int)64, (int)0, (int)8);
        bold = Font.getFont((int)64, (int)1, (int)8);
        italics = Font.getFont((int)64, (int)2, (int)8);
        normal = Font.getFont((int)64, (int)0, (int)8);
        linkUps = Font.getFont((int)64, (int)4, (int)8);
        footnotes = Font.getFont((int)32, (int)0, (int)8);
    }
}

