/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.render3d.m3g;

import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import tinbrain.render3d.AbstractTriangleBuffer;

public final class TriangleBuffer
extends AbstractTriangleBuffer {
    private static final float[] M3G_TEXTURE_BIAS = new float[]{0.5f, 0.5f};
    public VertexBuffer mM3GVertexBuffer;
    public TriangleStripArray mM3GTriangleStripArray;
    private VertexArray mVertexPositions;
    private VertexArray mVertexTextureCoords;
    private byte[] mBufferTextureCoords;
    private short[] mBufferPositions;
    private int mNumVertices;
    private boolean mChangePositions;
    private boolean mChangeTextureCoords;

    public final void init(int n) {
        int[] nArray = new int[]{47};
        int[] nArray2 = new int[47];
        int n2 = 0;
        for (int i = 0; i < 12; ++i) {
            int n3 = i * 3;
            nArray2[n2++] = n3 + 2;
            nArray2[n2++] = n3 + 1;
            nArray2[n2++] = n3;
            if (i >= 11) continue;
            nArray2[n2++] = n3;
        }
        this.mNumVertices = 36;
        this.mBufferPositions = new short[108];
        this.mBufferTextureCoords = new byte[72];
        this.mM3GTriangleStripArray = new TriangleStripArray(nArray2, nArray);
        this.mVertexPositions = new VertexArray(36, 3, 2);
        this.mVertexTextureCoords = new VertexArray(36, 2, 1);
        this.mM3GVertexBuffer = new VertexBuffer();
        this.mM3GVertexBuffer.setPositions(this.mVertexPositions, 1.0f, null);
        this.mM3GVertexBuffer.setTexCoords(0, this.mVertexTextureCoords, 0.00390625f, M3G_TEXTURE_BIAS);
    }

    public final void setPosition(int n, int n2, int n3, int n4, int n5) {
        n = n * 9 + n2 * 3;
        this.mBufferPositions[n++] = (short)n3;
        this.mBufferPositions[n++] = (short)n4;
        this.mBufferPositions[n] = (short)n5;
        this.mChangePositions = true;
    }

    public final void setTextureCoord(int n, int n2, int n3, int n4) {
        n = n * 6 + (n2 << 1);
        this.mBufferTextureCoords[n++] = (byte)(n3 - 128);
        this.mBufferTextureCoords[n] = (byte)(n4 - 128);
        this.mChangeTextureCoords = true;
    }

    public final void updateChanges() {
        if (this.mChangePositions) {
            this.mChangePositions = false;
            this.mVertexPositions.set(0, this.mNumVertices, this.mBufferPositions);
        }
        if (this.mChangeTextureCoords) {
            this.mChangeTextureCoords = false;
            this.mVertexTextureCoords.set(0, this.mNumVertices, this.mBufferTextureCoords);
        }
    }
}

