/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.render3d;

import tinbrain.RM;
import tinbrain.math3d.Matrix33;
import tinbrain.math3d.Point3D;

public abstract class AbstractSceneObject {
    public int obj;
    public Matrix33 rotation;
    public Point3D translation = new Point3D();
    public Point3D scale;
    public Point3D sphereCenter;
    public int sphereRadiusSq;
    public Point3D aabbCenter;
    public Point3D aabbExtent;
    public byte frustumPlaneFlag;
    private static int sObjDef;

    public static final void setObjectDefinitions(int n) {
        sObjDef = n;
    }

    protected final void init(int n, int n2, int n3) {
        this.obj = RM.getValue(n, n2, 0);
        this.translation.setFromResource(n, n2, 1);
        if (n3 == 1) {
            if (this.rotation == null) {
                this.rotation = new Matrix33();
            }
            this.rotation.setFromResource(n, n2, 4);
        }
        this.updateBounding();
    }

    protected final void setObject(int n) {
        this.obj = n;
        this.updateBounding();
    }

    public final void setTransform(Matrix33 matrix33, Point3D point3D) {
        this.translation.set(point3D);
        if (matrix33 != null) {
            if (this.rotation == null) {
                this.rotation = new Matrix33();
            }
            this.rotation.set(matrix33);
        }
        this.updateBounding();
    }

    public final void setScale(Point3D point3D) {
        if (this.scale == null) {
            this.scale = new Point3D(point3D);
        }
        this.updateBounding();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateBounding() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.obj < 0) return;
        Object object = this;
        int n11 = sObjDef;
        n11 = RM.getValue(n11, ((AbstractSceneObject)object).obj, 4);
        if (n11 >= 0) {
            int[] nArray = RM.getInts(n11);
            if (((AbstractSceneObject)object).sphereCenter == null) {
                ((AbstractSceneObject)object).sphereCenter = new Point3D();
            }
            ((AbstractSceneObject)object).sphereCenter.set(nArray, 0);
            int n12 = ((AbstractSceneObject)object).sphereRadiusSq = nArray[3];
            if (((AbstractSceneObject)object).rotation != null) {
                ((AbstractSceneObject)object).rotation.transform(((AbstractSceneObject)object).sphereCenter);
            }
            ((AbstractSceneObject)object).sphereCenter.add(((AbstractSceneObject)object).translation);
            if (((AbstractSceneObject)object).scale != null) {
                int n13;
                int n14 = ((AbstractSceneObject)object).scale.x;
                int n15 = ((AbstractSceneObject)object).scale.y;
                int n16 = ((AbstractSceneObject)object).scale.z;
                if (n15 > n14) {
                    n14 = n15;
                }
                if (n16 > n14) {
                    n14 = n16;
                }
                ((AbstractSceneObject)object).sphereRadiusSq = n13 = n12 * (n14 * n14 >> 10) >> 10;
            }
        } else {
            ((AbstractSceneObject)object).sphereCenter = null;
        }
        object = this;
        int n18 = sObjDef;
        n18 = RM.getValue(n18, ((AbstractSceneObject)object).obj, 5);
        if (n18 < 0) {
            ((AbstractSceneObject)object).aabbCenter = null;
            ((AbstractSceneObject)object).aabbExtent = null;
            return;
        }
        int[] nArray = RM.getInts(n18);
        if (((AbstractSceneObject)object).aabbCenter == null) {
            ((AbstractSceneObject)object).aabbCenter = new Point3D();
            ((AbstractSceneObject)object).aabbExtent = new Point3D();
        }
        Point3D point3D = ((AbstractSceneObject)object).aabbCenter;
        Point3D point3D2 = ((AbstractSceneObject)object).aabbExtent;
        point3D.x = nArray[0];
        point3D.y = nArray[1];
        point3D.z = nArray[2];
        point3D2.x = nArray[3];
        point3D2.y = nArray[4];
        point3D2.z = nArray[5];
        if (((AbstractSceneObject)object).scale != null) {
            point3D2.scale(((AbstractSceneObject)object).scale.x, ((AbstractSceneObject)object).scale.y, ((AbstractSceneObject)object).scale.z);
        }
        if (((AbstractSceneObject)object).rotation == null) {
            point3D.add(((AbstractSceneObject)object).translation);
            return;
        }
        Point3D point3D3 = point3D;
        Point3D point3D4 = ((AbstractSceneObject)object).translation;
        object = ((AbstractSceneObject)object).rotation;
        point3D = point3D2;
        Point3D point3D5 = point3D3;
        ((Matrix33)object).transform(point3D5, point3D4);
        Point3D point3D6 = ((Matrix33)object).ax;
        point3D2 = ((Matrix33)object).ay;
        object = ((Matrix33)object).az;
        int n19 = point3D.x;
        int n20 = point3D.y;
        int n21 = point3D.z;
        int n22 = point3D6.x;
        if (n22 < 0) {
            n22 = -n22;
        }
        if ((n9 = point3D6.y) < 0) {
            n9 = -n9;
        }
        if ((n8 = point3D6.z) < 0) {
            n7 = -n8;
        }
        if ((n6 = point3D2.x) < 0) {
            n6 = -n6;
        }
        if ((n5 = point3D2.y) < 0) {
            n5 = -n5;
        }
        if ((n4 = point3D2.z) < 0) {
            n4 = -n4;
        }
        if ((n3 = ((Point3D)object).x) < 0) {
            n3 = -n3;
        }
        if ((n2 = ((Point3D)object).y) < 0) {
            n2 = -n2;
        }
        if ((n = ((Point3D)object).z) < 0) {
            n = -n;
        }
        point3D.x = n19 * n22 + n20 * n6 + n21 * n3 >> 10;
        point3D.y = n19 * n9 + n20 * n5 + n21 * n2 >> 10;
        point3D.z = n19 * n7 + n20 * n4 + n21 * n >> 10;
    }
}

