/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.physics3d;

import game.game3d.Game3d;
import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.math3d.Matrix33;
import tinbrain.math3d.Point3D;
import tinbrain.physics3d.VerletAnimator;
import tinbrain.render3d.AbstractRenderer;

public final class VerletSystem {
    private static Game3d listener$22647a43;
    private static int physicsToScreen;
    private static int timeFactor;
    private static int bulletFactor;
    private boolean kinematicsSet;
    private Matrix33 orientation;
    private Matrix33 prevOrientation;
    Point3D[] positions;
    Point3D[] previous;
    private int[] invmasses;
    private int[] flags;
    Point3D center;
    private Point3D lastCenter;
    private Point3D min;
    private Point3D max;
    private int radiusSquared;
    private int resid;
    private int residx;
    private int skin;
    private boolean active;
    private boolean deactivated;
    private boolean allowResting;
    private int resting;
    private int deactivationScheduled;
    private VerletSystem linkMaster;
    private int linkInfo = -1;
    private int linkPose = -1;
    private int linkPoseStrength;
    private int linkFlags;
    private int linkType;
    private int currentPose = -1;
    private VerletAnimator anim;
    private int scene;
    private boolean visible = true;
    private int additiveFriction;
    private byte[][] partData;
    private byte[] userData;
    private int systemFlags;
    private int friction;
    private int restingThreshold;
    private int restingFrameThreshold;
    private int geometries;
    private int origin;
    private int gravity;
    private int sticks;
    private int planeSeparations;
    private int planeConstraints;
    private int reachCones;
    private int[] orientationData;

    public VerletSystem(AbstractRenderer abstractRenderer, int n, int n2) {
        int n3 = RM.getValue(n, n2, 11);
        this.init$47bf3e33(abstractRenderer, n, n2, n3);
    }

    public final int getScene() {
        return this.scene;
    }

    public static int getPhysicsToScreen() {
        return physicsToScreen;
    }

    public VerletSystem(AbstractRenderer abstractRenderer, int n, int n2, int n3) {
        this.init$47bf3e33(abstractRenderer, 569, n2, n3);
    }

    private void init$47bf3e33(AbstractRenderer abstractRenderer, int n, int n2, int n3) {
        int n4;
        this.allowResting = true;
        this.resid = n;
        this.residx = n2;
        this.skin = n3;
        this.systemFlags = this.get(10);
        this.friction = this.get(6);
        this.restingThreshold = this.get(8);
        this.restingFrameThreshold = this.get(9);
        this.geometries = this.get(4);
        this.origin = this.get(1);
        this.gravity = this.get(5);
        this.get(7);
        this.sticks = this.get(2);
        this.planeSeparations = this.get(13);
        this.planeConstraints = this.get(14);
        this.reachCones = this.get(15);
        n = this.get(3);
        this.orientationData = RM.getInts(n);
        this.center = new Point3D();
        this.lastCenter = new Point3D();
        this.min = new Point3D();
        this.max = new Point3D();
        this.orientation = new Matrix33();
        this.prevOrientation = new Matrix33();
        n = this.get(0);
        n2 = RM.getHeight(n);
        this.positions = new Point3D[n2];
        this.previous = new Point3D[n2];
        this.invmasses = new int[n2];
        this.flags = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            n4 = RM.getValue(n, n3, 0);
            int n5 = RM.getValue(n, n3, 1);
            int n6 = RM.getValue(n, n3, 2);
            int n7 = RM.getValue(n, n3, 4);
            int n8 = RM.getValue(n, n3, 3);
            this.positions[n3] = new Point3D(n4, n5, n6);
            this.previous[n3] = new Point3D(n4, n5, n6);
            this.invmasses[n3] = n7;
            this.flags[n3] = n8;
        }
        this.updateSystemOrientation();
        this.updateVirtualParts();
        VerletSystem verletSystem = this;
        this.prevOrientation.set(verletSystem.orientation);
        this.refreshPosition();
        this.lastCenter.set(this.center);
        this.active = false;
        this.resting = 0;
        this.deactivationScheduled = 0;
        n3 = this.get(4);
        if (abstractRenderer != null && n3 >= 0) {
            n4 = RM.getHeight(n3);
            this.scene = abstractRenderer.createScene(n4, 1, 0);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public final void tick() {
        if (this.isActive()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            VerletSystem verletSystem = this;
            if (verletSystem.isLinked()) {
                int n;
                int n2;
                Point3D point3D = Point3D.getLocal();
                Point3D point3D2 = Point3D.getLocal();
                object5 = Matrix33.getLocal();
                object4 = Matrix33.getLocal();
                verletSystem.getPosition(point3D);
                verletSystem.getPrevPosition(point3D2);
                ((Matrix33)object5).set(Matrix33.IDENTITY);
                ((Matrix33)object4).set(Matrix33.IDENTITY);
                if (verletSystem.linkPose >= 0) {
                    verletSystem.pose(verletSystem.linkPose, verletSystem.linkPoseStrength);
                }
                if (verletSystem.linkType == 2) {
                    n2 = RM.getValue(verletSystem.linkInfo, 4);
                    verletSystem.linkMaster.deriveOrientation(n2, (Matrix33)object5);
                    verletSystem.linkMaster.deriveLastOrientation(n2, (Matrix33)object4);
                    if ((verletSystem.linkFlags & 2) != 0) {
                        n = RM.getValue(verletSystem.linkInfo, 0);
                        verletSystem.linkMaster.getPosition(n, point3D);
                        verletSystem.linkMaster.getPrevPosition(n, point3D2);
                        object3 = Point3D.getLocal();
                        object2 = Point3D.getLocal();
                        ((Point3D)object3).setFromResource(verletSystem.linkInfo, 1);
                        ((Point3D)object2).set((Point3D)object3);
                        ((Matrix33)object5).transform((Point3D)object3);
                        ((Matrix33)object4).transform((Point3D)object2);
                        point3D.add((Point3D)object3);
                        point3D2.add((Point3D)object2);
                        Point3D.freeLocal((Point3D)object2);
                        Point3D.freeLocal((Point3D)object3);
                    }
                    if ((verletSystem.linkFlags & 4) != 0) {
                        Matrix33 matrix33 = Matrix33.getLocal();
                        matrix33.setIdentity();
                        int n3 = RM.getValue(verletSystem.linkInfo, 5);
                        int n4 = RM.getValue(verletSystem.linkInfo, 6);
                        object = RM.getValue(verletSystem.linkInfo, 7);
                        matrix33.rotateZYXFast(n3, n4, (int)object);
                        ((Matrix33)object5).append(matrix33);
                        ((Matrix33)object4).append(matrix33);
                        Matrix33.freeLocal(matrix33);
                    }
                    verletSystem.setKinematics(point3D, (Matrix33)object5, point3D2, (Matrix33)object4);
                }
                Matrix33.freeLocal((Matrix33)object4);
                Matrix33.freeLocal((Matrix33)object5);
                Point3D.freeLocal(point3D2);
                Point3D.freeLocal(point3D);
                if (verletSystem.linkType == 1) {
                    n2 = RM.getHeight(verletSystem.linkInfo);
                    for (n = 0; n < n2; ++n) {
                        int n5 = RM.getValue(verletSystem.linkInfo, n, 0);
                        int n6 = RM.getValue(verletSystem.linkInfo, n, 1);
                        object = RM.getValue(verletSystem.linkInfo, n, 2);
                        if ((verletSystem.linkFlags & 1) != 0) {
                            point3D = verletSystem.positions[n6];
                            Point3D point3D3 = verletSystem.linkMaster.positions[n5];
                            long l = point3D.x - point3D3.x >> 1;
                            long l2 = point3D.y - point3D3.y >> 1;
                            long l3 = point3D.z - point3D3.z >> 1;
                            l *= (long)object;
                            l2 *= (long)object;
                            l3 *= (long)object;
                            point3D.x = (int)((long)point3D.x - (l >>= 10));
                            point3D.y = (int)((long)point3D.y - (l2 >>= 10));
                            point3D.z = (int)((long)point3D.z - (l3 >>= 10));
                            point3D3.x = (int)((long)point3D3.x + l);
                            point3D3.y = (int)((long)point3D3.y + l2);
                            point3D3.z = (int)((long)point3D3.z + l3);
                            continue;
                        }
                        verletSystem.positions[n6].blend(verletSystem.linkMaster.positions[n5], (int)object);
                    }
                }
            }
            if (!this.kinematicsSet) {
                this.prevOrientation.set(this.getOrientation());
                this.lastCenter.set(this.center);
            }
            if (this.anim != null && this.anim.isPlaying()) {
                this.anim.tick();
            }
            if (this.anim == null || this.anim.needsConstraints()) {
                verletSystem = this;
                int n = verletSystem.get(7);
                while (--n >= 0) {
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    Point3D point3D;
                    Object object6 = verletSystem.sticks;
                    if (object6 >= 0) {
                        int n11 = object6;
                        object5 = verletSystem;
                        Point3D[] point3DArray = ((VerletSystem)object5).positions;
                        int[] nArray = ((VerletSystem)object5).invmasses;
                        int n12 = RM.getHeight(n11);
                        int n13 = false;
                        object = 0;
                        object6 = 0;
                        long l = 0L;
                        point3D = null;
                        Point3D point3D4 = null;
                        n10 = false;
                        n9 = false;
                        long l4 = 0L;
                        long l5 = 0L;
                        long l6 = 0L;
                        long l7 = 0L;
                        int n14 = 0;
                        object4 = RM.getInts(n11);
                        int n15 = 0;
                        for (int i = 0; i < n12; ++i) {
                            n13 = object4[n15];
                            object = object4[n15 + 1];
                            object6 = object4[n15 + 3];
                            l = (long)object4[n15 + 2];
                            point3D = point3DArray[n13];
                            point3D4 = point3DArray[object];
                            n10 = nArray[n13];
                            n9 = nArray[object];
                            l4 = point3D4.x - point3D.x;
                            l5 = point3D4.y - point3D.y;
                            l6 = point3D4.z - point3D.z;
                            l7 = l4 * l4 + l5 * l5 + l6 * l6 >> 10;
                            n14 = (int)((l << 10) / (l7 + l)) - 512;
                            if (object6 != 1024) {
                                n14 *= object6;
                                n14 >>= 10;
                            }
                            if (n10 != n9) {
                                l4 *= (long)(n14 /= n10 + n9);
                                l5 *= (long)n14;
                                l6 *= (long)n14;
                                point3D.x = (int)((long)point3D.x - (l4 >>= 10) * (long)n10);
                                point3D.y = (int)((long)point3D.y - (l5 >>= 10) * (long)n10);
                                point3D.z = (int)((long)point3D.z - (l6 >>= 10) * (long)n10);
                                point3D4.x = (int)((long)point3D4.x + l4 * (long)n9);
                                point3D4.y = (int)((long)point3D4.y + l5 * (long)n9);
                                point3D4.z = (int)((long)point3D4.z + l6 * (long)n9);
                            } else {
                                l4 *= (long)n14;
                                l5 *= (long)n14;
                                l6 *= (long)n14;
                                point3D.x = (int)((long)point3D.x - (l4 >>= 10));
                                point3D.y = (int)((long)point3D.y - (l5 >>= 10));
                                point3D.z = (int)((long)point3D.z - (l6 >>= 10));
                                point3D4.x = (int)((long)point3D4.x + l4);
                                point3D4.y = (int)((long)point3D4.y + l5);
                                point3D4.z = (int)((long)point3D4.z + l6);
                            }
                            n15 += 4;
                        }
                    }
                    if ((object6 = verletSystem.planeSeparations) >= 0) {
                        Object object7 = object6;
                        object5 = verletSystem;
                        ((VerletSystem)object5).updateSystemOrientation();
                        Matrix33 matrix33 = ((VerletSystem)object5).getOrientation();
                        Point3D[] point3DArray = ((VerletSystem)object5).positions;
                        object3 = ((VerletSystem)object5).invmasses;
                        int n16 = point3DArray.length;
                        object = RM.getHeight(object7);
                        int[] nArray = RM.getInts(object7);
                        int n17 = 0;
                        for (n8 = 0; n8 < object; ++n8) {
                            point3D = matrix33.getAxis(nArray[n17 + 1]);
                            int n18 = nArray[n17 + 0];
                            Point3D point3D5 = point3DArray[n18];
                            long l = nArray[n17 + 2];
                            int n19 = nArray[n17 + 3];
                            Object object8 = object3[n18];
                            int n20 = 0;
                            int n21 = 0;
                            int n22 = 0;
                            int n23 = 0;
                            for (int i = 0; i < n16; ++i) {
                                if ((1 << i & n19) == 0) continue;
                                object5 = point3DArray[i];
                                object7 = object3[i];
                                long l8 = point3D5.x - ((Point3D)object5).x;
                                long l9 = point3D5.y - ((Point3D)object5).y;
                                long l10 = point3D5.z - ((Point3D)object5).z;
                                long l11 = l8 * (long)point3D.x + l9 * (long)point3D.y + l10 * (long)point3D.z >> 10;
                                if (l11 >= l) continue;
                                int n24 = (int)((l - l11) / (long)(object8 + object7));
                                n18 = point3D.x * n24;
                                int n25 = point3D.y * n24;
                                n24 = point3D.z * n24;
                                n20 += (n18 >>= 10);
                                n21 += (n25 >>= 10);
                                n22 += (n24 >>= 10);
                                ((Point3D)object5).x -= n18 * object7;
                                ((Point3D)object5).y -= n25 * object7;
                                ((Point3D)object5).z -= n24 * object7;
                                ++n23;
                            }
                            if (n23 > 0) {
                                point3D5.add(n20 * object8 / n23, n21 * object8 / n23, n22 * object8 / n23);
                            }
                            n17 += 4;
                        }
                    }
                    if ((n7 = verletSystem.planeConstraints) >= 0) {
                        int n26 = n7;
                        object5 = verletSystem;
                        Point3D[] point3DArray = ((VerletSystem)object5).positions;
                        int n27 = ((VerletSystem)object5).positions.length;
                        int n28 = RM.getHeight(n26);
                        object2 = RM.getInts(n26);
                        object = 0;
                        for (n7 = 0; n7 < n28; ++n7) {
                            int n29 = object2[object + 0];
                            n8 = object2[object + 1];
                            int n30 = object2[object + 2];
                            Object object9 = object2[object + 3];
                            n10 = object2[object + 4];
                            n9 = object2[object + 5];
                            for (int i = 0; i < n27; ++i) {
                                if ((n9 & 1 << i) == 0) continue;
                                Point3D point3D6 = point3DArray[i];
                                reference var20_61 = (object9 - point3D6.dot(n29, n8, n30)) * n10 >> 10;
                                point3D6.add(n29 * var20_61 >> 10, n8 * var20_61 >> 10, n30 * var20_61 >> 10);
                            }
                            object += 6;
                        }
                    }
                    if ((n7 = verletSystem.reachCones) >= 0) {
                        verletSystem.satisfyCones(n7);
                    }
                    if (listener$22647a43 == null) continue;
                    listener$22647a43.onSatisfy(verletSystem, verletSystem.positions, verletSystem.previous, verletSystem.flags);
                }
                this.updateVirtualParts();
            }
            this.integrate();
            this.updateSystemOrientation();
            this.refreshPosition();
            this.checkActivity();
            this.kinematicsSet = false;
            this.currentPose = -1;
        }
    }

    public final int getNumParts() {
        return this.positions.length;
    }

    public static void setBulletTime(int n) {
        bulletFactor = n;
    }

    public final void linkTo(VerletSystem verletSystem, int n, int n2, int n3, int n4, int n5) {
        this.linkMaster = verletSystem;
        this.linkInfo = n;
        this.linkPose = n2;
        this.linkPoseStrength = n3;
        this.linkType = n4;
        this.linkFlags = n5;
    }

    public final void unlink() {
        this.linkMaster = null;
        this.linkInfo = -1;
        this.linkFlags = 0;
        this.linkPose = -1;
    }

    public final void startAnim(int n) {
        if (this.anim == null) {
            this.anim = new VerletAnimator(this);
        }
        this.anim.init(n);
    }

    public final void inheritKinematics(VerletSystem verletSystem, int n) {
        Point3D point3D = Point3D.getLocal();
        point3D.setBlend(verletSystem.center, verletSystem.lastCenter, n);
        Object object = verletSystem;
        Matrix33 matrix33 = verletSystem.prevOrientation;
        Point3D point3D2 = point3D;
        Matrix33 matrix332 = ((VerletSystem)object).orientation;
        object = verletSystem.center;
        verletSystem = this;
        int n2 = verletSystem.positions.length;
        for (int i = 0; i < n2; ++i) {
            Point3D point3D3 = verletSystem.positions[i];
            Point3D point3D4 = verletSystem.previous[i];
            point3D3.sub(verletSystem.center);
            point3D4.set(point3D3);
            matrix332.transform(point3D3);
            point3D3.add((Point3D)object);
            matrix33.transform(point3D4);
            point3D4.add(point3D2);
        }
        Point3D.freeLocal(point3D);
    }

    public final void inheritTranslation(VerletSystem verletSystem, int n) {
        Point3D[] point3DArray = Point3D.getLocal();
        point3DArray.setDiff(verletSystem.center, verletSystem.lastCenter);
        if (n >= 0 && point3DArray.length() > n) {
            point3DArray.setLength(n);
        }
        int n2 = 1024;
        Point3D[] point3DArray2 = point3DArray;
        VerletSystem verletSystem2 = this;
        Point3D point3D = Point3D.getLocal();
        point3D.set((Point3D)point3DArray2);
        point3D.scale(1024);
        point3D.scale(timeFactor);
        point3DArray2 = verletSystem2.positions;
        int n3 = verletSystem2.positions.length;
        while (--n3 >= 0) {
            point3DArray2[n3].add(point3D);
        }
        Point3D.freeLocal(point3D);
        verletSystem2.refreshPosition();
        Point3D.freeLocal((Point3D)point3DArray);
    }

    public final void setKinematics(Point3D point3D, Matrix33 matrix33, Point3D point3D2, Matrix33 matrix332) {
        Object object = this;
        object = ((VerletSystem)object).orientation;
        Point3D[] point3DArray = this.positions;
        Point3D[] point3DArray2 = this.previous;
        int n = point3DArray.length;
        Point3D point3D3 = this.center;
        for (int i = 0; i < n; ++i) {
            Point3D point3D4 = point3DArray[i];
            Point3D point3D5 = point3DArray2[i];
            point3D4.sub(point3D3);
            ((Matrix33)object).invTransform(point3D4);
            point3D5.set(point3D4);
            matrix33.transform(point3D4);
            point3D4.add(point3D);
            matrix332.transform(point3D5);
            point3D5.add(point3D2);
        }
        this.orientation.set(matrix33);
        this.lastCenter.set(point3D2);
        this.prevOrientation.set(matrix332);
        this.refreshCenter();
        this.kinematicsSet = true;
    }

    public final void setOrientation(Matrix33 matrix33) {
        Object object = this;
        object = ((VerletSystem)object).orientation;
        Point3D[] point3DArray = this.positions;
        int n = this.positions.length;
        Point3D point3D = this.center;
        for (int i = 0; i < n; ++i) {
            Point3D point3D2 = point3DArray[i];
            point3D2.sub(point3D);
            ((Matrix33)object).invTransform(point3D2);
            matrix33.transform(point3D2, point3D);
        }
    }

    private void refreshPosition() {
        this.updateVirtualParts();
        this.refreshCenter();
    }

    private void refreshCenter() {
        int n;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        Point3D[] point3DArray = this.positions;
        int n2 = n = this.positions.length;
        Point3D point3D = this.center;
        while (--n2 >= 0) {
            Point3D point3D2 = point3DArray[n2];
            l += (long)point3D2.x;
            l2 += (long)point3D2.y;
            l3 += (long)point3D2.z;
        }
        point3D.x = (int)(l /= (long)n);
        point3D.y = (int)(l2 /= (long)n);
        point3D.z = (int)(l3 /= (long)n);
        VerletSystem verletSystem = this;
        Point3D[] point3DArray2 = verletSystem.positions;
        Point3D point3D3 = verletSystem.min;
        Point3D point3D4 = verletSystem.max;
        point3D3.set(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        point3D4.set(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        long l4 = verletSystem.center.x;
        long l5 = verletSystem.center.y;
        long l6 = verletSystem.center.z;
        int n3 = point3DArray2.length;
        long l7 = Integer.MIN_VALUE;
        int n4 = point3D3.x;
        int n5 = point3D3.y;
        n = point3D3.z;
        n2 = point3D4.x;
        int n6 = point3D4.y;
        int n7 = point3D4.z;
        while (--n3 >= 0) {
            long l8;
            long l9;
            long l10;
            long l11;
            Point3D point3D5 = point3DArray2[n3];
            int n8 = point3D5.x;
            int n9 = point3D5.y;
            int n10 = point3D5.z;
            if (n8 < n4) {
                n4 = n8;
            }
            if (n9 < n5) {
                n5 = n9;
            }
            if (n10 < n) {
                n = n10;
            }
            if (n8 > n2) {
                n2 = n8;
            }
            if (n9 > n6) {
                n6 = n9;
            }
            if (n10 > n7) {
                n7 = n10;
            }
            if ((l11 = (l10 = (long)n8 - l4) * l10 + (l9 = (long)n9 - l5) * l9 + (l8 = (long)n10 - l6) * l8 >> 10) <= l7) continue;
            l7 = l11;
        }
        point3D3.set(n4, n5, n);
        point3D4.set(n2, n6, n7);
        verletSystem.radiusSquared = (int)l7;
    }

    public final void setActive(boolean bl) {
        boolean bl2 = this.active = bl && !this.deactivated;
        if (bl) {
            this.resting = 0;
        }
    }

    public final void deactivate() {
        this.deactivated = true;
    }

    public final void setRestingEnabled(boolean bl) {
        this.allowResting = bl;
    }

    public final void setAdditiveFriction(int n) {
        this.additiveFriction = n;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final boolean isDeactivated() {
        return this.deactivated;
    }

    public final boolean isLinked() {
        return this.linkMaster != null;
    }

    public final VerletSystem getLinkMaster() {
        return this.linkMaster;
    }

    public final void getPosition(Point3D point3D) {
        this.getPosition(this.origin, point3D);
    }

    public final void getPhysicsPosition(int n, Point3D point3D) {
        point3D.set(this.positions[n]);
    }

    public final void getPosition(int n, Point3D point3D) {
        if (bulletFactor == 1024) {
            point3D.set(this.positions[n]);
            return;
        }
        point3D.setBlend(this.previous[n], this.positions[n], bulletFactor);
    }

    public final void getWorldPosition(int n, Point3D point3D) {
        this.getPosition(n, point3D);
        point3D.shiftR(physicsToScreen);
    }

    public final void getPrevPosition(Point3D point3D) {
        this.getPrevPosition(this.origin, point3D);
    }

    public final void getPrevPosition(int n, Point3D point3D) {
        point3D.set(this.previous[n]);
    }

    public final Point3D getCenter() {
        return this.center;
    }

    public final int getRadiusSquared() {
        return this.radiusSquared;
    }

    public final int getScreenRadiusSquared() {
        return this.radiusSquared >> (physicsToScreen << 1);
    }

    public final void getScreenCenter(Point3D point3D) {
        point3D.set(this.center);
        point3D.shiftR(physicsToScreen);
    }

    public final void getScreenPosition(int n, Point3D point3D) {
        this.getPosition(n, point3D);
        point3D.shiftR(physicsToScreen);
    }

    public final void getScreenPosition(Point3D point3D) {
        this.getPosition(point3D);
        point3D.shiftR(physicsToScreen);
    }

    public final Matrix33 getOrientation() {
        return this.orientation;
    }

    public final int[] getPartFlags() {
        return this.flags;
    }

    public final int getIdx() {
        return this.residx;
    }

    public static void setListener$6fe08e58(Game3d game3d) {
        listener$22647a43 = game3d;
    }

    public static void setPhysicsShift(int n) {
        physicsToScreen = 5;
    }

    public static void setTimeFactor(int n) {
        timeFactor = 1500;
    }

    public final void move(int n, int n2, int n3) {
        Point3D[] point3DArray = this.positions;
        Point3D[] point3DArray2 = this.previous;
        int n4 = point3DArray.length;
        while (--n4 >= 0) {
            Point3D point3D = point3DArray[n4];
            point3D.x += n;
            point3D.y += n2;
            point3D.z += n3;
            point3D = point3DArray2[n4];
            point3D.x += n;
            point3D.y += n2;
            point3D.z += n3;
        }
        this.lastCenter.add(n, n2, n3);
        this.center.add(n, n2, n3);
    }

    public final void moveTo(int n, int n2, int n3) {
        Point3D point3D = this.positions[this.get(1)];
        this.move(n -= point3D.x, n2 -= point3D.y, n3 -= point3D.z);
    }

    public final void moveTo(Point3D point3D) {
        this.moveTo(point3D.x, point3D.y, point3D.z);
    }

    public final void moveTo(Point3D point3D, Matrix33 matrix33) {
        this.setKinematics(point3D, matrix33, point3D, matrix33);
        this.kinematicsSet = false;
    }

    public final void moveCenterTo(Point3D point3D) {
        int n = point3D.x - this.center.x;
        int n2 = point3D.y - this.center.y;
        int n3 = point3D.z - this.center.z;
        this.move(n, n2, n3);
    }

    public final void push(int n, int n2, int n3) {
        Point3D[] point3DArray = this.positions;
        int n4 = this.positions.length;
        int n5 = timeFactor;
        n *= n5;
        n >>= 10;
        n2 *= n5;
        n2 >>= 10;
        n3 *= n5;
        n3 >>= 10;
        while (--n4 >= 0) {
            Point3D point3D = point3DArray[n4];
            point3D.x += n;
            point3D.y += n2;
            point3D.z += n3;
        }
        this.refreshPosition();
    }

    public final void applyForce(int n, Point3D point3D) {
        Point3D point3D2 = Point3D.getLocal();
        point3D2.set(point3D);
        point3D2.scale(timeFactor);
        this.positions[n].add(point3D2);
        Point3D.freeLocal(point3D2);
    }

    public final void applyFriction(int n, Point3D point3D) {
        Point3D point3D2 = this.positions[n];
        Point3D point3D3 = this.previous[n];
        int n2 = this.friction + this.additiveFriction;
        int n3 = point3D2.x - point3D3.x;
        int n4 = point3D2.y - point3D3.y;
        int n5 = point3D2.z - point3D3.z;
        n3 *= point3D.x;
        n4 *= point3D.y;
        n5 *= point3D.z;
        point3D2.x -= (n3 >>= 10) * n2 >> 10;
        point3D2.y -= (n4 >>= 10) * n2 >> 10;
        point3D2.z -= (n5 >>= 10) * n2 >> 10;
    }

    public final void pose(int n, int n2) {
        this.currentPose = n;
        Point3D[] point3DArray = this.positions;
        Point3D point3D = this.positions[this.origin];
        Object object = this;
        object = ((VerletSystem)object).orientation;
        Point3D point3D2 = Point3D.getLocal();
        int n3 = RM.getHeight(n);
        int[] nArray = RM.getInts(n);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray[n4 + 0];
            point3D2.x = nArray[n4 + 1];
            point3D2.y = nArray[n4 + 2];
            point3D2.z = nArray[n4 + 3];
            ((Matrix33)object).invTransform(point3D2);
            point3D2.add(point3D);
            Point3D point3D3 = point3DArray[n5];
            point3D3.blend(point3D2, n2);
            n4 += 4;
        }
        Point3D.freeLocal(point3D2);
        this.updateSystemOrientation();
        this.updateVirtualParts();
    }

    public final void poseBlended(int n, int n2, int n3, int n4) {
        this.currentPose = n;
        Point3D[] point3DArray = this.positions;
        Point3D point3D = this.positions[this.origin];
        Object object = this;
        object = ((VerletSystem)object).orientation;
        Point3D point3D2 = Point3D.getLocal();
        Point3D point3D3 = Point3D.getLocal();
        int n5 = RM.getHeight(n);
        int[] nArray = RM.getInts(n);
        int[] nArray2 = RM.getInts(n2);
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            int n7 = nArray[n6 + 0];
            point3D2.x = nArray[n6 + 1];
            point3D2.y = nArray[n6 + 2];
            point3D2.z = nArray[n6 + 3];
            point3D3.x = nArray2[n6 + 1];
            point3D3.y = nArray2[n6 + 2];
            point3D3.z = nArray2[n6 + 3];
            ((Matrix33)object).invTransform(point3D2);
            ((Matrix33)object).invTransform(point3D3);
            point3D2.add(point3D);
            point3D3.add(point3D);
            point3D2.blend(point3D3, n3);
            Point3D point3D4 = point3DArray[n7];
            point3D4.blend(point3D2, n4);
            n6 += 4;
        }
        Point3D.freeLocal(point3D3);
        Point3D.freeLocal(point3D2);
        this.updateSystemOrientation();
        this.updateVirtualParts();
    }

    public final void poseToRest(int n) {
        Point3D[] point3DArray = this.positions;
        Point3D point3D = this.positions[this.origin];
        int n2 = point3DArray.length;
        int n3 = RM.getValue(this.resid, this.residx, 0);
        Point3D point3D2 = Point3D.getLocal();
        for (int i = 0; i < n2; ++i) {
            point3D2.setFromResource(n3, i, 0);
            point3D2.add(point3D);
            point3DArray[i].blend(point3D2, 64);
        }
        Point3D.freeLocal(point3D2);
        this.updateSystemOrientation();
    }

    public final boolean resolveCollision(VerletSystem verletSystem, int n, int n2) {
        long l = this.radiusSquared + verletSystem.radiusSquared;
        Point3D point3D = Point3D.getLocal();
        point3D.setDiff(verletSystem.center, this.center);
        long l2 = point3D.sqrLength();
        boolean bl = false;
        if (l2 > 0L && l2 < l) {
            long l3 = (l << 10) / (l2 + l) - 512L;
            l3 *= (long)n;
            l3 >>= 10;
            if (n2 == 1) {
                verletSystem.setActive(true);
            } else if (n2 == 2 && verletSystem.center.y > this.center.y) {
                verletSystem.setActive(true);
            }
            VerletSystem verletSystem2 = verletSystem;
            if (verletSystem2.active) {
                point3D.scale((int)l3);
                verletSystem.push(point3D.x, point3D.y, point3D.z);
                point3D.scale(-1024);
                this.push(point3D.x, point3D.y, point3D.z);
            } else {
                point3D.scale(-2 * (int)l3);
                this.push(point3D.x, point3D.y, point3D.z);
            }
            bl = true;
        }
        Point3D.freeLocal(point3D);
        return bl;
    }

    private void integrate() {
        if (listener$22647a43 != null) {
            listener$22647a43.preIntegrate(this);
        }
        Point3D[] point3DArray = this.positions;
        Point3D[] point3DArray2 = this.previous;
        int n = (this.gravity * timeFactor >> 10) * timeFactor >> 10;
        int n2 = point3DArray.length;
        if (this.kinematicsSet) {
            for (int i = 0; i < n2; ++i) {
                point3DArray[i].y -= n;
            }
            return;
        }
        int[] nArray = this.invmasses;
        for (int i = 0; i < n2; ++i) {
            Point3D point3D = point3DArray[i];
            Point3D point3D2 = point3DArray2[i];
            if (nArray[i] > 0) {
                int n3 = point3D.x - point3D2.x;
                int n4 = point3D.y - point3D2.y;
                int n5 = point3D.z - point3D2.z;
                point3D2.x = point3D.x;
                point3D2.y = point3D.y;
                point3D2.z = point3D.z;
                point3D.x += n3;
                point3D.y += (n4 -= n);
                point3D.z += n5;
                continue;
            }
            point3D2.set(point3D);
        }
    }

    private void satisfyCones(int n) {
        if (this.currentPose >= 0) {
            return;
        }
        Point3D point3D = Point3D.getLocal();
        Point3D point3D2 = Point3D.getLocal();
        int n2 = RM.getHeight(n);
        int[] nArray = RM.getInts(n);
        Matrix33 matrix33 = Matrix33.getLocal();
        int[] nArray2 = this.invmasses;
        Point3D[] point3DArray = this.positions;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            this.deriveOrientation(nArray[n3 + 0], matrix33);
            int n4 = nArray[n3 + 1];
            int n5 = nArray[n3 + 2];
            Point3D point3D3 = point3DArray[n4];
            Point3D point3D4 = point3DArray[n5];
            n4 = nArray2[n4];
            n5 = nArray2[n5];
            point3D.setDiff(point3D4, point3D3);
            int n6 = nArray[n3 + 3];
            int[] nArray3 = RM.getInts(n6);
            int n7 = RM.getHeight(n6);
            n6 = RM.getWidth(n6);
            int n8 = 0;
            for (int j = 0; j < n7; ++j) {
                point3D2.set(nArray3, n8);
                matrix33.transform(point3D2);
                int n9 = point3D2.dot(point3D) / (n4 + n5);
                if (n9 < 0) {
                    point3D2.scale(n9);
                    point3D4.sub(point3D2.x * n5, point3D2.y * n5, point3D2.z * n5);
                    point3D3.add(point3D2.x * n4, point3D2.y * n4, point3D2.z * n4);
                }
                n8 += n6;
            }
            n3 += 5;
        }
        Matrix33.freeLocal(matrix33);
        Point3D.freeLocal(point3D2);
        Point3D.freeLocal(point3D);
    }

    private void updateVirtualParts() {
        int n = this.get(12);
        if (n >= 0) {
            Point3D point3D = Point3D.getLocal();
            this.getPosition(point3D);
            Point3D[] point3DArray = this.positions;
            int n2 = RM.getHeight(n);
            int[] nArray = RM.getInts(n);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4;
                Point3D point3D2 = point3DArray[nArray[n3 + 0]];
                int n5 = nArray[n3 + 1];
                if (n5 == 0) {
                    Point3D point3D3 = point3DArray[nArray[n3 + 2]];
                    Point3D point3D4 = point3DArray[nArray[n3 + 3]];
                    n4 = nArray[n3 + 4];
                    point3D2.setBlend(point3D3, point3D4, n4);
                } else if (n5 == 1) {
                    n5 = nArray[n3 + 2];
                    int n6 = nArray[n3 + 3];
                    n4 = nArray[n3 + 4];
                    point3D2.set(n5, n6, n4);
                    VerletSystem verletSystem = this;
                    verletSystem.orientation.transform(point3D2, point3D);
                }
                n3 += 5;
            }
            Point3D.freeLocal(point3D);
        }
    }

    private static Point3D getWorldAxis(int n) {
        switch (n) {
            case -1: {
                return Point3D.X;
            }
            case -2: {
                return Point3D.Y;
            }
            case -3: {
                return Point3D.Z;
            }
            case -4: {
                return Point3D.NEGX;
            }
            case -5: {
                return Point3D.NEGY;
            }
            case -6: {
                return Point3D.NEGZ;
            }
        }
        return null;
    }

    private void deriveOrientation(int n, Matrix33 matrix33) {
        Object object = this.orientationData;
        int n2 = object[n <<= 2];
        int n3 = object[n + 1];
        int n4 = object[n + 2];
        n = object[n + 3];
        object = Point3D.getLocal();
        Point3D point3D = Point3D.getLocal();
        if (n3 >= 0) {
            this.getPosition(n2, (Point3D)object);
            this.getPosition(n3, point3D);
            matrix33.ax.setDiff(point3D, (Point3D)object);
        } else {
            matrix33.ax.set(VerletSystem.getWorldAxis(n3));
        }
        if (n >= 0) {
            this.getPosition(n4, (Point3D)object);
            this.getPosition(n, point3D);
            matrix33.az.setDiff(point3D, (Point3D)object);
        } else {
            matrix33.az.set(VerletSystem.getWorldAxis(n));
        }
        try {
            matrix33.orthoNormalize();
        }
        catch (Exception exception) {}
        Point3D.freeLocal(point3D);
        Point3D.freeLocal((Point3D)object);
    }

    private void deriveLastOrientation(int n, Matrix33 matrix33) {
        int[] nArray = this.orientationData;
        int n2 = nArray[n <<= 2];
        int n3 = nArray[n + 1];
        int n4 = nArray[n + 2];
        n = nArray[n + 3];
        if (n3 >= 0) {
            matrix33.ax.setDiff(this.previous[n3], this.previous[n2]);
        } else {
            matrix33.ax.set(VerletSystem.getWorldAxis(n3));
        }
        if (n >= 0) {
            matrix33.az.setDiff(this.previous[n], this.previous[n4]);
        } else {
            matrix33.az.set(VerletSystem.getWorldAxis(n));
        }
        try {
            matrix33.orthoNormalize();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void updateSystemOrientation() {
        Matrix33 matrix33 = this.orientation;
        boolean bl = false;
        Point3D[] point3DArray = this;
        int[] nArray = this.orientationData;
        int n = this.orientationData[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        point3DArray = point3DArray.positions;
        if (n2 >= 0) {
            matrix33.ax.setDiff(point3DArray[n2], point3DArray[n]);
        } else {
            matrix33.ax.set(VerletSystem.getWorldAxis(n2));
        }
        if (n4 >= 0) {
            matrix33.az.setDiff(point3DArray[n4], point3DArray[n3]);
        } else {
            matrix33.az.set(VerletSystem.getWorldAxis(n4));
        }
        try {
            matrix33.orthoNormalize();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void checkActivity() {
        VerletSystem verletSystem;
        if (this.deactivationScheduled > 0) {
            --this.deactivationScheduled;
        } else if (this.deactivationScheduled < 0) {
            verletSystem = this;
            this.deactivated = true;
            if (listener$22647a43 != null) {
                listener$22647a43.onDeactivate(this);
            }
        }
        if (this.isLinked()) {
            verletSystem = this.linkMaster;
            this.setActive(verletSystem.active);
            return;
        }
        if (this.allowResting) {
            int n;
            verletSystem = this;
            if (verletSystem.active && (n = this.restingThreshold) > 0) {
                int n2 = Point3D.distSquared(this.center, this.lastCenter);
                if (this.center.isEqual(this.lastCenter) || n2 >= 0 && n2 < n) {
                    ++this.resting;
                    if (this.resting > this.restingFrameThreshold) {
                        this.setActive(false);
                        if (listener$22647a43 != null) {
                            listener$22647a43.onDeactivate(this);
                            return;
                        }
                    }
                } else if (this.resting > 0) {
                    --this.resting;
                }
            }
        }
    }

    public final int getSpeed() {
        Point3D point3D = Point3D.getLocal();
        point3D.setDiff(this.center, this.lastCenter);
        int n = point3D.length();
        Point3D.freeLocal(point3D);
        return n;
    }

    public final int getAveragePartSpeed() {
        int n = this.positions.length;
        if (n == 0) {
            return 0;
        }
        Point3D point3D = Point3D.getLocal();
        long l = 0L;
        Point3D[] point3DArray = this.positions;
        Point3D[] point3DArray2 = this.previous;
        for (int i = 0; i < n; ++i) {
            point3D.setDiff(point3DArray[i], point3DArray2[i]);
            long l2 = point3D.sqrLength();
            l += l2;
        }
        Point3D.freeLocal(point3D);
        return GCanvas.sqrt((int)l) / n;
    }

    public final void getVelocity(Point3D point3D) {
        point3D.setDiff(this.center, this.lastCenter);
    }

    public final void getVelocity(int n, Point3D point3D) {
        point3D.setDiff(this.positions[n], this.previous[n]);
    }

    public final void getScreenVelocity(Point3D point3D) {
        this.getVelocity(point3D);
        point3D.shiftR(physicsToScreen);
    }

    public final void getScreenVelocity(int n, Point3D point3D) {
        this.getVelocity(n, point3D);
        point3D.shiftR(physicsToScreen);
    }

    private final int get(int n) {
        return RM.getValue(this.resid, this.residx, n);
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
    }

    public final void updateScene$3246187e(AbstractRenderer abstractRenderer, boolean n) {
        if (this.visible) {
            Point3D point3D = Point3D.getLocal();
            this.getScreenCenter(point3D);
            if (abstractRenderer.isInFrustum(point3D, this.getScreenRadiusSquared()) || n) {
                abstractRenderer.setSceneVisibility(this.scene, true);
                if (this.active || n) {
                    n = RM.getHeight(this.geometries);
                    int[] nArray = RM.getInts(this.geometries);
                    Matrix33 matrix33 = Matrix33.getLocal();
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        int n3 = nArray[n2 + 0];
                        n3 = RM.getValue(this.skin, n3);
                        this.getPosition(nArray[n2 + 1], point3D);
                        this.deriveOrientation(nArray[n2 + 2], matrix33);
                        if (listener$22647a43 != null) {
                            listener$22647a43.preDraw(this, i, point3D, matrix33);
                        }
                        abstractRenderer.setObject(this.scene, i, n3);
                        point3D.shiftR(physicsToScreen);
                        abstractRenderer.setObjectTransform(this.scene, i, matrix33, point3D);
                        n2 += 3;
                    }
                    Matrix33.freeLocal(matrix33);
                }
            } else {
                abstractRenderer.setSceneVisibility(this.scene, false);
            }
            Point3D.freeLocal(point3D);
            return;
        }
        abstractRenderer.setSceneVisibility(this.scene, false);
    }

    public final void createPartData(int n) {
        this.partData = new byte[1][this.positions.length];
    }

    public final byte[] getPartData(int n) {
        return this.partData[0];
    }

    public final byte[] createUserData(int n) {
        this.userData = new byte[9];
        return this.userData;
    }

    public final byte[] getUserData() {
        return this.userData;
    }

    public final int getFlags() {
        return this.systemFlags;
    }

    static {
        physicsToScreen = 5;
        timeFactor = 1024;
        bulletFactor = 1024;
    }
}

