/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.math3d;

import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.math3d.M3D;

public final class Point2D {
    private static Point2D X;
    public int x;
    public int y;

    public static final void locInit(int n) {
        M3D.locInit(4, new Point2D().getClass(), 10);
    }

    public static final Point2D getLocal() {
        return (Point2D)M3D.locAllocate(4);
    }

    public static final Point2D getLocal(int n, int n2) {
        Point2D point2D = (Point2D)M3D.locAllocate(4);
        point2D.set(n, n2);
        return point2D;
    }

    public static final void freeLocal(Point2D point2D) {
        M3D.locFree$4cfcfd12(4);
    }

    public Point2D() {
    }

    public final String toString() {
        return super.toString();
    }

    private Point2D(int n, int n2) {
        this.set(n, n2);
    }

    public final void set(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public final void set(Point2D point2D) {
        this.x = point2D.x;
        this.y = point2D.y;
    }

    public final void setFromResource(int n, int n2, int n3) {
        this.x = RM.getValue(777, n2, 1);
        this.y = RM.getValue(777, n2, 2);
    }

    public final void setDiff(Point2D point2D, Point2D point2D2) {
        this.x = point2D.x - point2D2.x;
        this.y = point2D.y - point2D2.y;
    }

    public final void setBlend(Point2D point2D, Point2D point2D2, int n) {
        if (n == 1024) {
            this.x = point2D2.x;
            this.y = point2D2.y;
            return;
        }
        if (n == 0) {
            this.x = point2D.x;
            this.y = point2D.y;
            return;
        }
        long l = n;
        long l2 = point2D2.x - point2D.x;
        long l3 = point2D2.y - point2D.y;
        this.x = point2D.x + (int)(l2 * l >> 10);
        this.y = point2D.y + (int)(l3 * l >> 10);
    }

    public final int dot(Point2D point2D) {
        long l = this.x;
        long l2 = this.y;
        long l3 = point2D.x;
        long l4 = point2D.y;
        return (int)(l * l3 + l2 * l4 >> 10);
    }

    public final void unit() {
        long l;
        long l2;
        long l3;
        int n = this.x < 0 ? -this.x : this.x;
        int n2 = this.y < 0 ? -this.y : this.y;
        if ((n = n < n2 ? n2 : n) == 0) {
            return;
        }
        if (n < 500) {
            int n3 = 1024 / n;
            this.x *= n3;
            this.y *= n3;
        }
        if ((n = GCanvas.sqrt((int)(l3 = (l2 = (long)this.x) * l2 + (l = (long)this.y) * l >> 10))) == 0) {
            n = 1;
        }
        this.x <<= 10;
        this.x /= n;
        this.y <<= 10;
        this.y /= n;
    }

    public final void add(Point2D point2D) {
        this.x += point2D.x;
        this.y += point2D.y;
    }

    public final void addScaled(Point2D point2D, int n) {
        long l = n;
        this.x += (int)((long)point2D.x * l >> 10);
        this.y += (int)((long)point2D.y * l >> 10);
    }

    public final void add(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public final void sub(Point2D point2D) {
        this.x -= point2D.x;
        this.y -= point2D.y;
    }

    public final void sub(int n, int n2) {
        this.x -= n;
        this.y -= n2;
    }

    public final void scale(int n) {
        long l = n;
        this.x = (int)((long)this.x * l >> 10);
        this.y = (int)((long)this.y * l >> 10);
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public final int length() {
        long l = this.x;
        long l2 = this.y;
        long l3 = l * l + l2 * l2 >> 10;
        int n = GCanvas.sqrt((int)l3);
        return n;
    }

    public final void setLength(int n) {
        long l = this.length();
        if (l != 0L && l != (long)n) {
            n = (int)(((long)n << 10) / l);
            this.scale(n);
        }
    }

    public final void capLength(int n) {
        long l = this.length();
        if (l != 0L && l > (long)n) {
            n = (int)(((long)n << 10) / l);
            this.scale(n);
        }
    }

    public final long sqrLength() {
        long l = this.x;
        long l2 = this.y;
        return l * l + l2 * l2 >> 10;
    }

    public static final int dist(Point2D point2D, Point2D point2D2) {
        long l = point2D2.x - point2D.x;
        long l2 = point2D2.y - point2D.y;
        return GCanvas.sqrt((int)(l * l + l2 * l2 >> 10));
    }

    public final void transform(Point2D point2D) {
        long l = point2D.x;
        long l2 = point2D.y;
        long l3 = this.x;
        long l4 = this.y;
        point2D.x = (int)(l * l3 - l2 * l4 >> 10);
        point2D.y = (int)(l * l4 + l2 * l3 >> 10);
    }

    public final void append(Point2D point2D) {
        point2D.transform(this);
    }

    public final void setRotation(int n) {
        this.x = GCanvas.cos(n);
        this.y = GCanvas.sin(n);
    }

    public final void perpCCW() {
        int n = this.y;
        this.y = -this.x;
        this.x = n;
    }

    static {
        new Point2D(0, 0);
        X = new Point2D(1024, 0);
        new Point2D(0, 1024);
        new Point2D(-1024, 0);
        new Point2D(0, -1024);
    }
}

