/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ArenaGame;
import tinbrain.GCanvas;
import tinbrain.RM;

public final class Player {
    public ArenaGame mGame;
    public int[] mStateInfo;
    public int mRideId;
    public int mRideHandle;
    public int mInputState;
    int mCachedInputState;
    public int mScoreDisplay;
    public int mScore;
    public int mScoreDisplayCombo;
    public int mScoreCombo;
    public int mScoreMultiplier;
    boolean mScoringEnabled;
    public int mScoreMultiplierMax;
    int mScoreMultiplierUpdateFrame;
    public int mScoreComboLastUpdateKeyFrame;
    public int mScoreComboTimeoutBarPercentage;
    public boolean mScoreComboDisableBreak;
    private int[] mScoreMoveCount;
    protected int[] mLastMoves;
    protected int[] mLastMovesPrefix;
    protected int mLastMoveIndex;
    public int mDistance;
    int mCollectedItems;
    int mDamageDuringLevel;
    int mFinished;
    public int mTicks;
    int mPassedFireRings;
    public boolean mExitWasTarget;
    int mScoreIncrement;
    public int mScoreComboIncrement;
    boolean mScoreOverrideLastMove = false;

    public Player(ArenaGame object) {
        this.mGame = object;
        this.mFinished = -1;
        object = this;
        Player player = object;
        ((Player)object).mScoreComboLastUpdateKeyFrame = Integer.MIN_VALUE;
        player.mScoreComboTimeoutBarPercentage = -1;
        ((Player)object).mScoreMultiplier = 0;
        ((Player)object).mScoreMultiplierUpdateFrame = -1;
        ((Player)object).mScore = 0;
        ((Player)object).mScoreDisplay = 0;
        ((Player)object).mScoreMultiplierMax = 0;
        ((Player)object).mScoreComboDisableBreak = false;
        if (null == ((Player)object).mLastMoves) {
            ((Player)object).mLastMoves = new int[3];
        }
        if (null == ((Player)object).mLastMovesPrefix) {
            ((Player)object).mLastMovesPrefix = new int[3];
        }
        if (((Player)object).mScoreMoveCount == null) {
            ((Player)object).mScoreMoveCount = new int[RM.getHeight(582)];
        }
        ((Player)object).resetScoreMoveCount();
        this.mDamageDuringLevel = 0;
        this.mPassedFireRings = 0;
        this.mScoreOverrideLastMove = false;
        this.mExitWasTarget = false;
        this.mScoringEnabled = true;
    }

    public final void clearSteer(int n) {
        this.mInputState &= 0xFFFFFFFB;
        this.mCachedInputState &= 0xFFFFFFFB;
    }

    public final void addDamage(int n) {
        this.mDamageDuringLevel += n;
    }

    public final int getLevelDamageInPercent() {
        int n = 100 * this.mDamageDuringLevel / 500;
        n = Math.min(100, n);
        return n;
    }

    public final int getCachedInputState() {
        return this.mCachedInputState;
    }

    public final void scoreComboImmediateBreak() {
        this.mScoreComboTimeoutBarPercentage = -1;
        int n = RM.getValue(583, this.mRideId, 8);
        this.mScoreComboDisableBreak = false;
        this.mGame.scoreComboScoreFloatStart();
        this.mScoreComboLastUpdateKeyFrame = this.mGame.getKeyFrame() - n;
    }

    private void resetLastMoves() {
        this.mLastMoveIndex = -1;
        for (int i = 0; i < 3; ++i) {
            this.mLastMoves[i] = -1;
            this.mLastMovesPrefix[i] = -1;
        }
    }

    public final void resetScoreMoveCount() {
        for (int i = 0; i < this.mScoreMoveCount.length; ++i) {
            this.mScoreMoveCount[i] = 0;
        }
    }

    public final int getMultiplier() {
        if (this.mScoreMultiplier > 0) {
            return this.mScoreMultiplier;
        }
        return 1;
    }

    public final void scoreAddMove(int n, boolean bl) {
        block17: {
            int n2;
            Player player;
            block16: {
                if (!this.mScoringEnabled) {
                    return;
                }
                if (RM.getValue(582, n, 7) == 0) break block16;
                player = this;
                if (this.mGame.getRideData(player.mRideHandle)[5] != 0) break block17;
            }
            if (n == 9) {
                ++this.mPassedFireRings;
            }
            if ((n2 = RM.getValue(582, n, 6)) > -1) {
                this.mGame.tutorialConditionFulfilled(n2);
            }
            if (RM.getValue(582, n, 2) == 1) {
                Player player2 = this;
                if ((player2.mLastMoveIndex < 0 ? -1 : player2.mLastMoves[player2.mLastMoveIndex]) != n || RM.getValue(582, n, 3) != 1 || this.mScoreOverrideLastMove) {
                    this.mScoreOverrideLastMove = false;
                    int n3 = n;
                    this.mScoreMoveCount[n3] = this.mScoreMoveCount[n3] + 1;
                    n2 = RM.getValue(582, n, 5);
                    if (this.mScoreMoveCount[n] <= n2 || n2 <= 0) {
                        ++this.mScoreMultiplier;
                        this.mScoreMultiplierUpdateFrame = this.mGame.getFrame();
                        if (this.mScoreMultiplier == 10) {
                            this.mGame.achievementsSet(10);
                        }
                    }
                    this.mLastMoveIndex = GCanvas.mathWrap(++this.mLastMoveIndex, 0, 2);
                    this.mLastMoves[this.mLastMoveIndex] = n;
                    this.mLastMovesPrefix[this.mLastMoveIndex] = ArenaGame.getRank(this.getMultiplier());
                }
            }
            if (this.mScoreMultiplier == 0) {
                this.mScoreMultiplier = 1;
            }
            n2 = RM.getValue(582, n, 1);
            player = this;
            int n4 = player.mRideId;
            if (n4 == 1 || n4 == 2) {
                Object object = this;
                object = ((Player)object).mStateInfo;
                if (n == 1 && this.mGame.getKeyFrame() == object[17] + 28) {
                    n2 *= 29;
                }
            }
            this.mScoreCombo += n2;
            this.mScoreComboLastUpdateKeyFrame = this.mGame.getKeyFrame();
            if (bl) {
                this.mScoreDisplayCombo = this.mScoreCombo;
            } else {
                this.mScoreComboIncrement = (this.mScoreCombo - this.mScoreDisplayCombo) / 10;
            }
            boolean bl2 = this.mScoreComboDisableBreak = RM.getValue(582, n, 4) == 1;
        }
        if (this.mScoreMultiplier == 0) {
            this.mScoreMultiplier = 1;
        }
    }

    public final void overrideLastMove() {
        this.mScoreOverrideLastMove = true;
    }

    public final void scoreComboAddToTotalScore() {
        this.mScore += this.mScoreCombo * this.getMultiplier();
        this.mScoreIncrement = (this.mScore - this.mScoreDisplay) / 10;
        this.mScoreCombo = 0;
        this.mScoreDisplayCombo = 0;
        this.mScoreMultiplier = 0;
        this.mScoreMultiplierUpdateFrame = -1;
        this.resetLastMoves();
    }

    public final int getRideId() {
        return this.mRideId;
    }

    public final void setRide(int n, int n2, int[] nArray) {
        this.mRideId = n;
        this.mRideHandle = n2;
        this.mStateInfo = nArray;
    }

    public final int[] getStateInfo() {
        return this.mStateInfo;
    }

    public final boolean succeeded() {
        return this.mFinished == 1 || this.mFinished == 2;
    }

    public final boolean isFinished() {
        return this.mFinished != -1;
    }
}

