/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.physics3d;

import tinbrain.RM;
import tinbrain.math3d.Matrix34;
import tinbrain.math3d.Point3D;
import tinbrain.physics3d.VerletSystem;
import tinbrain.util.GL;

public final class VerletAnimator {
    private static final Point3D fmcpos = new Point3D();
    private static final Point3D fmcrot = new Point3D();
    private static final Point3D fmnpos = new Point3D();
    private static final Point3D fmnrot = new Point3D();
    private static final Point3D tickOpos = new Point3D();
    private static final Matrix34 tickMat = new Matrix34();
    private static final Matrix34 tickTmpMat = new Matrix34();
    private int mAnimId = -1;
    private int mAnimFrame = 0;
    private int mAnimLength = 0;
    private int mAnimIndex;
    private int mAnimLastFrame;
    private Point3D mStartPos = new Point3D();
    private byte[] mAnimData;
    private Point3D mAnimLastKeyPos = new Point3D();
    private Point3D mAnimLastKeyRot = new Point3D();
    private Point3D mAnimLastPos = new Point3D();
    private Point3D mAnimLastRot = new Point3D();
    private Matrix34 mAnimStartOrientation = new Matrix34();
    private Matrix34 mAnimStartInvOrientation = new Matrix34();
    private int mAnimBlendFactor = 0;
    private int mAnimType;
    private Point3D[] mPartPositions;
    private VerletSystem sys;

    public VerletAnimator(VerletSystem verletSystem) {
        this.sys = verletSystem;
    }

    final void init(int n) {
        if (this.isPlaying()) {
            return;
        }
        this.mAnimId = n;
        this.mAnimFrame = 0;
        this.mStartPos.set(this.sys.center);
        if (n != -1) {
            int n2 = RM.getLink(491, 0, n);
            this.mAnimType = RM.getValue(491, n2, 1);
            this.mAnimLength = RM.getLength(n);
            this.mAnimData = RM.getBytes(n);
            this.mAnimIndex = 0;
            this.mAnimLastKeyPos.set(0, 0, 0);
            this.mAnimLastKeyRot.set(0, 0, 0);
            this.mAnimLastPos.set(0, 0, 0);
            this.mAnimLastRot.set(0, 0, 0);
            this.mAnimLastFrame = 0;
            this.mAnimStartOrientation.set(this.sys.getOrientation());
            this.mAnimStartInvOrientation.set(this.sys.getOrientation());
            this.mAnimStartInvOrientation.transpose3X3();
            this.mAnimBlendFactor = 1024;
            if (this.mAnimType == 1) {
                Point3D[] point3DArray = this.sys.positions;
                n2 = this.sys.positions.length;
                if (this.mPartPositions == null) {
                    this.mPartPositions = new Point3D[n2];
                    for (int i = 0; i < n2; ++i) {
                        this.mPartPositions[i] = new Point3D();
                    }
                }
                Point3D[] point3DArray2 = this.mPartPositions;
                while (--n2 >= 0) {
                    point3DArray2[n2].set(point3DArray[n2]);
                    point3DArray2[n2].sub(this.mStartPos);
                }
            }
        }
    }

    final boolean needsConstraints() {
        return !this.isPlaying() || this.mAnimType != 1;
    }

    final boolean isPlaying() {
        return this.mAnimId != -1;
    }

    private int animGetNextValue() {
        int n = GL.packedBinGetValue(this.mAnimData, this.mAnimIndex);
        this.mAnimIndex += GL.packedBinGetIncrement(this.mAnimData, this.mAnimIndex);
        return n;
    }

    private void animGetPosAndRot(Point3D point3D, Point3D point3D2) {
        int n = this.animGetNextValue();
        point3D.set(0, 0, 0);
        point3D2.set(0, 0, 0);
        if ((n & 8) > 0) {
            point3D2.x = this.animGetNextValue();
        }
        if ((n & 0x10) > 0) {
            point3D2.y = this.animGetNextValue();
        }
        if ((n & 0x20) > 0) {
            point3D2.z = this.animGetNextValue();
        }
        if ((n & 1) > 0) {
            point3D.x = this.animGetNextValue();
        }
        if ((n & 2) > 0) {
            point3D.y = this.animGetNextValue();
        }
        if ((n & 4) > 0) {
            point3D.z = this.animGetNextValue();
        }
    }

    final void tick() {
        ++this.mAnimFrame;
        if (this.mAnimId != -1) {
            Point3D point3D = tickOpos;
            Point3D[] point3DArray = tickMat;
            Object object = point3DArray;
            Point3D[] point3DArray2 = this;
            Point3D point3D2 = fmcpos;
            Point3D point3D3 = fmcrot;
            Point3D point3D4 = fmnpos;
            Point3D point3D5 = fmnrot;
            int n = point3DArray2.mAnimData[point3DArray2.mAnimIndex];
            if (n == point3DArray2.mAnimFrame) {
                point3DArray2.mAnimLastFrame = n;
                ++point3DArray2.mAnimIndex;
                point3DArray2.animGetPosAndRot(point3DArray2.mAnimLastKeyPos, point3DArray2.mAnimLastKeyRot);
                point3D2.set(point3DArray2.mAnimLastKeyPos);
                point3D3.set(point3DArray2.mAnimLastKeyRot);
            } else {
                int n2 = point3DArray2.mAnimIndex++;
                point3DArray2.animGetPosAndRot(point3D4, point3D5);
                n = ((point3DArray2.mAnimFrame << 10) - (point3DArray2.mAnimLastFrame << 10) << 10) / ((n << 10) - (point3DArray2.mAnimLastFrame << 10));
                point3D2.setBlend(point3DArray2.mAnimLastKeyPos, point3D4, n);
                point3D3.setBlend(point3DArray2.mAnimLastKeyRot, point3D5, n);
                point3DArray2.mAnimIndex = n2;
            }
            point3D2.shiftL(VerletSystem.getPhysicsToScreen());
            switch (point3DArray2.mAnimType) {
                case 1: {
                    ((Matrix34)object).rotateZYXFast(point3D3.x, point3D3.y, point3D3.z);
                    ((Matrix34)object).trn.set(point3D2);
                    break;
                }
                case 0: {
                    ((Matrix34)object).rotateZYXFast(point3D3.x - point3DArray2.mAnimLastRot.x, point3D3.y - point3DArray2.mAnimLastRot.y, point3D3.z - point3DArray2.mAnimLastRot.z);
                    ((Matrix34)object).trn.set(point3D2.x - point3DArray2.mAnimLastPos.x, point3D2.y - point3DArray2.mAnimLastPos.y, point3D2.z - point3DArray2.mAnimLastPos.z);
                }
            }
            point3DArray2.mAnimLastPos.set(point3D2);
            point3DArray2.mAnimLastRot.set(point3D3);
            point3DArray.prepend(this.mAnimStartInvOrientation);
            if (this.mAnimType == 0) {
                point3DArray.append(this.mAnimStartOrientation);
            } else {
                tickTmpMat.setIdentity();
                tickTmpMat.blend(this.mAnimStartOrientation, this.mAnimBlendFactor);
                this.mAnimBlendFactor = Math.max(0, this.mAnimBlendFactor - 100);
                point3DArray.append(tickTmpMat);
            }
            point3DArray2 = this.sys.positions;
            object = this.mPartPositions;
            int n3 = point3DArray2.length;
            block8: for (int i = 0; i < n3; ++i) {
                point3D4 = point3DArray2[i];
                switch (this.mAnimType) {
                    case 1: {
                        point3D4.set(object[i]);
                        point3DArray.transform(point3D4);
                        point3D4.add(this.mStartPos);
                        continue block8;
                    }
                    case 0: {
                        point3D.set(point3D4);
                        point3D4.sub(this.sys.center);
                        point3DArray.transform(point3D4);
                        point3D4.add(this.sys.center);
                        point3D4.setBlend(point3D, point3D4, 128);
                    }
                }
            }
            if (this.mAnimIndex >= this.mAnimLength) {
                this.mAnimId = -1;
                if (this.mAnimType == 1) {
                    point3DArray2 = this;
                    object = Point3D.getLocal();
                    Point3D[] point3DArray3 = point3DArray2.sys.positions;
                    Point3D[] point3DArray4 = point3DArray2.sys.previous;
                    for (int i = 0; i < point3DArray3.length; ++i) {
                        ((Point3D)object).setDiff(point3DArray3[i], point3DArray4[i]);
                        point3DArray3[i].add((Point3D)object);
                    }
                    Point3D.freeLocal((Point3D)object);
                }
            }
        }
    }
}

