/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.math3d;

import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.math3d.M3D;

public final class Point3D {
    public static final Point3D ZERO = new Point3D(0, 0, 0);
    public static final Point3D X = new Point3D(1024, 0, 0);
    public static final Point3D Y = new Point3D(0, 1024, 0);
    public static final Point3D Z = new Point3D(0, 0, 1024);
    public static final Point3D NEGX = new Point3D(-1024, 0, 0);
    public static final Point3D NEGY = new Point3D(0, -1024, 0);
    public static final Point3D NEGZ = new Point3D(0, 0, -1024);
    public int x;
    public int y;
    public int z;

    public static final void locInit(int n) {
        M3D.locInit(0, new Point3D().getClass(), 10);
    }

    public static final Point3D getLocal() {
        return (Point3D)M3D.locAllocate(0);
    }

    public static final Point3D getLocal(int n, int n2, int n3) {
        Point3D point3D = (Point3D)M3D.locAllocate(0);
        point3D.set(n, n2, 0);
        return point3D;
    }

    public static final void freeLocal(Point3D point3D) {
        M3D.locFree$4cfcfd12(0);
    }

    public Point3D() {
    }

    public final String toString() {
        return null;
    }

    public Point3D(Point3D point3D) {
        this.set(point3D);
    }

    public Point3D(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public final void set(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public final void set(int[] nArray, int n) {
        this.x = nArray[n++];
        this.y = nArray[n++];
        this.z = nArray[n];
    }

    public final void setFromResource(int n, int n2) {
        this.x = RM.getValue(n, 1);
        this.y = RM.getValue(n, 2);
        this.z = RM.getValue(n, 3);
    }

    public final void setFromResource(int n, int n2, int n3) {
        this.x = RM.getValue(n, n2, n3++);
        this.y = RM.getValue(n, n2, n3++);
        this.z = RM.getValue(n, n2, n3);
    }

    public final void set(Point3D point3D) {
        this.x = point3D.x;
        this.y = point3D.y;
        this.z = point3D.z;
    }

    public final int store(int[] nArray, int n) {
        nArray[n++] = this.x;
        nArray[n++] = this.y;
        nArray[n++] = this.z;
        return n;
    }

    public final void setDiff(Point3D point3D, Point3D point3D2) {
        this.x = point3D.x - point3D2.x;
        this.y = point3D.y - point3D2.y;
        this.z = point3D.z - point3D2.z;
    }

    public final void blend(Point3D point3D, int n) {
        if (n == 0) {
            return;
        }
        if (n == 1024) {
            this.x = point3D.x;
            this.y = point3D.y;
            this.z = point3D.z;
            return;
        }
        long l = n;
        long l2 = 1024 - n;
        long l3 = this.x;
        long l4 = this.y;
        long l5 = this.z;
        long l6 = point3D.x;
        long l7 = point3D.y;
        long l8 = point3D.z;
        this.x = (int)(l3 * l2 + l6 * l >> 10);
        this.y = (int)(l4 * l2 + l7 * l >> 10);
        this.z = (int)(l5 * l2 + l8 * l >> 10);
    }

    public final void setBlend(Point3D point3D, Point3D point3D2, int n) {
        if (n == 0) {
            this.x = point3D.x;
            this.y = point3D.y;
            this.z = point3D.z;
            return;
        }
        if (n == 1024) {
            this.x = point3D2.x;
            this.y = point3D2.y;
            this.z = point3D2.z;
            return;
        }
        long l = 1024 - n;
        long l2 = point3D.x;
        long l3 = point3D.y;
        long l4 = point3D.z;
        long l5 = point3D2.x;
        long l6 = point3D2.y;
        long l7 = point3D2.z;
        long l8 = n;
        long l9 = l2 * l + l5 * l8 >> 10;
        long l10 = l3 * l + l6 * l8 >> 10;
        long l11 = l4 * l + l7 * l8 >> 10;
        this.x = (int)l9;
        this.y = (int)l10;
        this.z = (int)l11;
    }

    public final int dot(Point3D point3D) {
        long l = this.x;
        long l2 = this.y;
        long l3 = this.z;
        long l4 = point3D.x;
        long l5 = point3D.y;
        long l6 = point3D.z;
        return (int)(l * l4 + l2 * l5 + l3 * l6 >> 10);
    }

    public final int dot(int n, int n2, int n3) {
        long l = this.x;
        long l2 = this.y;
        long l3 = this.z;
        long l4 = n;
        long l5 = n2;
        long l6 = n3;
        return (int)(l * l4 + l2 * l5 + l3 * l6 >> 10);
    }

    public final void cross(Point3D point3D, Point3D point3D2) {
        long l = point3D.x;
        long l2 = point3D.y;
        long l3 = point3D.z;
        long l4 = point3D2.x;
        long l5 = point3D2.y;
        long l6 = point3D2.z;
        this.x = (int)(l2 * l6 - l3 * l5 >> 10);
        this.y = (int)(l3 * l4 - l * l6 >> 10);
        this.z = (int)(l * l5 - l2 * l4 >> 10);
    }

    public final void unit() {
        int n;
        int n2 = Math.max(Math.max(Math.abs(this.x), Math.abs(this.y)), Math.abs(this.z));
        if (n2 == 0) {
            return;
        }
        if (n2 < 500) {
            n = 1024 / n2;
            this.x *= n;
            this.y *= n;
            this.z *= n;
        }
        if (n2 > 26000) {
            n = 1 + n2 / 26000;
            this.x /= n;
            this.y /= n;
            this.z /= n;
        }
        if ((n = GCanvas.sqrt(this.x * this.x + this.y * this.y + this.z * this.z >> 10)) == 0) {
            n = 1;
        }
        this.x <<= 10;
        this.x /= n;
        this.y <<= 10;
        this.y /= n;
        this.z <<= 10;
        this.z /= n;
    }

    public final void add(Point3D point3D) {
        this.x += point3D.x;
        this.y += point3D.y;
        this.z += point3D.z;
    }

    public final void addScaled(Point3D point3D, int n) {
        this.x += point3D.x * n >> 10;
        this.y += point3D.y * n >> 10;
        this.z += point3D.z * n >> 10;
    }

    public final void add(int n, int n2, int n3) {
        this.x += n;
        this.y += n2;
        this.z += n3;
    }

    public final void sub(Point3D point3D) {
        this.x -= point3D.x;
        this.y -= point3D.y;
        this.z -= point3D.z;
    }

    public final void sub(int n, int n2, int n3) {
        this.x -= n;
        this.y -= n2;
        this.z -= n3;
    }

    public final void scale(int n) {
        if (n == 1024) {
            return;
        }
        if (n == 512) {
            this.x >>= 1;
            this.y >>= 1;
            this.z >>= 1;
            return;
        }
        long l = n;
        long l2 = this.x;
        long l3 = this.y;
        long l4 = this.z;
        l2 *= l;
        l3 *= l;
        l4 *= l;
        this.x = (int)(l2 >>= 10);
        this.y = (int)(l3 >>= 10);
        this.z = (int)(l4 >>= 10);
    }

    public final void scale(int n, int n2, int n3) {
        long l = n;
        long l2 = n2;
        long l3 = n3;
        long l4 = this.x;
        long l5 = this.y;
        long l6 = this.z;
        l4 *= l;
        l5 *= l2;
        l6 *= l3;
        this.x = (int)(l4 >>= 10);
        this.y = (int)(l5 >>= 10);
        this.z = (int)(l6 >>= 10);
    }

    public final void shiftL(int n) {
        this.x <<= n;
        this.y <<= n;
        this.z <<= n;
    }

    public final void shiftR(int n) {
        this.x >>= n;
        this.y >>= n;
        this.z >>= n;
    }

    public final int length() {
        long l = this.x;
        long l2 = this.y;
        long l3 = this.z;
        long l4 = l * l + l2 * l2 + l3 * l3 >> 10;
        int n = GCanvas.sqrt((int)l4);
        return n;
    }

    public final void setLength(int n) {
        int n2 = this.length();
        if (n2 != 0 && n2 != n) {
            n = (int)(((long)n << 10) / (long)n2);
            this.scale(n);
        }
    }

    public final long sqrLength() {
        long l = this.x;
        long l2 = this.y;
        long l3 = this.z;
        return l * l + l2 * l2 + l3 * l3 >> 10;
    }

    public final int distSquared(Point3D point3D) {
        long l = point3D.x - this.x;
        long l2 = point3D.y - this.y;
        long l3 = point3D.z - this.z;
        return (int)(l * l + l2 * l2 + l3 * l3 >> 10);
    }

    public static final int distSquared(Point3D point3D, Point3D point3D2) {
        long l = point3D2.x - point3D.x;
        long l2 = point3D2.y - point3D.y;
        long l3 = point3D2.z - point3D.z;
        return (int)(l * l + l2 * l2 + l3 * l3 >> 10);
    }

    public static final int dist(Point3D point3D, Point3D point3D2) {
        return GCanvas.sqrt(Point3D.distSquared(point3D, point3D2));
    }

    public final boolean isEqual(Point3D point3D) {
        if (point3D == null) {
            return false;
        }
        if (this.x != point3D.x) {
            return false;
        }
        if (this.y != point3D.y) {
            return false;
        }
        return this.z == point3D.z;
    }

    static {
        new Point3D();
        new Point3D();
        new Point3D();
        new Point3D();
        new Point3D();
        new Point3D();
        new Point3D();
    }
}

