/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.math3d;

import tinbrain.GCanvas;
import tinbrain.math3d.M3D;
import tinbrain.math3d.Point3D;

public final class Matrix33 {
    public Point3D ax = new Point3D(Point3D.X);
    public Point3D ay = new Point3D(Point3D.Y);
    public Point3D az = new Point3D(Point3D.Z);
    public static final Matrix33 IDENTITY = new Matrix33();
    private static final Matrix33 itmp0;

    public static final void locInit(int n) {
        M3D.locInit(1, new Matrix33().getClass(), 10);
    }

    public static final Matrix33 getLocal() {
        return (Matrix33)M3D.locAllocate(1);
    }

    public static final Matrix33 getLocal(Matrix33 matrix33) {
        Matrix33 matrix332 = (Matrix33)M3D.locAllocate(1);
        matrix332.set(matrix33);
        return matrix332;
    }

    public static final void freeLocal(Matrix33 matrix33) {
        M3D.locFree$4cfcfd12(1);
    }

    public final void setIdentity() {
        this.ax.set(Point3D.X);
        this.ay.set(Point3D.Y);
        this.az.set(Point3D.Z);
    }

    public final void setFromResource(int n, int n2, int n3) {
        this.ax.setFromResource(n, n2, 4);
        this.ay.setFromResource(n, n2, 7);
        this.az.setFromResource(n, n2, 10);
    }

    public final String toString() {
        return null;
    }

    public final void set(Matrix33 matrix33) {
        this.ax.set(matrix33.ax);
        this.ay.set(matrix33.ay);
        this.az.set(matrix33.az);
    }

    public final void lookAt(Point3D point3D, Point3D point3D2, Point3D point3D3) {
        this.ay.set(point3D2);
        this.az.setDiff(point3D3, point3D);
        int n = this.az.length();
        if (n > 2048) {
            n >>= 4;
        }
        if (n == 0) {
            return;
        }
        this.az.x <<= 10;
        this.az.x /= n;
        this.az.y <<= 10;
        this.az.y /= n;
        this.az.z <<= 10;
        this.az.z /= n;
        this.ax.cross(this.ay, this.az);
        this.ay.cross(this.az, this.ax);
        this.ax.unit();
        this.ay.unit();
        this.az.unit();
    }

    public final void lookAtX(Point3D point3D, Point3D point3D2, Point3D point3D3) {
        this.ay.set(point3D2);
        this.ax.setDiff(point3D3, point3D);
        int n = this.ax.length();
        if (n > 2048) {
            n >>= 4;
        }
        if (n == 0) {
            return;
        }
        this.ax.x <<= 10;
        this.ax.x /= n;
        this.ax.y <<= 10;
        this.ax.y /= n;
        this.ax.z <<= 10;
        this.ax.z /= n;
        this.az.cross(this.ax, this.ay);
        this.ay.cross(this.az, this.ax);
        this.ax.unit();
        this.ay.unit();
        this.az.unit();
    }

    public final void setRotationX(int n) {
        int n2 = GCanvas.sin(n);
        int n3 = GCanvas.cos(n);
        Matrix33 matrix33 = this;
        matrix33.ax.set(Point3D.X);
        matrix33.ay.x = 0;
        matrix33.ay.y = n3;
        matrix33.ay.z = n2;
        matrix33.az.x = 0;
        matrix33.az.y = -n2;
        matrix33.az.z = n3;
    }

    public final void addRotationX(int n) {
        itmp0.setRotationX(n);
        this.append(itmp0);
    }

    public final void setRotationY(int n) {
        int n2 = GCanvas.sin(n);
        int n3 = GCanvas.cos(n);
        Matrix33 matrix33 = this;
        this.ax.x = n3;
        matrix33.ax.y = 0;
        matrix33.ax.z = -n2;
        matrix33.ay.set(Point3D.Y);
        matrix33.az.x = n2;
        matrix33.az.y = 0;
        matrix33.az.z = n3;
    }

    public final void setRotationZ(int n, int n2) {
        this.ax.x = n;
        this.ax.y = n2;
        this.ax.z = 0;
        this.ay.x = -n2;
        this.ay.y = n;
        this.ay.z = 0;
        this.az.set(Point3D.Z);
    }

    public final void setRotationZ(int n) {
        this.setRotationZ(GCanvas.cos(n), GCanvas.sin(n));
    }

    public final void orthoNormalize() {
        this.ax.unit();
        this.ay.cross(this.az, this.ax);
        this.ay.unit();
        this.az.cross(this.ax, this.ay);
    }

    public final void transform(Point3D point3D) {
        int n = point3D.x;
        int n2 = point3D.y;
        int n3 = point3D.z;
        point3D.x = n * this.ax.x + n2 * this.ay.x + n3 * this.az.x >> 10;
        point3D.y = n * this.ax.y + n2 * this.ay.y + n3 * this.az.y >> 10;
        point3D.z = n * this.ax.z + n2 * this.ay.z + n3 * this.az.z >> 10;
    }

    public final void invTransform(Point3D point3D) {
        int n = point3D.x;
        int n2 = point3D.y;
        int n3 = point3D.z;
        point3D.x = n * this.ax.x + n2 * this.ax.y + n3 * this.ax.z >> 10;
        point3D.y = n * this.ay.x + n2 * this.ay.y + n3 * this.ay.z >> 10;
        point3D.z = n * this.az.x + n2 * this.az.y + n3 * this.az.z >> 10;
    }

    public final void transform(Point3D point3D, Point3D point3D2) {
        int n = point3D.x;
        int n2 = point3D.y;
        int n3 = point3D.z;
        point3D.x = (n * this.ax.x + n2 * this.ay.x + n3 * this.az.x >> 10) + point3D2.x;
        point3D.y = (n * this.ax.y + n2 * this.ay.y + n3 * this.az.y >> 10) + point3D2.y;
        point3D.z = (n * this.ax.z + n2 * this.ay.z + n3 * this.az.z >> 10) + point3D2.z;
    }

    public final void append(Matrix33 matrix33) {
        matrix33.transform(this.ax);
        matrix33.transform(this.ay);
        matrix33.transform(this.az);
    }

    public final void prepend(Matrix33 matrix33) {
        itmp0.set(matrix33);
        itmp0.append(this);
        this.set(itmp0);
    }

    public final void appendInverse(Matrix33 matrix33) {
        matrix33.invTransform(this.ax);
        matrix33.invTransform(this.ay);
        matrix33.invTransform(this.az);
    }

    public final Point3D getAxis(int n) {
        switch (n) {
            case 0: {
                return this.ax;
            }
            case 1: {
                return this.ay;
            }
            case 2: {
                return this.az;
            }
        }
        return null;
    }

    public final void rotateZYXFast(int n, int n2, int n3) {
        int n4 = GCanvas.sin(n);
        int n5 = GCanvas.sin(n2);
        int n6 = GCanvas.sin(n3);
        n = GCanvas.cos(n);
        n2 = GCanvas.cos(n2);
        n3 = GCanvas.cos(n3);
        int n7 = n4 * n5 >> 10;
        int n8 = n5 * n >> 10;
        this.ax.x = n2 * n3 >> 10;
        this.ax.y = n6 * n2 >> 10;
        this.ax.z = -n5;
        this.ay.x = -(n6 * n >> 10) + (n7 * n3 >> 10);
        this.ay.y = n * n3 + n7 * n6 >> 10;
        this.ay.z = n4 * n2 >> 10;
        this.az.x = (n4 * n6 >> 10) + (n8 * n3 >> 10);
        this.az.y = -n4 * n3 + n8 * n6 >> 10;
        this.az.z = n * n2 >> 10;
    }

    static {
        new Matrix33();
        new Point3D();
        itmp0 = new Matrix33();
        new Matrix33();
    }
}

