/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.Tinlet;
import tinbrain.ea.fonts.BitmapFont;
import tinbrain.midp20.AGameCanvasNoPaint;
import tinbrain.midp20.MIDP20Proxy;

public final class GCanvas
implements Runnable {
    protected static volatile boolean isRunning;
    private static int screenOrientation;
    private static int dynamicScreenOrientation;
    private static int physicalScreenOrientation;
    private static int globalFrameCount;
    private static long uptimeMillis;
    protected static int width;
    protected static int height;
    private static int keyStatesUp;
    private static int keyStatesDown;
    private static int keyStates;
    private static Canvas canvas;
    private static Graphics deviceGraphics;
    private static Graphics targetGraphics;
    private static Graphics offscreenGraphics;
    private static Image backBuffer;
    private static int[] fontDefinition;
    private static Font[] nativeFonts;
    private static int[] nativeFontColors;
    private static int softkeyPressed;
    private static int lastSoftkeyPressFrame;
    protected static byte[][] softkeys;
    private static int leftSoftButton;
    private static int rightSoftButton;
    public static boolean hideSoftKeys;
    private static final int[][] clipStack;
    private static int clipStackPtr;
    private static long frameTime;
    private static long lastFrameTime;
    private static long lastDrawTime;
    private static int frameTimeCount;
    private static String fpsMessage;
    private static StringBuffer fpsBuf;
    private static String tmpMessage;
    private static int tmpMessageTime;
    private static int cheatFlags;
    private static final int[] cheatBase;
    private static int cheatPosition;
    private static int scheduledCheat;
    private static long current;
    private static long last;
    private static long delay;
    private static short[] sinTable;
    private static volatile boolean isShown;
    private static volatile boolean inPauseHandling;
    private static Image[] spriteCacheImages;
    private static short[] spriteCache;
    private static Image hourglass;
    private static Random random;

    protected static final void setForcedSize(int n, int n2) {
        if (n != width || n2 != height) {
            GCanvas.setSize(n, n2);
        }
    }

    public static final void setSize(int n, int n2) {
        physicalScreenOrientation = canvas == null ? (n > n2 ? 1 : 0) : (canvas.getWidth() > canvas.getHeight() ? 1 : 0);
        int n3 = n;
        int n4 = n2;
        if (screenOrientation == 0) {
            if (physicalScreenOrientation == 1) {
                dynamicScreenOrientation = 3;
                n3 = n2;
                n4 = n;
            } else {
                dynamicScreenOrientation = 0;
            }
        } else if (physicalScreenOrientation == 1) {
            dynamicScreenOrientation = 0;
        } else {
            dynamicScreenOrientation = 1;
            n3 = n2;
            n4 = n;
        }
        n2 = n4;
        n = n3;
        if (backBuffer == null || backBuffer.getWidth() != n || backBuffer.getHeight() != n2) {
            backBuffer = Image.createImage((int)n, (int)n2);
            offscreenGraphics = backBuffer.getGraphics();
        }
        width = n3;
        height = n4;
        if (Menu.isInitialized()) {
            Menu.screenSizeChanged();
        }
    }

    protected static final void setScreenOrientation(int n) {
        screenOrientation = n;
        GCanvas.setSize(canvas.getWidth(), canvas.getHeight());
    }

    public static final void init(MIDlet mIDlet) {
        canvas = new AGameCanvasNoPaint();
        deviceGraphics = canvas.getOffscreenGraphics();
        Display.getDisplay((MIDlet)mIDlet).setCurrent((Displayable)canvas);
    }

    public static final void initResources() {
        int n;
        int n2;
        BitmapFont.init(7);
        int n3 = RM.getHeight(9);
        int n4 = 0;
        fontDefinition = new int[n3];
        int[] nArray = fontDefinition;
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2] = RM.getValue(9, n2, 0);
            if (nArray[n2] >= 0) continue;
            ++n4;
        }
        nativeFonts = new Font[n4];
        nativeFontColors = new int[n4];
        n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (RM.getValue(9, i, 0) >= 0) continue;
            n2 = RM.getValue(9, i, 1);
            n = RM.getValue(9, i, 2);
            int n5 = RM.getValue(9, i, 3);
            GCanvas.nativeFonts[n4] = n2 < 0 ? Font.getDefaultFont() : Font.getFont((int)64, (int)n, (int)n2);
            GCanvas.nativeFontColors[n4] = n5;
            RM.setValue(9, i, 4, n4++);
        }
        sinTable = RM.getShorts(28);
        spriteCache = RM.getShorts(197);
        GCanvas.updateSpriteCache();
    }

    protected static final void updateSpriteCache() {
        int n = RM.getHeight(197);
        if (spriteCacheImages == null) {
            spriteCacheImages = new Image[n];
        }
        for (int i = 0; i < n; ++i) {
            int n2 = RM.getValue(197, i, 0);
            if (!RM.isLoaded(n2)) continue;
            GCanvas.spriteCacheImages[i] = RM.getImage(n2);
        }
    }

    public static final void resetKeys() {
        softkeyPressed = 0;
        keyStatesUp = 0;
        keyStatesDown = 0;
        keyStates = 0;
    }

    public static final int getSoftkeys() {
        int n = softkeyPressed;
        softkeyPressed = 0;
        return n;
    }

    public static final int getSoftKeyAreaTop() {
        return height - (2 + GCanvas.getFontHeight(9));
    }

    private static final void updateUptime(long l) {
        if (canvas.isShown()) {
            long l2 = Math.abs(l - lastDrawTime);
            if (l2 < 672L) {
                uptimeMillis += l2;
            }
            lastDrawTime = l;
        }
    }

    public static final boolean cheatEnabled(int n) {
        return (cheatFlags & 1 << n) != 0;
    }

    public static final long getUptimeMillis() {
        return uptimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void redraw() {
        Graphics graphics;
        deviceGraphics = graphics = deviceGraphics;
        targetGraphics = offscreenGraphics;
        synchronized (graphics) {
            Graphics graphics2 = targetGraphics;
            clipStackPtr = -1;
            if (!isRunning) {
                if (hourglass == null) {
                    int n = 269;
                    byte[] byArray = new byte[269];
                    while (--n >= 0) {
                        byArray[n] = (byte)"\u0089PNG\r\n\u001a\n\u0000\u0000\u0000\rIHDR\u0000\u0000\u0000\u0010\u0000\u0000\u0000\u001c\u0004\u0003\u0000\u0000\u0000\u009a\u001f\")\u0000\u0000\u0000'PLTE\u0000\u0000\u0000\u0010\u0010\u0010\u009c{9\u0090g1yK*k=!\u00b5\u00ad\u0094\u00e7\u00de\u00d6\u0097\u0089j\u00a5\u00a5\u00a5\u00de\u00de\u00de\u00f2\u00f0\u00f5\u00d6\u00d6\u00d6X\u00de&\u00c4\u0000\u0000\u0000\u0001tRNS\u0000@\u00e6\u00d8f\u0000\u0000\u0000\u0094IDATx^e\u008f\u00bb\u0011\u00c20\u0010D\u00f7:\u0010\u0004\u001ec2\u00b5\u0000-P\u0000%(9Q\u0081\u0015;\u0081\u00d8)D\n\u00f9T\u0080#:cO\u00f2\u00e0\u0080\u008d\u00de\u00bc\u009b\u00d9\u009d\u00c3j\u000e\u00d6\u00de\u00fb\u00dd\u00fep\\\u00a0{\u0094d\u00c2\u00f4.\u00b0yNfFH\u0005\u0007\u00b9\u00da\u00e9\u00ee\u0080&\u00f6\u00aa\u0001@\u00ab\u0084\u0081 \u00e7^O\u000e\u00a6\u00a2\tS\u0097*\u0080\u00ed\u00073\u00e4\nrc\u000b\u00c3\u0091\u00d7H\u00b0j\u0016\u0017\u00c1\tS\u009dme,\u00a3\u0012\u0013\u00b7\u00d4\u00a1\u00ad0\u00a0\u00d1\u0094\b\u0081P\u0012\u00fe\u00ff\u00fa\u00bd\u00fc\u0005\u0017hDC\u00156\u00c8\u00e9\u0000\u0000\u0000\u0000IEND\u00aeB`\u0082".charAt(n);
                    }
                    hourglass = Image.createImage((byte[])byArray, (int)0, (int)269);
                }
                int n = -1;
                Graphics graphics3 = graphics2;
                graphics3.setColor(-1);
                graphics3.fillRect(graphics3.getClipX(), graphics3.getClipY(), graphics3.getClipWidth(), graphics3.getClipHeight());
                graphics2.drawImage(hourglass, width >> 1, height >> 1, 3);
            } else {
                graphics2.setClip(0, 0, width, height);
                graphics2.translate(-graphics2.getTranslateX(), -graphics2.getTranslateY());
                try {
                    Menu.onDraw(graphics2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!hideSoftKeys) {
                    int n;
                    int n2;
                    Graphics graphics4 = graphics2;
                    if (leftSoftButton != -1) {
                        int n3 = softkeys[leftSoftButton][2];
                        int n4 = 3;
                        n2 = height - 1;
                        n = 36;
                        if (screenOrientation == 1) {
                            n4 = width - 3;
                            n2 = height - 1;
                            n = 40;
                        }
                        if (n3 < 0) {
                            n3 = RM.getShortFromBytes(softkeys[leftSoftButton], 0);
                            String string = RM.t(n3);
                            GCanvas.drawString(targetGraphics, 9, string, n4, n2, n);
                        } else {
                            GCanvas.drawImage(graphics4, n3, n4, n2, true, n);
                        }
                    }
                    if (rightSoftButton != -1) {
                        int n5 = softkeys[rightSoftButton][2];
                        int n6 = width - 3;
                        n2 = height - 1;
                        n = 40;
                        if (screenOrientation == 1) {
                            n6 = width - 3;
                            n2 = 1;
                            n = 24;
                        }
                        if (n5 < 0) {
                            n5 = RM.getShortFromBytes(softkeys[rightSoftButton], 0);
                            String string = RM.t(n5);
                            GCanvas.drawString(targetGraphics, 9, string, n6, n2, n);
                        } else {
                            GCanvas.drawImage(graphics4, n5, n6, n2, true, n);
                        }
                    }
                }
                long l = System.currentTimeMillis();
                if (GCanvas.cheatEnabled(4)) {
                    if (--frameTimeCount == 0) {
                        frameTimeCount = 16;
                        int n = (int)(l - lastFrameTime);
                        lastFrameTime = l;
                        if ((n >>= 4) > 0) {
                            n = 1024000 / n + 512;
                            int n7 = n >> 10;
                            n &= 0x3FF;
                            n = n * 10 >> 10;
                            if (fpsBuf == null) {
                                fpsBuf = new StringBuffer();
                            }
                            fpsBuf.setLength(0);
                            fpsBuf.append(n7);
                            fpsBuf.append('.');
                            fpsBuf.append(n);
                            fpsMessage = fpsBuf.toString();
                        }
                    }
                    if (fpsMessage != null) {
                        graphics2.setColor(-16777216);
                        graphics2.fillRect(0, 18, GCanvas.getStringWidth(fpsMessage, 0) + 4, GCanvas.getFontHeight(0) + 6);
                        GCanvas.drawString(graphics2, 0, fpsMessage, 2, 20, 20);
                    }
                }
                GCanvas.updateUptime(l);
                if (tmpMessageTime > 0) {
                    graphics2.setColor(-16777216);
                    graphics2.fillRect(0, (height >> 1) - 2, width, GCanvas.getFontHeight(0) + 4);
                    GCanvas.drawString(graphics2, 0, tmpMessage, width >> 1, height >> 1, 17);
                    --tmpMessageTime;
                }
                ++globalFrameCount;
                MIDP20Proxy.drawRotated(deviceGraphics, backBuffer, dynamicScreenOrientation);
            }
        }
        MIDP20Proxy.flushCanvas(canvas);
    }

    public static final void idleTick() {
        GCanvas.updateUptime(System.currentTimeMillis());
    }

    public static final void keyPressed(int n) {
        int n2 = GCanvas.getVKey(n);
        if (Menu.getMode() != 0) {
            if (cheatPosition == cheatBase.length) {
                for (int i = 0; i < 10; ++i) {
                    if (n2 != (RM.getValue(52, i, 0) & 0xFFFF)) continue;
                    scheduledCheat = i;
                    break;
                }
                cheatPosition = 0;
            }
            cheatPosition = cheatBase[cheatPosition] == n2 ? ++cheatPosition : 0;
        }
        if (n2 != 0) {
            keyStatesDown |= n2;
            return;
        }
        if (n == -6) {
            if (globalFrameCount - lastSoftkeyPressFrame > 3) {
                softkeyPressed |= 0x20000;
                lastSoftkeyPressFrame = globalFrameCount;
                return;
            }
        } else if (n == -7 && globalFrameCount - lastSoftkeyPressFrame > 3) {
            softkeyPressed |= 0x40000;
            lastSoftkeyPressFrame = globalFrameCount;
        }
    }

    public static final boolean isLandscape() {
        return screenOrientation == 1;
    }

    public static final void keyReleased(int n) {
        keyStatesUp |= GCanvas.getVKey(n);
    }

    public static final boolean isKeyPressed(int n) {
        return (keyStates & n) != 0;
    }

    public static final boolean consumeKey(int n) {
        if (GCanvas.isKeyPressed(1040)) {
            keyStatesDown &= 0xFFFFFBEF;
            return true;
        }
        return false;
    }

    public static final boolean consumeUP() {
        if ((0x81 & keyStates) != 0) {
            keyStatesDown &= 0xFFFFFF7E;
            return true;
        }
        return false;
    }

    public static final boolean consumeDOWN() {
        if ((0x2004 & keyStates) != 0) {
            keyStatesDown &= 0xFFFFDFFB;
            return true;
        }
        return false;
    }

    public static final boolean consumeLEFT() {
        if ((0x208 & keyStates) != 0) {
            keyStatesDown &= 0xFFFFFDF7;
            return true;
        }
        return false;
    }

    public static final boolean consumeRIGHT() {
        if ((0x802 & keyStates) != 0) {
            keyStatesDown &= 0xFFFFF7FD;
            return true;
        }
        return false;
    }

    public static final boolean consumeFIRE() {
        if ((0x410 & keyStates) != 0) {
            keyStatesDown &= 0xFFFFFBEF;
            return true;
        }
        return false;
    }

    private static int mapVKey(int n, int n2) {
        int n3;
        if (!RM.isLoaded(n)) {
            return 0;
        }
        int n4 = Menu.getMode() == 2 ? 2 : 1;
        int n5 = 0;
        int n6 = RM.getLink(n, 0, n2);
        if (n6 >= 0 && ((n3 = RM.getValue(n, n6, 2)) & n4) != 0) {
            n5 = RM.getValue(n, n6, 1);
        }
        if (n5 != 0) {
            return n5;
        }
        return GCanvas.checkExtendedDPAD(n2, n, 0, 1);
    }

    private static final int checkDPAD(int n) {
        int n2 = 0;
        try {
            n2 = canvas.getGameAction(n);
        }
        catch (Exception exception) {}
        switch (n2) {
            case 1: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 8: {
                return 16;
            }
        }
        return 0;
    }

    private static final int checkExtendedDPAD(int n, int n2, int n3, int n4) {
        n3 = 0;
        try {
            n3 = canvas.getGameAction(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n5 = 0;
        switch (n3) {
            case 1: {
                n5 = 0xDDDDDDD;
                break;
            }
            case 5: {
                n5 = 0xCCCCCCC;
                break;
            }
            case 6: {
                n5 = 0xBBBBBBB;
                break;
            }
            case 2: {
                n5 = 0xAAAAAAA;
                break;
            }
            case 8: {
                n5 = 0xEEEEEEE;
            }
        }
        if (n5 != 0 && (n5 = RM.getLinkedValue(n2, 0, n5, 1)) != -1) {
            if (physicalScreenOrientation == 1) {
                switch (dynamicScreenOrientation) {
                    case 3: {
                        switch (n5) {
                            case 1: {
                                return 2;
                            }
                            case 2: {
                                return 4;
                            }
                            case 4: {
                                return 8;
                            }
                            case 8: {
                                return 1;
                            }
                        }
                    }
                    case 1: {
                        switch (n5) {
                            case 1: {
                                return 8;
                            }
                            case 2: {
                                return 4;
                            }
                            case 4: {
                                return 2;
                            }
                            case 8: {
                                return 1;
                            }
                        }
                    }
                    case 0: {
                        switch (n5) {
                            case 1: {
                                return 2;
                            }
                            case 2: {
                                return 4;
                            }
                            case 4: {
                                return 8;
                            }
                            case 8: {
                                return 1;
                            }
                        }
                    }
                }
            }
            return n5;
        }
        return 0;
    }

    private static final int getVKey(int n) {
        int n2 = n;
        n2 = screenOrientation == 1 ? GCanvas.mapVKey(3, n2) : GCanvas.mapVKey(2, n2);
        if (n2 != 0) {
            return n2;
        }
        n2 = n;
        if (n2 == -6 || n2 == -7) {
            return 0;
        }
        if (screenOrientation == 0) {
            return 0;
        }
        if (screenOrientation == 1) {
            return 0;
        }
        return GCanvas.checkDPAD(n);
    }

    public static final void hideNotify() {
        try {
            Menu.stopMusic();
            Menu.doPause();
        }
        catch (Exception exception) {}
        inPauseHandling = false;
    }

    public static final void showNotify() {
        if (!inPauseHandling) {
            inPauseHandling = true;
            try {
                Menu.resumeFromInterrupt();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public final void run() {
        isRunning = true;
        lastDrawTime = last = System.currentTimeMillis();
        uptimeMillis = last;
        while (isRunning) {
            try {
                keyStates = keyStatesDown;
                keyStatesDown &= ~keyStatesUp;
                keyStatesUp = 0;
                int n = scheduledCheat;
                if (n >= 0) {
                    scheduledCheat = -1;
                    int n2 = n;
                    int n3 = -1;
                    int n4 = 1 << n2;
                    if ((cheatFlags & n4) != 0) {
                        cheatFlags &= ~n4;
                        n3 = 50;
                    } else {
                        n = RM.getValue(52, n2, 2);
                        if (n != 0) {
                            Menu.performMenuAction(n, n2);
                        } else {
                            n = RM.getValue(52, n2, 3);
                            if (n != 0) {
                                Menu.performMenuAction(n, n2);
                            }
                            cheatFlags |= n4;
                            n3 = 49;
                        }
                    }
                    n = RM.getValue(52, n2, 1);
                    if (n != -1 && n3 != -1) {
                        String string = RM.t(n) + " " + RM.t(n3);
                        if (tmpMessageTime <= 0) {
                            tmpMessage = string;
                            tmpMessageTime = 30;
                            GCanvas.redraw();
                            Thread.yield();
                        }
                        Menu.refreshMenu();
                    }
                }
                Menu.onInput();
            }
            catch (Throwable throwable) {}
            GCanvas.redraw();
            current = System.currentTimeMillis();
            frameTime = Math.abs(current - last);
            long l = Menu.getMode() == 2 ? Menu.game$486afe46.getDesiredFrameTime() : 42L;
            long l2 = delay = Math.max(2L, l - frameTime);
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
            last = System.currentTimeMillis();
        }
        if (!isRunning) {
            Tinlet.instance.notifyDestroyed();
        }
    }

    public static int ipGetLambda(int n, int n2) {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                n = 1024 - GCanvas.cos(n >> 2);
                break;
            }
            case 2: {
                n = GCanvas.cos(256 - (n >> 2));
                break;
            }
            case 3: {
                n = 512 + (GCanvas.cos(512 + (n >> 1)) >> 1);
            }
        }
        n = GCanvas.clamp(n, 0, 1024);
        return n;
    }

    public static int mathModWrap(int n, int n2, int n3) {
        n2 = n3;
        if (n2 <= 0) {
            return 0;
        }
        if ((n %= n2) < 0) {
            n += n2;
        }
        return n;
    }

    public static int mathWrap(int n, int n2, int n3) {
        if (n > 2) {
            return n - n / 3 * 3;
        }
        if (n < 0) {
            return n + (2 - n) / 3 * 3;
        }
        return n;
    }

    public static final int mathAbs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static final boolean isSpacingNeeded(int n) {
        return (n = GCanvas.getFontDef(n)) < 0;
    }

    private static final int getFontDef(int n) {
        if (fontDefinition != null) {
            return fontDefinition[n];
        }
        return -1;
    }

    private static Font getNativeFont(int n) {
        if (n == 0 || !RM.isLoaded(9)) {
            return Font.getDefaultFont();
        }
        if ((n = RM.getValue(9, n, 4)) >= 0) {
            return nativeFonts[n];
        }
        return null;
    }

    public static final int getFontHeight(int n) {
        int n2 = GCanvas.getFontDef(n);
        if (n2 >= 0) {
            return BitmapFont.getHeight(n2);
        }
        return GCanvas.getNativeFont(n).getHeight();
    }

    public static final int getSubstringWidth(String string, int n, int n2, int n3) {
        int n4 = GCanvas.getFontDef(n3);
        if (n4 >= 0) {
            return BitmapFont.getSubstringWidth(n4, string, n, n2);
        }
        return GCanvas.getNativeFont(n3).substringWidth(string, n, n2);
    }

    public static final int getCharWidth(char c, int n) {
        int n2 = GCanvas.getFontDef(n);
        if (n2 >= 0) {
            return BitmapFont.getCharWidth(n2, c);
        }
        return GCanvas.getNativeFont(n).charWidth(c);
    }

    public static final int getStringWidth(String string, int n) {
        int n2 = GCanvas.getFontDef(n);
        if (n2 >= 0) {
            return BitmapFont.getStringWidth(n2, string);
        }
        return GCanvas.getNativeFont(n).stringWidth(string);
    }

    public static final int getTextWidth(int n, int n2) {
        String string = RM.t(n);
        return GCanvas.getStringWidth(string, 1);
    }

    public static final void setSoftButton(int n, int n2) {
        boolean bl = false;
        if (GCanvas.isLandscape() && n2 == 8) {
            bl = true;
        }
        leftSoftButton = bl ? n2 : n;
        rightSoftButton = bl ? n : n2;
    }

    public static final int getLSK() {
        return leftSoftButton;
    }

    public static final int getRSK() {
        return rightSoftButton;
    }

    public static final void drawImage(Graphics graphics, int n, int n2, int n3) {
        GCanvas.drawImage(graphics, n, n2, n3, 20);
    }

    public static final void drawImage(Graphics graphics, int n, int n2, int n3, int n4) {
        GCanvas.drawImage(graphics, n, n2, n3, true, n4);
    }

    private static void drawImage(Graphics graphics, int n, int n2, int n3, boolean n4, int n5) {
        n4 = RM.getType(n);
        if (n4 == 1) {
            graphics.drawImage(RM.getImage(n), n2, n3, n5);
            return;
        }
        if (n4 == 4) {
            n4 = RM.getWidth(n);
            MIDP20Proxy.drawImage(graphics, RM.getInts(n), n2, n3, n4, RM.getHeight(n), n4, true, n5);
            return;
        }
        if (n4 == 5) {
            return;
        }
    }

    public static final void drawString(Graphics graphics, int n, String string, int n2, int n3, int n4) {
        int n5 = GCanvas.getFontDef(n);
        if (n5 >= 0) {
            BitmapFont.drawString(graphics, n5, string, n2, n3, n4);
            return;
        }
        Font font = GCanvas.getNativeFont(n);
        if ((n4 & 2) != 0) {
            n4 &= 0xFFFFFFFD;
            n4 |= 0x10;
            n3 -= font.getHeight() >> 1;
        }
        graphics.setFont(font);
        graphics.setColor(n != 0 && RM.isLoaded(9) && (n = RM.getValue(9, n, 4)) >= 0 ? nativeFontColors[n] : -1);
        graphics.drawString(string, n2, n3, n4);
    }

    public static final void drawSprite(Graphics graphics, int n, int n2, int n3, int n4) {
        short[] sArray = spriteCache;
        int n5 = n * 6;
        short s = sArray[n5 + 2];
        short s2 = sArray[n5 + 3];
        short s3 = sArray[n5 + 5];
        short s4 = sArray[n5 + 4];
        GCanvas.pushClip(graphics);
        if (GCanvas.clipRect(graphics, n2 -= s, n3 -= s2, s4, s3)) {
            graphics.drawImage(spriteCacheImages[n], n2, n3 - n4 * s3, 20);
        }
        GCanvas.popClip(graphics);
    }

    public static final int getSpriteWidth(int n) {
        return spriteCache[4 + n * 6];
    }

    public static final int getSpriteHeight(int n) {
        return spriteCache[5 + n * 6];
    }

    public static final int getSpriteFrames(int n) {
        return spriteCache[1 + n * 6];
    }

    public static final int log2(int n) {
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        int n2 = n | n >> 16;
        n = n2;
        n = n2;
        n = n2 - (n >>> 1 & 0x55555555);
        n = (n >>> 2 & 0x33333333) + (n & 0x33333333);
        n = (n >>> 4) + n & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return (n & 0x3F) - 1;
    }

    public static final int sqrt(int n) {
        int n2 = 0;
        int n3 = n;
        n = 0x40000000;
        do {
            int n4 = n2 + n;
            n2 >>= 1;
            if (n4 > n3) continue;
            n3 -= n4;
            n2 += n;
        } while ((n >>= 2) != 0);
        if (n2 < n3) {
            ++n2;
        }
        return n2 << 5;
    }

    public static final int sin(int n) {
        short[] sArray = sinTable;
        if ((n &= 0x3FF) <= 256) {
            return sArray[n];
        }
        if (n <= 512) {
            return sArray[512 - n];
        }
        if (n <= 768) {
            return -sArray[n - 512];
        }
        return -sArray[1024 - n];
    }

    public static final int cos(int n) {
        return GCanvas.sin(n + 256);
    }

    public static final int getRandom(int n, int n2) {
        if (random == null) {
            random = new Random();
        }
        if (n2 == n) {
            return n;
        }
        int n3 = random.nextInt();
        n3 = n3 < 0 ? -n3 : n3;
        return n + n3 % (n2 -= n);
    }

    public static final int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static final int getMinute(int n) {
        return n / 60000;
    }

    public static final int getSecond(int n) {
        return n % 60000 / 1000;
    }

    public static final int getHundrets(int n) {
        return n % 1000 / 10;
    }

    public static final int getScreenOrientation() {
        return screenOrientation;
    }

    public static final int getPhysicalScreenOrientation() {
        return physicalScreenOrientation;
    }

    public static final int getDynamicScreenOrientation() {
        return dynamicScreenOrientation;
    }

    public static final int getGlobalFrameCount() {
        return globalFrameCount;
    }

    public static final int getWidth() {
        return width;
    }

    public static final int getHeight() {
        return height;
    }

    public static final void pushClip(Graphics graphics) {
        int[] nArray = clipStack[++clipStackPtr];
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        nArray[0] = n;
        nArray[2] = n + graphics.getClipWidth();
        nArray[1] = n2;
        nArray[3] = n2 + graphics.getClipHeight();
    }

    public static final boolean clipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = clipStack[clipStackPtr];
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = nArray[2];
        int n8 = nArray[3];
        n3 = n + n3;
        n4 = n2 + n4;
        if (n5 < n) {
            n5 = n;
        }
        if (n6 < n2) {
            n6 = n2;
        }
        if (n7 > n3) {
            n7 = n3;
        }
        if (n8 > n4) {
            n8 = n4;
        }
        if (n7 > n5 && n8 > n6) {
            graphics.setClip(n5, n6, n7 - n5, n8 - n6);
            return true;
        }
        return false;
    }

    public static final void popClip(Graphics graphics) {
        int[] nArray = clipStack[clipStackPtr--];
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        graphics.setClip(n, n2, n3 - n, n4 - n2);
    }

    static {
        lastSoftkeyPressFrame = 0;
        leftSoftButton = -1;
        rightSoftButton = -1;
        clipStack = new int[8][4];
        clipStackPtr = -1;
        frameTimeCount = 16;
        cheatBase = new int[]{65536, 128, 32, 32};
        scheduledCheat = -1;
        isShown = true;
        String cfr_ignored_0 = " " + String.valueOf('(') + String.valueOf(' ') + String.valueOf(')');
        String cfr_ignored_1 = " " + String.valueOf('(') + String.valueOf(' ') + String.valueOf(')');
    }
}

