/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Player;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.IGame;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.math3d.Point2D;
import tinbrain.midp20.MIDP20Proxy;
import tinbrain.mmapi.Sound;
import tinbrain.util.GL;

public abstract class ArenaGame
implements IGame {
    public Player mActivePlayer;
    public int mRagdollHandle;
    private int mMenuBorderTargetTop;
    private int mMenuBorderTargetBottom;
    private int mMenuBorderTop;
    private int mMenuBorderBottom;
    private int mMenuSwipePercentage;
    private boolean mMenuMissionSelectReset;
    public int mCurrentMission;
    private int mMissionSelected;
    private int mPreparedMission;
    private boolean mNewHighscorePending;
    public int mPreviewLeft;
    public int mFrame;
    public int mKeyFrame;
    private int mGameFinishedCountdown;
    private boolean mFirstFrameDrawn;
    private boolean mWaitForPlayer = true;
    private int mCamShakeFrames;
    private int mCamShakeFramesMax;
    private int mCamShakeOffsetMax;
    private int[] mKeyshakeFrames;
    private int mBloodSplashWidth;
    private int mBloodSplashHeight;
    private static int[] mBloodSplash;
    private boolean mIsReplay;
    public boolean mInvalidatePreview;
    private int mTouchedRides;
    private int mPopupTutorialText;
    private int mPopupTutorialDelay;
    private static int mTutorialCondition;
    private static int mTutorialConditionLastTutorialIdx;
    public int mBulletTimeId;
    private int mBulletTimeFraction;
    private int mBulletTimeFractionDelta;
    private int mBulletTimeAccu;
    private int mKeyFramesScheduled;
    public int mRingScorePossible;
    public int mLastRingTrigger;
    public int mCurrentMove;
    private int mTimeLeft;
    private boolean mTimedMission;
    private boolean mIsTraining;
    private int mBackwardsDistance;
    public int[][] mHeightmapInfo;
    public int[] mHeightmapTestpositions;
    private int mMissionNewAchievements;
    private int mAvailableRidesBeforeMission;
    private int[][] mRideTransferTable;
    private boolean mDrawBlood;
    private boolean mDrawShake;
    private int mLastIngameText = -1;
    private Vector mTextlines;
    public Point2D[] mRideCenters;
    public byte[][] mRideDatas;
    private int[][] mScreenMessages;
    private int mLastScore;
    private int mLastMultiplier;
    private int mFrameCountComboScoreStartMoving = -1;
    private int mFrameCountMultiplierStartMoving = -1;
    private int mNewRideDisplayFramesLeft = -1;
    private int mLastNumRidesValue = -1;
    private Point2D mRideDisplayGlowPos;
    private static final String[] timeValues;
    private int[] mSectorsTouched;
    private int[] mSeenTutorials;
    private int mSeenTutorialMission;
    private int mSeenTutorialLast;
    private int mBulletTimeFadeOutReleaseKey = -1;
    private int mBulletTimeFadeOutId = -1;
    private int mBulletFadeInFinishedFrame;
    private int mScrollingTextX = -1;
    private int mScrollingTextY = -1;
    private int mScrollingTextWidth = -1;
    private int mScrollingTextSpeed = -1;
    private int mScrollingTextWait = -1;
    private int mScrollingTextId = -1;
    private static int mLastSelectedItem;
    private static final Point2D tmpDst;
    private int mBulletTimePriority = -1;
    private int[] mCalcVal;
    private int mMenuBackdropAchievement;
    private Vector mMissionPassedLines;
    private int[] mMissionPassedMedalInfo;
    private int mDeathCheckNextFreeRide = -1;
    private int mDeathCheckDelayStart = -1;
    private int mDeathCheckLastLevelDamage = 0;
    public boolean mIsCarAidVisible;
    private boolean mHasBulletTimeFadedOutOnCarAid;
    private int mLastFrameWithLogicsound = -1;
    private Point2D mSelPosTarget;
    private Point2D mSelPos;
    private Vector mMissionNameLines;
    private String mLastMissionName;
    private boolean mResumeMusicAfterInterrupt;

    public final int getFrame() {
        return this.mFrame;
    }

    public final int getKeyFrame() {
        return this.mKeyFrame;
    }

    protected abstract void setTutorialVisible(int var1);

    protected abstract void doRingDetection(Player var1);

    protected abstract void onInit();

    protected abstract void initViewport();

    protected abstract void doRestart();

    protected abstract void initMissionData(int var1);

    protected abstract int getNumRides();

    protected abstract void hideRideFX();

    protected abstract void setRideFXVisibility(int var1, boolean var2);

    protected abstract void getRideOrientation(Point2D var1);

    protected abstract void getRidePosition(Point2D var1);

    protected abstract void getRidePosition(int var1, int var2, Point2D var3);

    protected abstract void getRidePrevPosition(Point2D var1);

    protected abstract void getRidePrevPosition(int var1, Point2D var2);

    protected abstract void getRideVelocity(Point2D var1);

    protected abstract void getRideVelocity(int var1, Point2D var2);

    protected abstract boolean getRideGlowPosition(int var1, Point2D var2);

    protected abstract int getRideSpeed();

    protected abstract int getRideRadiusSquared(int var1);

    protected abstract void getRideCenter(int var1, Point2D var2);

    protected abstract boolean missionHasTargetZone(int var1);

    protected abstract boolean isSystemActive(int var1);

    protected abstract boolean isSystemDeactivated(int var1);

    protected abstract boolean isSystemVisible(int var1);

    protected abstract boolean isSystemLinked(int var1);

    protected abstract void unlinkSystem(int var1);

    protected abstract int getSystemType(int var1);

    protected abstract void setSystemVisible(int var1, boolean var2);

    protected abstract void setSystemActive(int var1, boolean var2);

    protected abstract void linkSystems(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract void inheritSystemTranslation(int var1, int var2, int var3);

    protected abstract void inheritSystemKinematics(int var1, int var2, int var3);

    protected abstract void pushSystem(int var1, int var2, int var3, int var4);

    protected abstract void poseRide(int var1, int var2);

    protected abstract void poseRide(int var1, int var2, int var3);

    protected abstract void poseRide(int var1, int var2, int var3, int var4, int var5);

    protected abstract void setRideKinematics(Point2D var1);

    protected abstract void setRideKinematics(Point2D var1, Point2D var2);

    protected abstract void setRideOrientation(Point2D var1);

    protected abstract void setSystemRestingEnabled(int var1, boolean var2);

    protected abstract void setSystemAdditiveFriction(int var1, int var2);

    protected abstract void setSystemDeactivated(int var1);

    protected abstract void moveSystemTo(int var1, Point2D var2);

    protected abstract void placeSystem(int var1, int var2, int var3);

    protected abstract void applyForce(int var1, Point2D var2);

    protected abstract void carApplySpecialConstraits();

    public final byte[] getRideData(int n) {
        return this.mRideDatas[n];
    }

    protected abstract void spawnEffect(int var1, int var2);

    protected abstract void spawnEffectSparse(int var1, int var2, boolean var3);

    protected abstract void updateRideCenters();

    protected abstract int calculateAim(int[] var1, int var2);

    protected abstract void carApplyCharge(int var1, int var2);

    protected abstract void carApplyAcceleration(int var1, int var2);

    protected abstract boolean isLoopingAvailable();

    protected abstract void initMainMenu();

    protected abstract void drawMainMenu(Graphics var1);

    protected abstract void initLevelFlyby();

    protected abstract void drawTrackPreview$11c48828(Graphics var1, int var2);

    protected abstract void draw(Graphics var1);

    protected abstract void triggerUpdateVisibleRepresentations();

    protected abstract void setCamHint(int var1);

    protected abstract void onIdleTick();

    protected abstract void onHandleBulletTime(int var1);

    protected abstract void doGameLogic();

    public abstract void playAnim(Player var1, int var2);

    protected abstract void autoCameraInit(int var1);

    protected abstract void autoCameraPlay();

    protected abstract void autoCameraReset();

    protected abstract void forceGameCameraReset();

    protected abstract int checkIfRagdollIsInTargetRange$2eb89048(int var1);

    public final void onDraw(Graphics graphics) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            GCanvas.pushClip(graphics);
            GCanvas.clipRect(graphics, 0, 0, GCanvas.getWidth(), GCanvas.getHeight() - this.mCalcVal[34]);
            this.triggerUpdateVisibleRepresentations();
            Player player = this.getActivePlayer();
            if (player.mScoreDisplay < player.mScore) {
                player.mScoreDisplay += player.mScoreIncrement;
            }
            int n14 = 0;
            int n15 = 0;
            if (this.mCamShakeFrames > 0) {
                n15 = 256 * this.mCamShakeFrames / this.mCamShakeFramesMax;
                if (this.mDrawShake) {
                    n14 = GCanvas.sin((this.mCamShakeFrames << 10) / this.mCamShakeFramesMax >> 2) * this.mCamShakeOffsetMax >> 10;
                    n14 = (this.mCamShakeFrames & 1) == 0 ? -n14 : n14;
                    n14 = n14 * ((GCanvas.getHeight() << 10) / 240);
                    graphics.translate(0, n14 >>= 10);
                    graphics.setColor(0);
                    if (n14 < 0) {
                        graphics.fillRect(0, graphics.getClipHeight(), graphics.getClipWidth(), -n14);
                    } else {
                        graphics.fillRect(0, 0, graphics.getClipWidth(), n14);
                    }
                }
                --this.mCamShakeFrames;
            } else {
                this.mDrawBlood = false;
                this.mDrawShake = false;
            }
            if (this.mWaitForPlayer && this.mDeathCheckNextFreeRide == -1) {
                this.drawTrackPreview$11c48828(graphics, this.mCurrentMission);
            } else {
                this.draw(graphics);
            }
            graphics.translate(0, -n14);
            if (n15 > 0 && this.mDrawBlood && n15 == 256) {
                MIDP20Proxy.drawImage(graphics, mBloodSplash, 0, 0, 0, 0, this.mBloodSplashWidth, this.mBloodSplashHeight, this.mBloodSplashWidth, true);
            }
            GCanvas.popClip(graphics);
            Graphics graphics2 = graphics;
            Object object = this;
            if (((ArenaGame)object).mDeathCheckDelayStart >= 0 && ((ArenaGame)object).mDeathCheckDelayStart + 50 > ((ArenaGame)object).mFrame) {
                int[] nArray = ((ArenaGame)object).mCalcVal;
                int n16 = ((ArenaGame)object).mDeathCheckLastLevelDamage;
                int n17 = ((ArenaGame)object).getActivePlayer().getLevelDamageInPercent();
                n17 = Math.min(n17, 100);
                n16 = Math.min(n16, 100);
                n13 = (((ArenaGame)object).mFrame - ((ArenaGame)object).mDeathCheckDelayStart << 10) / 15;
                n13 = Math.min(n13, 1024);
                n12 = n16 + ((n17 - n16) * n13 >> 10);
                n13 = (n12 << 10) / 100;
                n11 = ArenaGame.getRenderRegionHeight();
                n10 = GCanvas.getWidth() >> 1;
                n9 = n11 - nArray[34] >> 5;
                n8 = GCanvas.getWidth() >> 1;
                n7 = n11 - nArray[34] >> 1;
                n6 = 0x202010;
                n5 = 0xC0C080;
                n4 = n8 - (n10 >> 1);
                n3 = n7 - (n9 >> 1);
                n2 = n10 * n13 >> 10;
                RM.prepareVarText(12, String.valueOf(n12));
                n = GCanvas.getFontHeight(7);
                GCanvas.drawString(graphics2, 7, RM.t(12), n8, n3 - n, 17);
                if (n17 < 100) {
                    if (((ArenaGame)object).mDeathCheckNextFreeRide == -1) {
                        super.drawIngameText(graphics2, 5, n8, n3 + n9 + (n >> 1), 17);
                    } else {
                        super.drawIngameText(graphics2, 63, n8, n3 + n9 + (n >> 1), 17);
                    }
                } else {
                    super.drawIngameText(graphics2, 64, n8, n3 + n9 + (n >> 1), 17);
                }
                if (((ArenaGame)object).mFrame < ((ArenaGame)object).mDeathCheckDelayStart + 15 || ((ArenaGame)object).mFrame % 10 > 5) {
                    graphics2.setColor(0);
                    graphics2.drawRect(n4 - 1, n3 - 1, n10 + 1, n9 + 1);
                    graphics2.setColor(n6);
                    graphics2.fillRect(n4 + n2, n3, n10 - n2, n9);
                    graphics2.setColor(n5);
                    graphics2.fillRect(n4, n3, n2, n9);
                }
            }
            graphics2 = graphics;
            object = this;
            n7 = ((ArenaGame)object).getActiveScreenMessageId();
            if (n7 >= 0 && ((((ArenaGame)object).mScreenMessages[n7][2] & 1) == 0 || (((ArenaGame)object).mFrame & 0xF) > 7)) {
                ((ArenaGame)object).drawIngameText(graphics2, ((ArenaGame)object).mScreenMessages[n7][0], GCanvas.getWidth() >> 1, ArenaGame.getRenderRegionHeight() >> 1, 65);
            }
            graphics2 = graphics;
            object = this;
            Graphics graphics3 = graphics2;
            ArenaGame arenaGame = object;
            if (!((ArenaGame)object).getActivePlayer().isFinished()) {
                ArenaGame arenaGame2 = arenaGame;
                n8 = -1;
                int[] nArray = arenaGame2.getActivePlayer().getStateInfo();
                if (arenaGame2.getActivePlayer().getRideId() == 2) {
                    if (nArray[27] == 0) {
                        n8 = 2;
                    }
                } else if (arenaGame2.getActivePlayer().getRideId() == 5) {
                    if (nArray[14] == 1) {
                        n8 = 6;
                    }
                } else if (arenaGame2.getActivePlayer().getRideId() == 0) {
                    Point2D point2D = Point2D.getLocal();
                    arenaGame2.getRideVelocity(point2D);
                    if (point2D.x < 0) {
                        n8 = 1;
                    }
                    Point2D.freeLocal(point2D);
                }
                if (-1 == n8) {
                    n8 = RM.getValue(583, arenaGame2.getActivePlayer().getRideId(), 6);
                }
                if ((n13 = n8) >= 0) {
                    int[] nArray2 = arenaGame.mCalcVal;
                    n11 = RM.getHeight(581);
                    for (n10 = 0; n10 < n11; ++n10) {
                        n4 = nArray2[RM.getValue(581, n10, 4)];
                        n5 = nArray2[RM.getValue(581, n10, 3)];
                        n6 = RM.getValue(580, n13, RM.getValue(581, n10, 2));
                        int n18 = RM.getValue(580, n13, RM.getValue(581, n10, 1));
                        int n19 = RM.getValue(581, n10, 0);
                        Graphics graphics4 = graphics3;
                        arenaGame2 = arenaGame;
                        int[] nArray3 = arenaGame2.getActivePlayer().getStateInfo();
                        n2 = nArray3[0];
                        n = nArray3[1];
                        n3 = GCanvas.log2(n19);
                        if (n6 < 0 || n18 < 0) continue;
                        int n20 = 0;
                        if ((n2 & n19) > 0) {
                            ++n18;
                            int n21 = n3;
                            ArenaGame arenaGame3 = arenaGame2;
                            if (n21 < 0) {
                                for (n21 = 0; n21 < arenaGame3.mKeyshakeFrames.length; ++n21) {
                                    arenaGame3.mKeyshakeFrames[n21] = -1;
                                }
                            } else {
                                arenaGame3.mKeyshakeFrames[n21] = -1;
                            }
                        } else if ((arenaGame2.getActivePlayer().getCachedInputState() & n19) != 0) {
                            ++n20;
                        }
                        if ((n2 & n19) == 0 && (n & n19) > 0) {
                            arenaGame2.doKeyDescShake(n3);
                        }
                        GCanvas.drawSprite(graphics4, 9, n5, n4, n20);
                        if (arenaGame2.mKeyshakeFrames[n3] > 0) {
                            int n22 = n3;
                            arenaGame2.mKeyshakeFrames[n22] = arenaGame2.mKeyshakeFrames[n22] - 1;
                            n5 += GCanvas.getRandom(-2, 2);
                            n4 += GCanvas.getRandom(-2, 2);
                        }
                        GCanvas.drawSprite(graphics4, n6, n5, n4, n18);
                    }
                }
            }
            int n23 = (RM.getValue(771, ((ArenaGame)object).mCurrentMission, 25) & 1) != 0 ? 1 : 0;
            graphics3 = graphics2;
            arenaGame = object;
            n13 = GCanvas.getWidth();
            n12 = GCanvas.getHeight();
            int[] nArray = arenaGame.mCalcVal;
            if (GCanvas.getSpriteWidth(0) < n13) {
                graphics3.setColor(-11579569);
                graphics3.fillRect(0, n12 - nArray[34], n13, nArray[34]);
            }
            GCanvas.drawSprite(graphics3, 0, nArray[31], nArray[32], 0);
            if (n23 == 0) {
                graphics3 = graphics2;
                arenaGame = object;
                Object object2 = arenaGame.getActivePlayer();
                n9 = n13 = ((Player)object2).mScoreComboTimeoutBarPercentage;
                object2 = arenaGame;
                if (n9 > 0 && (n9 > 409 || (((ArenaGame)object2).mKeyFrame & 1) != 0)) {
                    n12 = GCanvas.getSpriteWidth(1);
                    GCanvas.pushClip(graphics3);
                    int n24 = n12 * (1024 - n13) >> 10;
                    if (GCanvas.clipRect(graphics3, n24 / 2 + (GCanvas.getWidth() - n12 >> 1), 0, n12 - n24, GCanvas.getHeight())) {
                        GCanvas.drawSprite(graphics3, 1, GCanvas.getWidth() >> 1, GCanvas.getHeight() - 39, arenaGame.mKeyFrame % (GCanvas.getSpriteFrames(1) << 1) / 2);
                    }
                    GCanvas.popClip(graphics3);
                }
            }
            if (n23 == 0) {
                ((ArenaGame)object).drawScore(graphics2);
                graphics3 = graphics2;
                arenaGame = object;
                int[] nArray4 = arenaGame.mCalcVal;
                n12 = arenaGame.getFoundRides();
                if (arenaGame.mWaitForPlayer && arenaGame.mDeathCheckNextFreeRide == -1) {
                    n12 = 0;
                }
                int n25 = arenaGame.getAvailableRides();
                if (n12 != arenaGame.mLastNumRidesValue && n12 > 1) {
                    arenaGame.mNewRideDisplayFramesLeft = 20;
                }
                if (arenaGame.mNewRideDisplayFramesLeft >= 0) {
                    --arenaGame.mNewRideDisplayFramesLeft;
                    arenaGame.getRideGlowPosition(arenaGame.getActiveRideHandle(), arenaGame.mRideDisplayGlowPos);
                }
                arenaGame.mLastNumRidesValue = n12;
                int n26 = n12 - (arenaGame.mNewRideDisplayFramesLeft >= 0 ? 1 : 0);
                RM.prepareVarText(4, String.valueOf(n26), String.valueOf(n25));
                n8 = GCanvas.getSpriteWidth(10);
                n23 = GCanvas.getSpriteFrames(10);
                int n27 = GCanvas.getGlobalFrameCount() % (n23 * 3) / 3;
                GCanvas.drawSprite(graphics3, 10, nArray4[14], nArray4[15], n27);
                n6 = nArray4[14];
                n5 = nArray4[15] + (n8 >> 1);
                if (arenaGame.mNewRideDisplayFramesLeft >= 0) {
                    GCanvas.drawString(graphics3, 7, RM.t(4), n6 + GCanvas.getRandom(-2, 2), n5 + GCanvas.getRandom(-2, 2), 17);
                    n4 = (20 - arenaGame.mNewRideDisplayFramesLeft << 10) / 20;
                    n4 = GCanvas.ipGetLambda(n4, 1);
                    Point2D point2D = Point2D.getLocal(nArray4[14], nArray4[15]);
                    point2D.setBlend(arenaGame.mRideDisplayGlowPos, point2D, n4);
                    GCanvas.drawSprite(graphics3, 10, point2D.x, point2D.y, n27);
                    Point2D.freeLocal(point2D);
                } else {
                    GCanvas.drawString(graphics3, 7, RM.t(4), n6, n5, 17);
                }
                super.drawTimeLeft(graphics2);
            }
            this.updateWarnings$272d79b7();
            if (GCanvas.cheatEnabled(-1)) {
                object = String.valueOf((this.mBulletTimeFraction << 10) / 1400);
                graphics.setColor(-16777216);
                graphics.fillRect(0, 18, GCanvas.getStringWidth((String)object, 0) + 4, GCanvas.getFontHeight(0) + 6);
                GCanvas.drawString(graphics, 0, (String)object, 2, 20, 6);
                GCanvas.drawString(graphics, 0, String.valueOf(this.mBulletTimePriority), 2, 20 + GCanvas.getFontHeight(0) + 2, 6);
            }
            if (GCanvas.cheatEnabled(2)) {
                GCanvas.drawString(graphics, 0, String.valueOf(GCanvas.getWidth()), 2, 20, 6);
                GCanvas.drawString(graphics, 0, String.valueOf(GCanvas.getHeight()), 2, 20 + GCanvas.getFontHeight(0) + 2, 6);
            }
            if (this.mPopupTutorialText >= 0) {
                this.drawShutterTop(graphics, 0, this.mMenuBorderTop);
                this.drawShutterBottom(graphics, 0, this.mMenuBorderBottom);
            }
            ArenaGame.drawDebugType(graphics);
            this.mFirstFrameDrawn = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void updateWarnings$272d79b7() {
        block7: {
            int[] nArray;
            block6: {
                Object object = this;
                object = ((ArenaGame)object).mActivePlayer;
                nArray = ((Player)object).mStateInfo;
                object = this;
                object = ((ArenaGame)object).mActivePlayer;
                if (((Player)object).mRideId == 1) break block6;
                object = this;
                object = ((ArenaGame)object).mActivePlayer;
                if (((Player)object).mRideId != 2) break block7;
            }
            if (nArray[21] >= 0 && this.mKeyFrame - nArray[21] < 100) {
                if (this.mKeyFrame - nArray[21] >= 50 && this.findScreenMessage(179) < 0) {
                    this.addScreenMessage(179, 100, 3);
                    return;
                }
            } else {
                this.removeScreenMessage(179);
            }
        }
    }

    private void addScreenMessage(int n, int n2, int n3) {
        this.removeScreenMessage(n);
        int[][] nArray = this.mScreenMessages;
        int n4 = -1;
        for (int i = 0; i < 5; ++i) {
            int[] nArray2 = nArray[i];
            if (nArray2[0] >= 0) continue;
            n4 = i;
        }
        if (n4 != -1) {
            int[] nArray3 = nArray[n4];
            int[] nArray4 = nArray3;
            nArray3[0] = n;
            nArray4[1] = n2;
            nArray4[2] = n3;
            nArray4[3] = this.mFrame;
            if ((n3 & 2) > 0) {
                nArray4[3] = nArray4[3] - 0x3FFFFFFF;
                for (int i = 0; i < 5; ++i) {
                    nArray4 = nArray[i];
                    if (nArray4[3] <= 0) continue;
                    nArray4[0] = -1;
                }
            }
        }
    }

    private void removeScreenMessage(int n) {
        if ((n = this.findScreenMessage(n)) >= 0) {
            this.mScreenMessages[n][0] = -1;
        }
    }

    private int findScreenMessage(int n) {
        int[][] nArray = this.mScreenMessages;
        for (int i = 0; i < 5; ++i) {
            int[] nArray2 = nArray[i];
            if (nArray2[0] != n) continue;
            return i;
        }
        return -1;
    }

    private static int getRenderRegionHeight() {
        int n = GCanvas.getHeight();
        return n;
    }

    private int getActiveScreenMessageId() {
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int[][] nArray = this.mScreenMessages;
        for (int i = 4; i >= 0; --i) {
            int[] nArray2 = nArray[i];
            if (nArray2[0] <= 0 || nArray2[3] >= n) continue;
            n = nArray2[3];
            n2 = i;
        }
        return n2;
    }

    public static int getRank(int n) {
        switch (n) {
            case 2: {
                return 311;
            }
            case 3: {
                return 312;
            }
            case 4: {
                return 313;
            }
            case 5: {
                return 314;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void drawScore(Graphics var1_1) {
        block16: {
            block19: {
                block17: {
                    var2_2 = this.mCalcVal;
                    var8_3 = this;
                    var3_6 = var8_3.mActivePlayer;
                    var8_3 = this;
                    var8_3 = var8_3.mActivePlayer;
                    var4_7 = RM.getValue(583, var8_3.mRideId, 8);
                    var8_3 = var3_6;
                    if (var8_3.mScoreComboLastUpdateKeyFrame <= -2147483648) break block16;
                    var8_3 = var3_6;
                    if (this.mKeyFrame > var8_3.mScoreComboLastUpdateKeyFrame + var4_7) break block17;
                    var8_3 = var3_6;
                    if (var8_3.mScoreDisplayCombo <= 0) break block17;
                    var8_3 = var3_6;
                    if (var8_3.mScoreDisplayCombo > 1) {
                        var8_3 = var3_6;
                        GCanvas.drawString(var1_1, 7, String.valueOf(String.valueOf(var8_3.mScoreDisplayCombo)), var2_2[21], var2_2[22], 10);
                    }
                    var6_12 /* !! */  = 0;
                    var7_13 /* !! */  = 0;
                    var5_14 = 8;
                    var8_3 = var3_6;
                    if (this.mKeyFrame < var8_3.mScoreComboLastUpdateKeyFrame + 5) {
                        var5_14 = 7;
                        var6_12 /* !! */  = GCanvas.getRandom(-2, 2);
                        var7_13 /* !! */  = GCanvas.getRandom(-2, 2);
                    }
                    var8_4 = GCanvas.getFontHeight(8);
                    var9_17 = var3_6.mLastMoves;
                    var10_20 = var3_6.mLastMovesPrefix;
                    var11_21 = 0;
                    var12_22 = var3_6.mLastMoveIndex;
                    var13_23 = 0;
                    while (var11_21 < 3) {
                        block18: {
                            if (var9_17[var12_22] < 0) break block18;
                            var15_25 = null;
                            var16_26 = RM.getValue(582, var9_17[var12_22], 0);
                            var14_24 = RM.t(var16_26);
                            if (var10_20[var12_22] < 0) ** GOTO lbl46
                            var15_25 = RM.t(var10_20[var12_22]);
                            if (GCanvas.getStringWidth(var14_24, var5_14) + GCanvas.getStringWidth(var15_25, var5_14) > Menu.getTextWidth()) {
                                GCanvas.drawString(var1_1, var5_14, var15_25, var2_2[23] + var6_12 /* !! */ , var2_2[24] - var8_4 * (var13_23 + 1) + var7_13 /* !! */ , 10);
                                GCanvas.drawString(var1_1, var5_14, var14_24, var2_2[23] + var6_12 /* !! */ , var2_2[24] - var8_4 * var13_23 + var7_13 /* !! */ , 10);
                                ++var13_23;
                                ++var13_23;
                            } else {
                                RM.prepareVarText(20, RM.t(var10_20[var12_22]), RM.t(var16_26));
                                var14_24 = RM.t(20);
lbl46:
                                // 2 sources

                                GCanvas.drawString(var1_1, var5_14, var14_24, var2_2[23] + var6_12 /* !! */ , var2_2[24] - var8_4 * var13_23 + var7_13 /* !! */ , 10);
                                ++var13_23;
                            }
                        }
                        ++var11_21;
                        var7_13 /* !! */  = 0;
                        var6_12 /* !! */  = 0;
                        var5_14 = 8;
                        --var12_22;
                        var12_22 = GCanvas.mathWrap(var12_22, 0, 2);
                    }
                }
                var8_5 = var3_6;
                if (this.mKeyFrame == var8_5.mScoreComboLastUpdateKeyFrame + var4_7) {
                    var8_5 = var3_6;
                    if (var8_5.mFinished == -1 && (this.mFrame < this.mFrameCountComboScoreStartMoving || this.mFrameCountComboScoreStartMoving == -1)) {
                        this.scoreComboScoreFloatStart();
                    }
                }
                if (this.mFrame >= this.mFrameCountComboScoreStartMoving && this.mLastScore > 0) {
                    var5_15 = var1_1;
                    var4_8 = this;
                    var8_5 = var4_8.mCalcVal;
                    var6_12 /* !! */  = var4_8.mCalcVal[29] - var8_5[21] + (GCanvas.getStringWidth(String.valueOf(var4_8.mLastScore), 7) >> 1);
                    var7_13 /* !! */  = (int)(var8_5[30] - var8_5[22] + (GCanvas.getFontHeight(7) >> 1));
                    var9_18 = (var4_8.mFrame - var4_8.mFrameCountComboScoreStartMoving << 10) / 8;
                    var9_18 = GCanvas.ipGetLambda(var9_18, 1);
                    GCanvas.drawString(var5_15, 7, String.valueOf(var4_8.mLastScore), (int)(var8_5[21] + (var6_12 /* !! */  * var9_18 >> 10)), (int)(var8_5[22] + (var7_13 /* !! */  * var9_18 >> 10)), 40);
                    if (var9_18 >= 1024) {
                        var4_8.mLastScore = -1;
                    }
                }
                if (this.mFrame >= this.mFrameCountComboScoreStartMoving + 8) {
                    this.mFrameCountComboScoreStartMoving = -1;
                }
                var8_5 = var3_6;
                if (this.mKeyFrame == var8_5.mScoreComboLastUpdateKeyFrame) {
                    var8_5 = this;
                    this.mLastMultiplier = var8_5.mActivePlayer.getMultiplier();
                    var4_9 = var3_6;
                    if (var4_9.mScoreMultiplierUpdateFrame >= this.mFrame && this.mLastMultiplier > 0) {
                        this.mFrameCountMultiplierStartMoving = this.mFrame;
                    }
                }
                if (this.mFrame < this.mFrameCountMultiplierStartMoving || this.mFrameCountMultiplierStartMoving <= 0) break block16;
                if (this.mLastScore > 0) break block19;
                var8_5 = var3_6;
                if (var8_5.mScoreCombo <= 0) break block16;
            }
            var5_16 = var1_1;
            var4_10 = this;
            var8_5 = var4_10.mCalcVal;
            RM.prepareVarText(21, String.valueOf(var4_10.mLastMultiplier));
            var9_19 = (var4_10.mFrame - var4_10.mFrameCountMultiplierStartMoving << 10) / 16;
            var9_19 = GCanvas.ipGetLambda(var9_19, 3);
            if (var4_10.mFrame >= var4_10.mFrameCountMultiplierStartMoving + 16) {
                var9_19 = 1024;
            }
            var6_12 /* !! */  = (int)(var8_5[25] - var8_5[27]);
            var7_13 /* !! */  = (int)(var8_5[26] - var8_5[28]);
            GCanvas.drawString(var5_16, 7, RM.t(21), (int)(var8_5[25] + (var6_12 /* !! */  * var9_19 >> 10)), GCanvas.getHeight() - (var8_5[26] + (var7_13 /* !! */  * var9_19 >> 10)), 17);
        }
        var4_11 = var3_6;
        GCanvas.drawString(var1_1, 7, String.valueOf(var4_11.mScoreDisplay), var2_2[29], var2_2[30], 3);
    }

    private int getFoundRides() {
        return this.mTouchedRides;
    }

    private int getAvailableRides() {
        return this.getNumRides() - 1;
    }

    private static String timeToString(int n) {
        int n2 = GCanvas.getMinute(n);
        int n3 = GCanvas.getSecond(n);
        n = GCanvas.getHundrets(n) / 10;
        String[] stringArray = timeValues;
        timeValues[0] = String.valueOf(n2);
        stringArray[1] = n3 < 10 ? '0' + String.valueOf(n3) : String.valueOf(n3);
        stringArray[2] = String.valueOf(n);
        RM.prepareVarText(17, stringArray);
        return RM.t(17);
    }

    private final void drawTimeLeft(Graphics graphics) {
        if (this.mTimedMission && !GCanvas.cheatEnabled(-1) && !this.mIsTraining) {
            int[] nArray = this.mCalcVal;
            GCanvas.drawString(graphics, 7, ArenaGame.timeToString(this.mTimeLeft), nArray[16], nArray[17], nArray[18]);
        }
    }

    public final void scoreComboScoreFloatStart() {
        Object object = this;
        Player player = ((ArenaGame)object).mActivePlayer;
        object = player;
        object = this;
        this.mLastScore = player.mScoreDisplayCombo * ((ArenaGame)object).mActivePlayer.getMultiplier();
        this.mFrameCountComboScoreStartMoving = this.mFrame;
        object = this;
        ((ArenaGame)object).mActivePlayer.scoreComboAddToTotalScore();
    }

    /*
     * Unable to fully structure code
     */
    public final void doSteer(Player var1_1, int var2_2) {
        switch (var1_1.getRideId()) {
            case 0: {
                var4_7 = var2_2;
                var3_11 = var1_1;
                var2_3 = this;
                var5_15 = var3_11.getStateInfo();
                var6_19 = Point2D.getLocal();
                var2_3.getRideVelocity(var6_19);
                var7_26 = -1;
                if (var5_15[2] == 0) {
                    if (var2_3.mKeyFrame - var5_15[12] >= 10) {
                        if (ArenaGame.isSteerLeft(var4_7)) {
                            var2_3.tutorialConditionFulfilled(13);
                            var2_3.doSteerRagdollSpeed(var5_15, -800);
                            var7_26 = var6_19.x > 0 ? 575 : 574;
                            var5_15[14] = 0;
                        } else if (ArenaGame.isSteerRight(var4_7)) {
                            var2_3.tutorialConditionFulfilled(13);
                            var2_3.doSteerRagdollSpeed(var5_15, 800);
                            var7_26 = var6_19.x > 0 ? 574 : 575;
                            var5_15[14] = 0;
                        } else {
                            var5_15[13] = 0;
                        }
                    } else {
                        var5_15[13] = 0;
                    }
                    if (var5_15[13] > 0) {
                        var8_29 = Point2D.getLocal();
                        var9_34 = Point2D.getLocal();
                        var2_3.getRideVelocity(var8_29);
                        var2_3.getRideCenter(var9_34);
                        var8_29.x = Math.min(var5_15[8], 10240);
                        var8_29.add(var9_34);
                        if (var7_26 >= 0) {
                            var2_3.poseRide(var7_26, 512);
                        }
                        var2_3.setRideKinematics(var8_29);
                        Point2D.freeLocal(var9_34);
                        Point2D.freeLocal(var8_29);
                    } else if (var5_15[13] < 0 && var2_3.mKeyFrame - var5_15[11] >= 50) {
                        var5_15[11] = var2_3.mKeyFrame;
                    }
                    var11_38 = var5_15;
                    var10_41 = var2_3;
                    if (!(var10_41.mKeyFrame - var11_38[12] < 20)) {
                        if (ArenaGame.isSteerCenter(var4_7)) {
                            var2_3.spawnEffect(0, 1);
                            var2_3.sfxPlayLogicSound(4);
                            var5_15[12] = var2_3.mKeyFrame;
                            var8_29 = Point2D.getLocal();
                            var9_34 = Point2D.getLocal();
                            var2_3.getRideCenter(var9_34);
                            var2_3.getRideVelocity(var8_29);
                            var8_29.set(var8_29.x < 0 ? -7168 : 7168, 5120);
                            var8_29.capLength(10240);
                            var8_29.add(var9_34);
                            var2_3.setRideKinematics(var8_29);
                            var2_3.playAnim(var2_3.getActivePlayer(), 490);
                            var5_15[14] = var5_15[14] + 1;
                            if (var5_15[14] == 3) {
                                var2_3.achievementsSet(9);
                            }
                            Point2D.freeLocal(var9_34);
                            Point2D.freeLocal(var8_29);
                            var2_3.tutorialConditionFulfilled(14);
                            var2_3.getActivePlayer().scoreAddMove(3, false);
                        }
                    } else {
                        var5_15[0] = var5_15[0] | 2;
                        if (var2_3.mKeyFrame - var5_15[12] < 10) {
                            var5_15[0] = var5_15[0] | 9;
                        }
                    }
                } else {
                    var5_15[0] = -1;
                }
                var5_15[2] = 0;
                Point2D.freeLocal(var6_19);
                break;
            }
            case 1: {
                var4_8 = var2_2;
                var3_12 = var1_1;
                var2_4 = this;
                var5_16 = var3_12.getStateInfo();
                var2_4.carApplySpecialConstraits();
                var2_4.carRoofDownDetection(var3_12, var5_16);
                var2_4.doSteerCarAcceleration(var4_8, var5_16, true);
                var2_4.doSteerCarCharge(var4_8, var5_16);
                if (var5_16[2] != 0) {
                    var5_16[17] = -1;
                    var3_12.overrideLastMove();
                }
                if (var5_16[2] == 0 && var5_16[17] == -1) {
                    var5_16[17] = var2_4.mKeyFrame;
                }
                if (var5_16[2] == 0 && var2_4.mKeyFrame >= var5_16[17] + 28 && var2_4.getRideSpeed() >= 2000 && var5_16[17] > -1) {
                    var2_4.getActivePlayer().scoreAddMove(1, true);
                }
                var2_4.setRideFXVisibility(0, true);
                var2_4.setRideFXVisibility(1, var5_16[9] <= 0);
                var2_4.doSteerCarEject(var3_12, var4_8, var5_16);
                var2_4.carDetectLooping$49667a20(var5_16);
                var5_16[2] = 0;
                break;
            }
            case 2: {
                var4_9 = var2_2;
                var3_13 = var1_1;
                var2_5 = this;
                var2_5.carApplySpecialConstraits();
                var5_17 = var3_13.getStateInfo();
                var2_5.getRideData()[6] = 0;
                var2_5.carRoofDownDetection(var3_13, var5_17);
                if (var5_17[27] >= 0) {
                    var2_5.doSteerCarAcceleration(var4_9, var5_17, var5_17[27] >= 0);
                }
                var2_5.doSteerCarCharge(var4_9, var5_17);
                if (var5_17[2] > 0) {
                    var5_17[17] = -1;
                    var3_13.overrideLastMove();
                }
                if (var5_17[2] == 0 && var5_17[17] == -1) {
                    var5_17[17] = var2_5.mKeyFrame;
                }
                var6_20 = 0;
                if (var5_17[27] == 0) ** GOTO lbl156
                var9_35 = var5_17;
                var8_30 = var4_9;
                var7_27 = var2_5;
                if (var9_35[3] == 0 && ArenaGame.isSteerCenter(var8_30)) {
                    if (var9_35[27] > 0) {
                        var9_35[27] = -var9_35[27];
                        Menu.performMenuAction(45, 4);
                        var4_9 = 4;
                        var8_30 = 1040;
                        var6_21 = var7_27;
                        var7_27.mBulletTimeFadeOutReleaseKey = 1040;
                        var6_21.mBulletTimeFadeOutId = 4;
                        var7_27.tutorialConditionFulfilled(5);
                    }
                } else if (!ArenaGame.isSteerCenter(var8_30)) {
                    var9_35[3] = 0;
                }
                if (var9_35[27] >= 0) ** GOTO lbl-1000
                var9_35[0];
                var9_35[0] = -1;
                var10_42 = Point2D.getLocal();
                var11_39 = Point2D.getLocal();
                var7_27.getRideCenter(var10_42);
                var7_27.getRideOrientation(var11_39);
                var10_42.addScaled(var11_39, 12500);
                var7_27.setRideKinematics(var10_42, var11_39);
                Point2D.freeLocal(var11_39);
                Point2D.freeLocal(var10_42);
                var6_20 = var9_35[27] < -6 ? 2 : 3;
                var7_27.spawnEffect(5, var6_20);
                var7_27.getRideData()[6] = 1;
                var9_35[27] = var9_35[27] + 1;
                if (var9_35[2] == 0 && var7_27.mKeyFrame >= var9_35[17] + 28) {
                    var7_27.getActivePlayer().scoreAddMove(2, true);
                    v0 = 1;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = 0;
                }
                var6_20 = v0;
                var3_13.clearSteer(4);
                ** GOTO lbl157
lbl156:
                // 1 sources

                var2_5.doSteerCarEject(var3_13, var4_9, var5_17);
lbl157:
                // 2 sources

                if (var5_17[27] < 0) {
                    var2_5.setRideFXVisibility(7, (var2_5.getEffectFrame() & 1) == 1);
                } else {
                    var2_5.setRideFXVisibility(7, false);
                }
                if (var6_20 == 0 && var5_17[2] == 0 && var2_5.mKeyFrame >= var5_17[17] + 28 && var5_17[17] >= 0) {
                    var2_5.getActivePlayer().scoreAddMove(1, true);
                }
                var2_5.carDetectLooping$49667a20(var5_17);
                var5_17[2] = 0;
                break;
            }
            case 4: {
                var4_10 = var2_2;
                var3_14 = var1_1;
                var2_6 = this;
                var5_18 = var3_14.getStateInfo();
                var6_22 = var2_6.mRideDatas[var2_6.getActiveRideHandle()][2] > 0 || var2_6.mRideDatas[var2_6.mRagdollHandle][2] > 0;
                if (var6_22 && var2_6.mKeyFrame % 10 == 0) {
                    var6_22 = false;
                }
                if (var6_22) break;
                var7_28 = Point2D.getLocal();
                var2_6.getRideCenter(var7_28);
                var5_18[22] = var7_28.y <= 500000 ? (ArenaGame.isSteerLeft(var4_10) && var5_18[4] == 0 ? 1 : (ArenaGame.isSteerRight(var4_10) && var5_18[5] == 0 ? -1 : 0)) : 0;
                if (var5_18[22] != 0) {
                    var5_18[0] = var5_18[0] | 2;
                    var2_6.tutorialConditionFulfilled(3);
                }
                var2_6.resetKeyLocking(var4_10, var5_18);
                if (!ArenaGame.isSteerCenterHold(var4_10) && var5_18[26] == 1 && var5_18[3] == 0) {
                    var8_31 = (var2_6.mKeyFrame - var5_18[17] << 10) / 60;
                    var5_18[18] = 20;
                    var5_18[17] = -1;
                    var5_18[26] = 0;
                    var2_6.getRideCenter(var7_28);
                    if (var7_28.y <= 500000) {
                        var9_36 = Point2D.getLocal();
                        var2_6.getRideVelocity(var9_36);
                        var7_28.addScaled(var9_36, 1000 + (var8_31 * 1000 >> 10));
                        var2_6.setRideKinematics(var7_28);
                        Point2D.freeLocal(var9_36);
                    }
                }
                if (var5_18[18] > 0) {
                    var5_18[18] = var5_18[18] - 1;
                }
                if (var5_18[25] == -1 && (var5_18[17] == -1 && var5_18[18] == 0 || var5_18[17] >= 0 && var5_18[17] + 60 > var2_6.mKeyFrame)) {
                    var2_6.getRideCenter(var7_28);
                    if (var7_28.y <= 500000) {
                        if (ArenaGame.isSteerCenterHold(var4_10) && var5_18[3] == 0 && var5_18[22] == 0) {
                            if (var5_18[17] == -1) {
                                var5_18[17] = var2_6.mKeyFrame;
                                var5_18[27] = -1;
                            }
                            if (var5_18[26] == 0) {
                                var6_22 = false;
                                var6_23 = var3_14;
                                var11_40 = var2_6;
                                v1 = var6_23.getStateInfo();
                                var8_32 = v1;
                                v1[14] = 40960;
                                var11_40.jetpackCalcRotationCenter(var6_23, 0);
                                var8_32[16] = 0;
                                var8_32[29] = 0;
                            }
                            var2_6.jetpackPerformCircularSteering(var3_14, 0);
                            var5_18[26] = 1;
                            var2_6.doSteerJetpackLoopingDetection(var5_18, var4_10, true);
                        } else {
                            var5_18[26] = 0;
                            if (!ArenaGame.isSteerCenterHold(var4_10)) {
                                var5_18[3] = 0;
                            }
                        }
                    } else {
                        var5_18[26] = 0;
                        var5_18[0] = var5_18[0] | 11;
                    }
                } else {
                    var5_18[0] = var5_18[0] | 2;
                    var5_18[3] = 1;
                    if (!ArenaGame.isSteerCenterHold(var4_10) && var5_18[18] == 0) {
                        var5_18[26] = 0;
                        var5_18[17] = -1;
                    }
                }
                var8_33 = var5_18[26] != 0;
                var9_37 = var5_18[18] > 0;
                var2_6.getRideData()[6] = (byte)((var8_33 &= var9_37 == false) != false);
                if (var8_33) {
                    var11_40 = var2_6;
                    var6_24 = Point2D.getLocal();
                    var11_40.getRideVelocity(var6_24);
                    if (var6_24.sqrLength() > 1024L) {
                        var6_24.unit();
                        var11_40.setRideOrientation(var6_24);
                    }
                    Point2D.freeLocal(var6_24);
                }
                var8_33 |= var5_18[22] != 0;
                if (var5_18[22] != 0) {
                    var2_6.jetpackHandleLeftRight(var5_18);
                }
                var2_6.setRideFXVisibility(2, var8_33 & ((var10_43 = var2_6.getEffectFrame()) & 1) == 0);
                var2_6.setRideFXVisibility(3, var9_37 & (var10_43 + 1 & 1) == 0);
                if (!var8_33) {
                    var2_6.setRideFXVisibility(2, false);
                    var2_6.getRideCenter(var7_28);
                    if (var7_28.y <= 500000) {
                        var6_25 = true;
                        var6_25 = false;
                        var11_40 = var2_6;
                        var11_40.jetpackHandleHovering(false, true, 0, 100);
                    }
                }
                Point2D.freeLocal(var7_28);
                break;
            }
            case 3: {
                this.doSteerGlider(var1_1, var2_2);
                break;
            }
            case 5: {
                this.doSteerSwingSingleButton(var1_1, var2_2);
            }
        }
        this.doRingDetection(var1_1);
    }

    public static final int projectP1ToDistFromP0(int n, int n2, Point2D point2D, int n3) {
        long l = point2D.x - n;
        long l2 = point2D.y - n2;
        long l3 = l * l + l2 * l2 >> 10;
        if (l3 < (long)(n = n3 * n3 >> 10)) {
            n = GCanvas.sqrt((int)l3);
            n = (n - n3 << 10) / n;
            n *= 1152;
            l *= (long)(n >>= 10);
            l2 *= (long)n;
            point2D.x = (int)((long)point2D.x - (l >>= 10));
            point2D.y = (int)((long)point2D.y - (l2 >>= 10));
            return n;
        }
        return 0;
    }

    private void carRoofDownDetection(Player player, int[] object) {
        if (this.isRideHeadDown() && object[2] > 0) {
            object[0] = object[0] | 0xB;
            if (object[21] == -1) {
                object[21] = this.mKeyFrame;
            }
            if (this.mKeyFrame - object[21] > 100) {
                object = Point2D.getLocal();
                this.getRideOrientation((Point2D)object);
                ((Point2D)object).perpCCW();
                ((Point2D)object).negate();
                Point2D.freeLocal((Point2D)object);
                this.spawnRagdoll(player, ((Point2D)object).x, -((Point2D)object).y);
                return;
            }
        } else {
            object[21] = -1;
        }
    }

    private void doSteerCarAcceleration(int n, int[] object, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.isRideHeadDown();
        if (ArenaGame.isSteerLeft(n) && object[4] == false) {
            object[9] = -1;
        } else if (ArenaGame.isSteerRight(n) && object[5] == false) {
            if (n4 == 0 && object[2] > 0 && bl && object[9] == false && this.mKeyFrame > 10 && object[18] + 5 > this.mKeyFrame) {
                object[19] = true;
                object[20] = this.mKeyFrame;
                this.spawnEffect(2, 2);
                this.spawnEffect(1, 1);
                this.tutorialConditionFulfilled(0);
            }
            object[9] = true;
        } else {
            this.resetKeyLocking(n, (int[])object);
            if (object[9] == true) {
                object[18] = this.mKeyFrame;
            }
            object[9] = false;
        }
        if (n4 != 0) {
            object[9] = false;
        }
        if (object[19] > 0) {
            n = this.getRideSpeed();
            if (n > 12000) {
                int point2D = this.getEffectFrame();
                this.setRideFXVisibility(4, (point2D & 3) == 1);
                this.setRideFXVisibility(5, (point2D & 3) == 2);
                this.setRideFXVisibility(6, (point2D & 3) == 3);
            } else {
                this.setRideFXVisibility(4, false);
                this.setRideFXVisibility(5, false);
                this.setRideFXVisibility(6, false);
            }
            if (object[20] + 20 <= this.mKeyFrame) {
                object[19] = false;
            } else {
                n2 = 2500;
                n3 = 2500;
            }
        } else {
            this.setRideFXVisibility(4, false);
            this.setRideFXVisibility(5, false);
            this.setRideFXVisibility(6, false);
        }
        if (object[2] > 0 && object[9] != false) {
            Point2D point2D = Point2D.getLocal();
            this.getRideVelocity(point2D);
            if (object[9] > 0) {
                if (point2D.x < 0) {
                    point2D.x = 0;
                }
                n = ArenaGame.getThrottle(point2D, n2 + 28000, n3 + 1800);
            } else {
                if (point2D.x > 0) {
                    point2D.x = 0;
                }
                n = -ArenaGame.getThrottle(point2D, 14000, 900);
            }
            object = Point2D.getLocal();
            this.getRideOrientation((Point2D)object);
            n3 = 0;
            if (((Point2D)object).x > 0 && n > 0 && point2D.x > 0) {
                n3 = -512;
            } else if (((Point2D)object).x < 0 && n < 0 && point2D.x < 0) {
                n3 = 512;
            }
            n3 = -n3;
            n4 = ((Point2D)object).y;
            if (n3 > 0) {
                if (n4 > n3) {
                    n = 0;
                }
            } else if (n3 < 0 && n4 < n3) {
                n = 0;
            }
            Point2D.freeLocal((Point2D)object);
            Point2D.freeLocal(point2D);
            this.carApplyAcceleration(n, n2 + 28000);
        }
    }

    private void resetKeyLocking(int n, int[] nArray) {
        if (!ArenaGame.isSteerLeft(n)) {
            nArray[4] = 0;
        }
        if (!ArenaGame.isSteerRight(n)) {
            nArray[5] = 0;
        }
    }

    private void doSteerCarCharge(int n, int[] nArray) {
        int n2;
        boolean bl;
        int n3 = this.isRideHeadDown() ? 4096 : 2048;
        boolean bl2 = bl = nArray[2] > 0;
        if (ArenaGame.isSteerAltCenter(n) && !bl) {
            nArray[15] = 0;
            nArray[14] = 0;
        }
        if (ArenaGame.isSteerAltCenter(n) && bl) {
            this.tutorialConditionFulfilled(1);
        }
        if (((n2 = n) & 0x10) != 0 || ArenaGame.isSteerAltCenter(n) && bl) {
            nArray[15] = Math.min(n3, nArray[15] + 256);
        } else {
            n2 = nArray[15];
            if (n2 > 0) {
                this.carApplyCharge(n2, 0);
            }
            nArray[15] = 0;
        }
        n2 = n;
        if ((n2 & 0x40) != 0 || ArenaGame.isSteerAltCenter(n) && bl) {
            nArray[14] = Math.min(n3, nArray[14] + 256);
        } else {
            n2 = nArray[14];
            if (n2 > 0) {
                this.carApplyCharge(0, n2);
            }
            nArray[14] = 0;
        }
        if (!bl) {
            nArray[0] = nArray[0] | 0x29;
        }
    }

    private void doSteerCarEject(Player player, int n, int[] object) {
        int n2 = object[10];
        int n3 = object[16];
        if (this.isCarFastEnoughToEject() && !this.isRideHeadDown()) {
            if (object[3] == 0 && ArenaGame.isSteerCenterHold(n)) {
                if (n3 < 0 || this.hasCarAidTimedOut()) {
                    n = n2 & 0xFF;
                    if ((n2 / 256 & 1) != 0) {
                        n = 256 - n;
                    }
                    object[10] = object[10] + 24;
                    this.calculateAim((int[])object, n);
                    return;
                }
                Point2D point2D = Point2D.getLocal();
                object = Point2D.getLocal();
                this.getRideCenter((Point2D)object);
                point2D.set(this.mRideCenters[n3]);
                point2D.sub((Point2D)object);
                point2D.unit();
                this.spawnRagdoll(player, point2D.x, point2D.y);
                Point2D.freeLocal((Point2D)object);
                Point2D.freeLocal(point2D);
                return;
            }
            if (!ArenaGame.isSteerCenterHold(n)) {
                object[3] = 0;
            }
            if (n2 > 0) {
                object[10] = 0;
                this.spawnRagdoll(player, object[11], object[12]);
                return;
            }
        } else {
            object[0] = object[0] | 2;
            object[10] = 0;
            object[16] = -1;
        }
    }

    private boolean isCarFastEnoughToEject() {
        boolean bl = false;
        Point2D point2D = Point2D.getLocal();
        this.getRideVelocity(point2D);
        if (GCanvas.mathAbs(point2D.x) > 300) {
            bl = true;
        }
        Point2D.freeLocal(point2D);
        return bl;
    }

    private static int getAngleSector(int n, int n2) {
        if (n >= 0) {
            if (n2 >= 0) {
                if (n > n2) {
                    return 0;
                }
                return 1;
            }
            if (n > -n2) {
                return 7;
            }
            return 6;
        }
        if (n2 >= 0) {
            if (-n > n2) {
                return 3;
            }
            return 2;
        }
        if (-n > -n2) {
            return 4;
        }
        return 5;
    }

    private void carResetLoopingDetection(int[] nArray) {
        for (int i = 0; i < this.mSectorsTouched.length; ++i) {
            this.mSectorsTouched[i] = 0;
        }
        nArray[24] = -1;
        nArray[25] = 0;
    }

    private void carDetectLooping$49667a20(int[] nArray) {
        boolean bl;
        int n;
        Object object;
        block10: {
            object = Point2D.getLocal();
            this.getRideOrientation((Point2D)object);
            n = ArenaGame.getAngleSector(((Point2D)object).x, ((Point2D)object).y);
            Point2D.freeLocal((Point2D)object);
            if (nArray[2] > 0) {
                nArray[26] = 0;
            }
            if (!this.isLoopingAvailable()) {
                this.carResetLoopingDetection(nArray);
            } else {
                RM.setBit(this.mSectorsTouched, n, true);
            }
            object = this;
            if (((ArenaGame)object).mSectorsTouched.length == 1) {
                bl = ((ArenaGame)object).mSectorsTouched[0] == 255;
            } else {
                for (int i = 0; i < 8; ++i) {
                    if (RM.isBitSet(((ArenaGame)object).mSectorsTouched, i)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl) {
            if (nArray[25] == -1) {
                nArray[26] = nArray[26] + 1;
                if (nArray[26] >= 2) {
                    this.achievementsSet(6);
                }
            }
            object = this;
            ((ArenaGame)object).mActivePlayer.scoreAddMove(0, false);
            nArray[17] = this.mKeyFrame;
            this.carResetLoopingDetection(nArray);
        }
        if (n != nArray[24]) {
            int n2 = GCanvas.mathModWrap(n - nArray[24], 0, 8);
            nArray[25] = n2 == 7 ? 1 : -1;
        }
        nArray[24] = n;
    }

    private static int getThrottle(Point2D point2D, int n, int n2) {
        int n3 = Math.abs(point2D.x);
        n3 = GCanvas.clamp((n - n3 << 10) / n, 0, 1024);
        return n3 * n2 >> 10;
    }

    private boolean doSteerRagdollSpeed(int[] nArray, int n) {
        int n2;
        if (nArray[13] == 0) {
            Point2D point2D = Point2D.getLocal();
            this.getRideVelocity(point2D);
            n2 = point2D.x;
            Point2D.freeLocal(point2D);
            nArray[8] = n2;
            nArray[9] = n2 >> 2;
            nArray[10] = n2 << 2;
            nArray[13] = 1;
        }
        int n3 = nArray[8];
        n2 = nArray[10];
        n2 = Math.abs(n2);
        nArray[8] = GCanvas.clamp(n3 + n, -n2, n2);
        return true;
    }

    private void doSteerGlider(Player player, int n) {
        Player player2 = player;
        Object object = player2;
        object = player2.mStateInfo;
        int n2 = player2.mStateInfo[8];
        if (object[10] > 0) {
            n2 -= 32;
        } else {
            if (ArenaGame.isSteerLeft(n) && object[4] == false) {
                n2 += 32;
                this.tutorialConditionFulfilled(6);
            }
            if (ArenaGame.isSteerRight(n) && object[5] == false) {
                n2 -= 32;
                this.tutorialConditionFulfilled(6);
            }
        }
        this.resetKeyLocking(n, (int[])object);
        if (!ArenaGame.isSteerLeft(n) && !ArenaGame.isSteerRight(n)) {
            n2 -= 3;
        }
        n2 = GCanvas.clamp(n2, -192, 128);
        Point2D point2D = Point2D.getLocal();
        point2D.setRotation(n2);
        Point2D point2D2 = Point2D.getLocal();
        point2D2.set(3000, 0);
        point2D.transform(point2D2);
        Point2D point2D3 = Point2D.getLocal();
        this.getRideVelocity(point2D3);
        int n3 = point2D3.length();
        if (n3 < 3000) {
            object[10] = true;
        } else if (n3 > 14000) {
            object[10] = false;
        }
        point2D2.setLength(n3);
        point2D2.add(point2D3);
        Point2D.freeLocal(point2D3);
        int n4 = point2D2.y > 0 ? 1 : 0;
        int n5 = n3 = point2D2.y < 0 ? 1 : 0;
        if (n4 != 0) {
            n4 = 0;
            n4 = (n2 << 10) / 128;
            n4 = n4 * 40 >> 10;
            Object object2 = object;
            object2[9] = object2[9] * (1024 - n4);
            Object object3 = object;
            object3[9] = object3[9] >> 10;
        } else if (n3 != 0) {
            n4 = 0;
            n4 = (n2 << 10) / -192;
            n4 = n4 * 200 >> 10;
            Object object4 = object;
            object4[9] = object4[9] * (n4 + 1024);
            Object object5 = object;
            object5[9] = object5[9] >> 10;
        }
        Object object6 = object;
        object6[9] = object6[9] * 1015;
        Object object7 = object;
        object7[9] = object7[9] >> 10;
        object[9] = GCanvas.clamp((int)object[9], 0, 15000);
        point2D2.setLength(Math.min((int)object[9], point2D2.length()));
        Point2D point2D4 = Point2D.getLocal();
        this.getRideCenter(point2D4);
        point2D2.add(point2D4);
        Point2D.freeLocal(point2D4);
        this.setRideKinematics(point2D2, point2D);
        Point2D.freeLocal(point2D2);
        object[8] = n2 * 950 >> 10;
        Point2D.freeLocal(point2D);
        if (object[3] == false && ArenaGame.isSteerCenter(n)) {
            point2D4 = Point2D.getLocal();
            this.getRideVelocity(point2D4);
            this.spawnRagdoll(player, Math.min(point2D4.x, 1024), 1228);
            Point2D.freeLocal(point2D4);
            return;
        }
        if (!ArenaGame.isSteerCenter(n)) {
            object[3] = false;
        }
    }

    private void jetpackCalcRotationCenter(Player object, int n) {
        object = ((Player)object).mStateInfo;
        Point2D point2D = Point2D.getLocal();
        Point2D point2D2 = Point2D.getLocal();
        this.getRideOrientation(point2D);
        point2D.perpCCW();
        point2D.x = -point2D.x;
        point2D.y = -point2D.y;
        if (n == 1) {
            point2D.x = -point2D.x;
            point2D.y = -point2D.y;
        }
        point2D.setLength((int)object[14]);
        this.getRideCenter(point2D2);
        point2D.add(point2D2);
        object[12] = point2D.x;
        object[13] = point2D.y;
        object[19] = point2D2.x;
        object[20] = point2D2.y;
        Point2D.freeLocal(point2D2);
        Point2D.freeLocal(point2D);
    }

    private void jetpackPerformCircularSteering(Player object, int n) {
        Object object2 = object;
        int[] nArray = ((Player)object2).mStateInfo;
        Point2D point2D = Point2D.getLocal();
        nArray[14] = nArray[14] + 5;
        object2 = object;
        object = this;
        object2 = ((Player)object2).mStateInfo;
        Point2D point2D2 = Point2D.getLocal();
        ((ArenaGame)object).getRideVelocity(point2D2);
        if (point2D2.y > 0) {
            Object object3 = object2;
            object3[15] = object3[15] + -8;
        } else {
            Object object4 = object2;
            object4[15] = object4[15] - -8;
        }
        Point2D.freeLocal(point2D2);
        object2[15] = GCanvas.clamp((int)object2[15], 34, 51);
        Object object5 = object2;
        object5[16] = object5[16] + 512;
        int n2 = -(nArray[15] + (nArray[16] >> 10));
        n2 = -n2;
        object2 = Point2D.getLocal();
        ((Point2D)object2).set(nArray[19], nArray[20]);
        ((Point2D)object2).sub(nArray[12], nArray[13]);
        point2D2 = Point2D.getLocal();
        point2D2.setRotation(n2);
        point2D2.transform((Point2D)object2);
        Point2D.freeLocal(point2D2);
        ((Point2D)object2).x += nArray[12];
        ((Point2D)object2).y += nArray[13];
        nArray[19] = ((Point2D)object2).x;
        nArray[20] = ((Point2D)object2).y;
        Point2D point2D3 = Point2D.getLocal();
        this.getRideOrientation(point2D3);
        this.setRideKinematics((Point2D)object2, point2D3);
        Point2D.freeLocal(point2D3);
        int n3 = this.mKeyFrame;
        if (nArray[17] >= 0 && nArray[17] + 20 < n3 && nArray[17] + 60 > n3) {
            n3 = (n3 - (nArray[17] + 20) << 10) / 40;
            if (GCanvas.getRandom(0, 1024) <= n3) {
                this.spawnEffectSparse(5, 3, false);
            } else {
                this.spawnEffectSparse(5, 2, false);
            }
        }
        Point2D.freeLocal((Point2D)object2);
        Point2D.freeLocal(point2D);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doSteerJetpackLoopingDetection(int[] nArray, int n, boolean n2) {
        if (!ArenaGame.isSteerCenterHold(n)) {
            nArray[27] = -1;
            nArray[28] = 0;
            return;
        }
        Object object = Point2D.getLocal();
        this.getRideOrientation((Point2D)object);
        n2 = ArenaGame.getAngleSector(((Point2D)object).x, ((Point2D)object).y);
        Point2D.freeLocal((Point2D)object);
        if (nArray[27] == -1) {
            nArray[27] = n2;
            return;
        }
        if (n2 != nArray[27]) {
            nArray[28] = 1;
            return;
        }
        if (nArray[28] != 1) return;
        object = this;
        ((ArenaGame)object).mActivePlayer.scoreAddMove(7, false);
        nArray[28] = 0;
        this.tutorialConditionFulfilled(4);
        nArray[29] = nArray[29] + 1;
        if (nArray[29] != 3) return;
        this.achievementsSet(7);
    }

    private void jetpackHandleHovering(boolean bl, boolean bl2, int n, int n2) {
        Point2D point2D = Point2D.getLocal();
        Point2D point2D2 = Point2D.getLocal();
        Point2D point2D3 = Point2D.getLocal();
        this.getRideCenter(point2D);
        this.getRideVelocity(point2D3);
        this.getRideOrientation(point2D2);
        point2D2.x = point2D2.x;
        point2D2.y += 100;
        if (point2D2.x == 0 && point2D2.y == 0) {
            point2D2.x = 10;
        }
        point2D2.unit();
        point2D3.x *= 1000;
        point2D3.x >>= 10;
        if (point2D3.y < 0) {
            point2D3.y = point2D3.y * (bl ? 300 : 800);
            point2D3.y >>= 10;
        }
        point2D.add(point2D3);
        this.setRideKinematics(point2D);
        if (bl2) {
            this.setRideOrientation(point2D2);
        }
        this.setRideFXVisibility(2, (this.getEffectFrame() & 7) == 0);
        Point2D.freeLocal(point2D3);
        Point2D.freeLocal(point2D2);
        Point2D.freeLocal(point2D);
    }

    private void jetpackHandleLeftRight(int[] nArray) {
        int n = nArray[22] == -1 ? 300 : -300;
        Point2D point2D = Point2D.getLocal();
        Point2D point2D2 = Point2D.getLocal();
        Point2D point2D3 = Point2D.getLocal();
        this.getRideCenter(point2D);
        this.getRideVelocity(point2D3);
        this.getRideOrientation(point2D2);
        point2D2.x += n;
        point2D2.y += 12;
        if (point2D2.x == 0 && point2D2.y == 0) {
            point2D2.y = 10;
        }
        point2D2.unit();
        point2D3.x *= 1000;
        point2D3.x >>= 10;
        if (point2D3.y < 0) {
            point2D3.y *= 800;
            point2D3.y >>= 10;
        }
        point2D3.x = point2D3.x + (nArray[22] == -1 ? 2000 : -2000);
        point2D3.x = GCanvas.clamp(point2D3.x, -12000, 12000);
        point2D.add(point2D3);
        this.setRideKinematics(point2D);
        this.setRideOrientation(point2D2);
        this.setRideFXVisibility(2, (this.getEffectFrame() & 7) == 0);
        Point2D.freeLocal(point2D3);
        Point2D.freeLocal(point2D2);
        Point2D.freeLocal(point2D);
    }

    private static void swingSetPose(int[] nArray, int n) {
        if (nArray[10] == n) {
            return;
        }
        if (nArray[10] >= 0) {
            nArray[9] = nArray[10];
        }
        nArray[10] = n;
        nArray[11] = 0;
    }

    private void doSteerSwingSingleButton(Player player, int n) {
        Point2D point2D = Point2D.getLocal();
        Point2D point2D2 = Point2D.getLocal();
        Point2D point2D3 = Point2D.getLocal();
        Point2D point2D4 = Point2D.getLocal();
        Point2D point2D5 = Point2D.getLocal();
        Point2D point2D6 = Point2D.getLocal();
        Object object = player;
        object = ((Player)object).mStateInfo;
        this.getRidePosition(0, point2D);
        this.getRidePosition(4, point2D2);
        int n2 = point2D.x - point2D2.x;
        point2D3.setDiff(point2D2, point2D);
        point2D4.set(point2D3.y, -point2D3.x);
        this.getRidePrevPosition(4, point2D5);
        point2D5.sub(point2D2);
        point2D5.negate();
        point2D6.set(point2D5);
        if (point2D6.sqrLength() > 10L) {
            point2D6.unit();
        }
        if (ArenaGame.isSteerCenterHold(n)) {
            if (object[14] == false) {
                object[16] = point2D4.dot(point2D5) < 0 ? (Object)true : (Object)-1;
            }
            object[14] = true;
            if (object[15] == true) {
                if (object[16] == true) {
                    point2D4.setLength(-800);
                    this.applyForce(4, point2D4);
                    ArenaGame.swingSetPose((int[])object, 577);
                    if (n2 < -50000) {
                        object[15] = false;
                        object[16] = -1;
                    }
                } else {
                    point2D4.setLength(800);
                    this.applyForce(4, point2D4);
                    ArenaGame.swingSetPose((int[])object, 576);
                    if (n2 > 50000) {
                        object[15] = false;
                        object[16] = true;
                    }
                }
            } else {
                ArenaGame.swingSetPose((int[])object, 578);
                if (object[16] == -1) {
                    if (n2 > -50000) {
                        object[15] = true;
                    }
                } else if (n2 < 50000) {
                    object[15] = true;
                }
            }
            this.swingApplyPose((int[])object);
        } else {
            ArenaGame.swingSetPose((int[])object, 578);
            this.swingApplyPose((int[])object);
            if (object[17] == false && this.mKeyFrame - object[18] > 10) {
                object[17] = true;
            }
            if (object[17] == true && object[14] == true) {
                point2D3.set(point2D4);
                point2D3.unit();
                if (point2D3.dot(point2D5) < 0) {
                    point2D3.negate();
                    point2D3.x = Math.max(point2D3.x, 800);
                } else {
                    point2D3.x = Math.min(point2D3.x, -800);
                }
                point2D3.scale(RM.getValue(583, 5, 2));
                this.spawnRagdoll(player, point2D3.x, point2D3.y);
            }
            object[14] = false;
            object[17] = true;
        }
        this.getRideVelocity(4, point2D3);
        if (point2D3.sqrLength() < 2000L && object[12] == false) {
            object[12] = true;
            object[13] = this.mKeyFrame;
        }
        Point2D.freeLocal(point2D6);
        Point2D.freeLocal(point2D5);
        Point2D.freeLocal(point2D4);
        Point2D.freeLocal(point2D3);
        Point2D.freeLocal(point2D2);
        Point2D.freeLocal(point2D);
    }

    private void swingApplyPose(int[] nArray) {
        int n = nArray[9];
        int n2 = nArray[10];
        if (n2 < 0 || n2 == n) {
            if (n >= 0) {
                this.poseRide(this.mRagdollHandle, n, 900);
                return;
            }
        } else if (n >= 0 && n2 >= 0) {
            this.poseRide(this.mRagdollHandle, n, n2, nArray[11], 900);
            nArray[11] = Math.min(nArray[11] + 128, 1024);
        }
    }

    private final void drawIngameText(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n != this.mLastIngameText) {
            this.mLastIngameText = n;
            this.mTextlines.removeAllElements();
            Menu.breakLine(this.mTextlines, 7, RM.t(n), GCanvas.getWidth() - 8);
        }
        Menu.drawText(graphics, this.mTextlines, n2, n3, n4, 7, 8);
    }

    public final boolean onItemCollected$65dcdce(Player player, int n) {
        switch (n) {
            case 1: {
                this.playerFinished(player, 1, false);
                break;
            }
            case 2: {
                this.playerFinished(player, 2, false);
                break;
            }
            case 7: {
                ++player.mCollectedItems;
                break;
            }
            case 0: {
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public final boolean tutorialWasSeen(int n) {
        return RM.isBitSet(this.mSeenTutorials, n);
    }

    public final void initializeTutorial(int n, int n2, int n3, boolean bl) {
        if (!(this.mIsReplay || GCanvas.cheatEnabled(-1) || Menu.isOptionBitSet(50, n2) && !bl)) {
            if (this.tutorialWasSeen(n2)) {
                return;
            }
            if (this.mSeenTutorialLast != -1) {
                RM.setBit(this.mSeenTutorials, this.mSeenTutorialLast, true);
            }
            this.mSeenTutorialLast = n2;
            this.mPopupTutorialText = RM.getValue(588, n2, 0);
            this.mPopupTutorialDelay = 15;
            if (n3 >= 0) {
                mTutorialCondition = n3;
                mTutorialConditionLastTutorialIdx = n;
            }
            n3 = RM.getWidth(33);
            ArenaGame arenaGame = this;
            this.mMenuBorderTop = -n3;
            arenaGame.mMenuBorderTargetTop = n3;
            arenaGame.mMenuBorderBottom = GCanvas.getHeight() + n3;
            arenaGame.mMenuBorderTargetBottom = GCanvas.getHeight() - n3;
            this.performMenuAction(45, 0);
            Menu.setOptionBit(50, n2, true);
            this.sfxPlayLogicSound(7);
        }
    }

    public final void onInput() {
        int n;
        block75: {
            block73: {
                Player player;
                ArenaGame arenaGame;
                Object object;
                Object object2;
                block74: {
                    Player player2;
                    block65: {
                        block70: {
                            Object object3;
                            block69: {
                                block66: {
                                    Object object4;
                                    block68: {
                                        block67: {
                                            if (this.mGameFinishedCountdown >= 0) {
                                                if (this.mGameFinishedCountdown == 0) {
                                                    this.onGameFinish();
                                                }
                                                --this.mGameFinishedCountdown;
                                                this.autoCameraPlay();
                                            }
                                            if (this.mWaitForPlayer) {
                                                if (GCanvas.consumeKey(1040)) {
                                                    ArenaGame arenaGame2 = this;
                                                    this.mWaitForPlayer = false;
                                                    arenaGame2.removeScreenMessage(261);
                                                    arenaGame2.forceGameCameraReset();
                                                    if (GCanvas.cheatEnabled(6)) {
                                                        ArenaGame arenaGame3 = arenaGame2;
                                                        arenaGame2.playerFinished(arenaGame3.mActivePlayer, 2, false);
                                                        return;
                                                    }
                                                    if (GCanvas.cheatEnabled(5)) {
                                                        ArenaGame arenaGame4 = arenaGame2;
                                                        arenaGame2.playerFinished(arenaGame4.mActivePlayer, 1, false);
                                                    }
                                                }
                                                return;
                                            }
                                            ++this.mFrame;
                                            if (this.mDeathCheckDelayStart == -1) break block65;
                                            if (this.mDeathCheckDelayStart + 50 >= this.mFrame) break block66;
                                            this.mDeathCheckDelayStart = -1;
                                            if (this.mDeathCheckNextFreeRide == -1) break block67;
                                            object4 = this;
                                            object4 = ((ArenaGame)object4).mActivePlayer;
                                            if (((Player)object4).mDamageDuringLevel < 500) break block68;
                                        }
                                        object4 = this;
                                        this.playerFinished(((ArenaGame)object4).mActivePlayer, 0, true);
                                        return;
                                    }
                                    Point2D point2D = Point2D.getLocal();
                                    point2D.set(this.mRideCenters[this.mDeathCheckNextFreeRide]);
                                    object4 = this;
                                    Player player3 = ((ArenaGame)object4).mActivePlayer;
                                    this.moveSystemTo(player3.mRideHandle, point2D);
                                    Point2D.freeLocal(point2D);
                                    object4 = this;
                                    player3 = ((ArenaGame)object4).mActivePlayer;
                                    RM.fill(this.mHeightmapInfo[player3.mRideHandle], 0);
                                    object4 = this;
                                    player3 = ((ArenaGame)object4).mActivePlayer;
                                    this.setSystemActive(player3.mRideHandle, true);
                                    object4 = this;
                                    boolean bl = false;
                                    object4 = ((ArenaGame)object4).mActivePlayer;
                                    ((ArenaGame)object4).mActivePlayer.mScoringEnabled = bl;
                                    object4 = this;
                                    this.doTransfer(((ArenaGame)object4).mActivePlayer, this.mDeathCheckNextFreeRide);
                                    this.onHandleBulletTime(1024);
                                    this.doGameLogic();
                                    this.doGameLogic();
                                    object4 = this;
                                    bl = true;
                                    object4 = ((ArenaGame)object4).mActivePlayer;
                                    ((ArenaGame)object4).mActivePlayer.mScoringEnabled = bl;
                                    object4 = this;
                                    if (!((ArenaGame)object4).mIsReplay) {
                                        this.mWaitForPlayer = true;
                                        this.addScreenMessage(261, Integer.MAX_VALUE, 2);
                                    }
                                    object4 = this;
                                    this.mDeathCheckLastLevelDamage = ((ArenaGame)object4).mActivePlayer.getLevelDamageInPercent();
                                    return;
                                }
                                if (this.mDeathCheckNextFreeRide == -1) break block69;
                                object3 = this;
                                object3 = ((ArenaGame)object3).mActivePlayer;
                                if (((Player)object3).mDamageDuringLevel < 500) break block70;
                            }
                            boolean bl = this.mFrame % 10 > 5;
                            object3 = this;
                            Player player4 = ((ArenaGame)object3).mActivePlayer;
                            this.setSystemVisible(player4.mRideHandle, bl);
                        }
                        return;
                    }
                    this.mBulletTimeAccu += this.mBulletTimeFraction;
                    object2 = this;
                    if (((ArenaGame)object2).mActivePlayer.isFinished()) {
                        this.mBulletTimeAccu = 0;
                    }
                    ArenaGame arenaGame5 = this;
                    if (arenaGame5.mBulletTimeFadeOutReleaseKey >= 0 && !GCanvas.isKeyPressed(arenaGame5.mBulletTimeFadeOutReleaseKey)) {
                        if (arenaGame5.mBulletTimeFadeOutId == 4) {
                            arenaGame5.sfxPlayLogicSound(3);
                        }
                        Menu.performMenuAction(46, arenaGame5.mBulletTimeFadeOutId);
                        arenaGame5.mBulletTimeAccu = 1024;
                        arenaGame5.mBulletTimeFadeOutId = -1;
                        arenaGame5.mBulletTimeFadeOutReleaseKey = -1;
                    }
                    if (this.mBulletTimeAccu >= 1024) {
                        this.mKeyFramesScheduled = this.mBulletTimeAccu >> 10;
                        this.mBulletTimeAccu &= 0x3FF;
                        int n2 = 1400;
                        if (this.mBulletTimeId >= 0) {
                            n2 = RM.getValue(778, this.mBulletTimeId, 0) * 1400 >> 10;
                        }
                        this.mBulletTimeFraction = GCanvas.clamp(this.mBulletTimeFraction + this.mBulletTimeFractionDelta, n2, 1400);
                    }
                    while (--this.mKeyFramesScheduled >= 0) {
                        ArenaGame arenaGame6;
                        block71: {
                            block72: {
                                Player player5;
                                this.onIdleTick();
                                this.onHandleBulletTime(1024);
                                ++this.mKeyFrame;
                                object2 = this;
                                if (((ArenaGame)object2).mActivePlayer.isFinished()) continue;
                                arenaGame6 = this;
                                int n3 = arenaGame6.getActiveScreenMessageId();
                                if (n3 >= 0) {
                                    int[] nArray = arenaGame6.mScreenMessages[n3];
                                    object = nArray;
                                    nArray[1] = nArray[1] - 1;
                                    if (object[1] < 0) {
                                        object[0] = -1;
                                    }
                                }
                                arenaGame6 = this;
                                object2 = arenaGame6;
                                player2 = player5 = arenaGame6.mActivePlayer;
                                player5.mCachedInputState = 0;
                                int n4 = 0;
                                if (GCanvas.isKeyPressed(1040)) {
                                    n4 = 2;
                                }
                                if (GCanvas.isKeyPressed(520)) {
                                    n4 |= 1;
                                } else if (GCanvas.isKeyPressed(2050)) {
                                    n4 |= 8;
                                }
                                if (GCanvas.isKeyPressed(4096)) {
                                    n4 |= 0x10;
                                }
                                if (GCanvas.isKeyPressed(16384)) {
                                    n4 |= 0x40;
                                }
                                if (GCanvas.isKeyPressed(8196)) {
                                    n4 |= 0x20;
                                }
                                if (GCanvas.isKeyPressed(1040)) {
                                    n4 |= 4;
                                }
                                int n5 = n4;
                                player2 = player5;
                                object2 = player2;
                                if (player2.mStateInfo != null) {
                                    Player player6 = player2;
                                    object2 = player6;
                                    object2 = player2;
                                    player6.mStateInfo[1] = ((Player)object2).mStateInfo[0];
                                    object2 = player2;
                                    ((Player)object2).mStateInfo[0] = 0;
                                }
                                player2.mInputState |= n5;
                                player2.mCachedInputState |= n5;
                                this.doGameLogic();
                                arenaGame6 = this;
                                if (ArenaGame.achievementsIsSet(8)) break block71;
                                object2 = arenaGame6;
                                player2 = ((ArenaGame)object2).mActivePlayer;
                                if (player2.mRideId == 2) break block72;
                                object2 = arenaGame6;
                                player2 = ((ArenaGame)object2).mActivePlayer;
                                if (player2.mRideId != 1) break block71;
                            }
                            Point2D point2D = Point2D.getLocal();
                            arenaGame6.getRideVelocity(point2D);
                            if (point2D.x > 0) {
                                arenaGame6.mBackwardsDistance = 0;
                            } else {
                                object = Point2D.getLocal();
                                object2 = Point2D.getLocal();
                                arenaGame6.getRidePrevPosition((Point2D)object);
                                arenaGame6.getRidePosition((Point2D)object2);
                                arenaGame6.mBackwardsDistance += Point2D.dist((Point2D)object, (Point2D)object2);
                                Point2D.freeLocal((Point2D)object2);
                                Point2D.freeLocal((Point2D)object);
                                if (arenaGame6.mBackwardsDistance > 2000000) {
                                    arenaGame6.achievementsSet(8);
                                }
                            }
                            Point2D.freeLocal(point2D);
                        }
                        arenaGame6 = this;
                        if (!arenaGame6.mTimedMission || arenaGame6.mIsTraining) continue;
                        object2 = arenaGame6;
                        arenaGame6.mTimeLeft = (int)((long)arenaGame6.mTimeLeft - 42L);
                        if (arenaGame6.mTimeLeft >= 0) continue;
                        arenaGame6.mTimeLeft = 0;
                        object2 = arenaGame6;
                        arenaGame6.playerFinished(((ArenaGame)object2).mActivePlayer, 4, false);
                    }
                    this.onHandleBulletTime(this.mBulletTimeAccu);
                    object2 = this;
                    object2 = ((ArenaGame)object2).mActivePlayer;
                    if (this.getSystemType(((Player)object2).mRideHandle) != 0) break block73;
                    arenaGame = this;
                    this.mIsCarAidVisible = false;
                    object2 = arenaGame;
                    player = ((ArenaGame)object2).mActivePlayer;
                    object2 = player;
                    object = player.mStateInfo;
                    object2 = arenaGame;
                    player2 = ((ArenaGame)object2).mActivePlayer;
                    if (player2.mRideId == 1) break block74;
                    object2 = arenaGame;
                    player2 = ((ArenaGame)object2).mActivePlayer;
                    if (player2.mRideId != 2 || object[27] != 0) break block75;
                }
                object2 = player;
                if (arenaGame.getSystemType(((Player)object2).mRideHandle) == 0) {
                    int n6 = object[16];
                    int n7 = object[10];
                    if (object[23] != n6) {
                        object[22] = -1;
                        object[23] = object[16];
                    }
                    if ((n6 >= 0 && !arenaGame.hasCarAidTimedOut() || n7 != 0) && arenaGame.isCarFastEnoughToEject()) {
                        if (object[22] == -1) {
                            object[22] = arenaGame.mKeyFrame;
                        }
                        boolean bl = false;
                        if (n6 >= 0 && !arenaGame.hasCarAidTimedOut()) {
                            boolean bl2 = bl = arenaGame.calculateAim((int[])object, -1) == -1;
                        }
                        if (!bl) {
                            arenaGame.mIsCarAidVisible = true;
                        }
                        if ((arenaGame.mBulletTimeId == 2 || arenaGame.mBulletTimeId == 3) && arenaGame.mHasBulletTimeFadedOutOnCarAid || arenaGame.mBulletTimeId != 2 && arenaGame.mBulletTimeId != 3) {
                            arenaGame.mHasBulletTimeFadedOutOnCarAid = false;
                            if (n7 != 0) {
                                arenaGame.performMenuAction(45, 3);
                            } else {
                                arenaGame.performMenuAction(45, 2);
                            }
                        }
                    } else {
                        object[22] = Integer.MAX_VALUE;
                        if (!arenaGame.mHasBulletTimeFadedOutOnCarAid) {
                            arenaGame.performMenuAction(46, 3);
                            arenaGame.performMenuAction(46, 2);
                            arenaGame.mHasBulletTimeFadedOutOnCarAid = true;
                        }
                    }
                }
                break block75;
            }
            this.mIsCarAidVisible = false;
        }
        if (this.mBulletTimeId >= 0 && (n = RM.getValue(778, this.mBulletTimeId, 1)) > -1) {
            if (this.mBulletFadeInFinishedFrame == -1) {
                n = (RM.getValue(778, this.mBulletTimeId, 0) + 20) * 1400 >> 10;
                if (this.mBulletTimeFraction <= n) {
                    this.mBulletFadeInFinishedFrame = this.mFrame;
                }
            } else if (this.mFrame == this.mBulletFadeInFinishedFrame + n) {
                this.mBulletTimeAccu = 1024;
                Menu.performMenuAction(46, this.mBulletTimeId);
            }
        }
        if (this.mPopupTutorialText >= 0) {
            this.stepShutter();
            if (--this.mPopupTutorialDelay == 0) {
                Menu.showMessage(RM.t(256), RM.t(this.mPopupTutorialText), 14, -1, 254);
                this.mPopupTutorialText = -1;
                this.mBulletTimeAccu = 1024;
                this.performMenuAction(46, 0);
            }
        }
    }

    public final boolean peekInput() {
        if (Menu.getCurrentMenu() == 5) {
            this.mMissionSelected = Menu.getSelection();
            int n = Menu.getMenuItemTarget(Menu.getCurrentMenu(), this.mMissionSelected);
            int n2 = Menu.getMenuItemAction(Menu.getCurrentMenu(), this.mMissionSelected);
            if (n2 == 36 && n >= 0 && (n2 = RM.getLink(776, 0, n)) >= 0) {
                int n3 = this.mMissionSelected;
                if (GCanvas.consumeLEFT()) {
                    this.mMissionSelected = ArenaGame.getSelectionFromMT(n2, 1);
                } else if (GCanvas.consumeRIGHT()) {
                    this.mMissionSelected = ArenaGame.getSelectionFromMT(n2, 2);
                } else if (GCanvas.consumeDOWN()) {
                    this.mMissionSelected = ArenaGame.getSelectionFromMT(n2, 3);
                } else if (GCanvas.consumeUP()) {
                    if ((n = RM.getLink(776, 3, n)) >= 0) {
                        this.mMissionSelected = ArenaGame.getSelectionFromMT(n, 0);
                    }
                } else if (GCanvas.consumeFIRE()) {
                    Menu.performMenuAction(1);
                }
                if (this.mMissionSelected == -1) {
                    this.mMissionSelected = n3;
                }
                if (this.mMissionSelected >= 0) {
                    Menu.setSelection(this.mMissionSelected);
                    if (n3 != this.mMissionSelected) {
                        this.menuNewMissionSelected();
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static int getSelectionFromMT(int n, int n2) {
        if ((n = RM.getValue(776, n, n2)) >= 0) {
            return Menu.findMenuItemByTarget(Menu.getCurrentMenu(), n);
        }
        return -1;
    }

    public final boolean isBulletTimeActive() {
        if (this.mBulletTimeId >= 0) {
            return this.mBulletTimeFraction < 1400;
        }
        return false;
    }

    private int getEffectFrame() {
        if (this.mBulletTimeFraction <= 1024) {
            return this.mKeyFrame;
        }
        return this.mFrame;
    }

    private static boolean isSteerLeft(int n) {
        return (n & 1) != 0;
    }

    private static boolean isSteerRight(int n) {
        return (n & 8) != 0;
    }

    private static boolean isSteerCenter(int n) {
        return (n & 2) != 0;
    }

    private static boolean isSteerCenterHold(int n) {
        return (n & 4) != 0;
    }

    private static boolean isSteerAltCenter(int n) {
        return (n & 0x20) != 0;
    }

    public final void tutorialConditionFulfilled(int n) {
        if (n == mTutorialCondition) {
            this.sfxPlayLogicSound(8);
            mTutorialCondition = -1;
            this.addScreenMessage(154 + GCanvas.getRandom(0, 2), 10, 0);
        }
    }

    public final void onArea(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                if (n2 == 0 && mTutorialCondition == n3) {
                    this.setTutorialVisible(mTutorialConditionLastTutorialIdx);
                    ArenaGame arenaGame = this;
                    this.playerFinished(arenaGame.mActivePlayer, 3, false);
                }
                if (n2 != 1) break;
                this.setCamHint(-1);
                return;
            }
            case 0: {
                if (n2 != 1) break;
                this.setCamHint(n3);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int drawMissionSelectPreview(Graphics var1_1, int var2_2, int var3_3, int var4_6) {
        block24: {
            block25: {
                var5_9 = var1_1.getTranslateX();
                var6_10 = var1_1.getTranslateY();
                var1_1.translate(-var5_9, -var6_10);
                if (Menu.getMenuItemAction(var2_2, var3_3) != 36) break block24;
                var2_2 = this.mMissionSelected;
                GCanvas.pushClip(var1_1);
                var3_4 = this.mCalcVal;
                var5_9 = this.mCalcVal[41];
                var3_5 = var3_4[42];
                if (!GCanvas.clipRect(var1_1, var1_1.getClipX() + var4_6, var5_9, var1_1.getClipWidth(), var3_5 - var5_9)) break block25;
                if (this.missionAvailable(var2_2)) {
                    this.drawTrackPreview$11c48828(var1_1, var2_2);
                    if (this.mMenuSwipePercentage > 0) {
                        var1_1.setColor(0);
                        var1_1.fillRect(0, var5_9, this.mMenuSwipePercentage * GCanvas.getWidth() / 100, var3_5 - var5_9);
                        this.mMenuSwipePercentage -= 15;
                    }
                } else {
                    var1_1.setColor(0);
                    var1_1.fillRect(0, var5_9, GCanvas.getWidth(), var3_5 - var5_9);
                }
                var4_6 = this.missionAvailable(var2_2) != false ? 2 : -1;
                GCanvas.setSoftButton(var4_6, 1);
                var7_12 = var2_2;
                var6_11 = var1_1;
                var4_7 = this;
                var8_13 = RM.getLink(776, 0, var7_12);
                if (var8_13 < 0 || RM.getLink(777, 0, var8_13) < 0) break block25;
                if (var4_7.mSelPos == null) {
                    var4_7.mSelPos = new Point2D();
                    var4_7.mSelPosTarget = new Point2D();
                    var4_7.mMissionNameLines = new Vector<E>();
                }
                ArenaGame.getMTNodePosition(var8_13, var4_7.mSelPosTarget);
                if (var4_7.mMenuMissionSelectReset) {
                    var4_7.mMenuMissionSelectReset = false;
                    var4_7.mSelPos.set(var4_7.mSelPosTarget);
                }
                var9_14 = -(var4_7.mSelPos.x - (GCanvas.getWidth() << 10 >> 1));
                var10_15 = -(var4_7.mSelPos.y - (GCanvas.getHeight() << 10 >> 1) - (GCanvas.getFontHeight(7) << 10));
                var11_16 = GCanvas.getSpriteWidth(13) << 10 >> 1;
                var12_17 = GCanvas.getSpriteHeight(13) << 10 >> 1;
                var13_18 = GCanvas.getSpriteWidth(14) << 10;
                var14_20 = RM.getHeight(776);
                var15_21 = Point2D.getLocal();
                var16_22 = Point2D.getLocal();
                var17_23 = Point2D.getLocal();
                for (var18_24 = 0; var18_24 < var14_20; ++var18_24) {
                    block27: {
                        block28: {
                            block26: {
                                var8_13 = var18_24;
                                var19_26 = RM.getValue(776, var18_24, 3);
                                var20_27 = RM.getLink(776, 0, var19_26);
                                if (var19_26 < 0) continue;
                                ArenaGame.getMTNodePosition(var8_13, var15_21);
                                ArenaGame.getMTNodePosition(var20_27, var16_22);
                                var15_21.add(var9_14, var10_15);
                                var16_22.add(var9_14, var10_15);
                                var21_28 = RM.getValue(776, var18_24, 4);
                                if (var21_28 != 0) break block26;
                                var16_22.x -= var11_16;
                                break block27;
                            }
                            if (var21_28 != 1) break block28;
                            v0 = var16_22;
                            v1 = v0;
                            v2 = v0.x;
                            ** GOTO lbl-1000
                        }
                        v3 = var16_22;
                        v1 = v3;
                        v2 = v3.x;
                        if (var15_21.x < var16_22.x) {
                            v4 = -var11_16;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = var11_16;
                        }
                        v1.x = v2 + v4;
                    }
                    var15_21.y += var12_17;
                    var22_31 = Point2D.dist(var16_22, var15_21);
                    var20_27 = var22_31 / (var13_18 * 2);
                    var23_32 = Point2D.getLocal();
                    var23_32.setDiff(var16_22, var15_21);
                    var23_32.setLength(var13_18 << 11);
                    var23_32.x >>= 10;
                    var23_32.y >>= 10;
                    for (var24_34 = 0; var24_34 <= var20_27; ++var24_34) {
                        var16_22.sub(var23_32.x, var23_32.y);
                        GCanvas.drawSprite(var6_11, 14, var16_22.x >> 10, var16_22.y >> 10, 0);
                    }
                    Point2D.freeLocal(var23_32);
                }
                for (var18_24 = 0; var18_24 < var14_20; ++var18_24) {
                    var8_13 = var18_24;
                    var20_27 = var19_26 = RM.getValue(776, var18_24, 0);
                    var13_19 = var4_7;
                    var22_31 = var20_27;
                    var21_29 = var13_19;
                    var23_33 = Menu.isOptionBitSet(46, var22_31);
                    var21_28 = var21_29.missionAvailable(var22_31);
                    if (var21_28 != 0 && var23_33 == 0) {
                        v5 = 2;
                    } else {
                        var22_31 = var20_27;
                        var21_30 = var13_19;
                        var23_33 = Menu.isOptionBitSet(48, var22_31);
                        v6 = var21_30.missionAvailable(var22_31);
                        var21_28 = (int)v6;
                        v5 = (v6 != false && var23_33 != 0) != false ? 3 : (var13_19.missionAvailable(var20_27) != false ? 0 : 1);
                    }
                    var20_27 = v5;
                    ArenaGame.getMTNodePosition(var8_13, var15_21);
                    var15_21.add(var9_14, var10_15);
                    GCanvas.drawSprite(var6_11, 13, var15_21.x >> 10, var15_21.y >> 10, var20_27);
                    if (var19_26 != var7_12) continue;
                    var17_23.set(var15_21);
                    var21_28 = (GCanvas.getGlobalFrameCount() & 2) == 0 ? 1 : 0;
                    var22_31 = GCanvas.getSpriteWidth(12) << 10 >> 1;
                    var20_27 = GCanvas.getSpriteHeight(11) << 10;
                    if (RM.getValue(776, var8_13, 1) >= 0) {
                        var23_33 = var15_21.x - var11_16 - var22_31;
                        var24_34 = var15_21.y;
                        if (var21_28 != 0) {
                            GCanvas.drawSprite(var6_11, 12, var23_33 >> 10, var24_34 >> 10, 0);
                        }
                    }
                    if (RM.getValue(776, var8_13, 2) >= 0) {
                        var23_33 = var15_21.x + var11_16 + var22_31;
                        var24_34 = var15_21.y;
                        if (var21_28 != 0) {
                            GCanvas.drawSprite(var6_11, 12, var23_33 >> 10, var24_34 >> 10, 1);
                        }
                    }
                    if (RM.getValue(776, var8_13, 3) >= 0) {
                        var23_33 = var15_21.x;
                        var24_34 = var15_21.y + var12_17;
                        if (var21_28 != 0) {
                            GCanvas.drawSprite(var6_11, 11, var23_33 >> 10, var24_34 >> 10, 1);
                        }
                    }
                    if ((var23_33 = RM.getLink(776, 3, var19_26)) < 0) continue;
                    var24_34 = var15_21.x;
                    var8_13 = var15_21.y - var12_17 - var20_27;
                    if (var21_28 == 0) continue;
                    GCanvas.drawSprite(var6_11, 11, var24_34 >> 10, var8_13 >> 10, 0);
                }
                var18_25 = RM.t(RM.getValue(771, var7_12, 0));
                if (var18_25 != var4_7.mLastMissionName) {
                    var4_7.mMissionNameLines.removeAllElements();
                    Menu.breakLine(var4_7.mMissionNameLines, 7, var18_25, Menu.getTextWidth());
                    var4_7.mLastMissionName = var18_25;
                }
                var19_26 = var4_7.mMissionNameLines.size();
                var20_27 = GCanvas.getFontHeight(7);
                var21_28 = (var17_23.y >> 10) + var4_7.mCalcVal[40] - (var19_26 - 1) * var20_27;
                for (var22_31 = 0; var22_31 < var19_26; ++var22_31) {
                    GCanvas.drawString(var6_11, 7, (String)var4_7.mMissionNameLines.elementAt(var22_31), var17_23.x >> 10, var21_28, 17);
                    var21_28 += var20_27;
                }
                var22_31 = var4_7.mSelPos.x - var4_7.mSelPosTarget.x << 7 >> 10;
                var20_27 = var4_7.mSelPos.y - var4_7.mSelPosTarget.y << 7 >> 10;
                var4_7.mSelPos.sub(var22_31, var20_27);
                Point2D.freeLocal(var17_23);
                Point2D.freeLocal(var16_22);
                Point2D.freeLocal(var15_21);
            }
            GCanvas.popClip(var1_1);
            if (var5_9 > 0) {
                this.drawShutter(var1_1, 0, var5_9, var3_5, true, false);
            }
            if (var3_5 > 0) {
                this.drawShutter(var1_1, 0, var5_9, var3_5, false, true);
            }
            if (!GCanvas.isLandscape()) {
                var6_10 = var2_2;
                var4_8 = var1_1;
                var7_12 = RM.getValue(771, var6_10, 24);
                if (var7_12 >= 0) {
                    GCanvas.drawImage(var4_8, var7_12, GCanvas.getWidth() >> 1, 5, 17);
                }
            }
            this.drawScrollingText(var1_1);
            return 3;
        }
        return 0;
    }

    private void drawScrollingText(Graphics graphics) {
        if (this.mScrollingTextId == -1) {
            return;
        }
        int n = GCanvas.getWidth() - Menu.getTextWidth() >> 1;
        if (this.mScrollingTextWidth < 0) {
            this.mScrollingTextX = -this.mScrollingTextWidth / 2;
        } else if (this.mScrollingTextWait > 0) {
            --this.mScrollingTextWait;
        } else {
            this.mScrollingTextX += this.mScrollingTextSpeed;
            if (this.mScrollingTextX < -this.mScrollingTextWidth) {
                this.mScrollingTextSpeed = -this.mScrollingTextSpeed;
                this.mScrollingTextX = -this.mScrollingTextWidth;
                this.mScrollingTextWait = 6;
            } else if (this.mScrollingTextX > 2) {
                this.mScrollingTextSpeed = -this.mScrollingTextSpeed;
                this.mScrollingTextX = 2;
                this.mScrollingTextWait = 6;
            }
        }
        if (this.mScrollingTextId == -2) {
            int n2 = GCanvas.getSpriteWidth(15);
            n = this.drawMedal$75a39d21(graphics, 241, 0, this.mScrollingTextX + n, n2);
            n = this.drawMedal$75a39d21(graphics, 243, 2, n, n2);
            n = this.drawMedal$75a39d21(graphics, 242, 1, n, n2);
            this.drawMedal$75a39d21(graphics, 244, 3, n, n2);
            return;
        }
        GCanvas.drawString(graphics, 5, RM.t(this.mScrollingTextId), this.mScrollingTextX + n, this.mScrollingTextY, 20);
    }

    private int drawMedal$75a39d21(Graphics graphics, int n, int n2, int n3, int n4) {
        if ((n2 = ArenaGame.getMissionRank(this.mMissionSelected, n2)) > 0) {
            GCanvas.drawString(graphics, 5, RM.t(n), n3, this.mScrollingTextY, 20);
            GCanvas.drawSprite(graphics, 15, n3 += GCanvas.getStringWidth(RM.t(n), 5) + n4, this.mScrollingTextY, n2 - 1);
            n3 += n4 * 2;
        }
        return n3;
    }

    public final int drawCustomMenu(Graphics object, int n, int n2, int n3) {
        int n4 = 0;
        switch (n) {
            case 12: {
                n = GCanvas.getGlobalFrameCount();
                n2 = 0;
                n3 = GCanvas.getWidth() >> 1;
                String string = RM.t(54);
                int n5 = string.length();
                for (int i = 0; i < n5; ++i) {
                    int n6 = (n + i * 3) % 4 < 2 ? 2 : 4;
                    int n7 = (n + (i << 1) << 10) / 10 >> 2;
                    n7 = GCanvas.cos(n7);
                    int n8 = GCanvas.getHeight() >> 4;
                    n2 = (n8 * n7 >> 10) + (GCanvas.getHeight() >> 1);
                    int n9 = n3 - (GCanvas.getStringWidth(string, n6) >> 1) + i * GCanvas.getCharWidth('A', n6) + (n8 * n7 >> 12);
                    GCanvas.drawString((Graphics)object, n6, string.substring(i, i + 1), n9, n2, 3);
                }
                n4 = 1;
                break;
            }
            case 0: {
                n = Menu.getMenuItemTop();
                n2 = 0;
                n2 = RM.getHeight(34) + 6;
                if (n < n2) {
                    Menu.setMenuCaptionOffset(n2 - n);
                }
                this.drawMainMenu((Graphics)object);
                n = RM.getWidth(34);
                GCanvas.drawImage((Graphics)object, 34, GCanvas.getWidth() - n >> 1, 3);
                n4 = 2;
                break;
            }
            case 9: {
                n2 = n;
                Graphics graphics = object;
                object = this;
                Vector vector = ((ArenaGame)object).mMissionPassedLines;
                int[] nArray = ((ArenaGame)object).mMissionPassedMedalInfo;
                int n10 = vector.size();
                int n11 = GCanvas.getSpriteHeight(15);
                int n12 = GCanvas.getSpriteHeight(15);
                int n13 = Math.max(Menu.getTextSpacing(5, n2), n12 + 1);
                int n14 = ((ArenaGame)object).mMenuBorderTargetBottom - n10 * n13 - (n13 >> 1);
                int n15 = n11 >> 2;
                n2 = GCanvas.getWidth() - n15;
                n11 = n13 - n12 >> 1;
                int n16 = 0;
                n4 = 0;
                n16 = GCanvas.getRandom(-3, 1);
                n4 = GCanvas.getRandom(-1, 1);
                n12 = Menu.getMenuCaptionBottom();
                n12 = Math.max(n12 + n13, n12 + n14 >> 2);
                GCanvas.drawString(graphics, 5, RM.t(265), n2, n12, 10);
                GCanvas.drawString(graphics, 5, RM.t(267), n2 + n16, n12 + n13 + n4, 10);
                n16 = 0;
                for (n4 = 0; n4 < n10; ++n4) {
                    GCanvas.drawString(graphics, 5, (String)vector.elementAt(n4), n15, n14 + n16, 20);
                    n16 += n13;
                }
                n2 -= GCanvas.getSpriteWidth(15) >> 1;
                n4 = 0;
                for (int i = 0; i < 5; ++i) {
                    n10 = nArray[n4 + 0] - 1;
                    if (n10 >= 0) {
                        n16 = GCanvas.getRandom(-2, 0);
                        n12 = nArray[n4 + 1] + n14 - n13;
                        GCanvas.drawSprite(graphics, 15, n2 + n16, n12 + n11, n10);
                    }
                    n4 += 2;
                }
                n4 = 1;
                break;
            }
            case 14: {
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                Graphics graphics = object;
                object = this;
                int[] nArray = ((ArenaGame)object).mCalcVal;
                int n23 = n2;
                if (ArenaGame.achievementsIsSet(n23)) {
                    n22 = RM.getValue(775, n23, 1);
                    if (n2 != mLastSelectedItem) {
                        mLastSelectedItem = n2;
                        ((ArenaGame)object).mTextlines.removeAllElements();
                        Menu.breakLine(((ArenaGame)object).mTextlines, 5, RM.t(n22), Menu.getTextWidth());
                        if (((ArenaGame)object).mTextlines.size() > 3) {
                            n21 = GCanvas.getFontHeight(5);
                            n20 = nArray[36];
                            n19 = n20 + (GCanvas.getHeight() - n20 - n21 >> 1);
                            super.scrollTextInit(n22, n19);
                        }
                    }
                    if ((n21 = ((ArenaGame)object).mTextlines.size()) <= 3) {
                        n20 = GCanvas.getHeight() - nArray[36];
                        n19 = GCanvas.getFontHeight(5);
                        n18 = n20 - n19 * n21 >> 1;
                        n18 = nArray[36] + n18;
                        n17 = (GCanvas.getGlobalFrameCount() << 6) % 1024;
                        n2 = GCanvas.cos(n17) / 300;
                        n21 = GCanvas.sin(n17) / 300;
                        Menu.drawText(graphics, ((ArenaGame)object).mTextlines, n2 + (GCanvas.getWidth() >> 1), n18 += n21, 17, 5, 0);
                    } else {
                        super.drawScrollingText(graphics);
                    }
                } else {
                    n22 = (GCanvas.getGlobalFrameCount() << 5) % 1024;
                    n21 = GCanvas.sin(n22);
                    n20 = GCanvas.cos(n22);
                    n19 = n20 / 40;
                    n18 = 0;
                    GCanvas.getFontHeight(5);
                    n17 = 0;
                    n18 = n21 / 300;
                    n17 = n20 / 100;
                    n2 = (GCanvas.getWidth() >> 1) + n21 / 50;
                    n21 = (GCanvas.getHeight() + nArray[36] >> 1) + n17;
                    GCanvas.drawString(graphics, 5, "?", n2 - n19, n21 + n18, 17);
                    GCanvas.drawString(graphics, 5, "?", n2, n21, 17);
                    GCanvas.drawString(graphics, 5, "?", n2 + n19, n21 - n18, 17);
                }
                n22 = 0;
                for (n21 = 10; n21 <= 17; ++n21) {
                    n22 += GL.bitsGetNumOnes(Menu.getOption(n21));
                }
                n21 = 0;
                for (n20 = 18; n20 <= 25; ++n20) {
                    n21 += GL.bitsGetNumOnes(Menu.getOption(n20));
                }
                n20 = 0;
                for (n19 = 26; n19 <= 33; ++n19) {
                    n20 += GL.bitsGetNumOnes(Menu.getOption(n19));
                }
                n18 = GCanvas.getSpriteWidth(15) - 1;
                n17 = (GCanvas.getCharWidth('0', 5) << 1) + n18;
                n2 = Menu.getMenuCaptionBottom();
                GCanvas.drawString(graphics, 5, RM.t(66), 2, n2, 20);
                n19 = 2 + (GCanvas.getStringWidth(RM.t(66), 5) + n18);
                GCanvas.drawSprite(graphics, 15, n19, Menu.getMenuCaptionBottom(), 0);
                GCanvas.drawString(graphics, 5, String.valueOf(n20), n19 += n18, n2, 20);
                GCanvas.drawSprite(graphics, 15, n19 += n17, Menu.getMenuCaptionBottom(), 1);
                GCanvas.drawString(graphics, 5, String.valueOf(n21), n19 += n18, n2, 20);
                GCanvas.drawSprite(graphics, 15, n19 += n17, Menu.getMenuCaptionBottom(), 2);
                GCanvas.drawString(graphics, 5, String.valueOf(n22), n19 += n18, n2, 20);
                break;
            }
            case 5: {
                n4 = 0 | this.drawMissionSelectPreview((Graphics)object, n, n2, n3);
            }
        }
        return n4;
    }

    private void drawShutter(Graphics graphics, int n, int n2, int n3, boolean n4, boolean bl) {
        int n5 = RM.getWidth(33);
        if (n4 != 0) {
            n4 = n2 - n5;
            while (n4 > 0) {
                ArenaGame.drawTileRow(graphics, 33, 1, n, n4 -= n5);
            }
            this.drawShutterTop(graphics, n, n2);
        }
        if (bl) {
            this.drawShutterBottom(graphics, n, n3);
            for (n4 = n3 + n5; n4 < GCanvas.getHeight(); n4 += n5) {
                ArenaGame.drawTileRow(graphics, 33, 1, n, n4);
            }
        }
    }

    public final void drawCustomMenuBackground$26c5358c(Graphics graphics, int n, int n2) {
        int n3 = RM.getLink(789, 0, n);
        if (n3 >= 0 && RM.getValue(789, n3, 1) == 0) {
            return;
        }
        if (Menu.getMode() != 0) {
            n3 = RM.getWidth(33);
            int n4 = 0;
            for (int i = n4 = -GCanvas.getGlobalFrameCount() % n3; i < GCanvas.getHeight(); i += n3) {
                ArenaGame.drawTileRow(graphics, 33, 1, n2 - n4 - n3, i);
            }
            if (n != 5) {
                n3 = 0;
                n4 = 0;
                this.stepShutter();
                n3 = this.mMenuBorderTop;
                n4 = this.mMenuBorderBottom;
                int n5 = n;
                Graphics graphics2 = graphics;
                ArenaGame arenaGame = this;
                int[] nArray = arenaGame.mCalcVal;
                int n6 = arenaGame.mCalcVal[37];
                int n7 = nArray[38];
                int n8 = -1;
                if (RM.t(Menu.getMenuCaption(Menu.getCurrentMenu())) == RM.t(256)) {
                    n8 = 27;
                } else {
                    switch (n5) {
                        case 9: {
                            n8 = 26;
                            break;
                        }
                        case 10: {
                            n8 = 25;
                            break;
                        }
                        case 11: {
                            n8 = -1;
                            switch (arenaGame.mMenuBackdropAchievement) {
                                case 2: {
                                    n8 = 21;
                                    break;
                                }
                                case 1: {
                                    n8 = 22;
                                    break;
                                }
                                case 3: {
                                    n8 = 23;
                                }
                            }
                            if (n8 == -1) break;
                            n6 = nArray[39];
                        }
                    }
                }
                if (n8 >= 0) {
                    GCanvas.drawImage(graphics2, n8, n6, n7, 40);
                }
                this.drawShutter(graphics, n2, n3, n4, true, true);
            }
        }
    }

    public final boolean menuHighlightSelection(int n) {
        return n != -1;
    }

    public final boolean menuDrawItem(Graphics graphics, int n, String string, int n2, int n3, int n4) {
        if (Menu.sCurrentDrawnItem == -1) {
            return false;
        }
        switch (Menu.getCurrentMenu()) {
            case 14: {
                int n5;
                int n6 = Menu.sCurrentDrawnItem;
                n6 = n6;
                if (ArenaGame.achievementsIsSet(n5)) {
                    n6 = GCanvas.getSpriteWidth(15);
                    GCanvas.drawSprite(graphics, 15, n2 - n6, n3 + 1, 0);
                    GCanvas.drawString(graphics, n, string, n2, n3, n4);
                    GCanvas.drawSprite(graphics, 15, n2 + GCanvas.getStringWidth(string, n) + n6, n3 + 1, 0);
                } else {
                    GCanvas.drawString(graphics, 8, string, n2, n3, n4);
                }
                return true;
            }
        }
        return false;
    }

    private void stepShutter() {
        int n = this.mMenuBorderTargetTop - this.mMenuBorderTop;
        if (Math.abs(n) > 1) {
            n = Math.abs(n) > 5 ? (n /= 5) : (n /= 2);
        }
        this.mMenuBorderTop += n;
        n = this.mMenuBorderTargetBottom - this.mMenuBorderBottom;
        if (Math.abs(n) > 1) {
            n = Math.abs(n) > 5 ? (n /= 5) : (n /= 2);
        }
        this.mMenuBorderBottom += n;
    }

    private void drawShutterTop(Graphics graphics, int n, int n2) {
        int n3 = RM.getWidth(33);
        ArenaGame.drawTileRow(graphics, 33, 2, n, n2 - n3);
    }

    private void drawShutterBottom(Graphics graphics, int n, int n2) {
        ArenaGame.drawTileRow(graphics, 33, 0, n, n2);
    }

    private int checkForTransfer(int n, int n2, int n3, int n4) {
        int n5;
        block4: {
            n5 = -1;
            int n6 = Integer.MAX_VALUE;
            if (!this.isSystemVisible(n) || !this.isSystemActive(n)) break block4;
            int[] nArray = RM.getInts(584);
            int n7 = this.getNumRides();
            int n8 = Integer.MAX_VALUE;
            for (int i = 0; i < n7; ++i) {
                int n9;
                int n10;
                block7: {
                    block6: {
                        block5: {
                            long l;
                            long l2;
                            if (!this.isSystemVisible(i) || this.isSystemDeactivated(i)) continue;
                            n10 = this.mRideDatas[i][0];
                            if (n == i || (n10 = this.findMatchingTransfer(n2, n10)) < 0) continue;
                            int n11 = nArray[(n10 *= 10) + 4];
                            n10 = nArray[n10 + 5];
                            int n12 = n3;
                            int n13 = n10 * n4;
                            int n14 = n11;
                            int n15 = i;
                            n11 = n;
                            ArenaGame arenaGame = this;
                            Point2D point2D = tmpDst;
                            Point2D[] point2DArray = arenaGame.mRideCenters;
                            if (n14 < 0) {
                                Point2D point2D2 = point2DArray[n15];
                                l2 = point2D2.x;
                                l = point2D2.y;
                            } else {
                                arenaGame.getRidePosition(n15, n14, point2D);
                                l2 = point2D.x;
                                l = point2D.y;
                            }
                            Point2D point2D3 = point2DArray[n11];
                            l2 = (long)point2D3.x - l2;
                            l = (long)point2D3.y - l;
                            long l3 = n13 < 0 ? (long)arenaGame.getRideRadiusSquared(n15) : (long)n13;
                            long l4 = arenaGame.getRideRadiusSquared(n11);
                            long l5 = l2 * l2 + l * l >> 10;
                            if (l5 <= 0L || l5 >= l4 + l3 + (long)n12) break block5;
                            if (arenaGame.mRideDatas[n15][3] != 0) break block6;
                            n9 = (int)l5;
                            break block7;
                        }
                        arenaGame.mRideDatas[n15][3] = 0;
                    }
                    n9 = n10 = Integer.MAX_VALUE;
                }
                if (n9 < n6) {
                    n6 = n10;
                    n5 = i;
                }
                if (n10 > n8) break;
                n8 = n10;
            }
        }
        return n5;
    }

    public final void handleTransfers(Player player) {
        Player player2 = player;
        int n = player2.mRideId;
        player2 = player;
        int n2 = player2.mRideHandle;
        if (n == 0 || n == 4) {
            if ((n = this.checkForTransfer(n2, n, 186368, 1)) >= 0) {
                this.doTransfer(player, n);
            }
            return;
        }
        if (this.getSystemType(n2) == 0) {
            player2 = player;
            int[] nArray = player2.mStateInfo;
            if (player2.mStateInfo[10] == 0) {
                nArray[16] = this.checkForTransfer(n2, 0, 6144000, 20);
            }
        }
    }

    private boolean doTransfer(Player player, int n) {
        Player player2 = player;
        int n2 = player2.mRideId;
        player2 = player;
        int n3 = player2.mRideHandle;
        byte by = this.mRideDatas[n][0];
        if (n2 != 0 && by != 0) {
            this.doTransfer(player, this.mRagdollHandle);
            this.setSystemRestingEnabled(n3, true);
            n2 = RM.getValue(583, this.mRideDatas[n3][0], 9) > 0 ? 1 : 0;
            if (n2 == 0) {
                this.setSystemDeactivated(n3);
                this.setOnFire(n3);
            }
            n2 = 0;
            n3 = this.mRagdollHandle;
        }
        if ((n2 = this.findMatchingTransfer(n2, by)) >= 0) {
            int n4;
            Point2D point2D = Point2D.getLocal();
            this.getRideVelocity(point2D);
            int n5 = RM.getValue(584, n2, 3);
            int n6 = RM.getValue(584, n2, 2);
            if (n5 < 0) {
                this.setSystemActive(n3, false);
                this.setSystemVisible(n3, false);
            } else {
                n4 = RM.getValue(584, n2, 8);
                int n7 = RM.getValue(584, n2, 9);
                int n8 = RM.getValue(584, n2, 6);
                int n9 = RM.getValue(584, n2, 7);
                this.linkSystems(n3, n, n5, n4, n7, n8, n9);
            }
            player.setRide(by, n, this.createStateInfo(by));
            n4 = RM.getValue(584, n2, 4);
            if (n4 < 0) {
                this.inheritSystemTranslation(n, n3, n6);
            } else {
                point2D.capLength(n6);
                this.applyForce(n4, point2D);
            }
            Point2D.freeLocal(point2D);
            this.onRideChanged(player, by, n, n3);
            this.setSystemActive(n, true);
            return true;
        }
        return false;
    }

    private void onRideChanged(Player player, int n, int n2, int n3) {
        int n4;
        this.mBackwardsDistance = 0;
        player.clearSteer(4);
        this.hideRideFX();
        int n5 = -1;
        if (n3 >= 0) {
            n5 = this.mRideDatas[n3][0];
        }
        Object object = player;
        int[] nArray = ((Player)object).mStateInfo;
        int n6 = 0;
        object = player;
        player.mScoreComboDisableBreak = false;
        object = player;
        object = ((Player)object).mGame;
        player.mScoreComboLastUpdateKeyFrame = ((ArenaGame)object).mKeyFrame;
        RM.fill(this.mHeightmapInfo[n2], 0);
        this.setSystemRestingEnabled(n2, false);
        if (n3 >= 0) {
            if (this.getSystemType(n3) == 0) {
                this.setSystemAdditiveFriction(n3, 24);
            }
            if (this.getSystemType(n3) != 1) {
                this.setSystemRestingEnabled(n3, true);
                boolean bl = RM.getValue(583, this.mRideDatas[n3][0], 9) > 0;
                if (!bl) {
                    this.setSystemDeactivated(n3);
                    this.setOnFire(n3);
                } else {
                    n6 = n3;
                    ArenaGame arenaGame = this;
                    arenaGame.mRideDatas[n6][8] = 120;
                }
            }
            this.performMenuAction(46, -1);
        }
        n6 = n2;
        ArenaGame arenaGame = this;
        boolean bl = RM.getValue(583, arenaGame.mRideDatas[n6][0], 9) > 0;
        if (bl) {
            n6 = n2;
            ArenaGame arenaGame2 = this;
            arenaGame2.mRideDatas[n6][3] = 1;
        }
        if (n3 >= 0 && (n4 = RM.getValue(583, n, 13)) >= 0) {
            this.sfxPlayLogicSound(n4);
        }
        switch (n) {
            case 0: {
                this.setSystemRestingEnabled(n2, true);
                boolean bl2 = false;
                nArray[12] = this.mKeyFrame - 15;
                nArray[11] = this.mKeyFrame - 100;
                nArray[14] = 0;
                nArray[0] = -1;
                break;
            }
            case 2: {
                nArray[27] = 25;
            }
            case 1: {
                nArray[16] = -1;
                nArray[9] = 0;
                nArray[17] = -1;
                Player player2 = player;
                nArray[3] = ArenaGame.isSteerCenter(player2.mCachedInputState) ? 1 : 0;
                player2 = player;
                nArray[4] = ArenaGame.isSteerLeft(player2.mCachedInputState) ? 1 : 0;
                player2 = player;
                nArray[5] = ArenaGame.isSteerRight(player2.mCachedInputState) ? 1 : 0;
                nArray[21] = -1;
                nArray[22] = -1;
                nArray[23] = -1;
                nArray[19] = 0;
                nArray[20] = 0;
                nArray[18] = 0;
                this.carResetLoopingDetection(nArray);
                break;
            }
            case 3: {
                nArray[9] = 15000;
                nArray[11] = 0;
                Player player3 = player;
                nArray[3] = ArenaGame.isSteerCenter(player3.mCachedInputState) ? 1 : 0;
                player3 = player;
                nArray[4] = ArenaGame.isSteerLeft(player3.mCachedInputState) ? 1 : 0;
                player3 = player;
                int n7 = nArray[5] = ArenaGame.isSteerRight(player3.mCachedInputState) ? 1 : 0;
                if (n3 >= 0) {
                    Menu.performMenuAction(45, 7);
                }
                Point2D point2D = Point2D.getLocal();
                this.getRideVelocity(point2D);
                if (this.getRideSpeed() < 3000 || point2D.x < 0) {
                    int n8 = 3000;
                    if (point2D.x < 0) {
                        n8 = 3000 - point2D.x;
                    }
                    player3 = player;
                    this.pushSystem(player3.mRideHandle, n8, 0, 1024);
                }
                Point2D.freeLocal(point2D);
                break;
            }
            case 4: {
                nArray[17] = -1;
                nArray[27] = -1;
                nArray[28] = 0;
                nArray[21] = 0;
                Player player4 = player;
                nArray[3] = ArenaGame.isSteerCenter(player4.mCachedInputState) ? 1 : 0;
                player4 = player;
                nArray[4] = ArenaGame.isSteerLeft(player4.mCachedInputState) ? 1 : 0;
                player4 = player;
                nArray[5] = ArenaGame.isSteerRight(player4.mCachedInputState) ? 1 : 0;
                nArray[16] = 0;
                nArray[22] = 0;
                nArray[23] = -1;
                nArray[24] = 0;
                nArray[25] = -1;
                if (n3 < 0) break;
                Menu.performMenuAction(45, 8);
                break;
            }
            case 5: {
                nArray[9] = 578;
                nArray[10] = -1;
                nArray[11] = 0;
                nArray[12] = 0;
                nArray[15] = 1;
                nArray[14] = 0;
                Object object2 = this;
                ((ArenaGame)object2).mActivePlayer.scoreAddMove(4, true);
                object2 = player;
                int n9 = nArray[17] = ArenaGame.isSteerCenter(((Player)object2).mCachedInputState) ? 0 : 1;
                if (nArray[17] == 0) {
                    nArray[18] = this.mKeyFrame;
                }
                this.initializeTutorial(-1, 24, -1, false);
            }
        }
        if (n3 > -1) {
            n6 = n3;
            ArenaGame arenaGame3 = this;
            arenaGame3.mRideDatas[n6][5] = 1;
            if (n5 == 3) {
                this.tutorialConditionFulfilled(7);
            }
        }
        if (n2 > -1) {
            n6 = n2;
            Object object3 = this;
            byte[] byArray = ((ArenaGame)object3).mRideDatas[n6];
            object3 = byArray;
            if (byArray[4] == 0 && n2 != this.mRagdollHandle) {
                ++this.mTouchedRides;
            }
            object3[4] = true;
            object3[8] = false;
            player.resetScoreMoveCount();
        }
        if (n3 != n2) {
            this.doKeyDescShake(-1);
        }
    }

    private void doKeyDescShake(int n) {
        if (n < 0) {
            for (n = 0; n < this.mKeyshakeFrames.length; ++n) {
                this.mKeyshakeFrames[n] = 5;
            }
            return;
        }
        this.mKeyshakeFrames[n] = 5;
    }

    public final void spawnRagdoll(Player player, int n, int n2) {
        this.spawnRagdoll(player, n, n2, false);
    }

    public final void spawnRagdoll(Player player, int n, int n2, boolean bl) {
        this.removeScreenMessage(179);
        this.tutorialConditionFulfilled(12);
        Player player2 = player;
        int n3 = RM.getValue(583, player2.mRideId, 2);
        player2 = player;
        int n4 = RM.getValue(583, player2.mRideId, 3);
        int n5 = this.mRagdollHandle;
        player2 = player;
        int n6 = player2.mRideHandle;
        this.inheritSystemKinematics(n5, n6, n4);
        this.placeSystem(n5, 1, 8192);
        if (this.isSystemLinked(n5)) {
            this.unlinkSystem(n5);
        }
        if (n3 != 0) {
            this.pushSystem(n5, n, n2, n3);
        }
        this.setSystemActive(n5, true);
        this.setSystemVisible(n5, true);
        player.setRide(0, n5, this.createStateInfo(0));
        this.onRideChanged(player, 0, n5, n6);
        if (bl) {
            Player player3 = player;
            player3.mStateInfo[11] = this.mKeyFrame - 100;
        }
    }

    private int findMatchingTransfer(int n, int n2) {
        return this.mRideTransferTable[n][n2];
    }

    public final int evaluateCondition(int n, int n2) {
        switch (n) {
            case 7: {
                if (n2 == 255) {
                    n2 = this.mCurrentMission;
                }
                if (n2 < 19 && (GCanvas.cheatEnabled(1) || this.missionAvailable(n2))) {
                    return 1;
                }
                return -1;
            }
            case 9: {
                return 1;
            }
            case 8: {
                if (this.findNextMission(this.mCurrentMission) == this.mCurrentMission) {
                    return -1;
                }
                return 1;
            }
            case 13: {
                ArenaGame arenaGame = this;
                if (arenaGame.mIsReplay) {
                    return 1;
                }
                return -1;
            }
            case 14: {
                ArenaGame arenaGame = this;
                if (!arenaGame.mIsReplay) {
                    return 1;
                }
                return -1;
            }
            case 11: {
                ArenaGame arenaGame = this;
                if (!arenaGame.mWaitForPlayer) {
                    return 1;
                }
                return -1;
            }
            case 12: {
                return -1;
            }
            case 15: {
                if (Menu.isOptionBitSet(50, 0)) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    public void init() {
        int n;
        int n2;
        this.updateHudValues();
        this.mTextlines = new Vector();
        this.updateBloodSplash();
        int[][] nArray = this.mRideTransferTable = new int[6][6];
        for (n2 = 0; n2 < 6; ++n2) {
            for (n = 0; n < 6; ++n) {
                nArray[n2][n] = -1;
            }
        }
        n2 = RM.getHeight(584);
        n = 0;
        while (n < n2) {
            int n3 = RM.getValue(584, n, 1);
            int n4 = RM.getValue(584, n, 0);
            nArray[n4][n3] = n++;
        }
        this.mRideDisplayGlowPos = new Point2D();
        this.mMenuBackdropAchievement = -1;
        this.mSeenTutorials = RM.createBitfield(64, false);
        this.tutorialSeenReset();
        this.initViewport();
        ArenaGame.setupMenus();
        this.onInit();
    }

    private void tutorialSeenReset() {
        RM.fill(this.mSeenTutorials, 0);
        this.mSeenTutorialMission = -1;
        this.mSeenTutorialLast = -1;
    }

    public final void initGame(boolean bl) {
        this.mResumeMusicAfterInterrupt = false;
        Menu.startLoading(184);
        this.mCurrentMission = this.mPreparedMission;
        ArenaGame arenaGame = this;
        this.mLastScore = -1;
        arenaGame.mFrameCountComboScoreStartMoving = -1;
        arenaGame.mFrameCountMultiplierStartMoving = -1;
        if (this.mSeenTutorialMission != this.mCurrentMission) {
            this.tutorialSeenReset();
            this.mSeenTutorialMission = this.mCurrentMission;
        }
        this.restart(false);
        Menu.stopLoading();
    }

    public final boolean isCycleMenu(int n) {
        return false;
    }

    public final void menuCycled(int n, int n2) {
    }

    public final boolean musicShouldStop(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    public final void notify(boolean bl) {
        if (bl) {
            GCanvas.setSoftButton(8, -1);
        }
        if (bl) {
            Object object = this;
            Player player = ((ArenaGame)object).mActivePlayer;
            int n = player.mRideId;
            object = this;
            object = ((ArenaGame)object).mActivePlayer;
            object = ((Player)object).mStateInfo;
            switch (n) {
                case 5: {
                    object[14] = false;
                    return;
                }
                case 1: 
                case 2: {
                    object[14] = false;
                    object[15] = false;
                    object[19] = false;
                    object[20] = false;
                    object[18] = false;
                    object[9] = false;
                }
            }
        }
    }

    public final void onPrepareMenuChange(int n, int n2) {
        Menu.resetItemBottom();
        int n3 = GCanvas.getSoftKeyAreaTop() - 4;
        int n4 = Menu.getMenuCaptionBottom() + 4;
        if (n != 11) {
            this.mMenuBackdropAchievement = -1;
        }
        this.mScrollingTextId = -1;
        Menu.setMenuItemOverlayWith(0);
        if (n == 22) {
            Menu.setDefaultSelection(n, Menu.findMenuItem(22, 44));
        } else if (n == 5) {
            if (!Menu.isOptionBitSet(50, 0)) {
                Menu.setOptionBit(50, 0, true);
                Menu.saveOptions();
            }
            this.mInvalidatePreview = true;
            this.tutorialSeenReset();
            this.autoCameraReset();
            if (this.mMissionSelected >= 0) {
                Menu.setDefaultSelection(n, this.mMissionSelected);
            }
            this.menuNewMissionSelected();
        } else if (n == 14) {
            int[] nArray = this.mCalcVal;
            Menu.setMenuItemOverlayWith((GCanvas.getSpriteWidth(15) << 1) - 3);
            Menu.setItemBottom(nArray[36] - GCanvas.getFontHeight(1));
            Menu.setMenuCaptionOffset(nArray[35]);
            n4 = GCanvas.getFontHeight(1) + nArray[35];
            n3 = nArray[36];
            mLastSelectedItem = -1;
        } else if (n == 0) {
            this.mMenuMissionSelectReset = true;
            this.mResumeMusicAfterInterrupt = true;
            this.initMainMenu();
            if (n2 == 26) {
                Menu.saveOptions();
            }
        } else if (n == 6) {
            Menu.evaluateMenuConditions(n);
        } else if (n == 9) {
            int n5 = n;
            ArenaGame arenaGame = this;
            if (arenaGame.mMissionPassedLines == null) {
                arenaGame.mMissionPassedLines = new Vector();
                arenaGame.mMissionPassedMedalInfo = new int[10];
            }
            RM.fill(arenaGame.mMissionPassedMedalInfo, 0);
            Vector vector = arenaGame.mMissionPassedLines;
            int[] nArray = arenaGame.mMissionPassedMedalInfo;
            n5 = Math.max(Menu.getTextSpacing(5, n5), GCanvas.getSpriteHeight(15) + 1);
            int n6 = GCanvas.getWidth() - 2 * GCanvas.getSpriteWidth(15);
            vector.removeAllElements();
            Object object = arenaGame;
            Player player = ((ArenaGame)object).mActivePlayer;
            object = player;
            int n7 = player.mScore;
            Object object2 = ArenaGame.getFormattedScore(n7, 1);
            RM.setString(265, RM.t(68));
            RM.setString(267, (String)object2);
            RM.prepareVarText(12, String.valueOf(player.getLevelDamageInPercent()));
            Menu.breakLine(vector, 5, RM.t(12), n6);
            nArray[0] = 0;
            nArray[1] = vector.size() * n5;
            if (!arenaGame.isTutorialMission()) {
                if (arenaGame.mTimedMission && !arenaGame.mIsTraining) {
                    Menu.breakLine(vector, 5, RM.t(244) + ' ' + ArenaGame.timeToString(arenaGame.mTimeLeft), n6);
                    nArray[2] = arenaGame.endscreenTimeLeftGetMedal();
                    nArray[3] = vector.size() * n5;
                }
                object2 = arenaGame;
                object2 = ((ArenaGame)object2).mActivePlayer;
                RM.prepareVarText(11, String.valueOf(((Player)object2).mScoreMultiplierMax));
                Menu.breakLine(vector, 5, RM.t(241) + ' ' + RM.t(11), n6);
                nArray[4] = arenaGame.endscreenComboGetMedal();
                nArray[5] = vector.size() * n5;
                object2 = arenaGame;
                object2 = ((ArenaGame)object2).mActivePlayer;
                if (((Player)object2).mExitWasTarget) {
                    object2 = arenaGame;
                    object2 = ((ArenaGame)object2).mActivePlayer;
                    int n8 = ((Player)object2).mDistance;
                    Menu.breakLine(vector, 5, RM.t(242) + ' ' + ArenaGame.getFormattedScore(n8, 2), n6);
                    nArray[6] = arenaGame.endscreenDistanceGetMedal();
                    nArray[7] = vector.size() * n5;
                }
                if (((ArenaGame)(object2 = arenaGame)).getNumRides() - 1 > 0) {
                    ArenaGame arenaGame2 = arenaGame;
                    object2 = arenaGame2;
                    object2 = arenaGame;
                    RM.prepareVarText(4, String.valueOf(arenaGame2.mTouchedRides), String.valueOf(((ArenaGame)object2).getNumRides() - 1));
                    Menu.breakLine(vector, 5, RM.t(243) + ' ' + RM.t(4), n6);
                    nArray[8] = arenaGame.endscreenRidesGetMedal();
                    nArray[9] = vector.size() * n5;
                }
            }
        }
        this.mMenuBorderTargetTop = n4;
        this.mMenuBorderTargetBottom = n3;
        if (n != n2 || n == 25) {
            this.mMenuBorderTop = this.mMenuBorderBottom = (this.mMenuBorderTargetBottom - this.mMenuBorderTargetTop) / 2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final boolean performMenuAction(int var1_1, int var2_12) {
        switch (var1_1) {
            case 12: {
                this.mIsReplay = true;
                if (this.mPreparedMission != this.mCurrentMission) {
                    var3_13 = this.mCurrentMission;
                    var1_2 = this;
                    this.mPreparedMission = var3_13;
                }
                Menu.performMenuAction(9);
                return true;
            }
            case 16: {
                Menu.saveOptions();
                Menu.performMenuAction(8, 5);
                Menu.setSelection(this.mMissionSelected);
                return true;
            }
            case 36: {
                v0 = this.missionAvailable(var2_12);
                var1_1 = (int)v0;
                if (v0) {
                    var3_14 = var2_12;
                    var1_3 = this;
                    this.mPreparedMission = var3_14;
                    Menu.performMenuAction(10, -1);
                }
                return true;
            }
            case 11: {
                if (this.mPreparedMission != this.mCurrentMission) {
                    var3_15 = this.mCurrentMission;
                    var1_4 = this;
                    this.mPreparedMission = var3_15;
                }
            }
            case 10: {
                this.mIsReplay = false;
                Menu.performMenuAction(9);
                return true;
            }
            case 17: {
                Menu.performMenuAction(8, 5);
                this.mMissionSelected = this.findNextMission(this.mCurrentMission);
                var1_1 = RM.getLink(776, 0, this.mMissionSelected);
                Menu.setSelection(var1_1);
                Menu.refreshMenu();
                return true;
            }
            case 13: {
                var1_5 = this;
                if (var1_5.mActivePlayer.succeeded() && this.mNewHighscorePending) {
                    this.mNewHighscorePending = false;
                    Menu.performMenuAction(6, 12);
                    Menu.addLocalHighscoreCandidate();
                    return true;
                }
                var1_5 = this;
                var2_12 = RM.getHeight(775);
                for (var3_16 = 0; var3_16 < var2_12; ++var3_16) {
                    var4_19 = 1 << var3_16;
                    if ((var1_5.mMissionNewAchievements & var4_19) <= 0) continue;
                    var1_5.mMissionNewAchievements &= ~var4_19;
                    v1 = var3_16;
                    ** GOTO lbl57
                }
                v1 = var1_6 = -1;
lbl57:
                // 2 sources

                if (v1 >= 0) {
                    this.mMenuBackdropAchievement = var1_6;
                    RM.setString(271, RM.t(RM.getValue(775, var1_6, 1)));
                    RM.setString(270, RM.t(RM.getValue(775, var1_6, 0)));
                    Menu.performMenuAction(6, 11);
                    return true;
                }
                var1_6 = this.achievementsGetAvailableRides();
                var2_12 = var1_6 ^ this.mAvailableRidesBeforeMission;
                var1_7 = this;
                var3_16 = RM.getHeight(771);
                for (var4_19 = 0; var4_19 < var3_16; ++var4_19) {
                    var5_20 = var1_7.missionGetUsedRides(var4_19);
                    if ((var5_20 & var2_12) <= 0) continue;
                    var5_20 = var4_19;
                    Menu.setOptionBit(48, var5_20, true);
                }
                Menu.saveOptions();
                Menu.performMenuAction(7, 6);
                return true;
            }
            case 42: {
                this.onGameFinish();
                return true;
            }
            case 43: {
                var1_8 = this;
                this.playerFinished(var1_8.mActivePlayer, 1, false);
                return true;
            }
            case 44: {
                var1_9 = this;
                this.playerFinished(var1_9.mActivePlayer, 2, false);
                return true;
            }
            case 45: {
                var1_1 = RM.getValue(778, var2_12, 5);
                if (1 == var1_1 && (var1_1 = RM.getValue(778, var2_12, 4)) > this.mBulletTimePriority) {
                    this.mBulletTimeId = var2_12;
                    this.mBulletTimeFractionDelta = -(RM.getValue(778, var2_12, 2) * 1400 >> 10);
                    this.mBulletFadeInFinishedFrame = -1;
                    this.mBulletTimePriority = var1_1;
                }
                return true;
            }
            case 46: {
                var1_1 = 0;
                if (var2_12 >= 0) {
                    var1_1 = RM.getValue(778, var2_12, 5);
                }
                if (var2_12 == this.mBulletTimeId && 1 == var1_1 || var2_12 < 0) {
                    this.mBulletTimeFractionDelta = RM.getValue(778, this.mBulletTimeId, 3) * 1400 >> 10;
                    this.mBulletTimePriority = -1;
                }
                return true;
            }
            case 47: {
                var3_17 = false;
                var1_10 = this;
                this.mIsTraining = var3_17;
                ArenaGame.changeToMissionSelectMenu(var2_12, true);
                return true;
            }
            case 48: {
                var3_18 = true;
                var1_11 = this;
                this.mIsTraining = var3_18;
                ArenaGame.changeToMissionSelectMenu(var2_12, false);
                return true;
            }
        }
        return false;
    }

    public final void prepareSounds$5d940954(Sound sound) {
        sound.prepare(60, false);
        sound.prepare(59, false);
        sound.prepare(57, false);
        sound.prepare(58, false);
        sound.prepare(54, false);
        sound.prepare(55, false);
        sound.prepare(56, false);
        sound.prepare(61, false);
        sound.prepare(62, false);
        sound.prepare(63, false);
    }

    private static void changeToMissionSelectMenu(int n, boolean n2) {
        if (!Menu.isOptionBitSet(50, 0)) {
            n2 = Menu.getMenuItemCount(4);
            for (int i = 0; i < n2; ++i) {
                Menu.setMenuItemTarget(4, i, n);
            }
            Menu.performMenuAction(6, 4);
            return;
        }
        Menu.changeMenu(n, n2 != 0);
    }

    public final void restart(boolean bl) {
        int n;
        if (bl) {
            Menu.startLoading(184);
        }
        this.autoCameraReset();
        ArenaGame arenaGame = this;
        if (arenaGame.mScreenMessages == null) {
            arenaGame.mScreenMessages = new int[5][4];
        }
        for (n = 0; n < 5; ++n) {
            arenaGame.mScreenMessages[n][0] = -1;
        }
        this.initLevelFlyby();
        this.addScreenMessage(261, Integer.MAX_VALUE, 2);
        this.mNewRideDisplayFramesLeft = -1;
        this.mTouchedRides = 0;
        this.mWaitForPlayer = true;
        this.mFrame = 0;
        this.mKeyFrame = 0;
        this.mGameFinishedCountdown = -1;
        this.mCamShakeFrames = -1;
        this.mDeathCheckNextFreeRide = -1;
        this.mDeathCheckDelayStart = -1;
        this.mDeathCheckLastLevelDamage = 0;
        this.mBulletTimeFractionDelta = 0;
        this.mBulletTimeFraction = 1400;
        this.mBulletTimeAccu = 1024;
        this.mBulletTimePriority = -1;
        this.mPopupTutorialDelay = -1;
        this.mPopupTutorialText = -1;
        if (bl && mTutorialCondition >= 0 && mTutorialConditionLastTutorialIdx >= 0) {
            this.setTutorialVisible(mTutorialConditionLastTutorialIdx);
        }
        mTutorialCondition = -1;
        mTutorialConditionLastTutorialIdx = -1;
        this.mLastNumRidesValue = -1;
        this.mLastIngameText = -1;
        this.mSeenTutorialLast = -1;
        this.mLastRingTrigger = -1;
        this.mRingScorePossible = 1;
        this.mLastRingTrigger = -1;
        this.mCurrentMove = -1;
        this.mSectorsTouched = RM.createBitfield(8, false);
        this.mBackwardsDistance = 0;
        this.mBulletFadeInFinishedFrame = -1;
        this.mBulletTimePriority = -1;
        this.mLastFrameWithLogicsound = -1;
        this.mMissionNewAchievements = 0;
        this.mTimeLeft = RM.getValue(771, this.mCurrentMission, 22) * 1000;
        this.mTimedMission = this.mTimeLeft > 0;
        this.mKeyshakeFrames = new int[128];
        this.mAvailableRidesBeforeMission = this.achievementsGetAvailableRides();
        Menu.setOptionBit(46, this.mCurrentMission, true);
        Menu.setOptionBit(48, this.mCurrentMission, false);
        this.initMissionData(this.mCurrentMission);
        int n2 = this.getNumRides();
        this.mRideCenters = new Point2D[n2];
        for (n = 0; n < n2; ++n) {
            this.mRideCenters[n] = new Point2D();
        }
        this.updateRideCenters();
        Object object = this;
        object = ((ArenaGame)object).mActivePlayer;
        if (((Player)object).mRideId == 3) {
            object = this;
            object = ((ArenaGame)object).mActivePlayer;
            n = ((Player)object).mRideHandle;
            object = this;
            ((ArenaGame)object).mActivePlayer.setRide(0, this.mRagdollHandle, this.createStateInfo(0));
            object = Point2D.getLocal();
            ((Point2D)object).set(this.mRideCenters[n]);
            this.moveSystemTo(this.mRagdollHandle, (Point2D)object);
            Point2D.freeLocal((Point2D)object);
            object = this;
            this.onRideChanged(((ArenaGame)object).mActivePlayer, 0, this.mRagdollHandle, -1);
            this.setSystemActive(this.mRagdollHandle, true);
            this.setSystemVisible(this.mRagdollHandle, true);
            object = this;
            this.doTransfer(((ArenaGame)object).mActivePlayer, n);
        } else {
            ArenaGame arenaGame2 = this;
            object = arenaGame2;
            object = this;
            Player player = ((ArenaGame)object).mActivePlayer;
            object = player;
            object = this;
            object = ((ArenaGame)object).mActivePlayer;
            this.onRideChanged(arenaGame2.mActivePlayer, player.mRideId, ((Player)object).mRideHandle, -1);
        }
        object = this;
        object = ((ArenaGame)object).mActivePlayer;
        this.setSystemActive(((Player)object).mRideHandle, true);
        this.doRestart();
        Menu.saveOptions();
        if (bl) {
            Menu.stopLoading();
        }
    }

    public final void setOptionDefaults() {
        Menu.setOption(8, 1);
        Menu.setOption(41, -1);
    }

    public final long getDesiredFrameTime() {
        return 42L;
    }

    private void updateBloodSplash() {
        int n = GCanvas.getWidth();
        int n2 = GCanvas.getHeight() - this.mCalcVal[34];
        if (n != this.mBloodSplashWidth || n2 != this.mBloodSplashHeight) {
            if (mBloodSplash != null) {
                mBloodSplash = null;
                System.gc();
            }
            mBloodSplash = new int[n * n2];
            this.mBloodSplashHeight = n2;
            this.mBloodSplashWidth = n;
            int n3 = n >> 1;
            int n4 = n2 >> 1;
            int n5 = Math.min(n3, n4);
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                int n7 = (i - n4 << 10) / n5;
                n7 = n7 * n7 >> 10;
                for (int j = 0; j < n; ++j) {
                    int n8 = (j - n3 << 10) / n5;
                    if ((n8 = (n8 = GCanvas.sqrt((n8 * n8 >> 10) + n7)) > 512 ? (n8 - 512) * 331 >> 10 : 0) > 255) {
                        n8 = 255;
                    }
                    ArenaGame.mBloodSplash[n6++] = 0xFF0000 | n8 << 24;
                }
            }
        }
    }

    public final void screenSizeChanged() {
        this.updateBloodSplash();
        this.mMenuBorderBottom = this.mMenuBorderTargetBottom = GCanvas.getSoftKeyAreaTop() - 4;
        this.mMenuBorderTop = this.mMenuBorderTargetTop = Menu.getMenuCaptionBottom() + 4;
        this.initViewport();
        this.updateHudValues();
        this.mLastMissionName = null;
    }

    private void updateHudValues() {
        if (this.mCalcVal == null) {
            this.mCalcVal = new int[43];
        }
        ArenaGame arenaGame = this;
        int n = GCanvas.getWidth();
        int[] nArray = arenaGame.mCalcVal;
        arenaGame.mCalcVal[19] = n >> 1;
        nArray[20] = 18;
        nArray[4] = nArray[19];
        nArray[5] = nArray[20];
        nArray[2] = nArray[19] - 3 - 36;
        nArray[3] = nArray[20];
        nArray[6] = nArray[19] + 3 + 36;
        nArray[7] = nArray[20];
        int n2 = nArray[20] + 3 + 31;
        nArray[10] = nArray[19];
        nArray[11] = n2;
        nArray[8] = nArray[19] - 3 - 36;
        nArray[9] = n2;
        nArray[12] = nArray[19] + 3 + 36;
        nArray[13] = n2;
        nArray[14] = nArray[2] - 18 >> 1;
        nArray[15] = 16;
        Object object = this;
        n = GCanvas.getWidth();
        int n3 = GCanvas.getHeight();
        object = ((ArenaGame)object).mCalcVal;
        ((ArenaGame)object).mCalcVal[29] = n >> 1;
        object[30] = n3 - 12;
        object[27] = n >> 1;
        object[28] = n3 - 38;
        object[25] = n >> 1;
        object[26] = n3 >> 1;
        object[21] = n * 97 / 100;
        object[22] = n3 - 44;
        object[23] = object[21];
        object[24] = object[22] - GCanvas.getFontHeight(7);
        object[31] = n >> 1;
        object[32] = n3;
        object[16] = n - object[14];
        object[17] = 0 + n3 * 3 / 100;
        object[18] = 17;
        object[34] = 32;
        object[36] = n3 - n3 / 3;
        object[35] = n3 / 8;
        object[37] = n;
        object[38] = n3 * 90 / 100;
        object[39] = n * 95 / 100;
        object[40] = -(GCanvas.getFontHeight(7) + 8 + 24);
        object = this;
        int[] nArray2 = ((ArenaGame)object).mCalcVal;
        nArray2[41] = GCanvas.isLandscape() ? 21 : 80;
        nArray2[42] = GCanvas.getSoftKeyAreaTop() - 32 - GCanvas.getFontHeight(5);
    }

    private static void drawTileRow(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        n = GCanvas.getWidth();
        int n6 = n5 = RM.getWidth(33);
        n2 = n4 - n2 * n6;
        GCanvas.pushClip(graphics);
        if (GCanvas.clipRect(graphics, n3, n4, n - n3, n6)) {
            while (n3 < n) {
                GCanvas.drawImage(graphics, 33, n3, n2);
                n3 += n5;
            }
        }
        GCanvas.popClip(graphics);
    }

    private int getMedalWidth(int n, int n2, int n3) {
        if ((n = ArenaGame.getMissionRank(n, n3)) > 0) {
            return 3 * GCanvas.getSpriteWidth(15) + GCanvas.getStringWidth(RM.t(n2), 5);
        }
        return 0;
    }

    private static int getMissionRank(int n, int n2) {
        boolean bl = Menu.isOptionBitSet((n2 *= 2) + 27, n);
        if (bl) {
            return 1;
        }
        bl = Menu.isOptionBitSet(n2 + 19, n);
        if (bl) {
            return 2;
        }
        boolean bl2 = Menu.isOptionBitSet(n2 + 11, n);
        n = bl2 ? 1 : 0;
        if (bl2) {
            return 3;
        }
        return 0;
    }

    private static String getFormattedScore(int n, int n2) {
        String string = null;
        block0 : switch (n2) {
            case 0: {
                if (n < 0) {
                    string = RM.t(288);
                    break;
                }
                string = RM.tts(n * 60);
                break;
            }
            case 1: {
                string = String.valueOf(n);
                break;
            }
            case 3: {
                switch (n) {
                    case 1: {
                        string = RM.t(72);
                        break block0;
                    }
                    case 2: {
                        string = RM.t(71);
                        break block0;
                    }
                    case 3: {
                        string = RM.t(70);
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                n2 = n * 100 >> 10;
                String string2 = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
                RM.prepareVarText(16, String.valueOf(n >> 10), string2);
                string = RM.t(16);
            }
        }
        return string;
    }

    private final int findNextMission(int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = RM.getHeight(776);
        for (int i = 0; i < n4; ++i) {
            if (RM.getValue(776, i, 3) != n || this.evaluateCondition(7, i) <= 0) continue;
            int n5 = RM.getValue(776, i, 4);
            if (n5 == 0 || n5 == 2 || n5 < 0) {
                n2 = i;
                continue;
            }
            if (n5 != 1 && n5 >= 0) continue;
            n3 = i;
        }
        Object object = this;
        object = ((ArenaGame)object).mActivePlayer;
        if (((Player)object).mFinished == 2 && n3 >= 0) {
            return n3;
        }
        if (n2 >= 0) {
            return n2;
        }
        if (n3 >= 0) {
            return n3;
        }
        return this.mCurrentMission;
    }

    private static void setupMenus() {
        int n = RM.getHeight(771);
        for (int i = 0; i < n; ++i) {
            int n2 = RM.getValue(771, i, 0);
            Menu.addMenuItem(5, n2, 36, i, 0);
        }
    }

    public final void onGameReset() {
        this.mMissionSelected = 0;
        Menu.setOption(44, 0);
        Menu.saveOptions();
    }

    private final void onGameFinish() {
        ArenaGame arenaGame = this;
        Object object = arenaGame;
        Player player = arenaGame.mActivePlayer;
        if (player.succeeded()) {
            if (!arenaGame.mIsTraining) {
                arenaGame.mNewHighscorePending = false;
                if (!arenaGame.isTutorialMission()) {
                    object = player;
                    arenaGame.mNewHighscorePending = Menu.prepareHighscoreEntry(arenaGame.mCurrentMission, ((Player)object).mScore, null, 1);
                }
                arenaGame.setMissionRank(arenaGame.mCurrentMission, arenaGame.endscreenComboGetMedal(), 0);
                object = player;
                if (((Player)object).mExitWasTarget) {
                    arenaGame.setMissionRank(arenaGame.mCurrentMission, arenaGame.endscreenDistanceGetMedal(), 1);
                }
                if (((ArenaGame)(object = arenaGame)).getNumRides() - 1 > 0) {
                    arenaGame.setMissionRank(arenaGame.mCurrentMission, arenaGame.endscreenRidesGetMedal(), 2);
                }
                if (arenaGame.mTimedMission) {
                    arenaGame.setMissionRank(arenaGame.mCurrentMission, arenaGame.endscreenTimeLeftGetMedal(), 3);
                }
                object = player;
                switch (((Player)object).mFinished) {
                    case 1: {
                        Menu.setOptionBit(35, arenaGame.mCurrentMission, true);
                        break;
                    }
                    case 2: {
                        Menu.setOptionBit(37, arenaGame.mCurrentMission, true);
                    }
                }
                object = arenaGame;
                if (arenaGame.mActivePlayer.succeeded()) {
                    int n;
                    Object object2;
                    if (RM.getValue(771, arenaGame.mCurrentMission, 0) == 199) {
                        arenaGame.achievementsSet(0);
                    }
                    if (RM.getValue(771, arenaGame.mCurrentMission, 0) == 203) {
                        arenaGame.achievementsSet(1);
                    }
                    if (RM.getValue(771, arenaGame.mCurrentMission, 0) == 205) {
                        arenaGame.achievementsSet(2);
                    }
                    object = arenaGame;
                    object = ((ArenaGame)object).mActivePlayer;
                    if (((Player)object).mFinished == 1 && RM.getValue(771, arenaGame.mCurrentMission, 0) == 201) {
                        arenaGame.achievementsSet(3);
                    }
                    object = arenaGame;
                    object = object2 = ((ArenaGame)object).mActivePlayer;
                    Menu.setOption(38, Menu.getOption(38) + ((Player)object).mDamageDuringLevel);
                    if (Menu.getOption(38) > 2000) {
                        ((Player)object2).mGame.achievementsSet(4);
                    }
                    object = arenaGame;
                    object2 = ((ArenaGame)object).mActivePlayer;
                    int n2 = Menu.getOption(39);
                    Menu.setOption(39, n2 += ((Player)object2).mPassedFireRings);
                    if (n2 >= 69) {
                        ((Player)object2).mGame.achievementsSet(5);
                    }
                    object2 = arenaGame;
                    n2 = RM.getHeight(771);
                    boolean bl = true;
                    for (n = 0; n < n2; ++n) {
                        if (Menu.isOptionBitSet(35, n) || Menu.isOptionBitSet(37, n)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        ((ArenaGame)object2).achievementsSet(11);
                    }
                    object2 = arenaGame;
                    n2 = RM.getHeight(771);
                    bl = true;
                    for (n = 0; n < n2; ++n) {
                        if (!((ArenaGame)object2).missionHasTargetZone(n) || n < 4 || Menu.isOptionBitSet(29, n)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        ((ArenaGame)object2).achievementsSet(12);
                    }
                }
            }
            Menu.setDefaultSelection(6, Menu.findMenuItem(6, 249));
        } else {
            Menu.setDefaultSelection(6, Menu.findMenuItem(6, 248));
        }
        Player player2 = player;
        int n = player2.mFinished;
        Menu.saveOptions();
        switch (n) {
            case 0: {
                RM.setString(290, RM.t(125));
                Menu.changeMenu(10, true);
                return;
            }
            case 4: {
                RM.setString(290, RM.t(126));
                Menu.changeMenu(10, true);
                return;
            }
            case 1: 
            case 2: {
                int n3 = 9;
                ArenaGame arenaGame2 = this;
                int n4 = 2;
                if (!Menu.isOptionBitSet(50, 2)) {
                    Menu.showMessage(RM.t(256), RM.t(85), 0, -1, 9);
                    n4 = 2;
                    Menu.setOptionBit(50, 2, true);
                    Menu.saveOptions();
                    break;
                }
                Menu.changeMenu(9, false);
                return;
            }
            case 3: {
                n = RM.getValue(579, mTutorialCondition, 0);
                RM.setString(290, RM.t(n));
                Menu.changeMenu(10, false);
            }
        }
    }

    private int endscreenGetMedal(int n, int n2, int n3, int n4, int n5) {
        if (this.isTutorialMission()) {
            return 0;
        }
        if (n * n5 < n2 * n5) {
            return 0;
        }
        if (n * n5 < n3 * n5) {
            return 3;
        }
        if (n * n5 < n4 * n5) {
            return 2;
        }
        return 1;
    }

    private int endscreenComboGetMedal() {
        int n = RM.getValue(771, this.mCurrentMission, 12);
        int n2 = RM.getValue(771, this.mCurrentMission, 11);
        int n3 = RM.getValue(771, this.mCurrentMission, 10);
        Object object = this;
        object = ((ArenaGame)object).mActivePlayer;
        return this.endscreenGetMedal(((Player)object).mScoreMultiplierMax, n, n2, n3, 1);
    }

    private int endscreenDistanceGetMedal() {
        int n = RM.getValue(771, this.mCurrentMission, 15);
        int n2 = RM.getValue(771, this.mCurrentMission, 14);
        int n3 = RM.getValue(771, this.mCurrentMission, 13);
        Object object = this;
        object = ((ArenaGame)object).mActivePlayer;
        return this.endscreenGetMedal(((Player)object).mDistance, n, n2, n3, -1);
    }

    private int endscreenRidesGetMedal() {
        int n = RM.getValue(771, this.mCurrentMission, 18);
        int n2 = RM.getValue(771, this.mCurrentMission, 17);
        int n3 = RM.getValue(771, this.mCurrentMission, 16);
        ArenaGame arenaGame = this;
        return this.endscreenGetMedal(arenaGame.mTouchedRides, n, n2, n3, 1);
    }

    private int endscreenTimeLeftGetMedal() {
        int n = RM.getValue(771, this.mCurrentMission, 21);
        int n2 = RM.getValue(771, this.mCurrentMission, 20);
        int n3 = RM.getValue(771, this.mCurrentMission, 19);
        return this.endscreenGetMedal(this.mTimeLeft, n, n2, n3, 1);
    }

    private final void setMissionRank(int n, int n2, int n3) {
        int n4 = ArenaGame.getMissionRank(n, n3);
        n3 *= 2;
        if (n2 != 0 && (n2 < n4 || n4 == 0)) {
            switch (n2) {
                case 3: {
                    Menu.setOptionBit(n3 + 11, n, true);
                    return;
                }
                case 2: {
                    Menu.setOptionBit(n3 + 11, n, false);
                    Menu.setOptionBit(n3 + 19, n, true);
                    return;
                }
                case 1: {
                    Menu.setOptionBit(n3 + 11, n, false);
                    Menu.setOptionBit(n3 + 19, n, false);
                    Menu.setOptionBit(n3 + 27, n, true);
                }
            }
        }
    }

    public final int[] createStateInfo(int n) {
        int[] nArray = new int[RM.getValue(583, n, 4)];
        ArenaGame.resetLastDefinitionsStateInfo(nArray);
        return nArray;
    }

    public static void resetLastDefinitionsStateInfo(int[] nArray) {
        nArray[7] = -1;
        nArray[6] = -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void playerFinished(Player player, int n, boolean bl) {
        Object object = this;
        Object object2 = ((ArenaGame)object).mActivePlayer;
        if (((Player)object2).mRideId == 0 && n == 0) {
            n = this.checkIfRagdollIsInTargetRange$2eb89048(n);
        }
        if (!bl && n == 0) {
            if (this.mDeathCheckDelayStart == -1) {
                this.mDeathCheckDelayStart = this.mFrame;
                object = player;
                if (((Player)object).mDamageDuringLevel < 20) {
                    player.addDamage(20);
                }
                Point2D point2D = Point2D.getLocal();
                this.getRidePosition(point2D);
                n = 20000;
                object2 = point2D;
                ArenaGame arenaGame = this;
                object = Point2D.getLocal();
                long l = 20000 * 20000;
                long l2 = Long.MAX_VALUE;
                int n2 = -1;
                int n3 = arenaGame.getNumRides() - 1;
                for (int i = 0; i < n3; ++i) {
                    long l3;
                    long l4;
                    long l5;
                    ((Point2D)object).set(arenaGame.mRideCenters[i]);
                    boolean bl2 = arenaGame.mRideDatas[i][4] != 0;
                    byte by = arenaGame.mRideDatas[i][0];
                    if (bl2 && by != 5 || (l5 = (l4 = (long)(((Point2D)object).x - ((Point2D)object2).x)) * l4 + (l3 = (long)(2 * (((Point2D)object).y - ((Point2D)object2).y))) * l3 >> 10) > l || l5 >= l2) continue;
                    n2 = i;
                    l2 = l5;
                }
                Point2D.freeLocal((Point2D)object);
                this.mDeathCheckNextFreeRide = n2;
                player.scoreComboImmediateBreak();
                Point2D.freeLocal(point2D);
            }
            return;
        }
        if (n == 1 || n == 2) {
            this.sfxPlayLogicSound(5);
            object = this;
            boolean bl3 = false;
            object = ((ArenaGame)object).mActivePlayer;
            ((ArenaGame)object).mActivePlayer.mScoreComboDisableBreak = false;
        } else {
            this.sfxPlayLogicSound(6);
        }
        this.removeScreenMessage(179);
        if (this.mPopupTutorialText == -1) {
            void var3_13;
            int n4 = 157;
            switch (n) {
                case 3: {
                    int n5 = 157;
                    break;
                }
                case 0: {
                    int n6 = 58;
                    break;
                }
                case 1: {
                    int n7 = 159;
                    break;
                }
                case 2: {
                    int n8 = 160;
                    break;
                }
                case 4: {
                    int n9 = 158;
                }
            }
            this.addScreenMessage((int)var3_13, 20, 2);
        }
        if (this.mGameFinishedCountdown < 0) {
            this.mGameFinishedCountdown = 30;
            if (n == 0) {
                this.autoCameraInit(3);
            } else {
                this.autoCameraInit(1);
            }
        }
        int n10 = n;
        Object object3 = player;
        player.mFinished = n10;
        object = object3;
        if (((Player)object).mScoreCombo > 0 && (n10 == 1 || n10 == 2)) {
            ((Player)object3).scoreComboImmediateBreak();
            int n11 = 20;
            object3 = ((Player)object3).mGame;
            ((ArenaGame)object3).mGameFinishedCountdown += 20;
        }
    }

    public final boolean hasCarAidTimedOut() {
        Object object = this;
        object = ((ArenaGame)object).mActivePlayer;
        if (((Player)object).mRideId != 1) {
            object = this;
            object = ((ArenaGame)object).mActivePlayer;
            if (((Player)object).mRideId != 2) {
                return true;
            }
        }
        object = this;
        object = ((ArenaGame)object).mActivePlayer;
        int n = ((Player)object).mStateInfo[22];
        return this.mKeyFrame > n + 20 && n != -1;
    }

    public final Player getActivePlayer() {
        return this.mActivePlayer;
    }

    public final int getActiveRideId() {
        Player player = this.mActivePlayer;
        return player.mRideId;
    }

    public final int getActiveRideHandle() {
        Player player = this.mActivePlayer;
        return player.mRideHandle;
    }

    private void initCamShake(int n, boolean bl, boolean bl2) {
        this.mCamShakeFramesMax = this.mCamShakeFrames = RM.getValue(791, n, 0);
        this.mCamShakeOffsetMax = RM.getValue(791, n, 1);
        if ((n = RM.getValue(791, n, 2)) >= 0) {
            this.sfxPlayLogicSound(n);
        }
        this.mDrawShake |= bl;
        this.mDrawBlood |= bl2;
    }

    public final void explosion$18041f15(Point2D point2D, int n, int n2) {
        this.setRagdollOnFire();
        Point2D point2D2 = Point2D.getLocal();
        Point2D point2D3 = Point2D.getLocal();
        Point2D point2D4 = Point2D.getLocal();
        this.getRideVelocity(point2D3);
        point2D2.set(point2D3.x << 8 >> 10, n);
        Point2D point2D5 = Point2D.getLocal();
        Point2D point2D6 = Point2D.getLocal();
        this.getRideCenter(point2D6);
        point2D4.set(point2D);
        point2D4.sub(point2D6);
        int n3 = (int)((98304L - (long)point2D4.length() << 10) / 98304L);
        n3 = GCanvas.clamp(n3, 0, 1024);
        n3 = n3 << 5 >> 10;
        point2D3.set(point2D2);
        point2D3.add(point2D6);
        point2D5.setRotation(n3);
        Point2D point2D7 = Point2D.getLocal();
        this.getRideOrientation(point2D7);
        point2D5.append(point2D7);
        Point2D.freeLocal(point2D7);
        this.setRideKinematics(point2D3, point2D5);
        Point2D.freeLocal(point2D6);
        Point2D.freeLocal(point2D5);
        Point2D.freeLocal(point2D4);
        Point2D.freeLocal(point2D3);
        Point2D.freeLocal(point2D2);
        if (n2 >= 0) {
            this.initCamShake(n2, true, false);
        }
    }

    public final void setRagdollOnFire() {
        this.setOnFire(this.mRagdollHandle);
    }

    public final void setOnFire(int n) {
        this.mRideDatas[n][7] = 48;
    }

    public final boolean isRagdollBurning() {
        int n = this.mRagdollHandle;
        ArenaGame arenaGame = this;
        return arenaGame.mRideDatas[n][7] > 0 || arenaGame.mRideDatas[n][6] > 0;
    }

    private byte[] getRideData() {
        return this.mRideDatas[this.getActiveRideHandle()];
    }

    private void getRideCenter(Point2D point2D) {
        this.getRideCenter(this.getActiveRideHandle(), point2D);
    }

    private void getRidePosition(int n, Point2D point2D) {
        this.getRidePosition(this.getActiveRideHandle(), n, point2D);
    }

    private void sfxPlayLogicSound(int n) {
        int n2 = RM.getValue(65, n, 2);
        if (n2 != 1 && this.mLastFrameWithLogicsound >= 0 && this.mFrame - this.mLastFrameWithLogicsound < 10) {
            return;
        }
        this.mLastFrameWithLogicsound = this.mFrame;
        n2 = RM.getValue(65, n, 0);
        n = RM.getValue(65, n, 1);
        if (n2 >= 0) {
            Menu.playSound(n2);
        }
        if (n != 0) {
            RM.getValue(64, n);
        }
    }

    public final boolean doRagdollCrash(int n) {
        boolean bl;
        boolean bl2 = false;
        if (n > 2500) {
            bl2 = true;
            Object object = this;
            object = ((ArenaGame)object).mActivePlayer;
            object = ((Player)object).mStateInfo;
            bl = false;
            object[12] = this.mKeyFrame - 10;
            object[11] = this.mKeyFrame - 90;
        }
        boolean bl3 = n > 2500;
        boolean bl4 = bl = n > 3000;
        if (bl3 || bl) {
            this.initCamShake(0, bl3, bl);
        }
        return bl2;
    }

    public final boolean isRideHeadDown() {
        boolean bl = false;
        Point2D point2D = Point2D.getLocal();
        this.getRideOrientation(point2D);
        if (point2D.x < 0) {
            bl = true;
        }
        Point2D.freeLocal(point2D);
        return bl;
    }

    public final boolean checkRideCrash(int n, int n2, boolean n3, boolean bl) {
        boolean bl2 = false;
        if (n3 != 0 && (n3 = RM.getValue(583, n2, 12)) >= 0 && n >= n3) {
            bl2 = true;
        }
        if (bl && (n3 = RM.getValue(583, n2, 11)) >= 0 && n >= n3) {
            bl2 = true;
        }
        if ((n3 = n > 2500 ? 1 : 0) != 0) {
            this.initCamShake(0, n3 != 0, bl2);
        }
        if (bl2) {
            ArenaGame arenaGame = this;
            arenaGame.mActivePlayer.addDamage(100);
        }
        return bl2;
    }

    private static final void drawDebugType(Graphics graphics) {
        if (GCanvas.cheatEnabled(3)) {
            graphics.setColor(0);
            int n = GCanvas.getStringWidth("Game-Designer", 0) + 2;
            graphics.fillRect(0, 0, n, GCanvas.getFontHeight(0));
            graphics.setColor(-1);
            graphics.drawString("Game-Designer", 1, 0, 0);
        }
    }

    public final boolean getCustomMenuItemPosition$1c96c319(int[] nArray, int n) {
        if (n == 2) {
            GCanvas.getGlobalFrameCount();
            if (!false) {
                nArray[0] = nArray[0] + GCanvas.getRandom(-2, 2);
                nArray[1] = nArray[1] + GCanvas.getRandom(-1, 1);
            }
            return true;
        }
        return false;
    }

    private static boolean getMTNodePosition(int n, Point2D point2D) {
        if ((n = RM.getLink(777, 0, n)) >= 0) {
            point2D.setFromResource(777, n, 1);
            point2D.scale(1024);
            point2D.x <<= 10;
            point2D.y <<= 10;
            return true;
        }
        return false;
    }

    public final void achievementsSet(int n) {
        if (!this.mIsTraining && !ArenaGame.achievementsIsSet(n)) {
            int n2 = RM.getValue(775, n, 0);
            this.addScreenMessage(n2, 40, 0);
            RM.prepareVarText(6, RM.t(n2));
            this.mMissionNewAchievements |= 1 << n;
            Menu.setOptionBit(44, n, true);
        }
    }

    private static boolean achievementsIsSet(int n) {
        if (GCanvas.cheatEnabled(-1) || GCanvas.cheatEnabled(1)) {
            return true;
        }
        if (GCanvas.cheatEnabled(-1) && (n & 1) == 0) {
            return true;
        }
        return Menu.isOptionBitSet(44, n);
    }

    public final boolean achievementsIsRideAvailable(int n) {
        switch (n) {
            case 5: {
                return ArenaGame.achievementsIsSet(0);
            }
            case 4: {
                return ArenaGame.achievementsIsSet(1);
            }
            case 3: {
                return ArenaGame.achievementsIsSet(2);
            }
            case 2: {
                return ArenaGame.achievementsIsSet(3);
            }
        }
        return true;
    }

    private int achievementsGetAvailableRides() {
        int n = RM.getHeight(583);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.achievementsIsRideAvailable(i)) continue;
            n2 |= 1 << i;
        }
        return n2;
    }

    public final int getNumValidSpawns(int n) {
        int n2 = 0;
        for (int i = 0; i < RM.getHeight(n); ++i) {
            int n3 = RM.getValue(n, i, 0);
            if (!this.achievementsIsRideAvailable(n3 = RM.getValue(587, n3, 0))) continue;
            ++n2;
        }
        return n2;
    }

    private boolean missionAvailable(int n) {
        if (GCanvas.cheatEnabled(1)) {
            return true;
        }
        n = RM.getLink(776, 0, n);
        boolean bl = false;
        if (n >= 0) {
            bl = true;
            int n2 = RM.getValue(776, n, 3);
            int n3 = RM.getValue(776, n, 4);
            n = RM.getValue(776, n, 5);
            if (n2 >= 0) {
                switch (n3) {
                    case 1: {
                        bl = true & Menu.isOptionBitSet(37, n2);
                        break;
                    }
                    case 0: {
                        bl = true & Menu.isOptionBitSet(35, n2);
                        break;
                    }
                    case 2: {
                        bl = true & (Menu.isOptionBitSet(37, n2) | Menu.isOptionBitSet(35, n2));
                    }
                }
            }
            if (n > 0) {
                n2 = RM.getHeight(775);
                for (n3 = 0; n3 < n2 && bl; ++n3) {
                    if ((n & 1 << n3) == 0) continue;
                    bl &= ArenaGame.achievementsIsSet(n3);
                }
            }
        }
        return bl;
    }

    protected abstract int missionGetUsedRides(int var1);

    private void menuNewMissionSelected() {
        this.mMenuSwipePercentage = 100;
        if (!this.missionAvailable(this.mMissionSelected)) {
            int n = this.mMissionSelected;
            int n2 = RM.getLinkedValue(776, 0, n, 3);
            n = this.mMissionSelected;
            n = RM.getLinkedValue(776, 0, n, 4);
            if (n2 != -1 && n != -1) {
                n = n == 0 ? 7 : 8;
                n2 = RM.getValue(771, n2, 0);
                RM.prepareVarText(n, RM.t(n2));
                this.scrollTextInit(n, GCanvas.getSoftKeyAreaTop() + this.mCalcVal[42] >> 1);
            }
            return;
        }
        int n = this.mMissionSelected;
        ArenaGame arenaGame = this;
        n = arenaGame.getMedalWidth(n, 241, 0) + arenaGame.getMedalWidth(n, 243, 2) + arenaGame.getMedalWidth(n, 242, 1) + arenaGame.getMedalWidth(n, 244, 3);
        int n3 = GCanvas.getSoftKeyAreaTop() + arenaGame.mCalcVal[42] >> 1;
        int n4 = n;
        ArenaGame arenaGame2 = arenaGame;
        arenaGame.mScrollingTextId = -2;
        arenaGame2.mScrollingTextWidth = n4 - Menu.getTextWidth();
        arenaGame2.mScrollingTextX = 2;
        arenaGame2.mScrollingTextY = n3;
        arenaGame2.mScrollingTextSpeed = 4;
        arenaGame2.mScrollingTextWait = 6;
    }

    private void scrollTextInit(int n, int n2) {
        this.mScrollingTextId = n;
        this.mScrollingTextWidth = GCanvas.getStringWidth(RM.t(this.mScrollingTextId), 5) - Menu.getTextWidth();
        this.mScrollingTextX = 2;
        this.mScrollingTextY = n2;
        this.mScrollingTextSpeed = 4;
        this.mScrollingTextWait = 6;
    }

    public final boolean resumeMusicAfterInterrupt() {
        if (Menu.getMode() == 0) {
            if (Menu.getSplashMode() > 7) {
                return Menu.getOption(0) > 0;
            }
            return false;
        }
        return this.mResumeMusicAfterInterrupt;
    }

    private boolean isTutorialMission() {
        return this.mCurrentMission < 4;
    }

    public abstract /* synthetic */ int updateSoftButtonState(int var1);

    static {
        mTutorialCondition = -1;
        mTutorialConditionLastTutorialIdx = -1;
        timeValues = new String[3];
        mLastSelectedItem = -1;
        tmpDst = new Point2D();
    }
}

