/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.render3d;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import tinbrain.RM;
import tinbrain.math3d.Matrix33;
import tinbrain.math3d.Point3D;
import tinbrain.math3d.VCamera;
import tinbrain.render3d.AbstractSceneObject;
import tinbrain.render3d.AbstractTriangleBuffer;
import tinbrain.render3d.ParticleSystem3D;
import tinbrain.render3d.SceneDesc;
import tinbrain.render3d.SceneObject;

public abstract class AbstractRenderer {
    public int left;
    public int top;
    public int width;
    public int height;
    private int currentFrame;
    private Vector scenes = new Vector();
    private int particleScene = -1;
    private int backgroundScene = -1;
    private int backgroundData = -1;
    private int background;
    private ParticleSystem3D particleSystem$2cea9fce;
    public Graphics boundGraphics;
    public VCamera camera;
    private int lodHint;
    public int objectDefinitions;
    public int[] pointSpriteDefinitions;

    protected abstract void clearColorBuffer(int var1);

    protected abstract void onCameraChanged();

    protected abstract void drawObject$10ad83a4(int var1, Matrix33 var2, Point3D var3, Point3D var4, int var5);

    protected abstract void drawTriangleBuffer(AbstractTriangleBuffer var1);

    public final int addAnimatedScene(int n, int n2, int n3, int n4) {
        SceneObject[] sceneObjectArray = this.createSceneDesc(n, 1, 0);
        sceneObjectArray.sceneflags |= 1;
        n2 = this.scenes.size();
        this.scenes.addElement(sceneObjectArray);
        n3 = sceneObjectArray.numObjects;
        sceneObjectArray = sceneObjectArray.objects;
        for (n4 = 0; n4 < n3; ++n4) {
            int n5;
            Object object = sceneObjectArray[n4];
            if (object == null || (n5 = RM.getLink(531, 0, ((AbstractSceneObject)object).obj)) < 0) continue;
            int[] nArray = new int[3];
            ((SceneObject)object).animInfo = nArray;
            object = nArray;
            nArray[0] = RM.getValue(531, n5, 1);
            object[1] = RM.getValue(531, n5, 2);
            object[2] = RM.getValue(531, n5, 3);
        }
        return n2;
    }

    private boolean testFrustum(SceneObject sceneObject, int n) {
        Point3D point3D;
        Point3D point3D2;
        Point3D point3D3 = sceneObject.sphereCenter;
        if (point3D3 != null) {
            int n2;
            int n3;
            if (n > 0 && (n3 = (n2 = point3D3.distSquared(this.camera.getPosition())) / sceneObject.sphereRadiusSq) > n) {
                return false;
            }
            sceneObject.frustumPlaneFlag = this.camera.sphereInFrustum(point3D3, sceneObject.sphereRadiusSq, sceneObject.frustumPlaneFlag);
            if (sceneObject.frustumPlaneFlag < 0) {
                return false;
            }
        }
        return sceneObject.frustumPlaneFlag == 0 || (point3D2 = sceneObject.aabbCenter) == null || (sceneObject.frustumPlaneFlag = this.camera.centeredBoxInFrustum(point3D2, point3D = sceneObject.aabbExtent, sceneObject.frustumPlaneFlag)) >= 0;
    }

    public final int addDynamicScene(int n, int n2, int n3) {
        SceneDesc sceneDesc = this.createSceneDesc(n, n2, n3);
        sceneDesc.sceneflags |= 2;
        n2 = this.scenes.size();
        this.scenes.addElement(sceneDesc);
        return n2;
    }

    public final void addStaticScene(int n, int n2, int n3) {
        SceneDesc sceneDesc = this.createSceneDesc(n, n2, n3);
        this.scenes.addElement(sceneDesc);
    }

    public final int addTriangleBufferScene(AbstractTriangleBuffer[] abstractTriangleBufferArray) {
        SceneDesc sceneDesc = new SceneDesc();
        new SceneDesc().customObjects = abstractTriangleBufferArray;
        sceneDesc.numObjects = abstractTriangleBufferArray.length;
        sceneDesc.type = 3;
        sceneDesc.flags = 0;
        int n = this.scenes.size();
        this.scenes.addElement(sceneDesc);
        return n;
    }

    public final void addParticleSystem$396f8c73(ParticleSystem3D particleSystem3D) {
        this.particleScene = this.createScene(0, 0, 0);
        this.particleSystem$2cea9fce = particleSystem3D;
    }

    public final void clearScenes() {
        this.scenes.removeAllElements();
        this.particleSystem$2cea9fce = null;
        this.particleScene = -1;
        this.backgroundScene = -1;
        this.currentFrame = 0;
    }

    public final void renderBackground() {
        if (this.backgroundScene >= 0) {
            int n = RM.getValue(this.backgroundData, this.background, 4);
            SceneDesc sceneDesc = this.getSceneDesc(this.backgroundScene);
            int n2 = n;
            AbstractRenderer abstractRenderer = this;
            Point3D point3D = Point3D.getLocal();
            Point3D point3D2 = Point3D.getLocal();
            point3D.set(abstractRenderer.camera.getPosition());
            point3D2.set(point3D);
            point3D2.scale(n2);
            abstractRenderer.camera.setPosition(point3D2);
            abstractRenderer.onCameraChanged();
            abstractRenderer.drawComplexScene(sceneDesc);
            abstractRenderer.camera.setPosition(point3D);
            abstractRenderer.onCameraChanged();
            Point3D.freeLocal(point3D2);
            Point3D.freeLocal(point3D);
        }
    }

    public final void setBackground(int n, int n2) {
        this.backgroundData = 773;
        this.background = 2;
        this.backgroundScene = -1;
        n = RM.getValue(this.backgroundData, this.background, 0);
        if ((n & 4) != 0) {
            n = RM.getValue(this.backgroundData, this.background, 3);
            this.backgroundScene = this.addDynamicScene(n, 1, 1);
        }
    }

    public final void setObjectTransform(int n, int n2, Matrix33 matrix33, Point3D point3D) {
        Object object = this.getSceneDesc(n);
        object = ((SceneDesc)object).objects[n2];
        ((AbstractSceneObject)object).setTransform(matrix33, point3D);
    }

    public final void setObjectScale(int n, int n2, Point3D point3D) {
        Object object = this.getSceneDesc(n);
        object = ((SceneDesc)object).objects[n2];
        ((AbstractSceneObject)object).setScale(point3D);
    }

    public final void setSceneVisibility(int n, boolean bl) {
        SceneDesc sceneDesc = this.getSceneDesc(n);
        this.getSceneDesc(n).dormant = !bl;
    }

    public final void setLODHint(int n) {
        this.lodHint = n;
    }

    public final void setLODHint(int n, int n2) {
        SceneDesc sceneDesc = this.getSceneDesc(n);
        this.getSceneDesc(n).lodHint = 0;
    }

    public final void setObjectVisibility(int n, int n2, boolean bl) {
        SceneDesc sceneDesc = this.getSceneDesc(n);
        if (sceneDesc.visibility == null) {
            sceneDesc.visibility = RM.createBitfield(sceneDesc.numObjects, true);
        }
        RM.setBit(sceneDesc.visibility, n2, bl);
    }

    public final void setRenderState(int n, int n2, int n3, int n4) {
        int n5;
        SceneDesc sceneDesc = this.getSceneDesc(n);
        if (sceneDesc.renderstates == null) {
            sceneDesc.renderstates = new int[sceneDesc.numObjects];
            RM.fill(sceneDesc.renderstates, -1);
        }
        n3 = 529;
        if (529 < 0 || n4 < 0) {
            n5 = -1;
        } else {
            int n6 = RM.getValue(n3, n4, 0);
            int n7 = RM.getValue(n3, n4, 1);
            n3 = RM.getValue(n3, n4, 2);
            n5 = (n6 & 0xFF0000) << 16 | n7 & 0xFF | (n3 & 0xFF00) << 8;
        }
        sceneDesc.renderstates[n2] = n3 = n5;
    }

    public final void setObject(int n, int n2, int n3) {
        SceneDesc sceneDesc = this.getSceneDesc(n);
        SceneObject sceneObject = sceneDesc.objects[n2];
        if (sceneObject == null) {
            sceneDesc.objects[n2] = sceneObject = new SceneObject();
        }
        sceneObject.setObject(n3);
    }

    private SceneDesc getSceneDesc(int n) {
        return (SceneDesc)this.scenes.elementAt(n);
    }

    public final int createScene(int n, int n2, int n3) {
        SceneDesc sceneDesc = new SceneDesc();
        new SceneDesc().lodHint = this.lodHint;
        sceneDesc.numObjects = n;
        sceneDesc.type = n2;
        sceneDesc.flags = 0;
        sceneDesc.objects = new SceneObject[n];
        n = this.scenes.size();
        this.scenes.addElement(sceneDesc);
        return n;
    }

    private SceneDesc createSceneDesc(int n, int n2, int n3) {
        SceneDesc sceneDesc = new SceneDesc();
        new SceneDesc().lodHint = this.lodHint;
        sceneDesc.type = n2;
        sceneDesc.flags = n3;
        sceneDesc.numObjects = n3 = n >= 0 ? RM.getHeight(n) : 0;
        if (n3 > 0) {
            sceneDesc.objects = new SceneObject[n3];
            SceneObject[] sceneObjectArray = sceneDesc.objects;
            for (int i = 0; i < n3; ++i) {
                SceneObject sceneObject = sceneObjectArray[i] = new SceneObject();
                sceneObjectArray[i].init(n, i, n2);
            }
        }
        return sceneDesc;
    }

    public void begin(Graphics object, int n) {
        this.boundGraphics = object;
        ++this.currentFrame;
        if ((n & 1) != 0 && this.backgroundData >= 0) {
            object = this;
            n = RM.getValue(((AbstractRenderer)object).backgroundData, ((AbstractRenderer)object).background, 0);
            if ((n & 1) != 0) {
                ((AbstractRenderer)object).clearColorBuffer(RM.getValue(((AbstractRenderer)object).backgroundData, ((AbstractRenderer)object).background, 1));
            }
        }
    }

    public void end(int n) {
    }

    public final void setCamera(Point3D point3D, Point3D point3D2) {
        this.camera.lookAt(point3D, point3D2);
        this.onCameraChanged();
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.width = n3;
        this.height = n4;
        if (this.camera == null) {
            this.camera = new VCamera();
        }
        this.camera.setupView(n3, n4);
    }

    public final void renderScenes() {
        AbstractRenderer abstractRenderer = this;
        int n = abstractRenderer.scenes.size();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            abstractRenderer = this;
            if (n2 == abstractRenderer.particleScene && abstractRenderer.particleSystem$2cea9fce != null) {
                abstractRenderer = this;
                this.drawParticles$396f8c73(abstractRenderer.particleSystem$2cea9fce);
                continue;
            }
            if (i == this.backgroundScene) continue;
            SceneDesc sceneDesc = this.getSceneDesc(i);
            if (sceneDesc.dormant) continue;
            if (sceneDesc.lastFrameDrawn < this.currentFrame) {
                Object object;
                int n3;
                if (sceneDesc.type == 0) {
                    SceneDesc sceneDesc2 = sceneDesc;
                    abstractRenderer = this;
                    n3 = sceneDesc2.numObjects;
                    int[] nArray = sceneDesc2.visibility;
                    object = sceneDesc2.objects;
                    int[] nArray2 = sceneDesc2.renderstates;
                    int n4 = sceneDesc2.lodHint;
                    for (int j = 0; j < n3; ++j) {
                        SceneObject sceneObject;
                        if (nArray != null && !RM.isBitSet(nArray, j) || (sceneObject = object[j]) == null) continue;
                        int n5 = -1;
                        if (nArray2 != null) {
                            n5 = nArray2[j];
                        }
                        if (!abstractRenderer.testFrustum(sceneObject, n4)) continue;
                        abstractRenderer.drawObject(sceneObject, n5);
                    }
                } else if (sceneDesc.type == 1) {
                    this.drawComplexScene(sceneDesc);
                } else if (sceneDesc.type != 2 && sceneDesc.type == 3) {
                    SceneDesc sceneDesc3 = sceneDesc;
                    abstractRenderer = this;
                    n3 = sceneDesc3.numObjects;
                    for (int j = 0; j < n3; ++j) {
                        object = (AbstractTriangleBuffer)sceneDesc3.customObjects[j];
                        if (!object.mVisible) continue;
                        abstractRenderer.drawTriangleBuffer((AbstractTriangleBuffer)object);
                    }
                }
            }
            sceneDesc.lastFrameDrawn = this.currentFrame;
        }
    }

    private final void drawComplexScene(SceneDesc sceneDesc) {
        int n = sceneDesc.numObjects;
        int[] nArray = sceneDesc.visibility;
        SceneObject[] sceneObjectArray = sceneDesc.objects;
        int[] nArray2 = sceneDesc.renderstates;
        int n2 = sceneDesc.lodHint;
        for (int i = 0; i < n; ++i) {
            SceneObject sceneObject;
            if (nArray != null && !RM.isBitSet(nArray, i) || (sceneObject = sceneObjectArray[i]) == null) continue;
            int n3 = -1;
            if (nArray2 != null) {
                n3 = nArray2[i];
            }
            if (!this.testFrustum(sceneObject, n2)) continue;
            this.drawObject(sceneObject, n3);
        }
    }

    private void drawObject(SceneObject sceneObject, int n) {
        int n2;
        Matrix33 matrix33 = sceneObject.rotation;
        if (matrix33 == null) {
            matrix33 = Matrix33.IDENTITY;
        }
        int n3 = this.currentFrame;
        Object object = sceneObject;
        if (((SceneObject)object).animInfo == null) {
            n2 = ((AbstractSceneObject)object).obj;
        } else {
            int n4 = ((AbstractSceneObject)object).obj;
            object = ((SceneObject)object).animInfo;
            Object object2 = object[2];
            Object object3 = object[1];
            int n5 = ((SceneObject)object).animInfo[0];
            if ((n4 += n3 / object2 % object3) >= n5 + object3) {
                n4 -= object3;
            }
            n2 = n4;
        }
        this.drawObject$10ad83a4(n2, matrix33, sceneObject.translation, sceneObject.scale, n);
    }

    public void init(int n) {
        this.objectDefinitions = n;
        AbstractSceneObject.setObjectDefinitions(n);
    }

    public final int projectVertex(Point3D point3D, Point3D point3D2) {
        this.camera.transformToObjectSpace(Point3D.ZERO, Matrix33.IDENTITY);
        return this.camera.projectVertex(point3D, point3D2);
    }

    public final boolean isInFrustum(Point3D point3D, int n) {
        return this.camera.sphereInFrustum(point3D, n, Matrix33.IDENTITY, Point3D.ZERO) >= 0;
    }

    /*
     * Unable to fully structure code
     */
    public final int pick(int var1_1, Point3D var2_3, Point3D var3_4, Point3D var4_5) {
        var1_2 = this.getSceneDesc(var1_1);
        var5_6 = var1_2.numObjects;
        var1_2 = var1_2.objects;
        var6_7 = -1;
        var7_8 = 0x7FFFFFFF;
        var8_9 = Point3D.getLocal();
        var9_10 = Point3D.getLocal();
        var10_11 = Point3D.getLocal();
        for (var11_12 = 0; var11_12 < var5_6; ++var11_12) {
            block26: {
                block19: {
                    block22: {
                        block25: {
                            block24: {
                                block23: {
                                    block21: {
                                        block20: {
                                            var12_13 = var1_2[var11_12];
                                            var14_16 = 0x7FFFFFFF;
                                            if (var12_13.aabbCenter == null) break block19;
                                            var13_15 = var12_13.aabbCenter;
                                            var12_13 = var12_13.aabbExtent;
                                            var8_9.set(var13_15);
                                            var8_9.sub((Point3D)var12_13);
                                            var9_10.set(var13_15);
                                            var9_10.add((Point3D)var12_13);
                                            var22_21 = var10_11;
                                            var17_19 = var9_10;
                                            var16_18 = var8_9;
                                            var15_17 = var3_4;
                                            var12_13 = var2_3;
                                            var23_23 = 0;
                                            var24_24 = 0x7FFFFFFF;
                                            var25_26 = var12_13.x;
                                            var26_27 = var12_13.y;
                                            var27_29 = var12_13.z;
                                            var28_30 = var15_17.x;
                                            var29_32 = var16_18.x;
                                            var30_33 = var17_19.x;
                                            if (var28_30 * var28_30 >= 10) break block20;
                                            if (var25_26 >= var29_32 && var25_26 <= var30_33) break block21;
                                            v0 = false;
                                            break block22;
                                        }
                                        var31_35 = (var29_32 - var25_26 << 10) / var28_30;
                                        var32_36 = (var30_33 - var25_26 << 10) / var28_30;
                                        if (var31_35 > var32_36) {
                                            var33_38 = var31_35;
                                            var31_35 = var32_36;
                                            var32_36 = var33_38;
                                        }
                                        if (var31_35 > 0) {
                                            var23_23 = var31_35;
                                        }
                                        if (var32_36 < var24_24) {
                                            var24_24 = var32_36;
                                        }
                                        if (var23_23 <= var24_24) break block21;
                                        v0 = false;
                                        break block22;
                                    }
                                    var31_35 = var15_17.y;
                                    var32_36 = var16_18.y;
                                    var33_38 = var17_19.y;
                                    if (var31_35 * var31_35 >= 10) break block23;
                                    if (var26_27 >= var16_18.y && var26_27 <= var17_19.y) break block24;
                                    v0 = false;
                                    break block22;
                                }
                                var34_39 = (var32_36 - var26_27 << 10) / var31_35;
                                var35_41 = (var33_38 - var26_27 << 10) / var31_35;
                                if (var34_39 > var35_41) {
                                    var36_42 = var34_39;
                                    var34_39 = var35_41;
                                    var35_41 = var36_42;
                                }
                                if (var34_39 > var23_23) {
                                    var23_23 = var34_39;
                                }
                                if (var35_41 < var24_24) {
                                    var24_24 = var35_41;
                                }
                                if (var23_23 <= var24_24) break block24;
                                v0 = false;
                                break block22;
                            }
                            var34_39 = var15_17.z;
                            var35_41 = var16_18.z;
                            var36_42 = var17_19.z;
                            if (var34_39 * var34_39 >= 10) break block25;
                            if (var27_29 >= var16_18.z && var27_29 <= var17_19.z) ** GOTO lbl-1000
                            v0 = false;
                            break block22;
                        }
                        var37_44 = (var35_41 - var27_29 << 10) / var34_39;
                        var38_45 = (var36_42 - var27_29 << 10) / var34_39;
                        if (var37_44 > var38_45) {
                            var39_47 = var37_44;
                            var37_44 = var38_45;
                            var38_45 = var39_47;
                        }
                        if (var37_44 > var23_23) {
                            var23_23 = var37_44;
                        }
                        if (var38_45 < var24_24) {
                            var24_24 = var38_45;
                        }
                        if (var23_23 > var24_24) {
                            v0 = false;
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (var22_21 != null) {
                                var28_30 = (var28_30 * var23_23 >> 10) + var25_26;
                                var31_35 = (var31_35 * var23_23 >> 10) + var26_27;
                                var34_39 = (var34_39 * var23_23 >> 10) + var27_29;
                                var22_21.set(var28_30, var31_35, var34_39);
                            }
                            v0 = true;
                        }
                    }
                    if (v0) {
                        var14_16 = var2_3.distSquared(var13_15);
                    }
                    break block26;
                }
                var13_15 = var12_13.sphereCenter;
                if (var13_15 == null) break block26;
                var17_20 = var12_14 = var12_13.sphereRadiusSq;
                var16_18 = var13_15;
                var15_17 = var3_4;
                var12_13 = var2_3;
                var22_22 = var12_13.x - var16_18.x;
                var24_25 = var12_13.y - var16_18.y;
                var26_28 = var12_13.z - var16_18.z;
                var28_31 = (var22_22 * var22_22 + var24_25 * var24_25 + var26_28 * var26_28 >> 10) - (long)var17_20;
                if (var28_31 <= 0L) ** GOTO lbl-1000
                var30_34 = var15_17.x;
                var32_37 = var15_17.y;
                var34_40 = var15_17.z;
                var36_43 = var22_22 * var30_34 + var24_25 * var32_37 + var26_28 * var34_40 >> 10;
                if (var36_43 > 0L) {
                    v1 = false;
                } else {
                    var38_46 = (var36_43 * var36_43 >> 10) - var28_31;
                    if (var38_46 < 0L) {
                        v1 = false;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    }
                }
                if (v1) {
                    var14_16 = var2_3.distSquared(var13_15);
                }
            }
            if (var14_16 >= var7_8) continue;
            var7_8 = var14_16;
            var6_7 = var11_12;
            if (var4_5 == null) continue;
            var4_5.set(var13_15);
        }
        Point3D.freeLocal(var10_11);
        Point3D.freeLocal(var9_10);
        Point3D.freeLocal(var8_9);
        return var6_7;
    }

    public abstract /* synthetic */ void drawParticles$396f8c73(ParticleSystem3D var1);

    static {
        new Point3D();
        new Point3D();
        new Point3D();
        new Matrix33();
    }
}

