/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.math3d;

import tinbrain.GCanvas;
import tinbrain.math3d.Bezier4;
import tinbrain.math3d.Point3D;

public final class AutoBezier {
    private Point3D[] mPoints;
    private int[] mLengths;
    private int mNumSegments;
    private int mTotalLength;
    private int mSmoothness = 200;
    private boolean mLooping = false;
    private static Bezier4 mBezier = new Bezier4();

    public AutoBezier(int n, boolean bl) {
    }

    public final void setSmoothness(int n) {
        this.mSmoothness = n;
    }

    public final void setLooping(boolean bl) {
        this.mLooping = bl;
    }

    public final void initBlank(int n) {
        if (n < 2) {
            return;
        }
        int n2 = n * 3;
        this.mPoints = new Point3D[n2];
        this.mNumSegments = n - 1;
        if (this.mLooping) {
            ++this.mNumSegments;
        }
        this.mLengths = new int[this.mNumSegments];
        for (n = 0; n < n2; ++n) {
            this.mPoints[n] = new Point3D();
        }
    }

    public final void setPoint(int n, int n2, int n3, int n4) {
        this.mPoints[1 + n * 3].set(n2, n3, n4);
    }

    public final void calculateWeights() {
        int n;
        int n2 = this.mNumSegments + 1;
        int n3 = this.mPoints.length;
        if (n2 < 2) {
            return;
        }
        int n4 = this.mSmoothness;
        Point3D point3D = Point3D.getLocal();
        Point3D point3D2 = Point3D.getLocal();
        Point3D point3D3 = Point3D.getLocal();
        for (n = 0; n < n2; ++n) {
            int n5 = GCanvas.mathModWrap(1 + n * 3, 0, n3);
            point3D2.setDiff(this.mPoints[GCanvas.mathModWrap(n5 + 3, 0, n3)], this.mPoints[n5]);
            point3D3.setDiff(this.mPoints[GCanvas.mathModWrap(n5 - 3, 0, n3)], this.mPoints[n5]);
            point3D.setDiff(point3D2, point3D3);
            this.mPoints[GCanvas.mathModWrap(n5 + 1, 0, n3)].set(this.mPoints[n5]);
            this.mPoints[GCanvas.mathModWrap(n5 + 1, 0, n3)].addScaled(point3D, n4);
            point3D.setDiff(point3D3, point3D2);
            this.mPoints[GCanvas.mathModWrap(n5 - 1, 0, n3)].set(this.mPoints[n5]);
            this.mPoints[GCanvas.mathModWrap(n5 - 1, 0, n3)].addScaled(point3D, n4);
        }
        if (!this.mLooping) {
            point3D.setDiff(this.mPoints[4], this.mPoints[1]);
            point3D.scale(n4);
            this.mPoints[2].set(this.mPoints[1]);
            this.mPoints[2].add(point3D);
            point3D.setDiff(this.mPoints[n3 - 5], this.mPoints[n3 - 2]);
            point3D.scale(n4);
            this.mPoints[n3 - 3].set(this.mPoints[n3 - 2]);
            this.mPoints[n3 - 3].add(point3D);
        }
        AutoBezier autoBezier = this;
        Point3D point3D4 = Point3D.getLocal();
        autoBezier.mTotalLength = 0;
        for (n4 = 0; n4 < autoBezier.mNumSegments; ++n4) {
            n = 1 + n4 * 3;
            point3D4.setDiff(autoBezier.mPoints[n + 1], autoBezier.mPoints[n]);
            autoBezier.mLengths[n4] = point3D4.length();
            point3D4.setDiff(autoBezier.mPoints[GCanvas.mathModWrap(n + 2, 0, autoBezier.mPoints.length)], autoBezier.mPoints[n + 1]);
            int n6 = n4;
            autoBezier.mLengths[n6] = autoBezier.mLengths[n6] + point3D4.length();
            point3D4.setDiff(autoBezier.mPoints[GCanvas.mathModWrap(n + 3, 0, autoBezier.mPoints.length)], autoBezier.mPoints[GCanvas.mathModWrap(n + 2, 0, autoBezier.mPoints.length)]);
            int n7 = n4;
            autoBezier.mLengths[n7] = autoBezier.mLengths[n7] + point3D4.length();
            autoBezier.mTotalLength += autoBezier.mLengths[n4];
        }
        Point3D.freeLocal(point3D4);
        Point3D.freeLocal(point3D3);
        Point3D.freeLocal(point3D2);
        Point3D.freeLocal(point3D);
    }

    public final void getPoint3D(int n, Point3D point3D) {
        int n2 = this.mNumSegments;
        n2 = (n2 << 10) - 1;
        n = Math.min(n, n2);
        n = Math.max(n, 0);
        n2 = n >> 10;
        n &= 0x3FF;
        n2 = 1 + n2 * 3;
        Point3D point3D2 = this.mPoints[GCanvas.mathModWrap(n2 + 3, 0, this.mPoints.length)];
        Point3D point3D3 = this.mPoints[GCanvas.mathModWrap(n2 + 2, 0, this.mPoints.length)];
        Point3D point3D4 = this.mPoints[n2 + 1];
        Point3D point3D5 = this.mPoints[n2];
        Bezier4 bezier4 = mBezier;
        bezier4.mPoints[0] = point3D5;
        bezier4.mPoints[1] = point3D4;
        bezier4.mPoints[2] = point3D3;
        bezier4.mPoints[3] = point3D2;
        point3D4 = point3D;
        int n3 = n;
        bezier4 = mBezier;
        long l = (n3 <<= 4) * n3 >> 14;
        long l2 = l * (long)n3 >> 14;
        long l3 = 16384 - n3;
        long l4 = l3 * l3 >> 14;
        long l5 = l4 * l3 >> 14;
        point3D4.x = (int)(l5 * ((long)bezier4.mPoints[0].x << 4) + ((long)(n3 * 3) * l4 >> 14) * ((long)bezier4.mPoints[1].x << 4) + (3L * l * l3 >> 14) * ((long)bezier4.mPoints[2].x << 4) + l2 * ((long)bezier4.mPoints[3].x << 4) >> 14 >> 4);
        point3D4.y = (int)(l5 * ((long)bezier4.mPoints[0].y << 4) + ((long)(n3 * 3) * l4 >> 14) * ((long)bezier4.mPoints[1].y << 4) + (3L * l * l3 >> 14) * ((long)bezier4.mPoints[2].y << 4) + l2 * ((long)bezier4.mPoints[3].y << 4) >> 14 >> 4);
        point3D4.z = (int)(l5 * ((long)bezier4.mPoints[0].z << 4) + ((long)(n3 * 3) * l4 >> 14) * ((long)bezier4.mPoints[1].z << 4) + (3L * l * l3 >> 14) * ((long)bezier4.mPoints[2].z << 4) + l2 * ((long)bezier4.mPoints[3].z << 4) >> 14 >> 4);
    }
}

