/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import game.ArenaGame;
import game.game3d.Game3d;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.IMenuExtension;
import tinbrain.RM;
import tinbrain.Tinlet;
import tinbrain.ea.localization.Localization;
import tinbrain.ea.moregames.MoreGames15;
import tinbrain.midp20.MIDP20Proxy;
import tinbrain.mmapi.Sound;

public final class Menu {
    static ArenaGame game$486afe46;
    private static IMenuExtension[] extensions;
    private static String[] midletInfo;
    protected static byte[][] menus;
    protected static byte[][][] menuItems;
    private static long splashStartTime;
    private static int splashMaxTime;
    private static int currentSplash;
    private static int currentSplashTime;
    private static int currentSplashFrame;
    private static int mode;
    private static int splashMode;
    private static int currentMenu;
    private static int selectedItem;
    private static int menuItemPosition;
    private static int menuItemEase;
    private static byte[] menuCaller;
    private static byte[] menuSelection;
    private static int[] menuItemWidths;
    private static int menuItemOverlayWidth;
    private static boolean paused;
    private static int menuClipTop;
    private static int menuClipHeight;
    private static int menuItemPositionMax;
    private static boolean showUpArrow;
    private static boolean showDownArrow;
    private static boolean lskEnabled;
    private static boolean rskEnabled;
    private static byte[][] textScreenItems;
    private static int delayedMenuCountDown;
    private static int[][] localHighscoreScoreTable;
    private static int localHighscoreCandidateTable;
    private static int localHighscoreCandidateScore;
    private static int localHighscoreCandidateSort;
    private static int MENU_ITEM_BOTTOM;
    private static int MENU_SCROLLTEXT_TOP;
    private static int MENU_SCROLLTEXT_BOTTOM;
    private static int MENU_SEPERATOR_TOP;
    private static int MENU_SEPERATOR_HEIGHT;
    private static int MENU_TEXT_WIDTH;
    private static int MENU_LEFT;
    private static String statusText;
    private static int menuCaptionImage;
    private static int menuCaptionOffset;
    private static final int[][] scrInfo;
    private static int[] options;
    private static volatile boolean showLoading;
    private static int languageLoadingMessage;
    private static int loadingFrame;
    private static boolean titleMusicStarted;
    private static Sound sound$25c7fb11;
    private static int currentTranslationString;
    private static int transitionFrame;
    private static int transitionDirection;
    private static int progressBarMax;
    private static int progressCurrent;
    private static final int[] dirtyRect;
    private static int sResumeMusicAfterInterruptDelay;
    private static int sOldItemBottom;
    public static int sCurrentDrawnItem;
    private static final int[] sCustomItemPositionArray;
    private static int[][] sDynamicStringsMeta;
    private static boolean sDynamicStringsInHighlightBlock;
    private static Vector sDynamicStringMetaTemp;

    private Menu() {
    }

    public static void start() {
        game$486afe46 = new Game3d();
        Menu.extensions[0] = game$486afe46;
        Menu.extensions[1] = new MoreGames15();
        Thread thread = new Thread(new GCanvas());
        thread.start();
    }

    public static void stop() {
        if (GCanvas.isRunning) {
            Menu.stopMusic();
            if (splashMode >= 10) {
                Menu.startLoading(185);
                RM.flushRMS();
            }
            GCanvas.isRunning = false;
        }
    }

    protected static final void onDraw(Graphics graphics) {
        if (showLoading) {
            GCanvas.pushClip(graphics);
            graphics.setClip(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
            if (mode != 0 && Menu.isInitialized()) {
                game$486afe46.drawCustomMenuBackground$26c5358c(graphics, -1, 0);
            } else {
                graphics.setColor(-12896208);
                graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
            }
            ++loadingFrame;
            if (statusText != null) {
                Menu.drawMenuItem(graphics, 10, statusText, 5, GCanvas.height - GCanvas.getFontHeight(10) - 5, 20, 5);
            }
            GCanvas.popClip(graphics);
            return;
        }
        switch (mode) {
            case 0: {
                int n;
                if (currentSplash >= 0 && currentSplash <= 2) {
                    n = Menu.getSplashID(currentSplash);
                    if (currentSplash != 0 && !RM.isLoaded(n)) break;
                    graphics.setColor(splashMode <= 9 ? -1 : -12896208);
                    graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
                    GCanvas.drawImage(graphics, n, GCanvas.width >> 1, GCanvas.height >> 1, 3);
                }
                n = Menu.splashSkippable();
                if (splashMode >= 4 && splashMode <= 6 && n == 0) {
                    if (RM.getCurrentLoading() < RM.getNumResources()) {
                        int n2 = GCanvas.width * 819 >> 10;
                        int n3 = GCanvas.height * 41 >> 10;
                        int n4 = GCanvas.width * 102 >> 10;
                        int n5 = GCanvas.height * 921 >> 10;
                        int n6 = GCanvas.width * 798 >> 10;
                        int n7 = GCanvas.height * 20 >> 10;
                        if ((n2 & 1) != 0) {
                            --n2;
                        }
                        if ((n3 & 1) != 0) {
                            --n3;
                        }
                        if ((n6 & 1) != 0) {
                            --n6;
                        }
                        if ((n7 & 1) != 0) {
                            --n7;
                        }
                        if (n2 - n6 < 2) {
                            n6 = n2 - 2;
                        }
                        if (n3 - n7 < 2) {
                            n7 = n3 - 2;
                        }
                        if (n3 < 4) {
                            n3 = 4;
                            n7 = 2;
                        }
                        int n8 = n4 + (n2 - n6 >> 1);
                        int n9 = n5 + (n3 - n7 >> 1);
                        n = (n6 << 10) / progressBarMax;
                        int n10 = n * progressCurrent >> 10;
                        if (n10 > 0) {
                            graphics.setColor(-4144960);
                            graphics.fillRect(n4, n5, n2, n3);
                            graphics.setColor(-864252);
                            graphics.fillRect(n8, n9, n10, n7);
                        }
                    }
                } else if (n != 0) {
                    int n11 = GCanvas.getHeight() - GCanvas.getFontHeight(6) - 5;
                    String string = RM.t(259);
                    int n12 = GCanvas.getWidth() >> 1;
                    n = 17;
                    int n13 = n11;
                    Graphics graphics2 = graphics;
                    GCanvas.drawString(graphics2, 6, string, n12, n13, 17);
                }
                ++currentSplashFrame;
                return;
            }
            case 1: {
                int n = currentMenu;
                GCanvas.pushClip(graphics);
                if (!Menu.isInitialized()) {
                    graphics.setColor(-12896208);
                    graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
                }
                int n14 = Menu.getMenuType(n);
                byte[][] byArray = Menu.getMenuItems(n);
                if (byArray != null) {
                    int n15;
                    int n16;
                    int n17;
                    int n18 = byArray.length;
                    MENU_LEFT = 0;
                    int n19 = MENU_TEXT_WIDTH;
                    int n20 = GCanvas.getWidth() >> 1;
                    if (menuCaptionImage >= 0) {
                        GCanvas.drawImage(graphics, menuCaptionImage, GCanvas.width - RM.getWidth(menuCaptionImage) - 4, Menu.getMenuSeperatorTop() - RM.getHeight(menuCaptionImage) - 4, 20);
                    }
                    if (Menu.isInitialized()) {
                        game$486afe46.drawCustomMenuBackground$26c5358c(graphics, n, 0);
                    }
                    GCanvas.pushClip(graphics);
                    if (transitionFrame > 0) {
                        n17 = (GCanvas.width * transitionFrame * transitionDirection << 10) / 5 >> 10;
                        graphics.translate(n17, 0);
                    }
                    n17 = 0;
                    if (Menu.isInitialized()) {
                        for (n16 = 0; n16 < extensions.length; ++n16) {
                            n17 |= extensions[n16].drawCustomMenu(graphics, n, selectedItem, 0);
                        }
                    }
                    if ((n17 & 2) == 0) {
                        n16 = Menu.getMenuCaption(n);
                        n15 = 2;
                        if (n16 != -1) {
                            if (scrInfo[0][0] != 0) {
                                n15 = GCanvas.width - Menu.updateScrolling(scrInfo[0]);
                            }
                            Menu.drawMenuItem(graphics, 1, RM.t(n16), n15, 3, 20, 1);
                        }
                    }
                    if (n18 > 0 && (n17 & 1) == 0 && (n16 = Menu.countEnabledItems(n)) > 0) {
                        int n21;
                        Menu.setMenuItemPosition(currentMenu, true, false);
                        n15 = n17 = (menuItemEase + 512 >> 10) + menuClipTop;
                        GCanvas.pushClip(graphics);
                        if (GCanvas.clipRect(graphics, 4, menuClipTop, n19, menuClipHeight + 1)) {
                            Graphics graphics3;
                            int n22;
                            int n23;
                            int n24;
                            int n25;
                            int n26;
                            byte[] byArray2;
                            int n27 = n14;
                            n16 = n15;
                            n14 = 0;
                            n19 = n18;
                            byte[][] byArray3 = byArray;
                            int n28 = n27;
                            Graphics graphics4 = graphics;
                            n21 = n14 + (GCanvas.getWidth() - n14 >> 1);
                            int n29 = n16;
                            int n30 = n28 != 2 ? 2 : 5;
                            int n31 = GCanvas.getFontHeight(n30);
                            int[] nArray = scrInfo[1];
                            int n32 = 0;
                            int n33 = Menu.getTextSpacingByType(n30, n28);
                            int n34 = n33 - n31 >> 1;
                            int n35 = graphics4.getClipY();
                            int n36 = n35 + graphics4.getClipHeight();
                            if (game$486afe46.menuHighlightSelection(Menu.getCurrentMenu()) && n28 != 2 && Menu.getMenuItemCaption(byArray2 = byArray3[selectedItem]) != -1 && Menu.isMenuItemVisible(n28, byArray2)) {
                                n26 = selectedItem;
                                int n37 = Menu.getCurrentMenu();
                                byte[][] byArray4 = menuItems[n37];
                                n26 = GCanvas.clamp(n26, 0, byArray4.length);
                                n25 = 0;
                                n24 = Menu.getMenuType(n37);
                                for (n23 = 0; n23 < n26; ++n23) {
                                    if (!Menu.isMenuItemVisible(n24, byArray4[n23])) continue;
                                    ++n25;
                                }
                                n22 = n25;
                                n25 = n31;
                                int n38 = n16 + n33 * n22;
                                graphics3 = graphics4;
                                n24 = RM.getWidth(8);
                                n23 = n38 + n25 / 2;
                                for (n26 = n14; n26 < GCanvas.getWidth(); n26 += n24) {
                                    GCanvas.drawImage(graphics3, 8, n26, n23, 6);
                                }
                            }
                            for (n22 = 0; n22 < n19; ++n22) {
                                byte[] byArray5 = byArray3[n22];
                                sCurrentDrawnItem = n22;
                                n14 = byArray5[4] != 0 ? 1 : 0;
                                n32 = Menu.isMenuItemVisible(n28, byArray5);
                                if (n32 != 0) {
                                    int n39 = n16 = n14 != 0 ? n30 : 4;
                                    if (game$486afe46.menuHighlightSelection(Menu.getCurrentMenu())) {
                                        int n40 = n16 = n22 == selectedItem ? 3 : n16;
                                    }
                                    if (n29 > n35 - n31) {
                                        n32 = n29 + n34;
                                        int n41 = Menu.getMenuItemCaption(byArray5);
                                        if (n41 != -1) {
                                            if (n28 != 2) {
                                                if (n22 != selectedItem || nArray[0] == 0) {
                                                    n14 = GCanvas.getStringWidth(RM.getFittedString(n22), n16);
                                                    n14 = n21 - (n14 >> 1);
                                                    Menu.drawMenuItem(graphics4, n16, RM.getFittedString(n22), n14, n32, 20, n22 == selectedItem ? 2 : 0);
                                                } else {
                                                    n14 = GCanvas.width - Menu.updateScrolling(nArray);
                                                    RM.t(n41);
                                                    Menu.drawMenuItem(graphics4, n16, RM.t(n41), n14, n32, 20, 2);
                                                }
                                            } else {
                                                n25 = 5;
                                                int n42 = n32;
                                                n26 = n41;
                                                graphics3 = graphics4;
                                                if (sDynamicStringsMeta[n26] != null) {
                                                    int[] nArray2 = sDynamicStringsMeta[n26];
                                                    n23 = nArray2.length / 3;
                                                    for (n14 = 0; n14 < n23; ++n14) {
                                                        n16 = nArray2[n14 * 3];
                                                        n25 = nArray2[n14 * 3 + 1];
                                                        int n43 = nArray2[n14 * 3 + 2];
                                                        int n44 = GCanvas.getStringWidth(RM.dt(n26), 5);
                                                        int n45 = GCanvas.getWidth() - n44 >> 1;
                                                        int n46 = n25 != -1 ? n45 + n25 : n45;
                                                        int n47 = n44;
                                                        if (n43 != -1) {
                                                            n47 = n43 + n45 - n46;
                                                        } else if (n25 != -1) {
                                                            n47 = n44 - n25;
                                                        }
                                                        n25 = n46 + 1;
                                                        n43 = n42 + 1;
                                                        n44 = GCanvas.getFontHeight(5) - 4;
                                                        graphics3.setColor(n16);
                                                        graphics3.fillRect(n25 - 2, n43 + 2, n47 + 4, n44);
                                                        graphics3.fillRect(n25, n43, n47, n44 + 4);
                                                    }
                                                }
                                                n14 = 0;
                                                n23 = 17;
                                                n24 = n32;
                                                n25 = n21;
                                                String string = RM.dt(n41);
                                                n26 = 5;
                                                graphics3 = graphics4;
                                                if (game$486afe46.menuHighlightSelection(Menu.getCurrentMenu())) {
                                                    Menu.sCustomItemPositionArray[0] = n25;
                                                    Menu.sCustomItemPositionArray[1] = n24;
                                                    if (game$486afe46.getCustomMenuItemPosition$1c96c319(sCustomItemPositionArray, 0)) {
                                                        n25 = sCustomItemPositionArray[0];
                                                        n24 = sCustomItemPositionArray[1];
                                                    }
                                                }
                                                GCanvas.drawString(graphics3, 5, string, n25, n24, 17);
                                            }
                                        }
                                    }
                                    n29 += n33;
                                }
                                if (n29 >= n36) break;
                            }
                            sCurrentDrawnItem = -1;
                        }
                        GCanvas.popClip(graphics);
                        n14 = menuClipTop - GCanvas.getSpriteHeight(11);
                        n21 = menuClipTop + menuClipHeight;
                        int n48 = n;
                        int n49 = Menu.getMenuType(n48);
                        int n50 = Menu.countEnabledItems(n48);
                        if ((n50 < 2 ? 0 : (n19 = n49 != 2 && n49 != 3 && n49 != 5 && Menu.countEnabledItems(n48, n50) > 0 && game$486afe46.menuHighlightSelection(n48) ? 1 : 0)) != 0) {
                            GCanvas.drawSprite(graphics, 11, n20, n14, 2);
                            GCanvas.drawSprite(graphics, 11, n20, n21, 3);
                        }
                        if (showUpArrow) {
                            GCanvas.drawSprite(graphics, 11, n20, n14, 0);
                        }
                        if (showDownArrow) {
                            GCanvas.drawSprite(graphics, 11, n20, n21, 1);
                        }
                    }
                    graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
                    GCanvas.popClip(graphics);
                    GCanvas.popClip(graphics);
                }
                return;
            }
            case 2: {
                game$486afe46.onDraw(graphics);
            }
        }
    }

    public static final void scheduleMenuRefresh() {
        RM.setRectEmpty(dirtyRect);
    }

    private static final void advanceSplashMode() {
        GCanvas.resetKeys();
        ++splashMode;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static final void onInput() {
        int n;
        int n2;
        if (showLoading) {
            return;
        }
        if (GCanvas.isRunning && sResumeMusicAfterInterruptDelay >= 0) {
            if (sResumeMusicAfterInterruptDelay == 0 && options != null && options[n2 = 0] == 1 && (mode == 1 || mode == 0) && game$486afe46.resumeMusicAfterInterrupt()) {
                Menu.playMusic(true);
            }
            --sResumeMusicAfterInterruptDelay;
        }
        if (mode == 0) {
            int n3;
            int n4;
            if (splashMode == 0) {
                currentSplash = -1;
                Menu.advanceSplashMode();
                return;
            }
            if (splashMode == 1) {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = midletInfo[0] + "_opt";
                stringArray2[1] = midletInfo[0] + "_his";
                RM.initRMS(stringArray2);
                options = RM.getRMSInts(0);
                if (options == null || RM.getRMSError() == 1) {
                    Menu.setInitialOptions(true);
                } else if (options.length != 51) {
                    RM.deleteRecordStore(0);
                    options = null;
                    Menu.setInitialOptions(true);
                    RM.setStoreDirty(0);
                }
                Menu.loadHighscore();
                n2 = 4;
                n4 = options[n2];
                Localization localization = null;
                localization = new Localization();
                n3 = n4 = localization.chooseLanguage(Tinlet.instance, RM.getLocales(), n4, true);
                n2 = 4;
                Menu.options[n2] = n3;
                if (n4 < 0) {
                    n4 = -(n4 + 1);
                }
                RM.setLocale(n4);
                n2 = options[5];
                GCanvas.setScreenOrientation(n2);
                Menu.advanceSplashMode();
            }
            if (splashMode == 2) {
                RM.preloadPack(0);
                GCanvas.initResources();
                Menu.setupLayout();
                menuCaller = new byte[menus.length];
                n3 = 22;
                n2 = 0;
                Menu.menuCaller[n2] = (byte)n3;
                n3 = 5;
                n2 = 6;
                Menu.menuCaller[n2] = (byte)n3;
                menuSelection = new byte[menus.length];
                menuItemWidths = new int[24];
                Menu.onLanguageChanged();
                Menu.advanceSplashMode();
            }
            if (splashMode == 3) {
                if (options[4] < 0) {
                    Menu.changeMenu(24, false);
                    return;
                }
                Menu.advanceSplashMode();
            }
            if (splashMode == 4) {
                if (RM.getNumResources() != 0) return;
                RM.load();
                return;
            }
            if (splashMode == 5) {
                n4 = 0;
                while (true) {
                    if (n4 >= extensions.length) {
                        GCanvas.updateSpriteCache();
                        Menu.advanceSplashMode();
                        return;
                    }
                    extensions[n4].init();
                    ++n4;
                }
            }
            if (splashMode == 6) {
                if (sound$25c7fb11 == null) {
                    sound$25c7fb11 = new Sound();
                    game$486afe46.prepareSounds$5d940954(sound$25c7fb11);
                }
                Menu.updateSplash(Menu.skipSplash());
                return;
            }
            if (splashMode == 7) {
                Menu.changeMenu(23, false);
                return;
            }
            if (splashMode == 8) {
                if (currentSplash >= 0) {
                    Menu.updateSplash(Menu.skipSplash());
                    return;
                }
                Menu.startSplash(1, 3400);
                return;
            }
            if (splashMode != 9) {
                if (splashMode != 10) return;
                Menu.changeMenu(0, false);
                return;
            }
            if (currentSplash >= 0) {
                Menu.updateSplash(Menu.skipSplash());
                return;
            }
            Menu.startSplash(2, 3000);
            return;
        }
        if (sound$25c7fb11 != null) {
            sound$25c7fb11.tick();
        }
        if (mode != 0 && (n = GCanvas.getSoftkeys()) != 0) {
            int n5;
            n2 = -1;
            if (n == 131072 && lskEnabled) {
                n2 = 3;
            }
            if (n == 262144 && rskEnabled) {
                n2 = 4;
            }
            if (n == 524288) {
                if (rskEnabled && (n = GCanvas.getRSK()) >= 0 && ((n5 = GCanvas.softkeys[n][3]) == 3 || n5 == 4 || n5 == 19 || n == 8)) {
                    n2 = 4;
                }
                if (lskEnabled && GCanvas.getLSK() == 8) {
                    n2 = 3;
                }
            }
            n = -1;
            if (n2 == 3) {
                n = GCanvas.getLSK();
            } else if (n2 == 4) {
                n = GCanvas.getRSK();
            }
            if (n == -1) return;
            n2 = n5 = GCanvas.softkeys[n][3];
            Menu.performMenuAction(n5, 255);
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        if (mode == 2 && delayedMenuCountDown < 0) {
            game$486afe46.onInput();
        }
        if (--delayedMenuCountDown == 0) {
            Menu.changeMenu(0, false);
        }
        if (transitionFrame > 0) {
            --transitionFrame;
        }
        if (mode != 1) return;
        n = 0;
        for (n2 = 0; n2 < extensions.length; ++n2) {
            IMenuExtension iMenuExtension = extensions[n2];
            boolean bl2 = iMenuExtension.peekInput();
            n = bl2 ? 1 : 0;
            if (bl2) break;
        }
        if (n != 0) return;
        n2 = currentMenu;
        if ((n2 = menus[n2][2]) == 3) return;
        if (GCanvas.consumeUP()) {
            Menu.setSelection(currentMenu, selectedItem - 1, -1, false);
        }
        if (GCanvas.consumeDOWN()) {
            Menu.setSelection(currentMenu, selectedItem + 1, 1, false);
        }
        if (GCanvas.consumeFIRE()) {
            n = GCanvas.getLSK();
            if (n < 0 || n == 1) {
                n = GCanvas.getRSK();
            }
            if (n >= 0 && n != 1) {
                Menu.menuItemSelected();
            }
        }
        for (n = 0; n < extensions.length; ++n) {
            IMenuExtension iMenuExtension = extensions[n];
            if (!iMenuExtension.isCycleMenu(currentMenu)) continue;
            if (GCanvas.consumeLEFT()) {
                iMenuExtension.menuCycled(currentMenu, -1);
                break;
            }
            if (!GCanvas.consumeRIGHT()) break;
            iMenuExtension.menuCycled(currentMenu, 1);
            break;
        }
        if (currentMenu != 27) return;
        if (GCanvas.consumeLEFT()) {
            Menu.performMenuAction(28, -1);
        }
        if (!GCanvas.consumeRIGHT()) return;
        Menu.performMenuAction(28, 1);
    }

    private static final boolean splashSkippable() {
        return currentSplash > 0;
    }

    private static final boolean skipSplash() {
        if (Menu.splashSkippable()) {
            return GCanvas.consumeKey(1040);
        }
        return false;
    }

    private static final void startSplash(int n, int n2) {
        splashStartTime = GCanvas.getUptimeMillis();
        splashMaxTime = n2;
        currentSplash = n;
        if ((n = Menu.getSplashID(currentSplash - 1)) >= 0) {
            RM.forget(n);
        }
        RM.load(Menu.getSplashID(currentSplash));
        GCanvas.redraw();
    }

    private static final void updateSplash(boolean bl) {
        if (bl) {
            Menu.splashFinished();
            return;
        }
        currentSplashTime = (int)(GCanvas.getUptimeMillis() - splashStartTime);
        if (currentSplashTime > splashMaxTime) {
            Menu.splashFinished();
        }
    }

    private static void splashFinished() {
        if (currentSplash >= 0) {
            Menu.advanceSplashMode();
            int n = Menu.getSplashID(currentSplash);
            if (n >= 0) {
                RM.forget(n);
            }
            currentSplash = -1;
        }
    }

    private static final void setInitialOptions(boolean n) {
        if (options == null) {
            options = new int[51];
        }
        if (n != 0) {
            Menu.options[4] = -1;
        }
        if (n != 0) {
            Menu.options[0] = 0;
            Menu.options[1] = 30;
            Menu.options[2] = 30;
            Menu.options[3] = 0;
            Menu.options[5] = 0;
        }
        for (n = 6; n < 51; ++n) {
            Menu.options[n] = 0;
        }
        game$486afe46.setOptionDefaults();
    }

    public static final int getOption(int n) {
        return options[n];
    }

    public static final void setOption(int n, int n2) {
        Menu.options[n] = n2;
    }

    private static final void loadHighscore() {
        localHighscoreScoreTable = new int[19][1];
        Object object = RM.getRMS(1, false);
        if (object != null && RM.getRMSError() != 1) {
            object = RM.getDataInput(object);
            try {
                for (int i = 0; i < 19; ++i) {
                    for (int j = 0; j < 1; ++j) {
                        Menu.localHighscoreScoreTable[i][j] = object.readInt();
                    }
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                RM.closeStream((InputStream)object);
            }
        }
    }

    protected static final void doPause() {
        GCanvas.resetKeys();
        if (!paused) {
            int n;
            paused = true;
            if (mode != 0 && (mode == 2 || menus[n = currentMenu][2] != 4)) {
                Menu.userPause$1385ff();
            }
        }
    }

    private static void userPause$1385ff() {
        if (mode == 2) {
            if (delayedMenuCountDown > 0) {
                delayedMenuCountDown = -1;
                Menu.changeMenu(0, false);
                return;
            }
            Menu.changeMenu(7, false);
        }
    }

    public static final void resumeFromInterrupt() {
        sResumeMusicAfterInterruptDelay = 20;
    }

    private static int getMenuType(int n) {
        return menus[n][2];
    }

    public static final int getMenuCaption(int n) {
        return RM.getShortFromBytes(menus[n], 0);
    }

    private static final void menuItemSelected() {
        if (selectedItem >= 0) {
            if (Menu.countEnabledItems(currentMenu) > 0) {
                int n = currentMenu;
                n = (n = menus[n][2]) == 2 ? 0 : selectedItem;
                byte[] byArray = menuItems[currentMenu][n];
                int n2 = byArray[2] & 0xFF;
                int n3 = byArray[3] & 0xFF;
                Menu.performMenuAction(n2, n3);
                return;
            }
        } else {
            int n = 3;
            Menu.performMenuAction(3, 255);
        }
    }

    public static final void performMenuAction(int n) {
        Menu.performMenuAction(n, 255);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void performMenuAction(int n, int n2) {
        if (n != 0) {
            transitionDirection = 1;
        }
        switch (n) {
            case 0: {
                return;
            }
            case 6: {
                Menu.changeMenu(n2, true);
                return;
            }
            case 7: {
                Menu.changeMenu(n2, false);
                return;
            }
            case 8: {
                transitionDirection = -1;
                Menu.changeMenu(n2, false);
                return;
            }
            case 18: {
                transitionDirection = -1;
                Menu.performMenuAction(8, 0);
                return;
            }
            case 1: {
                Menu.menuItemSelected();
                return;
            }
            case 2: {
                n = 3;
                Menu.performMenuAction(3, 255);
                return;
            }
            case 3: {
                if (menuCaller[currentMenu] == -2) {
                    transitionDirection = -1;
                    n = 4;
                    Menu.performMenuAction(4, 255);
                    return;
                }
                if (menuCaller[currentMenu] == -3) {
                    Menu.changeMode(0, -1);
                    return;
                }
                transitionDirection = -1;
                Menu.changeMenu((int)menuCaller[currentMenu], false);
                return;
            }
            case 9: {
                GCanvas.setSoftButton(-1, -1);
                game$486afe46.initGame(true);
                Menu.changeMode(2, -1);
                return;
            }
            case 15: {
                game$486afe46.restart(true);
                Menu.changeMode(2, -1);
                return;
            }
            case 4: {
                Menu.changeMode(2, -1);
                return;
            }
            case 5: {
                Menu.userPause$1385ff();
                return;
            }
            case 21: {
                Menu.startLoading(186);
                RM.deleteAllRecordStores();
                Menu.setInitialOptions(false);
                Menu.loadHighscore();
                game$486afe46.onGameReset();
                Menu.stopLoadingRefresh();
                n = 3;
                Menu.performMenuAction(3, 255);
                return;
            }
            case 23: {
                n = options[n2];
                Menu.options[n2] = n == 0 ? 1 : 0;
                Menu.refreshMenu();
                return;
            }
            case 27: {
                n = 27;
                Menu.menus[27][4] = n2 = (int)((byte)(mode == 2 ? 4 : 1));
                n = 27;
                n = menuItems[n].length - 1;
                if (Menu.getMenuItemCaption(27, n) == 24) {
                    Menu.menuItems[27][n][2] = n2 = (int)((byte)(mode == 2 ? 4 : 3));
                }
                Menu.changeMenu(27, true);
                return;
            }
            case 28: {
                String string;
                do {
                    if ((currentTranslationString += n2) < 0) {
                        currentTranslationString = RM.getNumStrings() - 1;
                    }
                    if (currentTranslationString < RM.getNumStrings()) continue;
                    currentTranslationString = 0;
                } while ((string = RM.getRawString(currentTranslationString)) == null || string.trim().length() <= 0);
                RM.setString(272, RM.getRawString(currentTranslationString));
                RM.prepareVarText(19, String.valueOf(currentTranslationString + 1), String.valueOf(RM.getNumStrings()));
                Menu.refreshMenu();
                return;
            }
            case 19: {
                Menu.stop();
                return;
            }
        }
        if (n == 20) {
            Menu.startLoading(languageLoadingMessage);
            RM.setLocale(n2);
            Menu.options[4] = RM.languageIndex;
            RM.setRMS(0, options);
            Menu.onLanguageChanged();
            Menu.stopLoadingRefresh();
            if (splashMode >= 10) {
                n = 3;
                Menu.performMenuAction(3, 255);
                return;
            }
            Menu.advanceSplashMode();
            Menu.changeMode(0, -1);
            Menu.onInput();
            return;
        }
        if (n == 22) {
            n = n2;
            n2 = options[n];
            if (n == 0) {
                Menu.options[n] = n2 == 0 ? 1 : 0;
            }
            Menu.updateVolume();
            if (menuCaller[currentMenu] == 7) {
                Menu.playSound(54);
                Menu.refreshMenu();
                return;
            }
            Menu.playMusic(true);
            Menu.refreshMenu();
            return;
        }
        if (n == 38) {
            Menu.options[0] = 1;
            Menu.advanceSplashMode();
            Menu.changeMode(0, -1);
            RM.setRMS(0, options);
            Menu.playMusic(true);
            return;
        }
        if (n == 39) {
            Menu.options[0] = 0;
            Menu.advanceSplashMode();
            Menu.changeMode(0, -1);
            RM.setRMS(0, options);
            return;
        }
        if (n == 26) {
            n = options[5];
            n = n == 0 ? 1 : 0;
            Menu.options[5] = n;
            GCanvas.setScreenOrientation(n);
            Menu.onLanguageChanged();
            Menu.refreshMenu();
            return;
        }
        int n3 = 0;
        while (n3 < extensions.length) {
            if (extensions[n3].performMenuAction(n, n2)) return;
            ++n3;
        }
    }

    public static final void shellOut(String string) {
        try {
            Menu.stopMusic();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
            MIDP20Proxy.platformRequest(Tinlet.instance, string);
            Menu.stop();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final void refreshMenu() {
        if (mode == 1) {
            int n = selectedItem;
            Menu.changeMenu(currentMenu, false);
            boolean bl = true;
            int n2 = currentMenu;
            n2 = menus[n2][2];
            if (n2 != 2 && n2 != 5) {
                boolean bl2 = bl = n < menuItems[currentMenu].length && menuItems[currentMenu][n][4] != 0;
            }
            if (bl) {
                Menu.setSelection(currentMenu, n, 0, false);
            }
        }
    }

    private static final int getSplashID(int n) {
        switch (n) {
            case 0: {
                return 29;
            }
            case 1: {
                return 30;
            }
            case 2: {
                if (GCanvas.isLandscape()) {
                    return 32;
                }
                return 31;
            }
        }
        return -1;
    }

    public static final void drawText(Graphics graphics, Vector vector, int n, int n2, int n3, int n4, int n5) {
        int n6 = GCanvas.getFontHeight(n4);
        int n7 = vector.size();
        for (int i = 0; i < n7; ++i) {
            Menu.drawMenuItem(graphics, n4, (String)vector.elementAt(i), n, n2, n3, n5);
            n2 += n6;
        }
    }

    public static final void resetItemBottom() {
        MENU_ITEM_BOTTOM = sOldItemBottom;
    }

    public static final void setItemBottom(int n) {
        MENU_ITEM_BOTTOM = n;
    }

    private static void setupLayout() {
        MENU_SEPERATOR_HEIGHT = GCanvas.getSpriteHeight(11) + 3;
        MENU_SEPERATOR_TOP = 3 + GCanvas.getFontHeight(1) + 3 + Math.abs(0);
        MENU_SCROLLTEXT_BOTTOM = GCanvas.getSoftKeyAreaTop();
        MENU_SCROLLTEXT_TOP = MENU_SCROLLTEXT_BOTTOM = Math.min(MENU_SCROLLTEXT_BOTTOM, GCanvas.height - RM.getHeight(49) - 2 - 1);
        sOldItemBottom = MENU_ITEM_BOTTOM = MENU_SCROLLTEXT_BOTTOM - MENU_SEPERATOR_HEIGHT;
        MENU_TEXT_WIDTH = GCanvas.width - 8;
    }

    private static int getTextSpacingByType(int n, int n2) {
        int n3 = GCanvas.getFontHeight(n);
        if (GCanvas.isSpacingNeeded(n)) {
            return n3;
        }
        return n3;
    }

    public static final int getTextSpacing(int n, int n2) {
        n2 = menus[n2][2];
        return Menu.getTextSpacingByType(n, n2);
    }

    public static final void screenSizeChanged() {
        Menu.setupLayout();
        if (mode == 1) {
            Menu.refreshMenu();
        }
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i] == null) continue;
            extensions[i].screenSizeChanged();
        }
    }

    public static final boolean isInitialized() {
        return splashMode > 5;
    }

    private static final void onLanguageChanged() {
        RM.prepareVarText(0, midletInfo);
        String string = null;
        string = RM.t(258);
        RM.prepareVarText(14, string);
    }

    public static final void addMenuItem(int n, int n2, int n3, int n4, int n5) {
        Menu.addMenuItem(n, menuItems[n].length, n2, n3, n4, 0);
    }

    public static final void addMenuItem(int n, int n2, int n3, int n4, int n5, int n6) {
        byte[][] byArray = menuItems[n];
        int n7 = byArray.length;
        byte[][] byArray2 = new byte[n7 + 1][6];
        for (int i = 0; i < n7; ++i) {
            System.arraycopy(byArray[i], 0, byArray2[i < n2 ? i : i + 1], 0, 6);
        }
        byte[] byArray3 = byArray2[n2];
        byte[] byArray4 = byArray3;
        byArray3[2] = (byte)n4;
        byArray4[3] = (byte)n5;
        byArray4[5] = (byte)n6;
        byArray4[4] = 1;
        Menu.setMenuItemCaption(byArray4, n3);
        Menu.menuItems[n] = byArray2;
    }

    public static final int findMenuItem(int n, int n2) {
        int n3 = -1;
        int n4 = n;
        n4 = menuItems[n4].length;
        for (int i = 0; i < n4; ++i) {
            if (Menu.getMenuItemCaption(n, i) != n2) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public static final int findMenuItemByTarget(int n, int n2) {
        int n3 = -1;
        int n4 = n;
        n4 = menuItems[n4].length;
        for (int i = 0; i < n4; ++i) {
            if (Menu.getMenuItemTarget(n, i) != n2) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public static final void playMusic(boolean bl) {
        Menu.playSound(53, true, true);
        titleMusicStarted = true;
    }

    public static final void playSound(int n) {
        int n2 = 0;
        if (options[n2] != 0) {
            Menu.playSound(n, false, false);
        }
    }

    private static final void playSound(int n, boolean bl, boolean bl2) {
        if (sound$25c7fb11 != null) {
            Menu.updateVolume();
            if (n >= 0) {
                sound$25c7fb11.play(n, bl, bl2);
            }
        }
    }

    public static final void stopMusic() {
        try {
            if (sound$25c7fb11 != null) {
                sound$25c7fb11.stop();
            }
        }
        catch (Exception exception) {}
        titleMusicStarted = false;
    }

    private static final void updateVolume() {
        if (sound$25c7fb11 != null) {
            int[] nArray = options;
            int n = options[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            sound$25c7fb11.setVolume(n2 * n, n3 * n);
        }
    }

    public static final boolean prepareHighscoreEntry(int n, int n2, byte[] byArray, int n3) {
        boolean bl = Menu.getHighscoreRanking(n, n2, 1) > -1;
        if (bl) {
            localHighscoreCandidateTable = n;
            localHighscoreCandidateScore = n2;
            localHighscoreCandidateSort = 1;
        }
        return bl;
    }

    private static int getHighscoreRanking(int n, int n2, int n3) {
        int n4 = -1;
        n2 *= n3;
        for (int i = 0; i < 1; ++i) {
            int n5 = localHighscoreScoreTable[n][0] * n3;
            if (n5 != 0 && n5 >= n2) continue;
            n4 = 0;
            break;
        }
        return n4;
    }

    public static final int addLocalHighscoreCandidate() {
        int n = localHighscoreCandidateTable;
        int n2 = localHighscoreCandidateScore;
        int n3 = localHighscoreCandidateSort;
        n3 = Menu.getHighscoreRanking(n, n2, n3);
        Object object = localHighscoreScoreTable[n];
        if (n3 >= 0) {
            int n4;
            for (n4 = -1; n4 >= n3; --n4) {
                object[n4 + 1] = object[n4];
            }
            object[n3] = n2;
            object = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            try {
                for (n4 = 0; n4 < 19; ++n4) {
                    for (int i = 0; i < 1; ++i) {
                        dataOutputStream.writeInt(localHighscoreScoreTable[n4][i]);
                    }
                }
                dataOutputStream.close();
                byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                RM.setRMS(1, byArray);
            }
            catch (Exception exception) {
            }
            finally {
                RM.closeStream(dataOutputStream);
            }
        }
        return n3;
    }

    public static final int countEnabledItems(int n) {
        byte[][] byArray = menuItems[n];
        return Menu.countEnabledItems(n, byArray.length);
    }

    private static int countEnabledItems(int n, int n2) {
        byte[][] byArray = menuItems[n];
        n2 = GCanvas.clamp(n2, 0, byArray.length);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i][4] == 0) continue;
            ++n3;
        }
        return n3;
    }

    private static final void setMenuItemPosition(int n, int n2) {
        menuItemPosition = n2 == 1 ? -Menu.countEnabledItems(currentMenu, selectedItem) * n : -selectedItem * n;
        if (menuItemPosition < -menuItemPositionMax) {
            menuItemPosition = -menuItemPositionMax;
        }
        if (menuItemPosition > 0) {
            menuItemPosition = 0;
        }
    }

    private static final void setMenuItemPosition(int n, boolean bl, boolean n2) {
        int n3;
        int n4 = n;
        int n5 = menus[n4][2];
        showUpArrow = false;
        showDownArrow = false;
        byte[][] byArray = Menu.getMenuItems(n);
        if (byArray == null) {
            return;
        }
        int n6 = byArray.length;
        int n7 = MENU_ITEM_BOTTOM - (Menu.getMenuSeperatorTop() + MENU_SEPERATOR_HEIGHT);
        byte[][] byArray2 = Menu.getMenuItems(n);
        if (byArray2 != null && byArray2.length > 0) {
            n4 = n;
            if (Menu.isDynamicType(n = menus[n4][2])) {
                n4 = byArray2.length;
                n = Menu.getMenuItemHeight(byArray2[0], n);
                int n8 = 0;
                for (int i = 0; i < n4; ++i) {
                    if (byArray2[i][4] == 0) continue;
                    n8 += n;
                }
                n3 = n8;
            } else {
                n3 = Menu.getMenuItemHeight(byArray2[0], n) * byArray2.length;
            }
        } else {
            n3 = GCanvas.getFontHeight(2);
        }
        n = n3;
        menuClipTop = Menu.getMenuSeperatorTop() + MENU_SEPERATOR_HEIGHT;
        menuClipHeight = MENU_ITEM_BOTTOM - menuClipTop;
        int n9 = Menu.getMenuItemHeight(byArray[0], n5);
        if (n7 >= n) {
            menuItemPosition = 0;
            menuClipTop = Menu.getMenuSeperatorTop() + MENU_SEPERATOR_HEIGHT + (n7 - n) / 2;
            menuClipHeight = n;
            menuItemEase = menuItemPosition << 10;
            menuItemPositionMax = n - menuClipHeight;
            return;
        }
        n7 = menuClipHeight;
        int n10 = menuClipHeight / n9;
        menuClipHeight = n10 * n9;
        menuClipTop += (n7 - menuClipHeight) / 2;
        menuItemPositionMax = n - menuClipHeight;
        if (n5 == 2 || n5 == 5) {
            if (selectedItem > n6 - n10) {
                selectedItem = n6 - n10;
            }
            Menu.setMenuItemPosition(n9, n5);
        } else {
            if (n2 != 0) {
                Menu.setMenuItemPosition(n9, n5);
            }
            n = selectedItem;
            if (n5 == 1) {
                n = Menu.countEnabledItems(currentMenu, selectedItem);
            }
            n2 = -menuItemPosition;
            n5 = n2 / n9;
            n6 = n5 + n10;
            if (n10 > 2) {
                if (n <= n5) {
                    n2 -= n9;
                }
                if (n >= n6 - 1) {
                    n2 += n9;
                }
            } else {
                if (n < n5) {
                    n2 -= n9;
                }
                if (n > n6 - 1) {
                    n2 += n9;
                }
            }
            if (n2 > menuItemPositionMax) {
                n2 = menuItemPositionMax;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            menuItemPosition = -n2;
        }
        menuItemEase = bl ? ((n = (menuItemPosition << 10) - menuItemEase) < -3 || n > 3 ? (menuItemEase += n / 4) : (menuItemEase += n)) : menuItemPosition << 10;
        showUpArrow = menuItemPosition < 0;
        showDownArrow = menuItemPosition > -menuItemPositionMax;
    }

    private static final boolean isDynamicType(int n) {
        return n == 1 || n == 4;
    }

    private static final boolean isMenuItemVisible(int n, byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = byArray[4] != 0;
        return !Menu.isDynamicType(n) || bl;
    }

    private static final int updateScrolling(int[] nArray) {
        int n = nArray[1];
        int n2 = n >> 10;
        nArray[4] = nArray[4] - 1;
        if (nArray[4] < 0) {
            int n3 = nArray[2];
            int n4 = nArray[3];
            nArray[1] = n += 1536 * nArray[5];
            if (n >= n3 || n < n4) {
                nArray[5] = -nArray[5];
            }
        }
        return n2;
    }

    public static final void setMenuItemOverlayWith(int n) {
        menuItemOverlayWidth = n;
    }

    public static final void drawMenuItem(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        if (game$486afe46.menuHighlightSelection(currentMenu)) {
            Menu.sCustomItemPositionArray[0] = n2;
            Menu.sCustomItemPositionArray[1] = n3;
            if (game$486afe46.getCustomMenuItemPosition$1c96c319(sCustomItemPositionArray, n5)) {
                n2 = sCustomItemPositionArray[0];
                n3 = sCustomItemPositionArray[1];
            }
        }
        if (!game$486afe46.menuDrawItem(graphics, n, string, n2, n3, n4)) {
            GCanvas.drawString(graphics, n, string, n2, n3, n4);
        }
    }

    private static final void setMenuItemCaption(byte[] byArray, int n) {
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)n;
    }

    public static final int getMenuItemAction(int n, int n2) {
        return menuItems[n][n2][2];
    }

    public static final int getMenuItemCount(int n) {
        return menuItems[n].length;
    }

    public static final int getMenuItemTarget(int n, int n2) {
        return menuItems[n][n2][3];
    }

    private static final int getMenuItemCaption(byte[] byArray) {
        return RM.getShortFromBytes(byArray, 0);
    }

    private static int getMenuItemCaption(int n, int n2) {
        return RM.getShortFromBytes(menuItems[n][n2], 0);
    }

    public static final void setMenuItemCaption(int n, int n2, int n3) {
        byte[] byArray = menuItems[n][1];
        Menu.setMenuItemCaption(byArray, n3);
    }

    public static final void setMenuItemTarget(int n, int n2, int n3) {
        Menu.menuItems[n][n2][3] = (byte)n3;
    }

    public static final void setMenuItemAction(int n, int n2, int n3) {
        Menu.menuItems[n][n2][2] = (byte)n3;
    }

    public static final void setMenuItemCondition(int n, int n2, int n3) {
        Menu.menuItems[2][n2][5] = (byte)n3;
    }

    public static final int getCurrentMenu() {
        return currentMenu;
    }

    public static final int getMenuItemHeight(int n) {
        byte[] byArray = menuItems[n][0];
        return Menu.getMenuItemHeight(byArray, menus[n][2]);
    }

    private static final int getMenuItemHeight(byte[] byArray, int n) {
        int n2 = n == 2 || n == 5 ? 5 : 2;
        n2 = Menu.getTextSpacingByType(n2, n);
        n = 0;
        n = n2;
        return n;
    }

    private static final byte[][] getMenuItems(int n) {
        int n2 = n;
        if (menus[n2][2] != 2) {
            return menuItems[n];
        }
        return textScreenItems;
    }

    public static final int getMenuItemTop() {
        return Menu.getMenuSeperatorTop() + MENU_SEPERATOR_HEIGHT;
    }

    public static final int getMenuCaptionBottom() {
        return MENU_SEPERATOR_TOP;
    }

    private static int getMenuSeperatorTop() {
        int n = MENU_SEPERATOR_TOP + menuCaptionOffset;
        if (menuCaptionImage >= 0) {
            n += RM.getHeight(menuCaptionImage);
            n += 4;
        }
        return n;
    }

    public static final int getMenuClipTop() {
        return menuClipTop;
    }

    private static final void updateMenuItemsWidths(int n) {
        byte[][] byArray = menuItems[n];
        int n2 = byArray.length;
        int n3 = n;
        n = menus[n3][2];
        for (int i = 0; i < n2; ++i) {
            Object object = byArray[i];
            int n4 = 4;
            if (Menu.isMenuItemVisible(n, object)) {
                n4 = menuItemOverlayWidth << 1;
                String string = RM.t(RM.getShortFromBytes(object, 0));
                object = string;
                RM.fitString(string, i, MENU_TEXT_WIDTH - n4, 2);
                n4 += GCanvas.getStringWidth((String)object, 2);
            }
            Menu.menuItemWidths[i] = n4;
        }
    }

    private static final void changeMode(int n, int n2) {
        GCanvas.resetKeys();
        if (n == 2) {
            paused = false;
            if (currentMenu != 7) {
                Menu.stopMusic();
            }
            Menu.menuSelection[7] = 0;
            lskEnabled = true;
            rskEnabled = true;
            Menu.notifyGame(true);
        } else if (n == 1) {
            if (mode == 2) {
                if (game$486afe46.musicShouldStop(n2)) {
                    Menu.stopMusic();
                }
                Menu.notifyGame(false);
            }
        } else if (n == 0) {
            GCanvas.setSoftButton(-1, -1);
        }
        GCanvas.hideSoftKeys = n == 0;
        mode = n;
    }

    private static final void notifyGame(boolean bl) {
        game$486afe46.notify(bl);
    }

    private static final void prepareMessage$43de0406(String string, String string2, int n, int n2) {
        RM.setString(289, string);
        RM.setString(290, string2);
        Menu.menus[25][3] = (byte)n;
        Menu.menus[25][4] = (byte)n2;
    }

    public static final void showMessage(String string, String string2, int n, int n2, int n3) {
        Menu.prepareMessage$43de0406(string, string2, n, -1);
        Menu.changeMenu(25, n3);
    }

    public static final void showMessage(int n, int n2, int n3, int n4) {
        n4 = 1;
        n3 = -1;
        String string = RM.t(324);
        String string2 = RM.t(315);
        Menu.prepareMessage$43de0406(string2, string, n3, n4);
        Menu.changeMenu(25, currentMenu);
    }

    private static void changeMenu(int n, int n2) {
        Menu.changeMenu(25, false);
        n = 25;
        Menu.menuCaller[n] = (byte)n2;
    }

    public static final int getTextWidth() {
        return MENU_TEXT_WIDTH - 2 * GCanvas.getCharWidth('X', 5);
    }

    public static final void changeMenu(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        boolean bl2;
        int n5;
        GCanvas.resetKeys();
        menuCaptionImage = -1;
        menuCaptionOffset = 0;
        if (bl) {
            n5 = currentMenu;
            if (menus[n5][2] != 2) {
                Menu.menuSelection[Menu.currentMenu] = (byte)selectedItem;
            }
            if (n != currentMenu) {
                int n6 = currentMenu;
                n5 = n;
                Menu.menuCaller[n5] = (byte)n6;
            }
        } else {
            byte by;
            byte by2 = (byte)(currentMenu != n ? 0 : selectedItem);
            if (menus[currentMenu][2] == 4) {
                by = 0;
            }
            Menu.menuSelection[Menu.currentMenu] = by;
        }
        if (bl2 = n != currentMenu || mode != 1) {
            transitionFrame = 5;
        }
        int n7 = n;
        int n8 = currentMenu;
        if (n7 == 24) {
            n5 = 4;
            n4 = options[n5];
            if (n4 < 0) {
                n4 = -(n4 + 1);
            }
            Menu.menuSelection[24] = (byte)n4;
        }
        if (n7 == 8) {
            int n9 = 5;
            int n10 = 10;
            RM.prepareVarText(10, options[5] == 0 ? RM.t(50) : RM.t(49));
        }
        if (n7 == 27 && n7 != n8) {
            currentTranslationString = -1;
            Menu.performMenuAction(28, 1);
        }
        if (n8 == 8 && n7 == menuCaller[8]) {
            RM.setRMS(0, options);
        }
        if (n7 == 8) {
            String string = null;
            n3 = options[0];
            string = n3 == 0 ? RM.t(50) : RM.t(49);
            RM.prepareVarText(2, string);
        }
        for (n2 = 0; n2 < extensions.length; ++n2) {
            extensions[n2].onPrepareMenuChange(n7, n8);
        }
        Menu.evaluateMenuConditions(n7);
        if (mode != 1) {
            Menu.changeMode(1, n);
        }
        boolean bl3 = false;
        if (n == 0 && currentMenu != 0) {
            bl3 = true;
        }
        textScreenItems = null;
        RM.flushDynamicStrings(0);
        n5 = n;
        n8 = menus[n5][2];
        if (n8 == 2) {
            Object object;
            int n11;
            n2 = n8 = n == 15 || n == 17 || n == 18 || n == 19 || n == 20 ? 1 : 0;
            n4 = Menu.getTextWidth();
            n7 = 5;
            n8 = n;
            if (n2 != 0) {
                Menu.startLoading(184);
            }
            Vector<String> vector = new Vector<String>(10, 2);
            byte[][] byArray = menuItems[n8];
            n3 = byArray.length;
            n7 = 0;
            for (int i = 0; i < n3; ++i) {
                int n12;
                n11 = 0;
                Object object2 = byArray[i];
                object2 = RM.t(RM.getShortFromBytes((byte[])object2, 0));
                while (n11 >= 0 && (n12 = Menu.nextBreak(n11, (String)object2, 5, n4)) >= 0) {
                    object = ((String)object2).substring(n11, n12).trim();
                    if ((n11 = ((String)object).length()) > 0 || n7 > 0) {
                        vector.addElement(((String)object).replace('\u0093', ' '));
                    }
                    n7 = n11;
                    n11 = n12;
                }
                if (n7 <= 0) continue;
                vector.addElement("");
                n7 = 0;
            }
            byte[] byArray2 = menuItems[n8][0];
            n11 = byArray2.length;
            n5 = Menu.multiLineGetNonEmptyLines(vector);
            byte[][] byArray3 = new byte[n5][n11];
            RM.flushDynamicStrings(n5);
            n8 = n5;
            sDynamicStringsMeta = n8 > 0 ? new int[n8][] : null;
            for (n8 = 0; n8 < n5; ++n8) {
                object = byArray3[n8];
                System.arraycopy(byArray2, 0, object, 0, n11);
                vector.elementAt(n8);
                String string = null;
                string = Menu.dynamicStringMetaParse((String)vector.elementAt(n8), 5);
                n7 = RM.createDynamicString(string);
                Menu.setMenuItemCaption((byte[])object, n7);
            }
            textScreenItems = byArray3;
            if (n2 != 0) {
                Menu.stopLoading();
            }
        }
        Menu.updateMenuItemsWidths(n);
        Menu.setSelection(n, menuSelection[n], 1, bl2);
        Menu.setMenuItemPosition(n, false, false);
        n8 = n;
        n7 = Menu.getMenuCaption(n8);
        if (n7 != -1) {
            n2 = GCanvas.getTextWidth(n7, 1);
            Menu.setMenuScrollData(scrInfo[0], n2, 2);
        } else {
            Menu.scrInfo[0][0] = 0;
        }
        currentMenu = n;
        if (bl3 && !titleMusicStarted) {
            Menu.playMusic(true);
        }
    }

    public static final void showMenuTransition(int n) {
        transitionDirection = n;
        transitionFrame = 5;
    }

    public static final void setMenuCaptionOffset(int n) {
        if (n != menuCaptionOffset) {
            menuCaptionOffset = n;
            Menu.setMenuItemPosition(currentMenu, true, true);
        }
    }

    public static final void evaluateMenuConditions(int n) {
        byte[][] byArray = menuItems[n];
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            byte[] byArray2 = byArray[i];
            byte by = byArray2[5];
            int n3 = byArray2[3] & 0xFF;
            block0 : switch (by) {
                case -1: 
                case 0: {
                    bl = true;
                    break;
                }
                case 4: {
                    if (localHighscoreScoreTable[n3][0] != 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (menuCaller[8] == 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 6: {
                    bl = GCanvas.isLandscape();
                    break;
                }
                default: {
                    if (by == 5) {
                        if (menuCaller[8] == 0) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    if (by == 3) {
                        if (menuCaller[8] == 0) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    for (int j = 0; j < extensions.length; ++j) {
                        int n4 = extensions[j].evaluateCondition(by, n3);
                        if (n4 < 0) {
                            bl = false;
                            break block0;
                        }
                        if (n4 > 0) break;
                    }
                    bl = true;
                }
            }
            by = bl ? (byte)1 : 0;
            byArray2[4] = by;
        }
    }

    public static final void saveOptions() {
        RM.setRMS(0, options);
    }

    public static final void setDefaultSelection(int n, int n2) {
        Menu.menuSelection[n] = (byte)n2;
    }

    public static final int getSelection() {
        return selectedItem;
    }

    public static final void setSelection(int n) {
        selectedItem = n;
        Menu.setMenuItemPosition(currentMenu, false, false);
    }

    private static final void setSelection(int n, int n2, int n3, boolean by) {
        byte by2;
        int n4;
        int n5 = n;
        n = 0;
        byte by3 = by;
        n = n5;
        byte[][] byArray = menuItems[n];
        int n6 = -1;
        if (by3 == 0) {
            n6 = selectedItem;
        }
        int n7 = n;
        boolean bl = (n7 = menus[n7][2]) == 2;
        if (bl) {
            byArray = textScreenItems;
        }
        int n8 = byArray.length;
        if (bl && by3 == 0) {
            n4 = menuClipHeight / Menu.getMenuItemHeight(n);
            n2 -= n3;
            n2 = GCanvas.clamp(n2 + (n4 - 1) * n3, 0, n8 - 1);
        }
        if ((n4 = !bl && n7 != 5 && (n2 < 0 || n2 >= n8) ? 1 : 0) != 0) {
            if (n2 < 0) {
                n2 = n8 - 1;
            }
            if (n2 >= n8) {
                n2 = 0;
            }
        } else {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= n8) {
                n2 = n8 - 1;
            }
        }
        if ((n7 = Menu.countEnabledItems(n, n8)) == 0) {
            n2 = 0;
        } else if (!bl && n2 >= 0) {
            while (byArray[n2][4] == 0) {
                if (n3 == 0) {
                    n3 = 1;
                }
                if ((n2 += n3) < 0) {
                    if (by3 != 0) {
                        n2 = 0;
                        n3 = -n3;
                    } else {
                        n2 = n8 - 1;
                    }
                }
                if (n2 < n8) continue;
                if (by3 != 0) {
                    n2 = 0;
                    n3 = -n3;
                    continue;
                }
                n2 = n6;
                break;
            }
        }
        selectedItem = n2;
        if (n4 != 0 || by3 != 0) {
            Menu.setMenuItemPosition(n, false, true);
        }
        lskEnabled = true;
        rskEnabled = true;
        if (!GCanvas.hideSoftKeys) {
            n3 = 0;
            if (n == 24) {
                if (menuCaller[n] != 8) {
                    n3 = 2;
                }
                int n9 = n2;
                n2 = n;
                int n11 = RM.encodeStringToInt(RM.getLocales()[n9]);
                n11 = RM.getLink(790, 0, n11);
                int n12 = RM.getValue(790, n11, 1);
                Menu.menus[n2][0] = (byte)(n12 >> 8 & 0xFF);
                Menu.menus[n2][1] = (byte)n12;
                languageLoadingMessage = RM.getValue(790, n11, 4);
            }
            for (n2 = 0; n2 < extensions.length; ++n2) {
                n3 |= extensions[n2].updateSoftButtonState(n);
            }
            boolean bl2 = (n3 & 2) == 0;
            byte[] byArray2 = menus[n];
            n3 = (lskEnabled &= (n3 & 1) == 0) ? byArray2[3] : -1;
            n2 = (rskEnabled &= bl2) ? byArray2[4] : -1;
            GCanvas.setSoftButton(n3, n2);
        }
        if ((by2 = menus[n7 = (n2 = n)][2]) != 2 && by2 != 5) {
            boolean bl3 = false;
            int n13 = menuItemOverlayWidth;
            Menu.setMenuScrollData(scrInfo[1], menuItemWidths[selectedItem], n13);
            return;
        }
        Menu.scrInfo[1][0] = 0;
    }

    private static final void setMenuScrollData(int[] nArray, int n, int n2) {
        nArray[0] = 0;
        if (n > MENU_TEXT_WIDTH) {
            nArray[0] = 1;
            nArray[2] = n + 2 + 8 - n2 << 10;
            nArray[3] = GCanvas.width - 4 - n2 << 10;
            nArray[4] = 20;
            nArray[1] = nArray[3];
            nArray[5] = 1;
        }
    }

    public static final void startLoading(int n) {
        showLoading = true;
        statusText = RM.t(n);
        GCanvas.setSoftButton(-1, -1);
        GCanvas.hideSoftKeys = true;
        loadingFrame = 0;
        if (mode == 2) {
            Menu.notifyGame(false);
        }
        GCanvas.redraw();
        try {
            Thread.sleep(50L);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void stopLoadingRefresh() {
        showLoading = false;
        statusText = null;
        GCanvas.resetKeys();
        boolean bl = GCanvas.hideSoftKeys = mode == 2;
        if (mode == 2) {
            Menu.notifyGame(true);
            return;
        }
        Menu.refreshMenu();
    }

    public static final void stopLoading() {
        showLoading = false;
        statusText = null;
        GCanvas.hideSoftKeys = mode == 2;
        GCanvas.resetKeys();
        if (mode == 2) {
            Menu.notifyGame(true);
        }
    }

    private static final int nextBreak(int n, String string, int n2, int n3) {
        int n4 = n;
        int n5 = string.length();
        if (n >= n5) {
            return -1;
        }
        int n6 = n;
        while (true) {
            int n7;
            if (n4 < n5) {
                n7 = string.charAt(n4);
                if (n7 > 32 || n7 == 147) {
                    ++n4;
                    continue;
                }
                if (n4 < n5 - 1) {
                    char c = string.charAt(n4 + 1);
                    n7 = c;
                    if (c == '!' || n7 == 63 || n7 == 58 || n7 == 187) {
                        n4 += 2;
                        continue;
                    }
                    if (n4 > 0) {
                        char c2 = string.charAt(n4 - 1);
                        n7 = c2;
                        if (c2 == '\u00ab') {
                            ++n4;
                            continue;
                        }
                    }
                }
            }
            n7 = GCanvas.getSubstringWidth(string, n6, n4 - n6, n2);
            if (n == n6 && n7 > n3) {
                while (GCanvas.getSubstringWidth(string, n6, --n4 - n6, n2) >= n3) {
                    char c = string.charAt(n4);
                    n = c;
                    if (c != '.' && n != 44 && n != 12290) continue;
                    --n4;
                }
                n = n4;
                break;
            }
            if (n7 <= n3) {
                n = n4;
            }
            if (n7 > n3 || n4 >= n5 || string.charAt(n4) == '\n') break;
            ++n4;
        }
        if (n >= n5) {
            return n;
        }
        return ++n;
    }

    private static final int multiLineGetNonEmptyLines(Vector vector) {
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            String string = (String)vector.elementAt(i);
            if (string.length() <= 0) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    private static final String dynamicStringMetaParse(String string, int n) {
        String string2;
        int n2 = RM.getNextDynamicString();
        if (sDynamicStringMetaTemp == null) {
            sDynamicStringMetaTemp = new Vector();
        } else {
            sDynamicStringMetaTemp.removeAllElements();
        }
        if (sDynamicStringsInHighlightBlock) {
            int n3 = string.indexOf(125);
            if (n3 != -1) {
                sDynamicStringsInHighlightBlock = false;
                string2 = string.substring(0, n3);
                int n4 = GCanvas.getStringWidth(string2, n);
                String string3 = string.substring(n3 + 1);
                string = string2 + string3;
                sDynamicStringMetaTemp.addElement(new Integer(-9236456));
                sDynamicStringMetaTemp.addElement(new Integer(-1));
                sDynamicStringMetaTemp.addElement(new Integer(n4));
            } else {
                sDynamicStringMetaTemp.addElement(new Integer(-9236456));
                sDynamicStringMetaTemp.addElement(new Integer(-1));
                sDynamicStringMetaTemp.addElement(new Integer(-1));
            }
        }
        int n5 = string.indexOf(123);
        while (n5 != -1) {
            sDynamicStringsInHighlightBlock = true;
            string2 = string.substring(0, n5);
            String string4 = string.substring(n5 + 1);
            string = string2 + string4;
            sDynamicStringMetaTemp.addElement(new Integer(-9236456));
            n5 = GCanvas.getStringWidth(string2, n);
            sDynamicStringMetaTemp.addElement(new Integer(n5));
            int n6 = string.indexOf(125);
            if (n6 != -1) {
                sDynamicStringsInHighlightBlock = false;
                string2 = string.substring(0, n6);
                n5 = GCanvas.getStringWidth(string2, n);
                sDynamicStringMetaTemp.addElement(new Integer(n5));
                String string5 = string.substring(n6 + 1);
                string = string2 + string5;
                n5 = string.indexOf(123);
                continue;
            }
            sDynamicStringMetaTemp.addElement(new Integer(-1));
            n5 = n6;
        }
        if (sDynamicStringMetaTemp.size() > 0) {
            Menu.sDynamicStringsMeta[n2] = new int[sDynamicStringMetaTemp.size()];
            for (int i = 0; i < sDynamicStringMetaTemp.size(); ++i) {
                Menu.sDynamicStringsMeta[n2][i] = (Integer)sDynamicStringMetaTemp.elementAt(i);
            }
        }
        return string;
    }

    public static int breakLine(Vector vector, int n, String string, int n2) {
        int n3;
        int n4 = 0;
        while (n4 >= 0 && (n3 = Menu.nextBreak(n4, string, n, n2)) >= 0) {
            String string2 = string.substring(n4, n3).trim();
            int n5 = string2.length();
            if (n5 > 0) {
                vector.addElement(string2.replace('\u0093', ' '));
            }
            n4 = n3;
        }
        return vector.size();
    }

    protected static final void onLoadingStart(int n) {
        progressBarMax = n;
        progressBarMax += 137;
        GCanvas.redraw();
    }

    public static final void onLoadingStep(int n) {
        progressCurrent = n;
        if (RM.getCurrentLoading() > Menu.getSplashID(0) && currentSplash < 0) {
            Menu.startSplash(0, 3400);
        }
        if ((n & 0x1F) == 0) {
            GCanvas.redraw();
        }
        GCanvas.idleTick();
    }

    protected static final void onLoadingDone() {
        Menu.advanceSplashMode();
    }

    public static final void loadJadParams() {
        Menu.midletInfo[0] = Menu.readJad("MIDlet-Name") + "";
        Menu.midletInfo[0] = midletInfo[0].toUpperCase();
        Menu.midletInfo[1] = Menu.readJad("MIDlet-Version") + "";
        int n = GCanvas.width;
        int n2 = GCanvas.height;
        n = Menu.readJadInt("FORCEDSCREENWIDTH", n);
        n2 = Menu.readJadInt("FORCEDSCREENHEIGHT", n2);
        GCanvas.setForcedSize(n, n2);
    }

    public static final String readJad(String string) {
        if ((string = Tinlet.instance.getAppProperty(string)) != null) {
            string = string.trim();
        }
        return string;
    }

    private static int readJadInt(String string, int n) {
        block4: {
            if ((string = Menu.readJad(string)) != null) {
                try {
                    int n2;
                    n = n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if ("Y".equals(string)) {
                        n = 1;
                    }
                    if (!"N".equals(string)) break block4;
                    n = 0;
                }
            }
        }
        return n;
    }

    public static final void setOptionBit(int n, int n2, boolean bl) {
        while (n2 >= 32) {
            n2 -= 32;
            --n;
        }
        int n3 = n;
        n3 = options[n3];
        n2 = bl ? n3 | 1 << n2 : n3 & ~(1 << n2);
        int n4 = n;
        n = n2;
        n3 = n4;
        Menu.options[n3] = n;
    }

    public static final boolean isOptionBitSet(int n, int n2) {
        while (n2 >= 32) {
            n2 -= 32;
            --n;
        }
        return (options[n] & 1 << n2) != 0;
    }

    public static int getMode() {
        return mode;
    }

    public static final int getSplashMode() {
        return splashMode;
    }

    static {
        extensions = new IMenuExtension[2];
        midletInfo = new String[2];
        currentMenu = 20;
        scrInfo = new int[2][6];
        titleMusicStarted = false;
        progressBarMax = 792;
        dirtyRect = new int[4];
        sResumeMusicAfterInterruptDelay = -1;
        sOldItemBottom = 0;
        sCurrentDrawnItem = -1;
        sCustomItemPositionArray = new int[2];
    }
}

