/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.render3d.m3g;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import tinbrain.GCanvas;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.math3d.Matrix33;
import tinbrain.math3d.Point3D;
import tinbrain.midp20.MIDP20Proxy;
import tinbrain.render3d.AbstractRenderer;
import tinbrain.render3d.AbstractTriangleBuffer;
import tinbrain.render3d.ParticleSystem3D;
import tinbrain.render3d.m3g.M3GC;
import tinbrain.render3d.m3g.TriangleBuffer;

public final class Renderer
extends AbstractRenderer {
    private final Image2D[] textureCache = new Image2D[3];
    private final int[] textureCacheIDs = new int[3];
    private int[] textureShiftCache = new int[3];
    private int textureCachePtr;
    private final Appearance[] mAppCache = new Appearance[16];
    private int mAppCachePtr;
    private static Appearance m3gAppearanceDefault;
    private static Appearance m3gAppearanceHalf;
    private static Appearance m3gAppearanceAdd;
    private static Appearance m3gAppearanceSub;
    private static Mesh[] objectCache;
    private static Appearance[] objectAppCache;
    private static final short[] SPRITE_VERTS;
    private static final byte[] SPRITE_TEXUV;
    private static TriangleStripArray spriteStrip;
    private static VertexBuffer spriteBuf;
    private static VertexArray spritePos;
    private static VertexArray spriteTex;
    private Image landscapeRenderTarget;
    private Graphics landscapeGraphics;
    private static Light lightAmbient;
    private int m3gFov;
    private float m3gAspect;
    private float m3gAspectDiv;
    private static Graphics3D g3D;
    private static Background background;
    private static Camera m3gCamera;
    private static Transform trnCam;
    private static float[] matrixCam;
    private static float[] matrixSpr;

    public final void init(int n) {
        super.init(n);
        try {
            n = RM.getHeight(n);
            objectCache = new Mesh[n];
            objectAppCache = new Appearance[n];
            for (int i = 0; i < n; ++i) {
                boolean bl;
                int n2;
                int n3 = i;
                Renderer renderer = this;
                Mesh[] meshArray = objectCache;
                if (objectCache[n3] == null && (n2 = RM.getValue(renderer.objectDefinitions, n3, 3)) >= 0 && !(bl = RM.getType(n2))) {
                    try {
                        String string = RM.getResfileName(n2);
                        Object3D[] object3DArray = Loader.load((String)string);
                        meshArray[n3] = (Mesh)object3DArray[0];
                        n2 = meshArray[n3].getScope();
                        meshArray[n3].setScope(-1);
                        bl = (n2 & 0xF00) == 0;
                        int n4 = RM.getValue(renderer.objectDefinitions, n3, 2);
                        n2 = renderer.loadAppearance$3b460438(n4, n2, bl);
                        meshArray[n3].getVertexBuffer().setDefaultColor(Integer.MAX_VALUE);
                        meshArray[n3].setAppearance(0, renderer.mAppCache[n2]);
                        Renderer.objectAppCache[n3] = renderer.mAppCache[n2];
                    }
                    catch (Exception exception) {}
                }
                Menu.onLoadingStep(i + 792);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private int loadTexture(int n) {
        int n2;
        Image2D[] image2DArray = this.textureCache;
        int[] nArray = this.textureCacheIDs;
        int n3 = image2DArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray[n2] != n) continue;
            return n2;
        }
        n2 = this.textureCachePtr++;
        nArray[n2] = n;
        Image image = RM.getImage(n);
        image2DArray[n2] = new Image2D(100, (Object)image);
        this.textureShiftCache[n2] = GCanvas.log2(image.getWidth());
        return n2;
    }

    private int loadAppearance$3b460438(int n, int n2, boolean bl) {
        Appearance appearance;
        CompositingMode compositingMode;
        int n3 = n2 & 0xF;
        n2 = (n2 & 0xF0) != 0 ? 1 : 0;
        int n4 = 68;
        int n5 = 228;
        if (n3 == 2) {
            n4 = 65;
        } else if (n3 == 3) {
            n4 = 64;
        } else if (n3 == 4) {
            n4 = 66;
        }
        if (n >= 0) {
            if (n3 == 1) {
                n5 = 227;
            }
            if (n3 == 3) {
                n5 = 227;
            }
            if (n2 != 0 && n3 != 2) {
                n4 = 64;
            }
        }
        Appearance[] appearanceArray = this.mAppCache;
        for (n3 = 0; n3 < this.mAppCachePtr; ++n3) {
            Appearance appearance2 = appearanceArray[n3];
            compositingMode = appearance2.getCompositingMode();
            if (compositingMode == null || compositingMode.isDepthWriteEnabled() != bl || compositingMode.getBlending() != n4) continue;
            if (n >= 0) {
                int n6;
                compositingMode = this.textureCache[this.loadTexture(n)];
                if ((appearance2 = appearance2.getTexture(0)) == null || appearance2.getImage() != compositingMode || (n6 = appearance2.getBlending()) != n5) continue;
            }
            return n3;
        }
        appearanceArray[this.mAppCachePtr] = appearance = new Appearance();
        CompositingMode compositingMode2 = new CompositingMode();
        compositingMode2.setBlending(n4);
        compositingMode2.setDepthWriteEnable(bl);
        compositingMode2.setAlphaWriteEnable(true);
        appearance.setCompositingMode(compositingMode2);
        compositingMode = new PolygonMode();
        compositingMode.setCulling(160);
        compositingMode.setShading(165);
        compositingMode.setPerspectiveCorrectionEnable(true);
        appearance.setPolygonMode((PolygonMode)compositingMode);
        if (n >= 0) {
            compositingMode = new Texture2D(this.textureCache[this.loadTexture(n)]);
            compositingMode.setFiltering(208, 210);
            compositingMode.setWrapping(241, 241);
            compositingMode.setBlending(n5);
            appearance.setTexture(0, (Texture2D)compositingMode);
        }
        return this.mAppCachePtr++;
    }

    public final void setViewport(int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        if (GCanvas.getScreenOrientation() != GCanvas.getPhysicalScreenOrientation()) {
            n5 = n4;
            n6 = n3;
            this.landscapeRenderTarget = Image.createImage((int)n5, (int)n6);
            this.landscapeGraphics = this.landscapeRenderTarget.getGraphics();
        } else {
            this.landscapeRenderTarget = null;
            this.landscapeGraphics = null;
        }
        super.setViewport(n, n2, n3, n4);
        if (g3D == null) {
            g3D = Graphics3D.getInstance();
            m3gCamera = new Camera();
            this.m3gFov = this.camera.getFOV() * 50 >> 10;
            trnCam = new Transform();
            matrixCam = new float[16];
            matrixSpr = new float[16];
            Renderer.matrixCam[15] = 1.0f;
            Renderer.matrixSpr[15] = 1.0f;
            lightAmbient = new Light();
            lightAmbient.setMode(128);
            lightAmbient.setIntensity(1.0f);
            g3D.addLight(lightAmbient, new Transform());
            background = new Background();
            background.setColorClearEnable(false);
            background.setDepthClearEnable(true);
            int[] nArray = new int[4];
            int[] nArray2 = nArray;
            nArray[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 3;
            nArray2[3] = 2;
            int[] nArray3 = new int[1];
            int[] nArray4 = nArray3;
            nArray3[0] = 4;
            float[] fArray = new float[]{0.5f, 0.5f};
            spriteStrip = new TriangleStripArray(nArray2, nArray4);
            spritePos = new VertexArray(4, 3, 2);
            spriteTex = new VertexArray(4, 2, 1);
            spriteBuf = new VertexBuffer();
            spriteBuf.setPositions(spritePos, 1.0f, null);
            spriteBuf.setTexCoords(0, spriteTex, 0.00390625f, fArray);
            m3gAppearanceAdd = this.mAppCache[this.loadAppearance$3b460438(this.textureCacheIDs[0], 2, false)];
            m3gAppearanceSub = this.mAppCache[this.loadAppearance$3b460438(this.textureCacheIDs[0], 4, false)];
            m3gAppearanceHalf = this.mAppCache[this.loadAppearance$3b460438(this.textureCacheIDs[0], 3, false)];
            m3gAppearanceDefault = this.mAppCache[this.loadAppearance$3b460438(this.textureCacheIDs[0], 0, true)];
        }
        this.m3gAspect = (float)n5 / (float)n6;
        this.m3gAspectDiv = this.m3gAspect < 1.0f ? 1.0f : this.m3gAspect;
        m3gCamera.setPerspective(1.21666f * (float)this.m3gFov / this.m3gAspectDiv, this.m3gAspect, 64.0f, 32767.0f);
        this.pointSpriteDefinitions = RM.getInts(492);
    }

    public final void begin(Graphics graphics, int n) {
        super.begin(graphics, n);
        int n2 = this.width;
        int n3 = this.height;
        if (this.landscapeGraphics != null) {
            n2 = this.height;
            n3 = this.width;
            g3D.bindTarget((Object)this.landscapeGraphics, true, 0);
        } else {
            g3D.bindTarget((Object)graphics, true, 0);
        }
        g3D.setViewport(this.left, this.top, n2, n3);
        g3D.clear(background);
        if ((n & 1) != 0) {
            this.renderBackground();
        }
    }

    public final void end(int n) {
        super.end(n);
        g3D.releaseTarget();
        if (this.landscapeRenderTarget != null) {
            MIDP20Proxy.drawRotated(this.boundGraphics, this.landscapeRenderTarget, GCanvas.getDynamicScreenOrientation());
        }
        this.boundGraphics = null;
    }

    public final void clearColorBuffer(int n) {
        background.setColorClearEnable(true);
        background.setColor(n);
    }

    public final void onCameraChanged() {
        this.camera.updateWorld();
        Point3D point3D = this.camera.getPosition();
        Matrix33 matrix33 = this.camera.getRotation();
        float f = 9.765625E-4f * (float)matrix33.az.x;
        float f2 = 9.765625E-4f * (float)matrix33.az.y;
        float f3 = 9.765625E-4f * (float)matrix33.az.z;
        float f4 = -f3;
        float f5 = 0.0f;
        float f6 = f;
        float f7 = -f2 * f6;
        float f8 = f * f6 - f3 * f4;
        float f9 = f2 * f4;
        if (this.landscapeGraphics != null) {
            float f10 = f7;
            float f11 = f8;
            float f12 = f9;
            int n = GCanvas.getDynamicScreenOrientation();
            switch (n) {
                case 1: {
                    f7 = f4;
                    f8 = 0.0f;
                    f9 = f6;
                    f4 = -f10;
                    f5 = -f11;
                    f6 = -f12;
                    break;
                }
                case 3: {
                    f7 = -f4;
                    f8 = 0.0f;
                    f9 = -f6;
                    f4 = f10;
                    f5 = f11;
                    f6 = f12;
                }
            }
        }
        Renderer.matrixCam[0] = f4;
        Renderer.matrixCam[4] = f5;
        Renderer.matrixCam[8] = f6;
        Renderer.matrixCam[1] = f7;
        Renderer.matrixCam[5] = f8;
        Renderer.matrixCam[9] = f9;
        Renderer.matrixCam[2] = -f;
        Renderer.matrixCam[6] = -f2;
        Renderer.matrixCam[10] = -f3;
        Renderer.matrixCam[3] = point3D.x;
        Renderer.matrixCam[7] = point3D.y;
        Renderer.matrixCam[11] = point3D.z;
        for (int i = 0; i < 11; ++i) {
            Renderer.matrixSpr[i] = -matrixCam[i];
        }
        trnCam.setIdentity();
        trnCam.set(matrixCam);
        g3D.setCamera(m3gCamera, trnCam);
    }

    protected final void drawObject$10ad83a4(int n, Matrix33 matrix33, Point3D point3D, Point3D point3D2, int n2) {
        Mesh mesh = objectCache;
        mesh = mesh[n];
        Transform transform = M3GC.getTransform();
        M3GC.setTransform(transform, matrix33, point3D);
        if (point3D2 != null) {
            M3GC.setScale(transform, point3D2);
        }
        if (n2 != -1) {
            mesh.setAppearance(0, m3gAppearanceHalf);
        } else {
            mesh.setAppearance(0, objectAppCache[n]);
        }
        g3D.render((Node)mesh, transform);
    }

    public final void drawTriangleBuffer(AbstractTriangleBuffer abstractTriangleBuffer) {
        Matrix33 matrix33 = abstractTriangleBuffer.mRotation;
        Point3D point3D = abstractTriangleBuffer.mTranslation;
        Transform transform = M3GC.getTransform();
        M3GC.setTransform(transform, matrix33, point3D);
        abstractTriangleBuffer = (TriangleBuffer)abstractTriangleBuffer;
        g3D.render(((TriangleBuffer)abstractTriangleBuffer).mM3GVertexBuffer, (IndexBuffer)((TriangleBuffer)abstractTriangleBuffer).mM3GTriangleStripArray, m3gAppearanceDefault, transform);
    }

    public final void drawParticles$396f8c73(ParticleSystem3D particleSystem3D) {
        Object object = particleSystem3D;
        this.pointSpriteDefinitions = ((ParticleSystem3D)object).mParticles;
        object = particleSystem3D;
        particleSystem3D.mEnumPart = 0;
        while (true) {
            Object object2;
            int n;
            int n2;
            int n3;
            int n4;
            Object object3;
            Object object4;
            Object object5;
            object = particleSystem3D;
            Object object6 = 0;
            while (((ParticleSystem3D)object).mEnumPart < 64 && (object6 = ((ParticleSystem3D)object).mLifes[((ParticleSystem3D)object).mEnumPart]) <= 0) {
                ++((ParticleSystem3D)object).mEnumPart;
            }
            if (((ParticleSystem3D)object).mEnumPart >= 64) {
                object5 = null;
            } else {
                object6 = (object6 << 10) + ParticleSystem3D.sBulletFactor;
                int[] nArray = ((ParticleSystem3D)object).mEffects;
                int[] nArray2 = ((ParticleSystem3D)object).mParticleInfo;
                object4 = ((ParticleSystem3D)object).mTypes[((ParticleSystem3D)object).mEnumPart];
                int n5 = object4 * 12;
                object3 = nArray[n5 + 0];
                n4 = nArray[n5 + 4] << 10;
                int n6 = nArray[n5 + 2];
                n3 = nArray[n5 + 5];
                n2 = nArray[n5 + 6];
                n5 = nArray[n5 + 7];
                n4 = n2 >= 0 ? Math.min(n6, n3 + (n2 * (n4 - object6) >> 10)) : Math.max(n3, n6 + (n2 * (n4 - object6) >> 10));
                n = 255;
                if (n5 != 0) {
                    n = object6 * n5 >> 10;
                }
                Point3D point3D = Point3D.getLocal();
                object2 = point3D;
                point3D.setBlend(((ParticleSystem3D)object).mOldPos[((ParticleSystem3D)object).mEnumPart], ((ParticleSystem3D)object).mPos[((ParticleSystem3D)object).mEnumPart], ParticleSystem3D.sBulletFactor);
                nArray2[0] = (int)object3;
                nArray2[1] = n4;
                nArray2[2] = object2.x;
                nArray2[3] = object2.y;
                nArray2[4] = object2.z;
                nArray2[5] = n;
                nArray2[6] = 1;
                Point3D.freeLocal((Point3D)object2);
                ++((ParticleSystem3D)object).mEnumPart;
                object = nArray2;
                object5 = object;
            }
            if (object5 == null) break;
            object4 = object[4];
            ParticleSystem3D particleSystem3D2 = object[3];
            ParticleSystem3D particleSystem3D3 = object[2];
            object6 = object[1];
            object3 = object[0];
            object = this;
            object2 = ((AbstractRenderer)object).pointSpriteDefinitions;
            n4 = object2[(object3 *= 5) + 4];
            Appearance appearance = n4 != 3 ? m3gAppearanceAdd : m3gAppearanceSub;
            n3 = (byte)((object2[object3 + true] << 8 >> 10) - 128);
            n2 = (byte)((object2[object3 + 2] << 8 >> 10) - 128);
            int n7 = object2[object3 + 3] << 8 >> 10;
            n4 = (byte)(n3 + n7);
            n = (byte)(n2 + n7);
            object2 = SPRITE_VERTS;
            short s = (short)(object6 >> 1);
            object3 = -s;
            object2[0] = (int)object3;
            object2[1] = (int)object3;
            object2[3] = s;
            object2[4] = (int)object3;
            object2[6] = s;
            object2[7] = s;
            object2[9] = (int)object3;
            object2[10] = s;
            object = SPRITE_TEXUV;
            SPRITE_TEXUV[0] = n3;
            object[1] = n2;
            object[2] = n4;
            object[3] = n2;
            object[4] = n4;
            object[5] = n;
            object[6] = n3;
            object[7] = n;
            spritePos.set(0, 4, (short[])object2);
            spriteTex.set(0, 4, (byte[])object);
            Renderer.matrixSpr[3] = (float)particleSystem3D3;
            Renderer.matrixSpr[7] = (float)particleSystem3D2;
            Renderer.matrixSpr[11] = object4;
            object = M3GC.getTransform();
            object.setIdentity();
            object.set(matrixSpr);
            g3D.render(spriteBuf, (IndexBuffer)spriteStrip, appearance, (Transform)object);
        }
    }

    static {
        SPRITE_VERTS = new short[12];
        SPRITE_TEXUV = new byte[8];
    }
}

