/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.render3d;

import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.math3d.Point3D;

public final class ParticleSystem3D {
    public Point3D[] mPos;
    public Point3D[] mOldPos;
    public byte[] mTypes;
    public int[] mGravitys;
    public int[] mLifes;
    public int[] mDamps;
    public Point3D mTmp = new Point3D();
    private int mNext;
    public int mActiveParticles;
    public int[] mParticles;
    public int[] mEffects;
    public static int sBulletFactor;
    public int[] mParticleInfo = new int[7];
    public int mEnumPart;

    public ParticleSystem3D(int n, int n2) {
        this.mPos = new Point3D[64];
        this.mOldPos = new Point3D[64];
        for (n = 0; n < 64; ++n) {
            this.mPos[n] = new Point3D();
            this.mOldPos[n] = new Point3D();
        }
        this.mGravitys = new int[64];
        this.mLifes = new int[64];
        this.mTypes = new byte[64];
        this.mDamps = new int[64];
        this.mEffects = RM.getInts(528);
        this.mParticles = RM.getInts(492);
        this.reset();
    }

    public final void reset() {
        int[] nArray = this.mLifes;
        for (int i = 0; i < 64; ++i) {
            nArray[i] = -1;
        }
    }

    public final void addParticle(int n, Point3D point3D, Point3D point3D2) {
        int n2 = n * 12;
        int n3 = this.mEffects[n2 + 1];
        int n4 = Math.abs(n3);
        for (int i = 0; i < n4; ++i) {
            int n5 = this.mNext++;
            if (this.mNext >= 64) {
                this.mNext = 0;
            }
            Point3D point3D3 = this.mPos[n5];
            Point3D point3D4 = this.mOldPos[n5];
            this.mTypes[n5] = (byte)n;
            this.mGravitys[n5] = this.mEffects[n2 + 3];
            this.mLifes[n5] = this.mEffects[n2 + 4];
            int n6 = this.mEffects[n2 + 8];
            int n7 = this.mEffects[n2 + 9];
            this.mDamps[n5] = GCanvas.getRandom(n6, n7);
            n5 = this.mEffects[n2 + 10];
            n6 = this.mEffects[n2 + 11];
            n5 = GCanvas.getRandom(n5, n6);
            point3D3.set(point3D);
            point3D4.set(point3D);
            point3D4.sub(point3D2);
            if (n3 > 1) {
                int n8 = 1024 / n3 * i;
                n6 = GCanvas.sin(n8);
                n8 = GCanvas.cos(n8);
                point3D4.x -= n8 * n5 >> 10;
                point3D4.y -= n6 * n5 >> 10;
                continue;
            }
            if (n3 >= 0) continue;
            int n9 = GCanvas.getRandom(-256, 512);
            n6 = GCanvas.sin(n9);
            n9 = GCanvas.cos(n9);
            point3D4.x -= n9 * n5 >> 10;
            point3D4.y -= n6 * n5 >> 10;
        }
    }
}

