/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.math3d;

import tinbrain.math3d.Matrix33;
import tinbrain.math3d.Point3D;

public final class VCamera {
    private Point3D worldPos = new Point3D();
    private Matrix33 worldTransform = new Matrix33();
    private Point3D localPos;
    private Matrix33 localTransform;
    private Point3D osO;
    private Point3D osS;
    private Point3D osT;
    private int screenWidth;
    private int screenHeight;
    private int fieldOfView = 1024;
    private int hfrac;
    private int vfrac;
    private int hScale;
    private int vScale;
    private int planeDS;
    private int planeDT;
    private static int FAR = Short.MAX_VALUE;
    private Point3D frustumFarPoint;
    private Point3D frustumSphereCenter;
    private int frustumSphereRadiusSquared;
    private Point3D[] frustumPlaneNormals;
    private Point3D[] frustumPlaneNormalsWorld;
    private Point3D[] frustumPlaneNormalsLocal;
    private int[] frustumPlaneDistancesWorld;
    private int[] frustumPlaneDistancesLocal;
    private int osx;
    private int osy;
    private int osz;
    private int otx;
    private int oty;
    private int otz;
    private int ltx;
    private int lty;
    private int ltz;
    private int posx;
    private int posy;
    private int posz;

    public VCamera() {
        this.worldTransform.ax.set(Point3D.X);
        this.worldTransform.ay.set(Point3D.Y);
        this.worldTransform.az.set(Point3D.Z);
        this.localPos = new Point3D();
        this.localTransform = new Matrix33();
        this.osO = new Point3D();
        this.osS = new Point3D();
        this.osT = new Point3D();
        this.frustumPlaneNormals = new Point3D[6];
        this.frustumPlaneNormalsWorld = new Point3D[6];
        this.frustumPlaneNormalsLocal = new Point3D[6];
        for (int i = 0; i < 6; ++i) {
            this.frustumPlaneNormals[i] = new Point3D();
            this.frustumPlaneNormalsWorld[i] = new Point3D();
            this.frustumPlaneNormalsLocal[i] = new Point3D();
        }
        this.frustumPlaneDistancesWorld = new int[6];
        this.frustumPlaneDistancesLocal = new int[6];
        this.frustumSphereCenter = new Point3D();
        this.frustumFarPoint = new Point3D();
    }

    public final Matrix33 getRotation() {
        return this.worldTransform;
    }

    public final Point3D getPosition() {
        return this.worldPos;
    }

    public final int getFOV() {
        return this.fieldOfView;
    }

    public final void setupView(int n, int n2) {
        this.screenWidth = n;
        this.screenHeight = n2;
        int n3 = this.fieldOfView >> 1;
        n = (n2 << 10) / n;
        this.hfrac = n3;
        this.vfrac = n3 * n >> 10;
        this.hScale = (this.screenWidth << 20) / (2 * this.hfrac);
        this.vScale = (this.screenHeight << 20) / (2 * this.vfrac);
        Point3D point3D = this.frustumPlaneNormals[0];
        point3D.set(-1024, 0, this.hfrac);
        point3D.unit();
        point3D = this.frustumPlaneNormals[1];
        point3D.set(1024, 0, this.hfrac);
        point3D.unit();
        point3D = this.frustumPlaneNormals[3];
        point3D.set(0, 1024, this.vfrac);
        point3D.unit();
        point3D = this.frustumPlaneNormals[2];
        point3D.set(0, -1024, this.vfrac);
        point3D.unit();
        point3D = this.frustumPlaneNormals[4];
        point3D.set(Point3D.Z);
        point3D = this.frustumPlaneNormals[5];
        point3D.set(Point3D.NEGZ);
    }

    public final void setPosition(Point3D point3D) {
        this.worldPos.set(point3D);
    }

    public final void lookAt(Point3D object, Point3D point3D) {
        this.worldPos.set((Point3D)object);
        object = this;
        ((VCamera)object).worldTransform.lookAt(((VCamera)object).worldPos, Point3D.Y, point3D);
    }

    public final void updateWorld() {
        Matrix33 matrix33 = this.worldTransform;
        Point3D point3D = this.worldPos;
        VCamera vCamera = this;
        int n = point3D.x;
        int n2 = point3D.y;
        int n3 = point3D.z;
        Point3D point3D2 = matrix33.az;
        int n4 = point3D2.x;
        int n5 = point3D2.y;
        int n6 = point3D2.z;
        int n7 = 1024 + (FAR - 1024 >> 1) >> 10;
        n4 = n + n4 * n7;
        n5 = n2 + n5 * n7;
        n6 = n3 + n6 * n7;
        vCamera.frustumSphereCenter.set(n4, n5, n6);
        Point3D point3D3 = vCamera.frustumFarPoint;
        point3D3.set(vCamera.hfrac, vCamera.vfrac, 1024);
        matrix33.transform(point3D3);
        n7 = FAR >> 10;
        int n8 = n + point3D3.x * n7;
        n = n2 + point3D3.y * n7;
        long l = n8 - n4;
        long l2 = n - n5;
        long l3 = (n3 += point3D3.z * n7) - n6;
        vCamera.frustumSphereRadiusSquared = (int)(l * l + l2 * l2 + l3 * l3 >> 10);
        vCamera.frustumFarPoint.set(n8, n, n3);
        this.updateFrustum(this.worldPos, this.worldTransform, this.frustumPlaneNormalsWorld, this.frustumPlaneDistancesWorld);
    }

    private void updateFrustum(Point3D point3D, Matrix33 matrix33, Point3D[] point3DArray, int[] nArray) {
        Point3D[] point3DArray2 = this.frustumPlaneNormals;
        for (int i = 0; i < 6; ++i) {
            Point3D point3D2 = point3DArray[i];
            point3D2.set(point3DArray2[i]);
            matrix33.transform(point3D2);
            nArray[i] = point3D.dot(point3DArray[i]);
        }
        nArray[4] = nArray[4] + 1024;
        nArray[5] = nArray[5] - FAR;
    }

    public final byte sphereInFrustum(Point3D point3D, int n, byte by) {
        long l;
        long l2;
        int n2;
        int n3;
        int n4;
        Point3D point3D2 = this.frustumSphereCenter;
        long l3 = point3D2.x - point3D.x;
        long l4 = point3D2.y - point3D.y;
        long l5 = point3D2.z - point3D.z;
        int n5 = (int)(l3 * l3 + l4 * l4 + l5 * l5 >> 10);
        int n6 = this.frustumSphereRadiusSquared + n;
        if (n5 > n6) {
            if (by < 0) {
                return by;
            }
            return -128;
        }
        n6 = point3D.x;
        n5 = point3D.y;
        int n7 = point3D.z;
        Point3D[] point3DArray = this.frustumPlaneNormalsWorld;
        int[] nArray = this.frustumPlaneDistancesWorld;
        if (by != -128 && by < 0) {
            n4 = -by - 1;
            Point3D point3D3 = point3DArray[n4];
            n3 = point3D3.x;
            n2 = point3D3.y;
            int n8 = point3D3.z;
            l2 = n3 * n6 + n2 * n5 + n8 * n7 >> 10;
            if ((l = (l2 -= (long)nArray[n4]) * l2 >> 10) > (long)n && l2 < 0L) {
                return by;
            }
        }
        by = 0;
        for (n4 = 0; n4 < 6; ++n4) {
            Point3D point3D4 = point3DArray[n4];
            n3 = point3D4.x;
            n2 = point3D4.y;
            int n9 = point3D4.z;
            l2 = n3 * n6 + n2 * n5 + n9 * n7 >> 10;
            if ((l = (l2 -= (long)nArray[n4]) * l2 >> 10) >= (long)n) {
                if (l2 >= 0L) continue;
                return (byte)(-(n4 + 1));
            }
            by = (byte)(by | 1 << n4);
        }
        return by;
    }

    public final int sphereInFrustum(Point3D point3D, int n, Matrix33 matrix33, Point3D point3D2) {
        matrix33.transform(point3D, point3D2);
        return this.sphereInFrustum(point3D, n, (byte)0);
    }

    public final byte centeredBoxInFrustum(Point3D point3D, Point3D point3D2, byte by) {
        int n;
        int n2;
        int n3;
        int n4 = point3D.x;
        int n5 = point3D.y;
        int n6 = point3D.z;
        int n7 = point3D2.x;
        int n8 = point3D2.y;
        int n9 = point3D2.z;
        Point3D[] point3DArray = this.frustumPlaneNormalsWorld;
        int[] nArray = this.frustumPlaneDistancesWorld;
        if (by != -128 && by < 0) {
            long l;
            n3 = -by - 1;
            Point3D point3D3 = point3DArray[n3];
            int n10 = point3D3.x;
            n2 = point3D3.y;
            n = point3D3.z;
            long l2 = n10 * n4 + n2 * n5 + n * n6 >> 10;
            l2 -= (long)nArray[n3];
            if (n10 < 0) {
                n10 = -n10;
            }
            if (n2 < 0) {
                n2 = -n2;
            }
            if (n < 0) {
                n = -n;
            }
            if (l2 < -(l = (long)(n10 * n7 + n2 * n8 + n * n9 >> 10))) {
                return by;
            }
        }
        by = (byte)63;
        for (n3 = 0; n3 < 6; ++n3) {
            long l;
            int n11 = 1 << n3;
            if ((by & n11) == 0) continue;
            Point3D point3D4 = point3DArray[n3];
            n2 = point3D4.x;
            n = point3D4.y;
            int n12 = point3D4.z;
            long l3 = n2 * n4 + n * n5 + n12 * n6 >> 10;
            l3 -= (long)nArray[n3];
            if (n2 < 0) {
                n2 = -n2;
            }
            if (n < 0) {
                n = -n;
            }
            if (n12 < 0) {
                n12 = -n12;
            }
            if (l3 < -(l = (long)(n2 * n7 + n * n8 + n12 * n9 >> 10))) {
                return (byte)(-(n3 + 1));
            }
            if (l3 < l) continue;
            by = (byte)(by & ~n11);
        }
        return by;
    }

    public final void transformToObjectSpace(Point3D point3D, Matrix33 object) {
        this.localPos.set(this.worldPos);
        this.localPos.sub(point3D);
        ((Matrix33)object).invTransform(this.localPos);
        this.localTransform.set(this.worldTransform);
        this.localTransform.appendInverse((Matrix33)object);
        this.updateFrustum(this.localPos, this.localTransform, this.frustumPlaneNormalsLocal, this.frustumPlaneDistancesLocal);
        point3D = this.localTransform.ax;
        object = this.localTransform.ay;
        Point3D point3D2 = this.localTransform.az;
        this.osS.set(-point3D.x, -point3D.y, -point3D.z);
        this.osT.set(-((Point3D)object).x, -((Point3D)object).y, -((Point3D)object).z);
        this.osO.set(point3D2);
        this.osO.sub(point3D.x * this.hfrac >> 10, point3D.y * this.hfrac >> 10, point3D.z * this.hfrac >> 10);
        this.osO.sub(((Point3D)object).x * this.vfrac >> 10, ((Point3D)object).y * this.vfrac >> 10, ((Point3D)object).z * this.vfrac >> 10);
        this.planeDS = this.osO.dot(this.localTransform.ax);
        this.planeDT = this.osO.dot(this.localTransform.ay);
        this.osx = this.osS.x;
        this.osy = this.osS.y;
        this.osz = this.osS.z;
        this.otx = this.osT.x;
        this.oty = this.osT.y;
        this.otz = this.osT.z;
        this.ltx = point3D2.x;
        this.lty = point3D2.y;
        this.ltz = point3D2.z;
        this.posx = this.localPos.x;
        this.posy = this.localPos.y;
        this.posz = this.localPos.z;
    }

    public final int projectVertex(Point3D point3D, Point3D point3D2) {
        int n = point3D.x;
        int n2 = point3D.y;
        int n3 = point3D.z;
        int n4 = this.osx * (n -= this.posx) + this.osy * (n2 -= this.posy) + this.osz * (n3 -= this.posz);
        int n5 = this.otx * n + this.oty * n2 + this.otz * n3;
        if ((n3 = this.ltx * n + this.lty * n2 + this.ltz * n3 >> 10) == 0) {
            n3 = 1;
        }
        point3D2.x = (n4 / n3 - this.planeDS) * this.hScale >> 10;
        point3D2.y = (n5 / n3 - this.planeDT) * this.vScale >> 10;
        point3D2.z = n3;
        return n3;
    }
}

