/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.math3d;

import tinbrain.GCanvas;
import tinbrain.math3d.M3D;
import tinbrain.math3d.Matrix33;
import tinbrain.math3d.Point3D;

public final class Matrix34 {
    private Point3D ax = new Point3D(Point3D.X);
    private Point3D ay = new Point3D(Point3D.Y);
    private Point3D az = new Point3D(Point3D.Z);
    public Point3D trn = new Point3D(Point3D.ZERO);
    private static final Matrix34 itmp0;

    public static final void locInit(int n) {
        M3D.locInit(2, new Matrix34().getClass(), 10);
    }

    public final void setIdentity() {
        this.ax.set(Point3D.X);
        this.ay.set(Point3D.Y);
        this.az.set(Point3D.Z);
        this.trn.set(Point3D.ZERO);
    }

    public final String toString() {
        return null;
    }

    public final void set(Matrix33 matrix33) {
        this.ax.set(matrix33.ax);
        this.ay.set(matrix33.ay);
        this.az.set(matrix33.az);
    }

    private void set(Matrix34 matrix34) {
        this.ax.set(matrix34.ax);
        this.ay.set(matrix34.ay);
        this.az.set(matrix34.az);
        this.trn.set(matrix34.trn);
    }

    public final void transform(Point3D point3D) {
        int n = point3D.x;
        int n2 = point3D.y;
        int n3 = point3D.z;
        point3D.x = (n * this.ax.x + n2 * this.ay.x + n3 * this.az.x >> 10) + this.trn.x;
        point3D.y = (n * this.ax.y + n2 * this.ay.y + n3 * this.az.y >> 10) + this.trn.y;
        point3D.z = (n * this.ax.z + n2 * this.ay.z + n3 * this.az.z >> 10) + this.trn.z;
    }

    private void rotate(Point3D point3D) {
        int n = point3D.x;
        int n2 = point3D.y;
        int n3 = point3D.z;
        point3D.x = n * this.ax.x + n2 * this.ay.x + n3 * this.az.x >> 10;
        point3D.y = n * this.ax.y + n2 * this.ay.y + n3 * this.az.y >> 10;
        point3D.z = n * this.ax.z + n2 * this.ay.z + n3 * this.az.z >> 10;
    }

    public final void append(Matrix34 matrix34) {
        matrix34.rotate(this.ax);
        matrix34.rotate(this.ay);
        matrix34.rotate(this.az);
        matrix34.transform(this.trn);
    }

    public final void prepend(Matrix34 matrix34) {
        itmp0.set(matrix34);
        itmp0.append(this);
        this.set(itmp0);
    }

    public final void transpose3X3() {
        int n = this.ax.y;
        this.ax.y = this.ay.x;
        this.ay.x = n;
        n = this.ax.z;
        this.ax.z = this.az.x;
        this.az.x = n;
        n = this.ay.z;
        this.ay.z = this.az.y;
        this.az.y = n;
    }

    public final void rotateZYXFast(int n, int n2, int n3) {
        int n4 = GCanvas.sin(n);
        int n5 = GCanvas.sin(n2);
        int n6 = GCanvas.sin(n3);
        n = GCanvas.cos(n);
        n2 = GCanvas.cos(n2);
        n3 = GCanvas.cos(n3);
        int n7 = n4 * n5 >> 10;
        int n8 = n5 * n >> 10;
        this.ax.x = n2 * n3 >> 10;
        this.ax.y = n6 * n2 >> 10;
        this.ax.z = -n5;
        this.ay.x = -(n6 * n >> 10) + (n7 * n3 >> 10);
        this.ay.y = n * n3 + n7 * n6 >> 10;
        this.ay.z = n4 * n2 >> 10;
        this.az.x = (n4 * n6 >> 10) + (n8 * n3 >> 10);
        this.az.y = -n4 * n3 + n8 * n6 >> 10;
        this.az.z = n * n2 >> 10;
        this.trn.x = 0;
        this.trn.y = 0;
        this.trn.z = 0;
    }

    public final void blend(Matrix34 matrix34, int n) {
        this.ax.blend(matrix34.ax, n);
        this.ay.blend(matrix34.ay, n);
        this.az.blend(matrix34.az, n);
        this.trn.blend(matrix34.trn, n);
    }

    static {
        new Matrix34();
        new Matrix34();
        itmp0 = new Matrix34();
        new Matrix34();
    }
}

