/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.ea.fonts;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tinbrain.GCanvas;
import tinbrain.RM;

public final class BitmapFont {
    private static byte[][] mFontData;
    private static byte[] mNumCharacterPerFont;
    private static short[][] mCharOffsets;
    private static Image[] mImages;
    private static final short[] sStringIDCache;

    public static final void init(int n) {
        n = RM.getHeight(7);
        mFontData = new byte[n][];
        mImages = new Image[n];
        mNumCharacterPerFont = new byte[n];
        mCharOffsets = new short[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = RM.getValue(7, i, 1);
            byte[] byArray = RM.getBytes(n2);
            BitmapFont.mFontData[i] = byArray;
            int n3 = RM.getValue(7, i, 0);
            BitmapFont.mImages[i] = RM.getImage(n3);
            n3 = RM.getShortFromBytes(byArray, 8);
            BitmapFont.mNumCharacterPerFont[i] = (byte)n3;
            BitmapFont.mCharOffsets[i] = new short[n3];
            for (int j = 0; j < n3; ++j) {
                int n4 = 12 + (n3 + j << 1);
                BitmapFont.mCharOffsets[i][j] = (short)(12 + (n3 << 2) + RM.getShortFromBytes(byArray, n4));
            }
        }
    }

    public static final void drawString(Graphics graphics, int n, String string, int n2, int n3, int n4) {
        short[] sArray;
        short[] sArray2;
        int n5;
        byte[] byArray = mFontData[n];
        int n6 = mNumCharacterPerFont[n] & 0xFF;
        byte by = byArray[4];
        String string2 = string;
        byte[] byArray2 = byArray;
        int n7 = n6;
        int n8 = string2.length();
        if (n8 < 32) {
            short[] sArray3 = sStringIDCache;
            for (n5 = 0; n5 < n8; ++n5) {
                sArray3[n5] = (short)BitmapFont.charID(n7, byArray2, string2.charAt(n5));
            }
            sArray2 = sArray3;
        } else {
            sArray2 = sArray = null;
        }
        if (n4 != 0) {
            if ((n4 & 1) != 0) {
                n2 -= BitmapFont.getStringWidthInternal(n, string, sArray) >> 1;
            } else if ((n4 & 8) != 0) {
                n2 -= BitmapFont.getStringWidthInternal(n, string, sArray);
            }
            if ((n4 & 0x20) != 0) {
                n3 -= BitmapFont.getHeight(n);
            } else if ((n4 & 0x40) != 0) {
                n3 -= by;
            } else if ((n4 & 2) != 0) {
                n3 -= BitmapFont.getHeight(n) >> 1;
            }
        }
        n3 += by;
        n4 = byArray[7];
        int n9 = string.length();
        string2 = null;
        string2 = mImages[n];
        short[] sArray4 = mCharOffsets[n];
        GCanvas.pushClip(graphics);
        for (n8 = 0; n8 < n9; ++n8) {
            int n10;
            if (sArray == null) {
                n10 = string.charAt(n8);
                n10 = BitmapFont.charID(n6, byArray, (char)n10);
            } else {
                n10 = sArray[n8];
            }
            if (n10 == -2) {
                n2 += byArray[6];
                continue;
            }
            if (n10 == -1) {
                if (GCanvas.clipRect(graphics, n2, n3 - by, byArray[6], by)) {
                    graphics.setColor(-65536);
                    graphics.fillRect(n2, n3 - by, (int)byArray[6], (int)by);
                }
                n2 += byArray[6];
                continue;
            }
            if (n10 == -3) continue;
            n10 = sArray4[n10];
            n5 = byArray[n10];
            int n11 = byArray[n10 + 1];
            n10 += 2;
            for (int i = 0; i < n11; ++i) {
                int n12 = byArray[n10] & 0xFF;
                int n13 = byArray[n10 + 1] & 0xFF;
                int n14 = byArray[n10 + 2];
                int n15 = byArray[n10 + 3];
                int n16 = byArray[n10 + 5] & 0xFF;
                int n17 = byArray[n10 + 4] & 0xFF;
                if (GCanvas.clipRect(graphics, n14 = n2 + n14, n15 = n3 - n16 - n15, n17, n16)) {
                    graphics.drawImage((Image)string2, n14 - n12, n15 - n13, 20);
                }
                n10 += 6;
            }
            n2 += n5 + n4;
        }
        GCanvas.popClip(graphics);
    }

    public static final int getHeight(int n) {
        byte[] byArray = mFontData[n];
        return byArray[4] + byArray[5] + byArray[3];
    }

    public static final int getStringWidth(int n, String string) {
        return BitmapFont.getSubstringWidth(n, string, 0, string.length());
    }

    public static final int getSubstringWidth(int n, String string, int n2, int n3) {
        int n4 = 0;
        int n5 = string.length();
        if ((n3 = n2 + n3) > n5) {
            n3 = n5;
        }
        byte[] byArray = mFontData[n];
        int n6 = mNumCharacterPerFont[n] & 0xFF;
        while (n2 < n3) {
            int n7 = string.charAt(n2);
            if ((n7 = BitmapFont.charID(n6, byArray, (char)n7)) == -1 || n7 == -2) {
                n4 += byArray[6];
            } else if (n7 != -3) {
                n7 = mCharOffsets[n][n7];
                n4 += byArray[n7];
            }
            ++n2;
        }
        return n4;
    }

    private static final int getStringWidthInternal(int n, String string, short[] sArray) {
        int n2 = 0;
        int n3 = string.length();
        byte[] byArray = mFontData[n];
        if (sArray == null) {
            int n4 = mNumCharacterPerFont[n] & 0xFF;
            for (int i = 0; i < n3; ++i) {
                char c = string.charAt(i);
                int n5 = BitmapFont.charID(n4, byArray, c);
                if (n5 == -1 || n5 == -2) {
                    n2 += byArray[6];
                    continue;
                }
                if (n5 == -3) continue;
                n5 = mCharOffsets[n][n5];
                n2 += byArray[n5];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                short s = sArray[i];
                if (s == -1 || s == -2) {
                    n2 += byArray[6];
                    continue;
                }
                if (s == -3) continue;
                short s2 = mCharOffsets[n][s];
                n2 += byArray[s2];
            }
        }
        return n2;
    }

    public static final int getCharWidth(int n, char c) {
        byte[] byArray = mFontData[n];
        int n2 = mNumCharacterPerFont[n] & 0xFF;
        byte by = 0;
        int n3 = BitmapFont.charID(n2, byArray, c);
        c = (char)n3;
        if (n3 == -1 || c == '\ufffffffe') {
            by = byArray[6];
        } else if (c != '\ufffffffd') {
            n = mCharOffsets[n][c];
            by = byArray[n];
        }
        return by;
    }

    private static final int charID(int n, byte[] byArray, char c) {
        switch (c) {
            case ' ': 
            case '\u0093': {
                return -2;
            }
            case '\u0092': {
                return -3;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = n + n2 >> 1;
            int n4 = 12 + (n3 << 1);
            int n5 = byArray[n4++] & 0xFF;
            n5 <<= 8;
            if ((n5 |= byArray[n4] & 0xFF) == c) {
                return n3;
            }
            if (c < n5) {
                n = n3;
                continue;
            }
            n2 = n3 + 1;
        }
        return -1;
    }

    static {
        sStringIDCache = new short[32];
    }
}

