/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.mmapi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import tinbrain.RM;

public final class Sound
implements PlayerListener {
    private Player player;
    private int activeTune;
    private int activeSfx;
    private boolean looped;
    private boolean isMenu;
    private int restartTune = -1;
    private int volumeMusic;
    private int volumeSFX;
    private Hashtable prefetched = new Hashtable();
    private static String[] formats;

    public final void play(int n, boolean n2, boolean n3) {
        this.restartTune = -1;
        this.stop();
        this.looped = n3;
        this.isMenu = n2;
        n2 = n2 != 0 ? this.volumeMusic : this.volumeSFX;
        int n4 = n;
        n = 0;
        n3 = n2;
        n2 = n4;
        Sound sound = this;
        if (n3 > 0) {
            if (sound.player != null) {
                sound.stop();
            }
            try {
                sound.player = (Player)sound.prefetched.get(new Integer(n2));
                if (sound.player == null) {
                    sound.player = sound.createPlayer(n2, 0);
                    if (!sound.isMenu && sound.prefetched.size() < 9 && sound.player != null) {
                        sound.prefetched.put(new Integer(n2), sound.player);
                    }
                }
                try {
                    sound.player.setMediaTime(0L);
                }
                catch (Exception exception) {}
                sound.player.start();
                sound.updateVolume();
                sound.activeTune = sound.isMenu ? n2 : -1;
                sound.activeSfx = sound.isMenu ? -1 : n2;
                return;
            }
            catch (Exception exception) {}
        }
    }

    private Player createPlayer(int n, int n2) {
        Player player;
        ByteArrayInputStream byteArrayInputStream;
        block4: {
            byteArrayInputStream = null;
            player = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(RM.getBytes(n));
                player = Manager.createPlayer((InputStream)byteArrayInputStream, (String)formats[n2]);
                if (!Sound.realizePlayer(player)) {
                    player = null;
                }
                if (player == null) break block4;
                player.setLoopCount(1);
                player.addPlayerListener((PlayerListener)this);
                player.prefetch();
            }
            catch (Exception exception) {
                RM.closeStream(byteArrayInputStream);
            }
            catch (Throwable throwable) {
                RM.closeStream(byteArrayInputStream);
                throw throwable;
            }
        }
        RM.closeStream(byteArrayInputStream);
        return player;
    }

    private static final boolean realizePlayer(Player player) {
        boolean bl = false;
        try {
            player.realize();
            bl = true;
        }
        catch (MediaException mediaException) {
            System.gc();
        }
        return bl;
    }

    public final void stop() {
        if (this.player != null) {
            try {
                this.player.stop();
                while (this.player.getState() == 400) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            bl = this.isMenu;
            if (bl) {
                Sound sound = this;
                Sound.deallocate$674805f(sound.player);
                sound.player = null;
            }
        }
        this.activeTune = -1;
        this.restartTune = -1;
        this.activeSfx = -1;
        this.player = null;
    }

    private static void deallocate$674805f(Player player) {
        if (player != null) {
            try {
                player.stop();
            }
            catch (Exception exception) {}
            try {
                player.deallocate();
            }
            catch (Exception exception) {}
            try {
                player.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public final void setVolume(int n, int n2) {
        this.volumeMusic = n;
        this.volumeSFX = n2;
        this.updateVolume();
    }

    private void updateVolume() {
        int n;
        if (this.player != null && (n = this.player.getState()) == 400) {
            n = this.isMenu ? this.volumeMusic : this.volumeSFX;
            if (n > 0) {
                try {
                    VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
                    volumeControl.setLevel(n);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            this.stop();
        }
    }

    public final void playerUpdate(Player player, String string, Object object) {
        if (string == "endOfMedia") {
            if (this.looped) {
                this.restartTune = this.activeTune;
                return;
            }
            this.stop();
        }
    }

    public final void tick() {
        if (this.restartTune >= 0) {
            if (this.player != null) {
                this.stop();
                return;
            }
            this.play(this.restartTune, this.isMenu, true);
            this.restartTune = -1;
        }
    }

    public final void prepare(int n, boolean bl) {
        Player player = null;
        Integer n2 = new Integer(n);
        if (this.prefetched.containsKey(n2)) {
            Sound.deallocate$674805f((Player)this.prefetched.remove(n2));
        }
        if (this.prefetched.size() < 9 && (player = this.createPlayer(n, 0)) != null) {
            this.prefetched.put(n2, player);
        }
    }

    static {
        String[] stringArray = new String[10];
        formats = stringArray;
        stringArray[0] = "audio/midi";
        Sound.formats[1] = "audio/x-mid";
        Sound.formats[2] = "audio/sp-midi";
        Sound.formats[4] = "audio/amr";
        Sound.formats[3] = "audio/x-wav";
        Sound.formats[6] = "audio/mmf";
        Sound.formats[9] = "audio/imelody";
    }
}

