/*
 * Decompiled with CFR 0.152.
 */
package game.game3d;

import game.ArenaGame;
import game.HeightMap;
import game.Player;
import game.game3d.BurstingCrates;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.math3d.AutoBezier;
import tinbrain.math3d.M3D;
import tinbrain.math3d.Matrix33;
import tinbrain.math3d.Matrix34;
import tinbrain.math3d.Point2D;
import tinbrain.math3d.Point3D;
import tinbrain.physics3d.VerletSystem;
import tinbrain.render3d.AbstractRenderer;
import tinbrain.render3d.ParticleSystem3D;
import tinbrain.render3d.m3g.Renderer;

public final class Game3d
extends ArenaGame {
    private AbstractRenderer mRenderer$1894c531;
    private ParticleSystem3D mEffects$2cea9fce;
    private BurstingCrates mBurstingCrates;
    private int mCamHint;
    private Point3D mCamPosition;
    private Point3D mCamTarget;
    private Point3D mCamEaseTarget;
    private Point3D mCamEasePosition;
    private int mCurrentCamera;
    private int mCurrentCamEase;
    private int mCurrentTargetEase;
    private Point3D mPreviewPos;
    private HeightMap[] mHeightMaps;
    private int mLeftTrackLimit;
    private int mRightTrackLimit;
    private VerletSystem[] mSystems;
    private int mNumRides;
    private int mNumBoxes;
    private int mPictogramsScene;
    private int mRideFXScene;
    private int mFXScene;
    private int mTutorialsScene;
    private int mGlowScene;
    private int mOccluderScene;
    private int mMetaScene;
    private int mExplosionStart;
    private Point3D mExplosionPosition;
    private int mBulletFactor;
    private int mCollectables;
    private int mCollectablesScene;
    private int mTriggerAreas;
    private int mTriggers;
    private int[] mTutorialObjects;
    private int mNumTutorials;
    private int[] mTriggerVisibleFlags;
    private int[] mTriggerTouchedFlags;
    private int[] mCollectablesFlags;
    private int[] mTriggerAreasFlags;
    private int mObstacles;
    private int[] mObstacleCache;
    private int mNumObstaclesCached;
    private int[] mCollectableSphereCache;
    private int[] mTriggerSphereCache;
    private Point2D mRagdollSpawnDir = new Point2D();
    private boolean mRagdollSpawnScheduled;
    private boolean mRagdollSpawnCrash;
    private int mCurGlows;
    private int mOccludedObject;
    private Point2D mHeightmapCheckPos = new Point2D();
    private Point2D mHeightmapCheckOld = new Point2D();
    private int[] mObstacleBoundingRects;
    private int[] mStaticSceneLayers = new int[8];
    private int mCameraCurrentId;
    private int mCameraCurrentIndex;
    private int mCameraAnimLength;
    private int mCameraLastFrame;
    private int mCameraStartFrame;
    private AutoBezier mCameraBezierPos;
    private AutoBezier mCameraBezierTarget;
    private int mCameraTimeScale;
    private int mAutoCameraType;
    private int mAutoCameraBlendInc;
    private Point3D mAutoCameraFlybyStart;
    private Point3D mAutoCameraFlybyEnd;
    private Point3D mAutoCameraFlybyStartLookAt;
    private Point3D mAutoCameraFlybyEndLookAt;
    private int mAutoCameraFlybyStartSpeed;
    private int mAutoCameraFlybyEndSpeed;
    private int mAutoCameraSpeedupStart;
    private int mAutoCameraSlowdownStart;
    private int mPlaybackCamera = -1;

    protected final void draw(Graphics graphics) {
        Object object;
        Object object2 = this.mSystems;
        Game3d game3d = this;
        if (object2 != null) {
            int n = ((VerletSystem[])object2).length;
            for (int i = 0; i < n; ++i) {
                object = object2[i].getUserData();
                object2[i].updateScene$3246187e(game3d.mRenderer$1894c531, object[5] == 1 && RM.getValue(583, object[0], 9) == 0);
            }
        }
        game3d = this;
        if (game3d.mIsCarAidVisible) {
            object2 = game3d.getActivePlayer();
            VerletSystem verletSystem = game3d.getRide((Player)object2);
            int[] nArray = ((Player)object2).mStateInfo;
            object = Point3D.getLocal();
            object2 = Point3D.getLocal();
            Matrix33 matrix33 = Matrix33.getLocal();
            verletSystem.getScreenPosition((Point3D)object);
            ((Point3D)object2).set(nArray, 11);
            object.add(((Point3D)object2).x * 60 / 100, 0, 0);
            matrix33.lookAtX(Point3D.ZERO, Point3D.Z, (Point3D)object2);
            game3d.mRenderer$1894c531.setObjectVisibility(game3d.mPictogramsScene, 0, true);
            game3d.mRenderer$1894c531.setObjectTransform(game3d.mPictogramsScene, 0, matrix33, (Point3D)object);
            Matrix33.freeLocal(matrix33);
            Point3D.freeLocal((Point3D)object2);
            Point3D.freeLocal((Point3D)object);
        } else {
            game3d.mRenderer$1894c531.setObjectVisibility(game3d.mPictogramsScene, 0, false);
        }
        this.mBurstingCrates.update$71fdc2ea(this.mRenderer$1894c531);
        game3d = this;
        if (game3d.mExplosionStart > 0) {
            int n = game3d.mFrame - game3d.mExplosionStart;
            if (n <= 19) {
                int n2 = 1024 + 84 * (n - 1);
                game3d.mExplosionPosition.y += (n2 += game3d.mBulletFactor * 84 >> 10) >> 3;
                game3d.mRenderer$1894c531.setObjectTransform(game3d.mFXScene, 0, Matrix33.IDENTITY, game3d.mExplosionPosition);
                object = Point3D.getLocal();
                object.set(n2, 1024, n2);
                game3d.mRenderer$1894c531.setObjectScale(game3d.mFXScene, 1, (Point3D)object);
                object.scale(2500);
                game3d.mRenderer$1894c531.setObjectScale(game3d.mFXScene, 0, (Point3D)object);
                Point3D.freeLocal((Point3D)object);
            } else {
                game3d.mRenderer$1894c531.setObjectVisibility(game3d.mFXScene, 0, false);
                game3d.mRenderer$1894c531.setObjectVisibility(game3d.mFXScene, 1, false);
                game3d.mExplosionStart = 0;
            }
        }
        game3d = this;
        if (!(game3d.mAutoCameraType != -1)) {
            this.calculateView(false);
        }
        this.mRenderer$1894c531.setCamera(this.mCamPosition, this.mCamTarget);
        this.mRenderer$1894c531.begin(graphics, 1);
        this.mRenderer$1894c531.renderScenes();
        this.mRenderer$1894c531.end(0);
    }

    private void rideGlowInit() {
        int n = 0;
        this.mCurGlows = n = Math.min(this.mNumRides, 3);
        this.mGlowScene = this.mRenderer$1894c531.createScene(n, 1, 0);
        Point3D point3D = Point3D.getLocal();
        for (int i = 0; i < n; ++i) {
            VerletSystem verletSystem = this.mSystems[i];
            int n2 = verletSystem.getUserData()[0];
            if (n2 < 0) continue;
            this.mRenderer$1894c531.setObject(this.mGlowScene, i, 28);
            this.mRenderer$1894c531.setObjectVisibility(this.mGlowScene, i, false);
            n2 = RM.getValue(583, n2, 10);
            if (n2 > -1) {
                verletSystem.getWorldPosition(n2, point3D);
            } else {
                verletSystem.getScreenCenter(point3D);
            }
            this.mRenderer$1894c531.setObjectTransform(this.mGlowScene, i, Matrix33.IDENTITY, point3D);
        }
        Point3D.freeLocal(point3D);
    }

    protected final void onHandleBulletTime(int n) {
        this.mBulletFactor = n;
        VerletSystem.setBulletTime(n);
        ParticleSystem3D.sBulletFactor = n;
    }

    protected final void onIdleTick() {
        try {
            VerletSystem[] verletSystemArray = this.mSystems;
            if (this.mSystems != null) {
                int n;
                int n2;
                Object[] objectArray = verletSystemArray;
                Object object = this;
                int n3 = objectArray.length;
                for (int i = 0; i < n3; ++i) {
                    VerletSystem verletSystem = objectArray[i];
                    byte[] byArray = verletSystem.getUserData();
                    int n4 = byArray[7];
                    if (n4 <= 0) continue;
                    int n5 = GCanvas.getRandom(0, verletSystem.getNumParts());
                    n2 = 2;
                    if (n4 < 12) {
                        n2 = 3;
                    } else if (n4 < 24 && (n = GCanvas.getRandom(0, 2)) == 1) {
                        n2 = 3;
                    }
                    Game3d.spawnEffect(verletSystem, n5, n2);
                    byArray[7] = (byte)(--n4);
                    if (n4 != 0 || !verletSystem.isDeactivated()) continue;
                    verletSystem.setVisible(false);
                }
                objectArray = verletSystemArray;
                object = this;
                Point3D point3D = Point3D.getLocal();
                Object object2 = Point3D.getLocal();
                int n6 = objectArray.length;
                for (int i = 0; i < n6; ++i) {
                    VerletSystem verletSystem = objectArray[i];
                    byte[] byArray = verletSystem.getPartData(0);
                    n2 = byArray.length;
                    while (--n2 >= 0) {
                        n = byArray[n2];
                        if (n <= 0) continue;
                        verletSystem.getScreenPosition(n2, point3D);
                        verletSystem.getScreenVelocity(n2, (Point3D)object2);
                        ((Game3d)object).mEffects$2cea9fce.addParticle(n, point3D, (Point3D)object2);
                        byArray[n2] = 0;
                    }
                }
                Point3D.freeLocal((Point3D)object2);
                Point3D.freeLocal(point3D);
                object = this.mEffects$2cea9fce;
                this.mEffects$2cea9fce.mActiveParticles = 0;
                objectArray = ((ParticleSystem3D)object).mLifes;
                for (int i = 0; i < 64; ++i) {
                    if (objectArray[i] <= 0) continue;
                    int n7 = i;
                    objectArray[n7] = objectArray[n7] - true;
                    object2 = ((ParticleSystem3D)object).mPos[i];
                    Point3D point3D2 = ((ParticleSystem3D)object).mOldPos[i];
                    ((ParticleSystem3D)object).mTmp.setDiff((Point3D)object2, point3D2);
                    ((ParticleSystem3D)object).mTmp.scale(((ParticleSystem3D)object).mDamps[i]);
                    ((ParticleSystem3D)object).mTmp.y += ((ParticleSystem3D)object).mGravitys[i];
                    point3D2.set((Point3D)object2);
                    ((Point3D)object2).add(((ParticleSystem3D)object).mTmp);
                    ++((ParticleSystem3D)object).mActiveParticles;
                }
                int n8 = verletSystemArray.length;
                for (int i = 0; i < n8; ++i) {
                    VerletSystem verletSystem = verletSystemArray[i];
                    byte[] byArray = verletSystem.getUserData();
                    object2 = byArray;
                    int n9 = byArray[8];
                    if (n9 <= 0) continue;
                    verletSystem.poseToRest(64);
                    if (--n9 == 0) {
                        verletSystem.setActive(false);
                    }
                    object2[8] = (byte)n9;
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected final void doGameLogic() {
        int n;
        int n2;
        byte by;
        int n3;
        int n4;
        int n5;
        Player player = this.mActivePlayer;
        if (this.mRagdollSpawnScheduled) {
            this.spawnRagdoll(player, this.mRagdollSpawnDir.x, this.mRagdollSpawnDir.y, this.mRagdollSpawnCrash);
            this.mRagdollSpawnScheduled = false;
        }
        this.handleTransfers(player);
        Object object = player;
        Player player2 = object;
        if (((Player)object).mScoreDisplay > player2.mScore) {
            player2.mScoreDisplay = player2.mScore;
        }
        if (player2.mScoreDisplayCombo < player2.mScoreCombo) {
            player2.mScoreDisplayCombo += player2.mScoreComboIncrement;
        }
        if (player2.mScoreDisplayCombo > player2.mScoreCombo) {
            player2.mScoreDisplayCombo = player2.mScoreCombo;
        }
        if (player2.mScoreMultiplierMax < player2.getMultiplier()) {
            player2.mScoreMultiplierMax = player2.mScoreMultiplier;
        }
        Object object2 = player2;
        int n6 = RM.getValue(583, ((Player)object2).mRideId, 8);
        if (!((Player)object2).mScoreComboDisableBreak && ((Player)object2).mGame.getKeyFrame() > ((Player)object2).mScoreComboLastUpdateKeyFrame + n6 && ((Player)object2).mScoreCombo > 0 && ((Player)object2).mScoreComboLastUpdateKeyFrame > -1 && player2.mScoreCombo > 0) {
            player2.scoreComboAddToTotalScore();
        }
        if (player2.mScoreComboLastUpdateKeyFrame == Integer.MIN_VALUE || player2.mScoreCombo <= 0) {
            player2.mScoreComboTimeoutBarPercentage = -1;
        } else {
            n5 = RM.getValue(583, player2.mRideId, 8);
            if (n5 > 0) {
                player2.mScoreComboTimeoutBarPercentage = 1024 - (player2.mGame.getKeyFrame() - player2.mScoreComboLastUpdateKeyFrame - 1 << 10) / n5;
            }
        }
        ((Player)object).mGame.doSteer((Player)object, ((Player)object).mInputState);
        ((Player)object).mInputState = 0;
        ++((Player)object).mTicks;
        object = this;
        if (((Game3d)object).mNumBoxes > 0) {
            int n7 = ((Game3d)object).mNumRides;
            VerletSystem[] verletSystemArray = ((Game3d)object).mSystems;
            int n8 = n7 + ((Game3d)object).mNumBoxes;
            for (n6 = n7; n6 < n8; ++n6) {
                int n9;
                VerletSystem verletSystem = verletSystemArray[n6];
                if (!verletSystem.isVisible()) continue;
                if (verletSystem.isActive()) {
                    for (n9 = n7; n9 < n8; ++n9) {
                        VerletSystem verletSystem2;
                        if (n9 == n6 || !(verletSystem2 = verletSystemArray[n9]).isVisible() || n9 <= n6 && verletSystem2.isActive()) continue;
                        verletSystem.resolveCollision(verletSystem2, 512, 2);
                    }
                }
                n9 = ((ArenaGame)object).getActiveRideId();
                for (n4 = 0; n4 < n7; ++n4) {
                    VerletSystem verletSystem3 = ((Game3d)object).mSystems[n4];
                    if (!verletSystem3.isVisible() || !verletSystem3.resolveCollision(verletSystem, 1536, 1) || verletSystemArray[n6].getUserData()[4] != 0) continue;
                    if (((ArenaGame)object).isRagdollBurning() || n9 == 4) {
                        ((ArenaGame)object).getActivePlayer().scoreAddMove(10, false);
                        ((ArenaGame)object).setOnFire(n6);
                    } else {
                        ((ArenaGame)object).getActivePlayer().scoreAddMove(11, false);
                    }
                    verletSystemArray[n6].getUserData()[4] = 1;
                    ((Game3d)object).mBurstingCrates.addCrate$731d857b(((Game3d)object).mRenderer$1894c531, ((Game3d)object).mSystems[n6]);
                }
            }
        }
        object = this.getActivePlayer();
        ArenaGame.resetLastDefinitionsStateInfo(((Player)object).mStateInfo);
        object = this.mSystems;
        if (this.mSystems != null) {
            int n10 = ((VerletSystem[])object).length;
            for (n5 = 0; n5 < n10; ++n5) {
                object[n5].tick();
            }
        }
        this.updateRideCenters();
        if (this.mCollectables >= 0) {
            this.checkCollectables(player, this.mCollectables, this.mCollectableSphereCache, this.mCollectablesFlags, this.mCollectablesScene, 7);
        }
        if (this.mTriggers >= 0) {
            this.checkCollectables(player, this.mTriggers, this.mTriggerSphereCache, this.mTriggerVisibleFlags, -1, 6);
        }
        if (this.mTriggerAreas >= 0) {
            boolean bl = true;
            n6 = 0;
            object2 = this.mTriggerAreasFlags;
            n5 = this.mTriggerAreas;
            player2 = player;
            object = this;
            Point3D point3D = Point3D.getLocal();
            super.getRide(player2).getScreenCenter(point3D);
            n4 = point3D.x;
            int n11 = point3D.y;
            int n12 = RM.getHeight(n5);
            for (n3 = 0; n3 < n12; ++n3) {
                boolean bl2 = n4 >= RM.getValue(n5, n3, 0) && n4 <= RM.getValue(n5, n3, 1) && n11 >= RM.getValue(n5, n3, 2) && n11 <= RM.getValue(n5, n3, 3);
                if (!(bl2 ^ (by = RM.isBitSet((int[])object2, n3)))) continue;
                n2 = RM.getValue(n5, n3, 6);
                n = RM.getValue(n5, n3, 7);
                if (bl2 && by == 0) {
                    ((ArenaGame)object).onArea(0, n2, n);
                    RM.setBit((int[])object2, n3, true);
                    continue;
                }
                if (by == 0) continue;
                ((ArenaGame)object).onArea(1, n2, n);
                RM.setBit((int[])object2, n3, false);
            }
            Point3D.freeLocal(point3D);
        }
        object = this;
        if (((Game3d)object).mCurGlows > 0) {
            int n13 = 0;
            n5 = 0;
            object2 = Point3D.getLocal();
            n13 = ((Game3d)object).mCurGlows >> 1;
            n5 = ((Game3d)object).mCurGlows - n13;
            Object object3 = super.getActiveRide();
            ((VerletSystem)object3).getScreenCenter((Point3D)object2);
            object3 = Point3D.getLocal();
            Matrix33 matrix33 = Matrix33.getLocal();
            Matrix33 matrix332 = Matrix33.getLocal();
            n4 = 0;
            int n14 = -1;
            int n15 = ((Game3d)object).mNumRides;
            for (n3 = 0; n3 < n15; ++n3) {
                VerletSystem verletSystem = ((Game3d)object).mSystems[n3];
                by = verletSystem.getUserData()[0];
                if (by < 0 || by == 0) continue;
                n2 = RM.getValue(583, by, 10);
                if (n2 >= 0) {
                    verletSystem.getWorldPosition(n2, (Point3D)object3);
                } else {
                    verletSystem.getScreenCenter((Point3D)object3);
                }
                n = n3;
                int n16 = verletSystem.getUserData()[4] == 0 ? 1 : 0;
                if (n16 != 0) {
                    if (((Point3D)object3).x < ((Point3D)object2).x) {
                        n16 = 0;
                    } else {
                        if (n14 < 0) {
                            n14 = n3;
                        }
                        n = n4++;
                    }
                }
                if (n16 == 0) continue;
                n16 = (((ArenaGame)object).mFrame + (n3 << 3)) * 80;
                matrix33.setRotationY(n16);
                matrix332.setRotationX(n16);
                matrix33.append(matrix332);
                ((Game3d)object).mRenderer$1894c531.setObjectTransform(((Game3d)object).mGlowScene, n, matrix33, (Point3D)object3);
                ((Game3d)object).mRenderer$1894c531.setObjectVisibility(((Game3d)object).mGlowScene, n, true);
                if (--n5 <= 0) break;
            }
            if (n13 > 0) {
                if (n14 < 0) {
                    n14 = ((Game3d)object).mNumRides;
                }
                for (n3 = n14 - 1; n3 >= 0; --n3) {
                    VerletSystem verletSystem = ((Game3d)object).mSystems[n3];
                    by = verletSystem.getUserData()[0];
                    if (by < 0 || by == 0 || verletSystem.getUserData()[4] != 0) continue;
                    n2 = RM.getValue(583, by, 10);
                    if (n2 >= 0) {
                        verletSystem.getWorldPosition(n2, (Point3D)object3);
                    } else {
                        verletSystem.getScreenCenter((Point3D)object3);
                    }
                    n = (((ArenaGame)object).mFrame + (n3 << 3)) * 80;
                    matrix33.setRotationY(n);
                    matrix332.setRotationX(n);
                    matrix33.append(matrix332);
                    int n17 = n4++;
                    ((Game3d)object).mRenderer$1894c531.setObjectTransform(((Game3d)object).mGlowScene, n17, matrix33, (Point3D)object3);
                    ((Game3d)object).mRenderer$1894c531.setObjectVisibility(((Game3d)object).mGlowScene, n17, true);
                    if (--n13 <= 0) break;
                }
            }
            if (n4 < ((Game3d)object).mCurGlows) {
                for (n3 = n4; n3 < ((Game3d)object).mCurGlows; ++n3) {
                    ((Game3d)object).mRenderer$1894c531.setObjectVisibility(((Game3d)object).mGlowScene, n3, false);
                }
            }
            Matrix33.freeLocal(matrix332);
            Matrix33.freeLocal(matrix33);
            Point3D.freeLocal((Point3D)object3);
            Point3D.freeLocal((Point3D)object2);
        }
        int n18 = this.mOccluderScene;
        object = this;
        if (n18 >= 0) {
            int n19;
            int n20;
            if (M3D.sLocCurrentMarker < 10) {
                for (int i = 0; i < 5; ++i) {
                    M3D.sLocStackPosMarkers[M3D.sLocCurrentMarker][i] = M3D.sLocStackPos[i];
                }
                int n21 = M3D.sLocCurrentMarker;
                n20 = n21;
                M3D.sLocCurrentMarker = n21 + 1;
            } else {
                n20 = -1;
            }
            n5 = n20;
            object2 = ((Game3d)object).mCamPosition;
            Point3D point3D = Point3D.getLocal();
            Point3D point3D2 = Point3D.getLocal();
            Point3D point3D3 = Point3D.getLocal();
            super.getActiveRide().getScreenCenter(point3D3);
            point3D.setDiff(point3D3, (Point3D)object2);
            point3D.unit();
            n4 = ((Game3d)object).mRenderer$1894c531.pick(n18, (Point3D)object2, point3D, point3D2);
            if (n4 >= 0) {
                if (((Game3d)object).mOccludedObject != n4 && ((Game3d)object).mOccludedObject >= 0) {
                    ((Game3d)object).mRenderer$1894c531.setRenderState(n18, ((Game3d)object).mOccludedObject, 529, -1);
                }
                if (point3D2.z > point3D3.z) {
                    ((Game3d)object).mOccludedObject = n4;
                    ((Game3d)object).mRenderer$1894c531.setRenderState(n18, n4, 529, 0);
                }
            } else if (((Game3d)object).mOccludedObject >= 0) {
                ((Game3d)object).mRenderer$1894c531.setRenderState(n18, ((Game3d)object).mOccludedObject, 529, -1);
                ((Game3d)object).mOccludedObject = -1;
            }
            if ((n19 = n5) == --M3D.sLocCurrentMarker) {
                for (int i = 0; i < 5; ++i) {
                    M3D.sLocStackPos[i] = M3D.sLocStackPosMarkers[M3D.sLocCurrentMarker][i];
                }
            }
        }
    }

    private VerletSystem getRide(Player object) {
        int n = ((Player)object).mRideHandle;
        object = this;
        return ((Game3d)object).mSystems[n];
    }

    protected final void updateRideCenters() {
        Point2D[] point2DArray = this.mRideCenters;
        VerletSystem[] verletSystemArray = this.mSystems;
        int n = point2DArray.length;
        for (int i = 0; i < n; ++i) {
            Point3D point3D = verletSystemArray[i].getCenter();
            point2DArray[i].set(point3D.x, point3D.y);
        }
    }

    protected final void getRideCenter(int n, Point2D point2D) {
        Point3D point3D = this.mSystems[n].getCenter();
        point2D.set(point3D.x, point3D.y);
    }

    protected final void carApplyAcceleration(int n, int n2) {
        VerletSystem verletSystem = this.getActiveRide();
        Point3D point3D = Point3D.getLocal();
        verletSystem.getPosition(point3D);
        Point3D point3D2 = verletSystem.getOrientation().ax;
        Point3D point3D3 = Point3D.getLocal();
        point3D3.set(n2, point3D2.y, -point3D.z >> 1);
        point3D3.unit();
        point3D3.scale(n);
        if (n >= 0) {
            verletSystem.applyForce(3, point3D3);
            verletSystem.applyForce(4, point3D3);
        } else {
            verletSystem.applyForce(1, point3D3);
            verletSystem.applyForce(2, point3D3);
        }
        Point3D.freeLocal(point3D3);
        Point3D.freeLocal(point3D);
    }

    protected final int calculateAim(int[] nArray, int n) {
        int n2 = nArray[16];
        if (n2 < 0 || this.hasCarAidTimedOut()) {
            VerletSystem verletSystem = this.getActiveRide();
            Matrix33 matrix33 = Matrix33.getLocal();
            matrix33.setRotationZ(n);
            matrix33.append(verletSystem.getOrientation());
            nArray[11] = matrix33.ax.x;
            nArray[12] = matrix33.ax.y;
            nArray[13] = matrix33.ax.z;
            Matrix33.freeLocal(matrix33);
        } else {
            VerletSystem verletSystem = this.getActiveRide();
            int n3 = n2;
            Object object = this;
            VerletSystem verletSystem2 = ((Game3d)object).mSystems[n3];
            object = Matrix33.getLocal();
            ((Matrix33)object).lookAtX(verletSystem.getCenter(), Point3D.Z, verletSystem2.getCenter());
            if (((Matrix33)object).ax.dot(verletSystem.getOrientation().ay) < 0) {
                nArray[16] = -1;
                n2 = -1;
            } else {
                nArray[11] = ((Matrix33)object).ax.x;
                nArray[12] = ((Matrix33)object).ax.y;
                nArray[13] = ((Matrix33)object).ax.z;
            }
            Matrix33.freeLocal((Matrix33)object);
        }
        return n2;
    }

    protected final void carApplyCharge(int n, int n2) {
        VerletSystem verletSystem = this.getActiveRide();
        Point3D point3D = Point3D.getLocal();
        if (n != 0) {
            point3D.set(verletSystem.getOrientation().ay);
            if (point3D.z != 0) {
                point3D.z = 0;
                point3D.unit();
            }
            point3D.scale(n);
            point3D.scale(4096);
            verletSystem.applyForce(1, point3D);
            verletSystem.applyForce(2, point3D);
        }
        if (n2 != 0) {
            point3D.set(verletSystem.getOrientation().ay);
            if (point3D.z != 0) {
                point3D.z = 0;
                point3D.unit();
            }
            point3D.scale(n2);
            point3D.scale(4096);
            verletSystem.applyForce(3, point3D);
            verletSystem.applyForce(4, point3D);
        }
        Point3D.freeLocal(point3D);
    }

    public final void onDeactivate(VerletSystem verletSystem) {
        if (verletSystem == this.getActiveRide()) {
            this.playerFinished(this.getActivePlayer(), 0, false);
            return;
        }
        if (verletSystem.getUserData()[0] >= 0) {
            verletSystem.deactivate();
        }
        if (verletSystem.getIdx() == 5) {
            verletSystem.setActive(false);
            verletSystem.setVisible(false);
        }
    }

    private static int getSystemHandle(VerletSystem verletSystem) {
        return verletSystem.getUserData()[1] & 0xFF;
    }

    public final void onSatisfy(VerletSystem object, Point3D[] point3DArray, Point3D[] point3DArray2, int[] nArray) {
        boolean bl = (((VerletSystem)object).getFlags() & 1) != 0;
        VerletSystem verletSystem = ((VerletSystem)object).getLinkMaster();
        if (bl &= verletSystem == null || (verletSystem.getFlags() & 1) != 0) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = this.mObstacles;
            Point3D[] point3DArray3 = point3DArray;
            Point3D[] point3DArray4 = point3DArray2;
            Object object2 = object;
            Object object3 = this;
            if (n8 >= 0 && (((VerletSystem)object2).getFlags() & 1) != 0) {
                int n9;
                n7 = Integer.MAX_VALUE;
                n6 = Integer.MAX_VALUE;
                n5 = Integer.MIN_VALUE;
                n4 = Integer.MIN_VALUE;
                n3 = point3DArray3.length;
                while (--n3 >= 0) {
                    Point3D point3D = point3DArray3[n3];
                    Point3D point3D2 = point3DArray4[n3];
                    int n10 = point3D2.x;
                    n9 = point3D2.y;
                    int n11 = point3D.x;
                    n2 = point3D.y;
                    if (n10 < n7) {
                        n7 = n10;
                    }
                    if (n11 < n7) {
                        n7 = n11;
                    }
                    if (n9 < n6) {
                        n6 = n9;
                    }
                    if (n2 < n6) {
                        n6 = n2;
                    }
                    if (n10 > n5) {
                        n5 = n10;
                    }
                    if (n11 > n5) {
                        n5 = n11;
                    }
                    if (n9 > n4) {
                        n4 = n9;
                    }
                    if (n2 <= n4) continue;
                    n4 = n2;
                }
                int n12 = 0;
                n = RM.getHeight(n8);
                int[] nArray2 = ((Game3d)object3).mObstacleBoundingRects;
                n9 = 0;
                int[] nArray3 = ((Game3d)object3).mObstacleCache;
                for (n2 = 0; n2 < n; ++n2) {
                    if (n5 >= nArray2[n12 + 1] && n7 <= nArray2[n12 + 3] && n4 >= nArray2[n12 + 2] && n6 <= nArray2[n12 + 4]) {
                        nArray3[n9++] = n2;
                    }
                    n12 += 5;
                }
                ((Game3d)object3).mNumObstaclesCached = n9;
            }
            VerletSystem verletSystem2 = this.getActiveRide();
            boolean bl2 = object == verletSystem2;
            int n13 = Game3d.getSystemHandle((VerletSystem)object);
            int[] nArray4 = this.mHeightmapInfo[n13];
            int n14 = 0;
            int n15 = this.mLeftTrackLimit;
            int n16 = this.mRightTrackLimit;
            Point3D point3D = Point3D.getLocal();
            int n17 = point3DArray.length;
            ((VerletSystem)object).getUserData()[2] = 0;
            for (int i = 0; i < n17; ++i) {
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                int n24 = nArray[i];
                Point3D point3D3 = point3DArray[i];
                Object object4 = point3DArray2[i];
                int n25 = 512;
                object2 = object4;
                object3 = point3D3;
                int n26 = ((Point3D)object3).z;
                n8 = ((Point3D)object2).z;
                n7 = n26 - n8;
                ((Point3D)object3).z = n26 -= n7 << 9 >> 10;
                if (n26 < -16384) {
                    ((Point3D)object3).z -= n26 - -16384 << 5 >> 10;
                } else if (n26 > 16384) {
                    ((Point3D)object3).z += 16384 - n26 << 5 >> 10;
                }
                int n27 = 0;
                int n28 = 0;
                int n29 = 0;
                if (point3D3.x < n15) {
                    n29 = point3D3.x - n15;
                    point3D3.x = n15;
                }
                if (point3D3.x > n16) {
                    n29 = n16 - point3D3.x;
                    point3D3.x = n16;
                }
                if ((n24 & 2) != 0) {
                    Point3D point3D4 = point3D;
                    n26 = this.mObstacles;
                    Point3D point3D5 = point3D3;
                    object2 = object4;
                    object3 = this;
                    n7 = 0;
                    n6 = ((Game3d)object3).mNumObstaclesCached;
                    if (n26 >= 0 && n6 > 0) {
                        int n30;
                        Point2D point2D = Point2D.getLocal();
                        if (point3D5.x < ((Point3D)object2).x) {
                            n4 = point3D5.x;
                            n30 = ((Point3D)object2).x;
                        } else {
                            n4 = ((Point3D)object2).x;
                            n30 = point3D5.x;
                        }
                        if (point3D5.y < ((Point3D)object2).y) {
                            n3 = point3D5.y;
                            n = ((Point3D)object2).y;
                        } else {
                            n3 = ((Point3D)object2).y;
                            n = point3D5.y;
                        }
                        int[] nArray5 = ((Game3d)object3).mObstacleBoundingRects;
                        int[] nArray6 = ((Game3d)object3).mObstacleCache;
                        for (int j = 0; j < n6; ++j) {
                            n2 = nArray6[j] * 5;
                            n26 = nArray5[n2 + 0];
                            n23 = nArray5[n2 + 1];
                            n22 = nArray5[n2 + 2];
                            n21 = nArray5[n2 + 3];
                            n20 = nArray5[n2 + 4];
                            if (n30 < n23 || n4 > n21 || n < n22 || n3 > n20) continue;
                            if (n26 == 1) {
                                int n31 = n23 + n21 >> 1;
                                n27 = n22 + n20 >> 1;
                                point2D.set(point3D5.x, point3D5.y);
                                n7 = ArenaGame.projectP1ToDistFromP0(n31, n27, point2D, n21 - n31);
                                point3D5.x = point2D.x;
                                point3D5.y = point2D.y;
                                point3D4.set(0, 0, 0);
                                continue;
                            }
                            int n32 = ((Point3D)object2).x - n23;
                            n27 = n21 - ((Point3D)object2).x;
                            int n33 = ((Point3D)object2).y - n22;
                            n19 = n20 - ((Point3D)object2).y;
                            int n34 = n32 < n27 ? n32 : n27;
                            int n35 = n26 = n33 < n19 ? n33 : n19;
                            if (n34 <= n26) {
                                point3D4.set(0, 1024, 1024);
                                if (n32 < n27) {
                                    n32 = n23 - point3D5.x;
                                    if (n32 > 0) continue;
                                    point3D5.x = n23;
                                    n7 += n32;
                                    continue;
                                }
                                n32 = point3D5.x - n21;
                                if (n32 > 0) continue;
                                point3D5.x = n21;
                                n7 += n32;
                                continue;
                            }
                            point3D4.set(1024, 0, 1024);
                            if (n33 < n19) {
                                n32 = n22 - point3D5.y;
                                if (n32 >= 0) continue;
                                point3D5.y = n22;
                                n7 += n32;
                                continue;
                            }
                            n32 = point3D5.y - n20;
                            if (n32 >= 0) continue;
                            point3D5.y = n20;
                            n7 += n32;
                        }
                        Point2D.freeLocal(point2D);
                    }
                    if ((n27 = n7 >> 5) < 0) {
                        ((VerletSystem)object).applyFriction(i, point3D);
                    }
                }
                if ((n24 & 1) != 0) {
                    object4 = this.mHeightmapCheckPos;
                    Point2D point2D = this.mHeightmapCheckOld;
                    for (n19 = 0; n19 < 2; ++n19) {
                        int n36;
                        ((Point2D)object4).x = point3D3.x;
                        ((Point2D)object4).y = point3D3.y;
                        int[] nArray7 = nArray4;
                        int n37 = 1024;
                        Object var26_14 = null;
                        Point2D point2D2 = point2D;
                        object2 = object4;
                        object3 = this.mHeightMaps[n19];
                        if (((HeightMap)object3).mNumFragments == 0) {
                            n36 = 0;
                        } else if (((HeightMap)object3).mIsContinuous) {
                            n6 = nArray7[0];
                            n5 = ((Point2D)object2).x >> 5;
                            int[] nArray8 = ((HeightMap)object3).mFragmentBounds;
                            n3 = n6 << 2;
                            int n38 = nArray8[n3 + 0];
                            n = nArray8[n3 + 2];
                            if (n5 >= n38 && n5 < n) {
                                n36 = ((HeightMap)object3).project(n6, (Point2D)object2, point2D2, null, 1024);
                            } else {
                                int n39 = n5 < n38 ? -1 : 1;
                                boolean bl3 = false;
                                while ((n6 += n39) >= 0 && n6 < ((HeightMap)object3).mNumFragments) {
                                    n3 = n6 << 2;
                                    n38 = nArray8[n3 + 0];
                                    n = nArray8[n3 + 2];
                                    if (n5 < n38 || n5 >= n) continue;
                                }
                                if (n6 >= 0 && n6 < ((HeightMap)object3).mNumFragments) {
                                    nArray7[0] = n6;
                                    n36 = ((HeightMap)object3).project(n6, (Point2D)object2, point2D2, null, 1024);
                                } else {
                                    nArray7[0] = 0;
                                    n36 = 0;
                                }
                            }
                        } else {
                            long l = nArray7[1];
                            long l2 = nArray7[2];
                            long l3 = l << 32 | l2;
                            if (l3 == 0L) {
                                n36 = 0;
                            } else {
                                int n40 = ((HeightMap)object3).mNumFragments;
                                int[] nArray9 = ((HeightMap)object3).mFragmentBounds;
                                int n41 = 0;
                                n2 = ((Point2D)object2).x >> 5;
                                int n42 = 0;
                                for (n23 = 0; n23 < n40; ++n23) {
                                    if ((l3 & 1L << n23) != 0L) {
                                        n22 = nArray9[n41 + 0];
                                        n21 = nArray9[n41 + 2];
                                        if (n2 >= n22 && n2 < n21 && (n20 = ((HeightMap)object3).project(n23, (Point2D)object2, point2D2, null, 1024)) < n42) {
                                            n42 = n20;
                                        }
                                    }
                                    n41 += 4;
                                }
                                n36 = n42;
                            }
                        }
                        n28 += n36;
                        if ((n24 & 0x40) != 0) continue;
                        point3D3.x = ((Point2D)object4).x;
                        point3D3.y = ((Point2D)object4).y;
                    }
                    if (n28 < 0 && (n24 & 0x40) == 0) {
                        n19 = (n24 & 8) != 0 ? 2048 : 1024;
                        point3D.set(n19, 0, n19);
                        ((VerletSystem)object).applyFriction(i, point3D);
                    }
                }
                if ((n18 = (n27 += n29) + n28) >= 0) continue;
                ((VerletSystem)object).getUserData()[2] = 1;
                if ((n24 & 0x20) != 0) {
                    ++n14;
                }
                if (bl2) {
                    if ((n24 & 0x10) != 0) {
                        if (n13 == this.mRagdollHandle) {
                            int n43 = ((VerletSystem)object).getAveragePartSpeed();
                            if (this.doRagdollCrash(n43)) {
                                this.onCrash((VerletSystem)object, false);
                            }
                        } else {
                            this.crashRide((VerletSystem)object, n27, n28);
                        }
                    }
                } else if (n13 == this.mRagdollHandle && verletSystem != null) {
                    this.crashRide(verletSystem, n27, n28);
                }
                if (n18 >= -32) continue;
                this.spawnEffectSparse((VerletSystem)object, i, 1, false);
            }
            if (bl2) {
                int[] nArray10;
                object = this.getActivePlayer();
                int[] nArray11 = nArray10 = ((Player)object).mStateInfo;
                nArray11[2] = nArray11[2] + n14;
            }
            Point3D.freeLocal(point3D);
        }
    }

    private void crashRide(VerletSystem verletSystem, int n, int n2) {
        byte by;
        int n3 = verletSystem.getAveragePartSpeed();
        if (this.checkRideCrash(n3, by = verletSystem.getUserData()[0], n < 0, (n2 = n2 < 0 ? 1 : 0) != 0)) {
            this.onCrash(verletSystem, n2 != 0);
        }
    }

    public final boolean preDraw(VerletSystem object, int n, Point3D point3D, Matrix33 matrix33) {
        if (object == this.getActiveRide()) {
            int n2;
            Object object2;
            Object object3;
            if (((VerletSystem)object).getIdx() == 0) {
                if (n == 0) {
                    object3 = this.getActivePlayer();
                    object3 = ((Player)object3).mStateInfo;
                    this.augmentCarCharging((VerletSystem)object, point3D, matrix33, (int)(object3[15] * 204 >> 10), 1, 3, 4);
                    this.augmentCarCharging((VerletSystem)object, point3D, matrix33, (int)(object3[14] * 204 >> 10), -1, 1, 2);
                } else {
                    object3 = Matrix33.getLocal();
                    ((Matrix33)object3).setRotationZ(-point3D.x >> 5);
                    matrix33.prepend((Matrix33)object3);
                    Matrix33.freeLocal((Matrix33)object3);
                }
            } else if (((VerletSystem)object).getIdx() == 3) {
                int n3;
                object3 = this.getActivePlayer();
                object = this;
                if (((Player)object3).isFinished()) {
                    n3 = 0;
                } else {
                    int[] nArray;
                    object2 = super.getRide((Player)object3);
                    int n4 = ((VerletSystem)object2).getSpeed();
                    n4 = GCanvas.clamp(n4, 0, 15000);
                    n4 = 15000 - n4;
                    int n5 = (n4 << 10) / 15000;
                    n4 = n5 * 150;
                    n4 >>= 10;
                    n2 = n5 * 180;
                    n2 >>= 10;
                    int[] nArray2 = nArray = ((Player)object3).mStateInfo;
                    nArray2[11] = nArray2[11] + (n4 += 50);
                    int n6 = GCanvas.sin(nArray[11]) * (n2 += 20);
                    n3 = n6 = n6 >> 10;
                }
                matrix33.addRotationX(n3);
            }
            Point3D point3D2 = point3D;
            object2 = matrix33;
            int n7 = n;
            object = this;
            Point3D point3D3 = Point3D.getLocal();
            point3D3.set(point3D2);
            point3D3.shiftR(5);
            int n8 = RM.getHeight(585);
            for (n2 = 0; n2 < n8; ++n2) {
                int n9 = RM.getValue(585, n2, 0);
                if ((1 << ((ArenaGame)object).getActiveRideId() & n9) == 0 || RM.getValue(585, n2, 2) != n7) continue;
                ((Game3d)object).mRenderer$1894c531.setObjectTransform(((Game3d)object).mRideFXScene, n2, (Matrix33)object2, point3D3);
            }
            Point3D.freeLocal(point3D3);
        }
        return false;
    }

    private void augmentCarCharging(VerletSystem verletSystem, Point3D point3D, Matrix33 matrix33, int n, int n2, int n3, int n4) {
        if (n > 0) {
            Matrix33 matrix332 = Matrix33.getLocal();
            int n5 = n;
            if (n >= 2048 && (this.mKeyFrame & 1) != 0) {
                n5 -= 512;
            }
            matrix332.setRotationZ((n5 >> 5) * n2);
            Point3D point3D2 = Point3D.getLocal();
            Point3D point3D3 = Point3D.getLocal();
            verletSystem.getPosition(n3, point3D2);
            verletSystem.getPosition(n4, point3D3);
            point3D2.add(point3D3);
            point3D2.shiftR(1);
            point3D.sub(point3D2);
            matrix332.transform(point3D);
            point3D.add(point3D2);
            matrix33.prepend(matrix332);
            Point3D.freeLocal(point3D3);
            Point3D.freeLocal(point3D2);
            Matrix33.freeLocal(matrix332);
        }
    }

    public final void preIntegrate(VerletSystem object) {
        if ((((VerletSystem)object).getFlags() & 1) != 0) {
            VerletSystem verletSystem = object;
            object = this;
            if ((verletSystem.getFlags() & 1) != 0) {
                int[] nArray = ((ArenaGame)object).mHeightmapTestpositions;
                Object object2 = Point3D.getLocal();
                int n = verletSystem.getNumParts();
                int[] nArray2 = verletSystem.getPartFlags();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    if ((nArray2[i] & 1) == 0) continue;
                    verletSystem.getPhysicsPosition(i, (Point3D)object2);
                    nArray[n2 + 0] = ((Point3D)object2).x;
                    nArray[n2 + 1] = ((Point3D)object2).y;
                    n2 += 2;
                }
                Point3D.freeLocal((Point3D)object2);
                HeightMap heightMap = ((Game3d)object).mHeightMaps[1];
                int n3 = Game3d.getSystemHandle(verletSystem);
                object2 = object = (Object)((ArenaGame)object).mHeightmapInfo[n3];
                int n4 = n2 >> 1;
                int[] nArray3 = nArray;
                object = heightMap;
                if (((HeightMap)object).mNumFragments != 0) {
                    int n5;
                    n = Integer.MAX_VALUE;
                    int n6 = Integer.MIN_VALUE;
                    n2 = Integer.MAX_VALUE;
                    int n7 = Integer.MIN_VALUE;
                    int n8 = n4;
                    int n9 = 0;
                    while (--n8 >= 0) {
                        n5 = nArray3[n9 + 0];
                        int n10 = nArray3[n9 + 1];
                        if (n5 < n) {
                            n = n5;
                        }
                        if (n5 > n6) {
                            n6 = n5;
                        }
                        if (n10 < n2) {
                            n2 = n10;
                        }
                        if (n10 > n7) {
                            n7 = n10;
                        }
                        n9 += 2;
                    }
                    n >>= 5;
                    n2 >>= 5;
                    n6 >>= 5;
                    n7 >>= 5;
                    n5 = ((HeightMap)object).depthSign;
                    long l = (long)object2[1];
                    long l2 = (long)object2[2];
                    long l3 = l << 32 | l2;
                    int[] nArray4 = ((HeightMap)object).mFragmentBounds;
                    int n11 = -4;
                    int n12 = ((HeightMap)object).mNumFragments;
                    for (int i = 0; i < n12; ++i) {
                        long l4 = 1L << i;
                        n8 = nArray4[(n11 += 4) + 0] - 1536;
                        n9 = nArray4[n11 + 2] + 1536;
                        int n13 = nArray4[n11 + 1];
                        int n14 = nArray4[n11 + 3];
                        if (n5 > 0) {
                            if (n7 <= n13) {
                                if ((l3 & l4) == 0L) continue;
                                l3 &= l4 ^ 0xFFFFFFFFFFFFFFFFL;
                                continue;
                            }
                        } else if (n5 < 0 && n2 >= n14) {
                            if ((l3 & l4) == 0L) continue;
                            l3 &= l4 ^ 0xFFFFFFFFFFFFFFFFL;
                            continue;
                        }
                        if (n9 < n || n8 > n6) {
                            if ((l3 & l4) == 0L) continue;
                            l3 &= l4 ^ 0xFFFFFFFFFFFFFFFFL;
                            continue;
                        }
                        n8 = n4;
                        n9 = 0;
                        n13 = 0;
                        while (--n8 >= 0) {
                            n14 = nArray3[n9 + 0];
                            int n15 = nArray3[n9 + 1];
                            if (n5 > 0) {
                                if (((HeightMap)object).getFragmentHeightAt(i, n14) <= n15) {
                                    ++n13;
                                }
                            } else if (((HeightMap)object).getFragmentHeightAt(i, n14) >= n15) {
                                ++n13;
                            }
                            n9 += 2;
                        }
                        if (n13 != n4) continue;
                        l3 |= l4;
                    }
                    object2[1] = (int)(l3 >> 32);
                    object2[2] = (int)l3;
                }
            }
        }
    }

    protected final void onInit() {
        Point2D.locInit(10);
        Point3D.locInit(10);
        Matrix33.locInit(10);
        Matrix34.locInit(10);
        VerletSystem.setListener$6fe08e58(this);
        VerletSystem.setPhysicsShift(5);
        VerletSystem.setTimeFactor(1500);
        this.mObstacleCache = new int[8];
        this.mHeightMaps = new HeightMap[2];
        for (int i = 0; i < 2; ++i) {
            this.mHeightMaps[i] = new HeightMap(true);
        }
        this.mBurstingCrates = new BurstingCrates();
        this.mBurstingCrates.init();
    }

    private void onCrash(VerletSystem verletSystem, boolean bl) {
        this.hideRideFX();
        Player player = this.getActivePlayer();
        if (verletSystem == this.getRide(player)) {
            int n;
            if (verletSystem.getIdx() != 1) {
                n = 0;
                int n2 = 0;
                if (bl) {
                    Point3D point3D = Point3D.getLocal();
                    verletSystem.getVelocity(point3D);
                    n = point3D.x * 50 / 100;
                    n2 = -(point3D.y * 50) / 100;
                    Point3D.freeLocal(point3D);
                }
                int n3 = this.mRagdollHandle;
                Game3d game3d = this;
                game3d.mSystems[n3].moveCenterTo(verletSystem.getCenter());
                boolean bl2 = true;
                Game3d game3d2 = this;
                game3d2.mRagdollSpawnDir.set(n, n2);
                game3d2.mRagdollSpawnScheduled = true;
                game3d2.mRagdollSpawnCrash = true;
            }
            if (verletSystem.getIdx() == 1) {
                n = verletSystem.getAveragePartSpeed();
                Player player2 = player;
                player2.addDamage(n / 190);
            }
            this.performMenuAction(45, 1);
        }
    }

    protected final void doRestart() {
        this.mExplosionStart = -1;
        this.mCurrentCamera = -1;
        this.calculateView(true);
    }

    protected final void placeSystem(int n, int n2, int n3) {
        this.placeSystem(this.mSystems[n], 1, 8192);
    }

    private void placeSystem(VerletSystem verletSystem, int n, int n2) {
        int n3 = verletSystem.getNumParts();
        Point3D point3D = Point3D.getLocal();
        verletSystem.getPosition(point3D);
        int n4 = point3D.y + n2;
        int n5 = point3D.x;
        HeightMap heightMap = this.mHeightMaps[n];
        int n6 = n5 >> 5;
        int n7 = n4 >> 5;
        int[] nArray = heightMap.mFragmentBounds;
        int n8 = 0;
        int n9 = heightMap.mNumFragments;
        int n10 = Integer.MAX_VALUE;
        int n11 = Integer.MIN_VALUE;
        for (int i = 0; i < n9; ++i) {
            int n12 = nArray[n8 + 0];
            int n13 = nArray[n8 + 2];
            if (n6 >= n12 && n6 < n13) {
                n12 = heightMap.getFragmentHeightAt(i, n5);
                if ((heightMap.mIsContinuous || n12 < n4) && (n13 = Math.abs(n12 - n7)) < n10) {
                    n10 = n13;
                    n11 = n12;
                }
            }
            n8 += 4;
        }
        int n14 = n11;
        Point3D.freeLocal(point3D);
        if (n14 != Integer.MIN_VALUE) {
            int n15 = Integer.MAX_VALUE;
            Point3D point3D2 = Point3D.getLocal();
            for (n4 = 0; n4 < n3; ++n4) {
                verletSystem.getPosition(n4, point3D2);
                if (point3D2.y >= n15) continue;
                n15 = point3D2.y;
            }
            Point3D.freeLocal(point3D2);
            n4 = n14 - n15;
            if (n4 > 0) {
                verletSystem.move(0, n4 += n2, 0);
            }
            verletSystem.updateScene$3246187e(this.mRenderer$1894c531, true);
        }
    }

    private VerletSystem getActiveRide() {
        Player player = this.getActivePlayer();
        return this.mSystems[player.mRideHandle];
    }

    protected final void drawTrackPreview$11c48828(Graphics graphics, int n) {
        int n2;
        graphics.getTranslateX();
        graphics.getTranslateY();
        if (this.mCurrentMission != n || this.mInvalidatePreview) {
            this.initMissionData(n);
            n2 = n;
            Game3d game3d = this;
            this.mPlaybackCamera = RM.getValue(771, n2, 9);
            n2 = RM.getValue(771, n2, 23);
            if (game3d.mPlaybackCamera != -1) {
                game3d.cameraInit(game3d.mPlaybackCamera, true, n2);
            }
        }
        if (this.mAutoCameraType == 4) {
            this.autoCameraPlay();
        } else if (!this.cameraPlay()) {
            this.cameraRestart();
        }
        n = this.mNumTutorials;
        for (n2 = 0; n2 < n; ++n2) {
            this.mRenderer$1894c531.setObjectVisibility(this.mTutorialsScene, n2, false);
        }
        this.mRenderer$1894c531.setCamera(this.mCamPosition, this.mCamTarget);
        this.mRenderer$1894c531.begin(graphics, 1);
        this.mRenderer$1894c531.renderScenes();
        this.mRenderer$1894c531.end(0);
    }

    private void explosion(int n, Point3D point3D, int n2, int n3) {
        Object object = Point2D.getLocal();
        ((Point2D)object).set(point3D.x, point3D.y);
        super.explosion$18041f15((Point2D)object, n2, n3);
        Point2D.freeLocal((Point2D)object);
        object = this.mExplosionPosition;
        ((Point3D)object).set(point3D.x, point3D.y, 0);
        ((Point3D)object).shiftR(5);
        Point3D point3D2 = this.mExplosionPosition;
        int n4 = 4;
        ParticleSystem3D particleSystem3D = this.mEffects$2cea9fce;
        particleSystem3D.addParticle(4, point3D2, Point3D.ZERO);
        this.mRenderer$1894c531.setObjectVisibility(this.mFXScene, 0, true);
        this.mRenderer$1894c531.setObjectTransform(this.mFXScene, 0, Matrix33.IDENTITY, (Point3D)object);
        this.mRenderer$1894c531.setObjectVisibility(this.mFXScene, 1, true);
        this.mRenderer$1894c531.setObjectTransform(this.mFXScene, 1, Matrix33.IDENTITY, (Point3D)object);
        this.mExplosionStart = this.mFrame;
    }

    /*
     * Unable to fully structure code
     */
    private void checkCollectables(Player var1_1, int var2_2, int[] var3_3, int[] var4_4, int var5_5, int var6_6) {
        var27_7 = var1_1;
        var7_11 = 1 << var27_7.mRideId;
        var27_7 = var1_1;
        var8_12 = this.mSystems[var27_7.mRideHandle];
        var9_14 = Point3D.getLocal();
        var8_12.getScreenCenter(var9_14);
        var10_16 = var9_14.x;
        var12_17 = var9_14.y;
        var14_18 = var8_12.getScreenRadiusSquared() + 1024;
        Point3D.freeLocal(var9_14);
        var8_13 = RM.getHeight(var2_2);
        var9_15 = 0;
        for (var16_19 = 0; var16_19 < var8_13; ++var16_19) {
            block19: {
                block20: {
                    if (!RM.isBitSet(var4_4, var16_19)) break block19;
                    var17_20 = var3_3[var9_15 + 0];
                    var18_22 = var3_3[var9_15 + 1];
                    var19_26 = var3_3[var9_15 + 2];
                    var22_31 = var10_16 - (long)var17_20;
                    var24_34 = var12_17 - (long)var18_22;
                    var26_37 = var22_31 * var22_31 + var24_34 * var24_34 >> 10;
                    if (var26_37 < 0L || var26_37 >= var14_18 + (long)var19_26) break block19;
                    var24_35 = var6_6;
                    var23_33 = var16_19;
                    var22_32 = var7_11;
                    var21_30 = var5_5;
                    var20_29 = var4_4;
                    var19_26 = var2_2;
                    var18_23 = var1_1;
                    var17_21 = this;
                    if (var24_35 >= 0) {
                        var27_7 = var18_23;
                        var27_7.mStateInfo[var24_35] = var23_33;
                    }
                    var24_35 = 0;
                    var25_36 = 0;
                    var26_38 = 1;
                    var27_8 = RM.getValue(var19_26, var23_33, 0);
                    var28_40 = RM.getLink(586, 0, var27_8);
                    if (var28_40 >= 0) {
                        var26_38 = RM.getValue(586, var28_40, 3);
                        var26_38 = (var26_38 & var22_32) != 0 ? 1 : 0;
                        var24_35 = RM.getValue(586, var28_40, 2);
                        var25_36 = RM.getValue(586, var28_40, 1);
                    }
                    if (var26_38 == 0) break block19;
                    var26_39 = Point3D.getLocal();
                    var26_39.setFromResource(var19_26, var23_33, 1);
                    var26_39.shiftL(5);
                    v0 = var24_35;
                    v1 = var27_8;
                    var28_41 = var26_39;
                    var27_8 = var23_33;
                    var18_24 = v1;
                    var24_35 = var19_26;
                    var22_32 = v0;
                    var19_27 = var18_23;
                    var18_25 = var17_21;
                    switch (var22_32) {
                        case 4: {
                            var27_9 = var19_27;
                            if (var27_9.mRideId == 5) ** GOTO lbl70
                            var27_9 = var19_27;
                            if (var27_9.mRideId == 3) ** GOTO lbl64
                            var27_9 = var19_27;
                            if (var27_9.mRideId != 4) ** GOTO lbl65
lbl64:
                            // 2 sources

                            var18_25.spawnRagdoll(var19_27, 0, 0);
lbl65:
                            // 2 sources

                            var27_9 = var19_27;
                            var18_25.explosion(var27_9.mRideHandle, var28_41, 17000, 2);
                            Menu.performMenuAction(45, 5);
                            var18_25.getActivePlayer().scoreAddMove(5, false);
                            break;
lbl70:
                            // 1 sources

                            v2 = false;
                            break block20;
                        }
                        case 3: {
                            var27_10 = var19_27;
                            if (var27_10.mRideId == 5) ** GOTO lbl85
                            var27_10 = var19_27;
                            if (var27_10.mRideId == 3) ** GOTO lbl79
                            var27_10 = var19_27;
                            if (var27_10.mRideId != 4) ** GOTO lbl80
lbl79:
                            // 2 sources

                            var18_25.spawnRagdoll(var19_27, 0, 0);
lbl80:
                            // 2 sources

                            var27_10 = var19_27;
                            var18_25.explosion(var27_10.mRideHandle, var28_41, 11000, 1);
                            Menu.performMenuAction(45, 5);
                            var18_25.getActivePlayer().scoreAddMove(6, false);
                            break;
lbl85:
                            // 1 sources

                            v2 = false;
                            break block20;
                        }
                        case 5: {
                            var18_25.setRagdollOnFire();
                            v2 = false;
                            break block20;
                        }
                        case 8: {
                            v2 = false;
                            break block20;
                        }
                        case 6: {
                            var19_28 = RM.getValue(var24_35, var27_8, 4);
                            var22_32 = RM.getValue(var24_35, var27_8, 6) == 1 ? 1 : 0;
                            var28_42 = RM.getValue(588, var19_28, 1);
                            var24_35 = RM.getValue(var24_35, var27_8, 5);
                            if ((1 << var18_25.getActiveRideId() & var28_42) != 0) {
                                var18_25.initializeTutorial(var27_8, var19_28, var24_35, (boolean)var22_32);
                                break;
                            }
                            v2 = false;
                            break block20;
                        }
                        default: {
                            v2 = super.onItemCollected$65dcdce(var19_27, var22_32);
                            break block20;
                        }
                    }
                    v2 = true;
                }
                if (v2) {
                    RM.setBit(var20_29, var23_33, false);
                    if (var21_30 >= 0) {
                        var17_21.mRenderer$1894c531.setObjectVisibility(var21_30, var23_33, false);
                        var18_25 = Point3D.getLocal();
                        var18_25.set(var26_39);
                        var18_25.y += 512;
                        var17_21.mEffects$2cea9fce.addParticle(var25_36, var26_39, (Point3D)var18_25);
                        Point3D.freeLocal((Point3D)var18_25);
                    }
                }
                Point3D.freeLocal(var26_39);
            }
            var9_15 += 3;
        }
    }

    protected final void initViewport() {
        if (this.mRenderer$1894c531 == null) {
            this.mRenderer$1894c531 = new Renderer();
            this.mRenderer$1894c531.setLODHint(2500);
            this.mRenderer$1894c531.init(493);
            this.mEffects$2cea9fce = new ParticleSystem3D(492, 528);
        }
        this.mRenderer$1894c531.setViewport(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
    }

    protected final void initMissionData(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        int n8;
        this.mCurrentMission = n;
        this.mInvalidatePreview = false;
        this.mCamHint = -1;
        this.mCurGlows = 0;
        this.mActivePlayer = new Player(this);
        this.mOccludedObject = -1;
        this.mRagdollSpawnScheduled = false;
        int n9 = RM.getValue(771, n, 1);
        int n10 = RM.getValue(771, n, 3);
        int n11 = RM.getValue(771, n, 5);
        int n12 = RM.getValue(771, n, 4);
        int n13 = RM.getValue(771, n, 8);
        int n14 = RM.getValue(771, n, 6);
        int n15 = RM.getValue(771, n, 2);
        n = RM.getValue(771, n, 7);
        int n16 = RM.getValue(770, n9, 8);
        int n17 = RM.getValue(770, n9, 9);
        int n18 = RM.getValue(770, n9, 3);
        int n19 = RM.getValue(770, n9, 4);
        int n20 = RM.getValue(770, n9, 6);
        int n21 = RM.getValue(770, n9, 7);
        int n22 = RM.getValue(770, n9, 10);
        int n23 = RM.getValue(770, n9, 0);
        int n24 = RM.getValue(770, n9, 1);
        this.mTriggers = n12;
        this.mCollectables = n10;
        this.mTriggerAreas = n11;
        this.mObstacles = n22;
        int n25 = n22;
        Object object2 = this;
        if (n25 < 0) {
            ((Game3d)object2).mObstacleBoundingRects = null;
        } else {
            ((Game3d)object2).mNumObstaclesCached = 0;
            n8 = RM.getHeight(((Game3d)object2).mObstacles);
            ((Game3d)object2).mObstacleBoundingRects = new int[n8 * 5];
            object = ((Game3d)object2).mObstacleBoundingRects;
            n7 = 0;
            for (n6 = 0; n6 < n8; ++n6) {
                n5 = RM.getValue(n25, n6, 0);
                int n26 = RM.getValue(n25, n6, 1);
                n4 = RM.getValue(n25, n6, 2);
                int[] nArray = RM.getInts(n5);
                n3 = 0;
                n2 = RM.getLink(774, 0, n5);
                if (n2 >= 0) {
                    n3 = RM.getValue(774, n2, 1);
                }
                object[n7 + 0] = n3;
                object[n7 + 1] = nArray[0] + n26 << 5;
                object[n7 + 2] = nArray[1] + n4 << 5;
                object[n7 + 3] = nArray[3] + n26 << 5;
                object[n7 + 4] = nArray[4] + n4 << 5;
                n7 += 5;
            }
        }
        this.mMetaScene = n;
        this.mTriggerVisibleFlags = n12 >= 0 ? RM.createBitfield(RM.getHeight(n12), true) : null;
        this.mTriggerTouchedFlags = n12 >= 0 ? RM.createBitfield(RM.getHeight(n12), false) : null;
        this.mCollectablesFlags = n10 >= 0 ? RM.createBitfield(RM.getHeight(n10), true) : null;
        this.mTriggerAreasFlags = n11 >= 0 ? RM.createBitfield(RM.getHeight(n11), false) : null;
        this.mHeightMaps[0].setHeights(n19, 0, 1024, 530, 0, 1, true, true);
        if (n20 >= 0) {
            this.mHeightMaps[1].setHeights(n20, 0, 1024, 530, 0, 1, true, false);
        } else {
            object2 = this.mHeightMaps[1];
            this.mHeightMaps[1].mNumFragments = 0;
            ((HeightMap)object2).mNumSegments = null;
            ((HeightMap)object2).mFragmentPositions = null;
            ((HeightMap)object2).mFragmentBounds = null;
            ((HeightMap)object2).mHeights = null;
            System.gc();
        }
        this.mRenderer$1894c531.clearScenes();
        this.mRenderer$1894c531.setBackground(773, 2);
        this.mRenderer$1894c531.addStaticScene(n23, 1, 1);
        n = RM.getValue(770, n9, 2);
        if (n >= 0) {
            this.mRenderer$1894c531.addStaticScene(n, 1, 1);
        }
        this.mRenderer$1894c531.addStaticScene(n18, 0, 0);
        this.mRenderer$1894c531.addAnimatedScene(n24, 531, 1, 0);
        this.mRenderer$1894c531.addStaticScene(n19, 0, 0);
        this.mBurstingCrates.addScene$71fdc2ea(this.mRenderer$1894c531);
        n = RM.getValue(770, n9, 5);
        this.mRenderer$1894c531.addStaticScene(n, 1, 1);
        this.mSystems = null;
        this.mNumRides = 0;
        this.mNumBoxes = 0;
        n = 0 + ((n15 >= 0 ? this.getNumValidSpawns(n15) : 0) + 1);
        this.mSystems = new VerletSystem[n += n13 >= 0 ? RM.getHeight(n13) : 0];
        this.mRideDatas = new byte[n][];
        n8 = n15;
        Player player = this.getActivePlayer();
        object2 = this;
        if (n8 >= 0) {
            int n27 = RM.getHeight(n8);
            ((Game3d)object2).mNumRides = ((ArenaGame)object2).getNumValidSpawns(n8) + 1;
            int n28 = 0;
            for (n7 = 0; n7 < n27; ++n7) {
                n6 = RM.getValue(n8, n7, 0);
                n5 = RM.getValue(587, n6, 0);
                if (!((ArenaGame)object2).achievementsIsRideAvailable(n5)) continue;
                VerletSystem verletSystem = super.createRide(n5, n28);
                if (verletSystem.getIdx() == 0) {
                    ((Game3d)object2).mRenderer$1894c531.setLODHint(verletSystem.getScene(), 0);
                }
                n4 = RM.getValue(n8, n7, 1) << 5;
                n3 = RM.getValue(n8, n7, 2) << 5;
                n2 = RM.getValue(n8, n7, 3) << 5;
                verletSystem.moveTo(n4, n3, n2);
                if (RM.getValue(583, n5, 7) != 0) {
                    super.placeSystem(verletSystem, 0, 0);
                }
                verletSystem.updateScene$3246187e(((Game3d)object2).mRenderer$1894c531, true);
                ((Game3d)object2).mSystems[n28] = verletSystem;
                if (n28 == 0) {
                    player.setRide(n5, 0, ((ArenaGame)object2).createStateInfo(n5));
                }
                ++n28;
            }
            ((ArenaGame)object2).mRagdollHandle = n28;
            VerletSystem verletSystem = super.createRide(0, n28);
            ((Game3d)object2).mRenderer$1894c531.setLODHint(verletSystem.getScene(), 0);
            verletSystem.setVisible(false);
            ((Game3d)object2).mSystems[n28] = verletSystem;
        }
        n8 = 569;
        int n29 = n13;
        object2 = this;
        if (n29 >= 0) {
            int n30;
            ((Game3d)object2).mNumBoxes = n30 = RM.getHeight(n29);
            object = Point3D.getLocal();
            Matrix33 matrix33 = Matrix33.getLocal();
            n6 = ((Game3d)object2).mNumRides;
            for (n5 = 0; n5 < n30; ++n5) {
                int n31 = RM.getValue(n29, n5, 0);
                if (n31 < 0) continue;
                ((Point3D)object).setFromResource(n29, n5, 1);
                matrix33.setFromResource(n29, n5, 4);
                ((Point3D)object).shiftL(5);
                VerletSystem verletSystem = new VerletSystem(((Game3d)object2).mRenderer$1894c531, 569, n31);
                verletSystem.createUserData(9);
                byte[] byArray = verletSystem.getUserData();
                byte[] byArray2 = byArray;
                byArray[0] = -1;
                byArray2[1] = (byte)n6;
                ((ArenaGame)object2).mRideDatas[n6] = byArray2;
                verletSystem.createPartData(1);
                verletSystem.moveTo((Point3D)object, matrix33);
                verletSystem.updateScene$3246187e(((Game3d)object2).mRenderer$1894c531, true);
                verletSystem.setActive(false);
                ((Game3d)object2).mSystems[n6] = verletSystem;
                ++n6;
            }
            Matrix33.freeLocal(matrix33);
            Point3D.freeLocal((Point3D)object);
        }
        this.mHeightmapInfo = new int[n][3];
        n9 = 0;
        for (n11 = 0; n11 < n; ++n11) {
            n13 = this.mSystems[n11].getNumParts();
            if (n13 <= n9) continue;
            n9 = n13;
        }
        this.mHeightmapTestpositions = new int[n9 << 1];
        this.mPictogramsScene = this.mRenderer$1894c531.createScene(1, 1, 0);
        this.mRenderer$1894c531.setObject(this.mPictogramsScene, 0, 19);
        this.mRenderer$1894c531.setObjectVisibility(this.mPictogramsScene, 0, false);
        n29 = 585;
        object2 = this;
        n8 = 0;
        int n32 = RM.getHeight(585);
        n8 = ((Game3d)object2).mRenderer$1894c531.createScene(n32, 1, 0);
        for (int i = 0; i < n32; ++i) {
            n7 = RM.getValue(585, i, 1);
            ((Game3d)object2).mRenderer$1894c531.setObject(n8, i, n7);
            ((Game3d)object2).mRenderer$1894c531.setObjectVisibility(n8, i, false);
        }
        this.mRideFXScene = n8;
        this.mFXScene = this.mRenderer$1894c531.createScene(2, 1, 0);
        this.mRenderer$1894c531.setObject(this.mFXScene, 0, 135);
        this.mRenderer$1894c531.setObjectVisibility(this.mFXScene, 0, false);
        this.mRenderer$1894c531.setObject(this.mFXScene, 1, 134);
        this.mRenderer$1894c531.setObjectVisibility(this.mFXScene, 1, false);
        this.mRenderer$1894c531.addStaticScene(n16, 1, 0);
        this.mRenderer$1894c531.addStaticScene(n20, 0, 0);
        this.mRenderer$1894c531.addAnimatedScene(n21, 531, 1, 0);
        this.mOccluderScene = -1;
        if (n17 >= 0) {
            this.mOccluderScene = this.mRenderer$1894c531.addDynamicScene(n17, 1, 0);
        }
        this.mCollectablesScene = this.mRenderer$1894c531.addDynamicScene(n10, 0, 0);
        this.mCollectableSphereCache = null;
        this.mTriggerSphereCache = null;
        if (n10 >= 0) {
            this.mCollectableSphereCache = new int[RM.getHeight(n10) * 3];
            Game3d.cacheSphereChecks(n10, this.mCollectableSphereCache, 493, 4);
        }
        if (n12 >= 0) {
            this.mTriggerSphereCache = new int[RM.getHeight(n12) * 3];
            Game3d.cacheSphereChecks(n12, this.mTriggerSphereCache, 494, 3);
        }
        this.triggerInitVisibleRepresentations();
        this.rideGlowInit();
        this.mEffects$2cea9fce.reset();
        this.mRenderer$1894c531.addParticleSystem$396f8c73(this.mEffects$2cea9fce);
        this.mLeftTrackLimit = RM.getValue(n14, 0, 0) << 5;
        this.mRightTrackLimit = RM.getValue(n14, 1, 0) << 5;
        if (this.mLeftTrackLimit > this.mRightTrackLimit) {
            n11 = this.mLeftTrackLimit;
            this.mLeftTrackLimit = this.mRightTrackLimit;
            this.mRightTrackLimit = n11;
        }
        this.mPreviewPos.x = this.mPreviewLeft = this.mLeftTrackLimit >> 5;
    }

    private static void cacheSphereChecks(int n, int[] nArray, int n2, int n3) {
        int n4 = RM.getHeight(n);
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = RM.getValue(n, i, 0);
            int n7 = RM.getValue(n, i, 1);
            int n8 = RM.getValue(n, i, 2);
            n6 = RM.getValue(n2, n6, n3);
            n6 = RM.getValue(n6, 3);
            nArray[n5 + 0] = n7;
            nArray[n5 + 1] = n8;
            nArray[n5 + 2] = n6;
            n5 += 3;
        }
    }

    private void triggerInitVisibleRepresentations() {
        this.mNumTutorials = 0;
        this.mTutorialObjects = null;
        if (this.mTriggers >= 0) {
            int n = RM.getHeight(this.mTriggers);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (RM.getVarType(this.mTriggers, i) != 1) continue;
                ++n2;
            }
            this.mNumTutorials = n2;
            this.mTutorialObjects = new int[n2 * 7];
            int[] nArray = this.mTutorialObjects;
            this.mTutorialsScene = this.mRenderer$1894c531.createScene(n2, 1, 0);
            Point3D point3D = Point3D.getLocal();
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                if (RM.getVarType(this.mTriggers, i) != 1) continue;
                nArray[n3] = i;
                int n5 = RM.getValue(this.mTriggers, i, 4);
                nArray[n3 + 1] = n5;
                int n6 = n5;
                nArray[n3 + 2] = RM.getValue(this.mTriggers, i, 6);
                nArray[n3 + 3] = RM.getValue(588, n6, 1);
                point3D.setFromResource(this.mTriggers, i, 1);
                point3D.store(nArray, n3 + 4);
                this.mRenderer$1894c531.setObject(this.mTutorialsScene, n4, 32);
                ++n4;
                n3 += 7;
            }
            Point3D.freeLocal(point3D);
        }
    }

    protected final void triggerUpdateVisibleRepresentations() {
        int n = this.mNumTutorials;
        if (n > 0) {
            Point3D point3D = Point3D.getLocal();
            int n2 = 1 << this.getActiveRideId();
            int[] nArray = this.mTutorialObjects;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                int n4 = nArray[n3 + 0];
                int n5 = nArray[n3 + 1];
                int n6 = nArray[n3 + 2];
                int n7 = nArray[n3 + 3];
                if ((n4 = RM.isBitSet(this.mTriggerVisibleFlags, n4) && (!Menu.isOptionBitSet(50, n5) || n6 != 0) && !this.tutorialWasSeen(n5) ? 1 : 0) != 0) {
                    n5 = (n7 & n2) != 0 ? 1 : 0;
                    this.mRenderer$1894c531.setObject(this.mTutorialsScene, i, n5 != 0 ? 32 : 33);
                }
                this.mRenderer$1894c531.setObjectVisibility(this.mTutorialsScene, i, n4 != 0);
                n5 = this.mKeyFrame * 20480 >> 10;
                n5 = GCanvas.mathModWrap(n5, 0, 1024);
                n5 = (GCanvas.sin(n5) * 480 >> 10) + -180;
                point3D.set(nArray, n3 + 4);
                point3D.y += n5;
                n4 = this.mKeyFrame * 20480 >> 10;
                n4 = GCanvas.mathModWrap(n4, 0, 1024);
                Matrix33 matrix33 = Matrix33.getLocal();
                matrix33.setRotationY(n4);
                this.mRenderer$1894c531.setObjectTransform(this.mTutorialsScene, i, matrix33, point3D);
                Matrix33.freeLocal(matrix33);
                n3 += 7;
            }
            Point3D.freeLocal(point3D);
        }
    }

    protected final void setRideFXVisibility(int n, boolean bl) {
        this.mRenderer$1894c531.setObjectVisibility(this.mRideFXScene, n, bl);
    }

    protected final void hideRideFX() {
        int n = RM.getHeight(585);
        for (int i = 0; i < n; ++i) {
            this.mRenderer$1894c531.setObjectVisibility(this.mRideFXScene, i, false);
        }
    }

    private VerletSystem createRide(int n, int n2) {
        int n3 = RM.getValue(583, n, 0);
        int n4 = RM.getValue(583, n, 1);
        VerletSystem verletSystem = new VerletSystem(this.mRenderer$1894c531, 569, n3, n4);
        byte[] byArray = verletSystem.createUserData(9);
        byte[] byArray2 = byArray;
        byArray[0] = (byte)n;
        byArray2[1] = (byte)n2;
        this.mRideDatas[n2] = byArray2;
        verletSystem.createPartData(1);
        return verletSystem;
    }

    protected final void setCamHint(int n) {
        this.mCamHint = n;
    }

    private void calculateView(boolean bl) {
        Object object;
        bl = bl;
        int n = this.getActiveRideId();
        int n2 = RM.getValue(583, n, 5);
        int n3 = 1;
        if (n2 >= 0) {
            n3 = RM.getValue(527, n2, 0);
        }
        if (this.mCamHint >= 0) {
            n2 = this.mCamHint;
        } else if (this.mExplosionStart > 0) {
            n2 = 8;
        } else {
            if (n == 1 || n == 2) {
                Player player = this.getActivePlayer();
                object = player;
                object = player.mStateInfo;
                if (player.mStateInfo[19] == 1 || n == 2 && object[27] < 0) {
                    n2 = 2;
                }
            } else if (n == 0) {
                object = Point2D.getLocal();
                this.getRideVelocity((Point2D)object);
                n2 = ((Point2D)object).x < -4100 ? 4 : 3;
                Point2D.freeLocal((Point2D)object);
            }
            if (n2 >= 0) {
                n3 = RM.getValue(527, n2, 0);
            }
        }
        object = null;
        if (n3 == 1) {
            object = this.getActiveRide();
        } else if (n3 == 0) {
            n = this.mRagdollHandle;
            object = this;
            object = ((Game3d)object).mSystems[n];
        }
        Point3D point3D = Point3D.getLocal();
        Point3D point3D2 = Point3D.getLocal();
        if (!((VerletSystem)object).isActive()) {
            bl |= 2;
        }
        ((VerletSystem)object).getScreenPosition(point3D);
        ((VerletSystem)object).getScreenVelocity(point3D2);
        if (n2 == 2 && this.mBulletTimeId == 4 && this.isBulletTimeActive()) {
            n2 = 10;
        }
        int n4 = n2;
        int n5 = bl;
        object = point3D2;
        Point3D point3D3 = point3D;
        Game3d game3d = this;
        point3D3.x = point3D3.x;
        point3D3.z = point3D3.z;
        game3d.mCamEaseTarget.set(point3D3);
        if ((n5 & 3) == 0) {
            ((Point3D)object).scale(2048);
            ((Point3D)object).x = GCanvas.clamp(((Point3D)object).x, -4096, 4096);
            ((Point3D)object).y = GCanvas.clamp(((Point3D)object).y, -4096, 4096);
            ((Point3D)object).z = GCanvas.clamp(((Point3D)object).z, -4096, 4096);
        }
        game3d.mCamEasePosition.set(game3d.mCamEaseTarget);
        int n6 = RM.getValue(527, n4, 1);
        int n7 = RM.getValue(527, n4, 2);
        int n8 = RM.getValue(527, n4, 3);
        int n9 = RM.getValue(527, n4, 7);
        int n10 = RM.getValue(527, n4, 8);
        int n11 = RM.getValue(527, n4, 9);
        game3d.mCamEaseTarget.add(n6, n7, n8);
        game3d.mCamEasePosition.add(n9, n10, n11);
        if (game3d.mCurrentCamera != n4) {
            n6 = RM.getValue(527, n4, 4);
            n7 = RM.getValue(527, n4, 10);
            game3d.mCurrentCamera = n4;
            game3d.mCurrentCamEase = n7;
            game3d.mCurrentTargetEase = n6;
        } else {
            n6 = RM.getValue(527, n4, 5);
            n7 = RM.getValue(527, n4, 11);
            game3d.mCurrentCamEase += n7;
            game3d.mCurrentTargetEase += n6;
            if (game3d.mCurrentCamEase > 1024) {
                game3d.mCurrentCamEase = 1024;
            }
            if (game3d.mCurrentTargetEase > 1024) {
                game3d.mCurrentTargetEase = 1024;
            }
        }
        if ((n5 & 1) == 0) {
            game3d.mCamPosition.blend(game3d.mCamEasePosition, game3d.mCurrentCamEase);
            game3d.mCamTarget.blend(game3d.mCamEaseTarget, game3d.mCurrentTargetEase);
        } else {
            game3d.mCamPosition.set(game3d.mCamEasePosition);
            game3d.mCamTarget.set(game3d.mCamEaseTarget);
        }
        Point3D.freeLocal(point3D2);
        Point3D.freeLocal(point3D);
    }

    protected final void spawnEffect(int n, int n2) {
        Game3d.spawnEffect(this.getActiveRide(), n, n2);
    }

    private static void spawnEffect(VerletSystem verletSystem, int n, int n2) {
        verletSystem.getPartData((int)0)[n] = (byte)n2;
    }

    private final void spawnEffectSparse(VerletSystem verletSystem, int n, int n2, boolean bl) {
        if (!((this.mKeyFrame & 1) != 0 || bl && verletSystem.getPartData(0)[n] != 0)) {
            Game3d.spawnEffect(verletSystem, n, n2);
        }
    }

    protected final void autoCameraReset() {
        this.mAutoCameraType = -1;
    }

    protected final void autoCameraInit(int n) {
        this.mAutoCameraType = n;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                int n2 = n;
                Game3d game3d = this;
                int n3 = 400;
                n3 = 0;
                int n4 = 2;
                Game3d game3d2 = game3d;
                game3d.mCameraBezierPos.initBlank(2);
                game3d2.mCameraBezierPos.setLooping(false);
                game3d2.mCameraBezierPos.setSmoothness(400);
                game3d2.mCameraBezierTarget.initBlank(2);
                game3d2.mCameraBezierTarget.setLooping(false);
                game3d2.mCameraBezierTarget.setSmoothness(400);
                game3d.mCameraCurrentIndex = 0;
                game3d.mAutoCameraBlendInc = 34;
                Point3D point3D = Point3D.getLocal();
                game3d.mSystems[game3d.getActiveRideHandle()].getScreenCenter(point3D);
                if (n2 == 3) {
                    game3d.mCameraBezierTarget.setPoint(0, game3d.mCamTarget.x, game3d.mCamTarget.y, game3d.mCamTarget.z);
                    game3d.mCameraBezierTarget.setPoint(1, point3D.x + 2000, game3d.mCamTarget.y, game3d.mCamTarget.z);
                    game3d.mCameraBezierPos.setPoint(0, game3d.mCamPosition.x, game3d.mCamPosition.y, game3d.mCamPosition.z);
                    game3d.mCameraBezierPos.setPoint(1, point3D.x + -2000, game3d.mCamPosition.y + 1000, game3d.mCamPosition.z + 3000);
                } else {
                    game3d.mCameraBezierTarget.setPoint(0, game3d.mCamTarget.x, game3d.mCamTarget.y, game3d.mCamTarget.z);
                    game3d.mCameraBezierTarget.setPoint(1, point3D.x + -2000, game3d.mCamTarget.y, game3d.mCamTarget.z);
                    game3d.mCameraBezierPos.setPoint(0, game3d.mCamPosition.x, game3d.mCamPosition.y, game3d.mCamPosition.z);
                    game3d.mCameraBezierPos.setPoint(1, point3D.x + 3000, game3d.mCamPosition.y + 1000, game3d.mCamPosition.z + 1000);
                }
                game3d.mCameraBezierPos.calculateWeights();
                game3d.mCameraBezierTarget.calculateWeights();
                Point3D.freeLocal(point3D);
                return;
            }
            case 4: {
                Game3d game3d = this;
                Point3D point3D = Point3D.getLocal();
                Point3D point3D2 = Point3D.getLocal();
                int n5 = Game3d.autoCameraGetObjectPos(game3d.mCollectables, 34, point3D);
                if (n5 == 0) {
                    n5 = Game3d.autoCameraGetObjectPos(game3d.mMetaScene, 4, point3D);
                }
                if (n5 == 0) {
                    n5 = Game3d.autoCameraGetObjectPos(game3d.mCollectables, 35, point3D);
                }
                if (n5 == 0) break;
                n5 = RM.getValue(771, game3d.mCurrentMission, 2);
                point3D2.setFromResource(n5, 0, 1);
                n5 = Point3D.dist(point3D2, point3D);
                game3d.mAutoCameraBlendInc = Math.max(1, 4096 / (n5 /= 1000));
                game3d.mCameraCurrentIndex = 0;
                game3d.mAutoCameraFlybyStart.set(2000 + point3D.x, 5000 + point3D.y, 12000 + point3D.z);
                game3d.mAutoCameraFlybyEnd.set(-2000 + point3D2.x, 5000 + point3D2.y, 12000 + point3D2.z);
                game3d.mAutoCameraFlybyStartLookAt.set(point3D.x, point3D.y - 1000, point3D.z);
                game3d.mAutoCameraFlybyEndLookAt.set(point3D2.x, point3D2.y - 1000, point3D2.z);
                game3d.mAutoCameraFlybyStartSpeed = Math.max(1, game3d.mAutoCameraBlendInc / 3);
                game3d.mAutoCameraFlybyEndSpeed = Math.max(1, game3d.mAutoCameraBlendInc / 4);
                game3d.mAutoCameraSpeedupStart = 15 * game3d.mAutoCameraFlybyStartSpeed;
                game3d.mAutoCameraSlowdownStart = 4096 - 20 * game3d.mAutoCameraFlybyEndSpeed;
                Point3D.freeLocal(point3D2);
                Point3D.freeLocal(point3D);
            }
        }
    }

    private static boolean autoCameraGetObjectPos(int n, int n2, Point3D point3D) {
        if (n != -1 && (n2 = RM.getLink(n, 0, n2)) != -1) {
            point3D.setFromResource(n, n2, 1);
            return true;
        }
        return false;
    }

    protected final void autoCameraPlay() {
        switch (this.mAutoCameraType) {
            case 4: {
                int n = this.mAutoCameraBlendInc;
                int n2 = this.mAutoCameraSlowdownStart;
                if (this.mCameraCurrentIndex > n2) {
                    n2 = 1024 - (this.mCameraCurrentIndex - n2 << 10) / (4096 - n2);
                    n = Math.max(this.mAutoCameraFlybyEndSpeed, this.mAutoCameraBlendInc * n2 >> 10);
                }
                if (this.mCameraCurrentIndex < (n2 = this.mAutoCameraSpeedupStart)) {
                    n = 1024 - (n2 - this.mCameraCurrentIndex << 10) / n2;
                    n = Math.max(this.mAutoCameraFlybyStartSpeed, this.mAutoCameraBlendInc * n >> 10);
                }
                this.mCameraCurrentIndex += n;
                this.mCameraCurrentIndex = Math.min(this.mCameraCurrentIndex, 4096);
                Game3d.cameraInterpolate(this.mAutoCameraFlybyStart, this.mAutoCameraFlybyEnd, this.mCamPosition, this.mCameraCurrentIndex, 4096);
                Game3d.cameraInterpolate(this.mAutoCameraFlybyStartLookAt, this.mAutoCameraFlybyEndLookAt, this.mCamTarget, this.mCameraCurrentIndex, 4096);
                return;
            }
        }
        this.mCameraCurrentIndex += this.mAutoCameraBlendInc;
        this.mCameraCurrentIndex = Math.min(this.mCameraCurrentIndex, 1024);
        this.mCameraBezierPos.getPoint3D(this.mCameraCurrentIndex, this.mCamPosition);
        this.mCameraBezierTarget.getPoint3D(this.mCameraCurrentIndex, this.mCamTarget);
    }

    private static void cameraInterpolate(Point3D point3D, Point3D point3D2, Point3D point3D3, int n, int n2) {
        n2 = 4096 - n;
        point3D3.x = (point3D.x * n2 + point3D2.x * n) / 4096;
        point3D3.y = (point3D.y * n2 + point3D2.y * n) / 4096;
        point3D3.z = (point3D.z * n2 + point3D2.z * n) / 4096;
    }

    private void cameraInit(int n, boolean n2, int n3) {
        int n4 = RM.getHeight(n);
        if (n4 < 2) {
            this.mPlaybackCamera = -1;
            return;
        }
        this.mCameraTimeScale = 0x100000 / n3;
        this.mCameraBezierPos.setLooping(n2 != 0);
        this.mCameraBezierTarget.setLooping(n2 != 0);
        this.mCameraBezierPos.initBlank(n2 != 0 ? n4 - 1 : n4);
        this.mCameraBezierTarget.initBlank(n2 != 0 ? n4 - 1 : n4);
        this.mCameraBezierPos.setSmoothness(200);
        this.mCameraBezierTarget.setSmoothness(200);
        if (n2 != 0) {
            --n4;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.mCameraBezierPos.setPoint(n2, RM.getValue(n, n2, 1), RM.getValue(n, n2, 2), RM.getValue(n, n2, 3));
            this.mCameraBezierTarget.setPoint(n2, RM.getValue(n, n2, 4), RM.getValue(n, n2, 5), RM.getValue(n, n2, 6));
        }
        this.mCameraBezierPos.calculateWeights();
        this.mCameraBezierTarget.calculateWeights();
        this.mCameraCurrentId = n;
        this.mCameraAnimLength = RM.getHeight(n);
        if (this.mCameraAnimLength == 0) {
            this.mCameraCurrentId = -1;
            return;
        }
        this.mCameraCurrentIndex = 1;
        this.mCameraLastFrame = 0;
        this.mCameraStartFrame = GCanvas.getGlobalFrameCount();
    }

    private void cameraRestart() {
        this.mCameraCurrentIndex = 1;
        this.mCameraLastFrame = 0;
        this.mCameraStartFrame = GCanvas.getGlobalFrameCount();
    }

    protected final void initLevelFlyby() {
        int n = RM.getValue(771, this.mCurrentMission, 9);
        int n2 = RM.getValue(771, this.mCurrentMission, 23);
        if (n != -1) {
            this.cameraInit(n, true, n2);
            n = 200;
            Game3d game3d = this;
            if (game3d.mCameraCurrentId != -1) {
                n2 = RM.getHeight(game3d.mCameraCurrentId);
                for (int i = 0; i < n2; ++i) {
                    if (200 >= RM.getValue(game3d.mCameraCurrentId, i, 0)) continue;
                    game3d.mCameraCurrentIndex = i;
                    game3d.mCameraStartFrame = GCanvas.getGlobalFrameCount() - 200;
                    if (i > 0) {
                        game3d.mCameraLastFrame = RM.getValue(game3d.mCameraCurrentId, i - 1, 0);
                        break;
                    }
                    game3d.mCameraLastFrame = RM.getValue(game3d.mCameraCurrentId, 0, 0);
                    return;
                }
            }
        }
    }

    private boolean cameraPlay() {
        if (this.mCameraCurrentIndex >= this.mCameraAnimLength) {
            return false;
        }
        int n = GCanvas.getGlobalFrameCount() - this.mCameraStartFrame;
        int n2 = RM.getValue(this.mCameraCurrentId, this.mCameraCurrentIndex, 0);
        if (n == (n2 = n2 * this.mCameraTimeScale >> 10)) {
            ++this.mCameraCurrentIndex;
            this.mCameraLastFrame = n;
            this.mCameraBezierPos.getPoint3D(this.mCameraCurrentIndex - 1 << 10, this.mCamPosition);
            this.mCameraBezierTarget.getPoint3D(this.mCameraCurrentIndex - 1 << 10, this.mCamTarget);
        } else {
            n -= this.mCameraLastFrame;
            if ((n2 -= this.mCameraLastFrame) > 0) {
                n = (n << 10) / n2;
                this.mCameraBezierPos.getPoint3D(n += this.mCameraCurrentIndex - 1 << 10, this.mCamPosition);
                this.mCameraBezierTarget.getPoint3D(n, this.mCamTarget);
            }
        }
        return true;
    }

    protected final void initMainMenu() {
        boolean bl = false;
        Game3d game3d = this;
        game3d.mRenderer$1894c531.setLODHint(0);
        game3d.mRenderer$1894c531.clearScenes();
        for (int i = 0; i < 8; ++i) {
            game3d.mStaticSceneLayers[i] = RM.getValue(772, 0, i);
            if (game3d.mStaticSceneLayers[i] == -1) continue;
            int n = RM.getHeight(game3d.mStaticSceneLayers[i]);
            int n2 = RM.getWidth(game3d.mStaticSceneLayers[i]);
            if (n == 0 || n2 == 0) {
                game3d.mStaticSceneLayers[i] = -1;
                continue;
            }
            if (i < 7) {
                game3d.mRenderer$1894c531.addStaticScene(game3d.mStaticSceneLayers[i], 1, 1);
                continue;
            }
            game3d.mRenderer$1894c531.addAnimatedScene(game3d.mStaticSceneLayers[i], 531, 1, 0);
        }
        game3d.mRenderer$1894c531.setLODHint(2500);
        this.mRenderer$1894c531.setBackground(773, 2);
        this.mPlaybackCamera = 767;
        this.cameraInit(this.mPlaybackCamera, false, 1024);
    }

    protected final void drawMainMenu(Graphics graphics) {
        if (!this.cameraPlay() && this.mPlaybackCamera >= 0) {
            if (this.mPlaybackCamera == 767) {
                this.mPlaybackCamera = 768;
                this.cameraInit(this.mPlaybackCamera, true, 1024);
            } else if (this.mPlaybackCamera == 768) {
                this.cameraRestart();
            }
        }
        int n = graphics.getTranslateX();
        int n2 = graphics.getTranslateY();
        graphics.translate(-n, -n2);
        this.mRenderer$1894c531.setCamera(this.mCamPosition, this.mCamTarget);
        this.mRenderer$1894c531.begin(graphics, 1);
        this.mRenderer$1894c531.renderScenes();
        this.mRenderer$1894c531.end(0);
        graphics.translate(n, n2);
    }

    protected final void getRideOrientation(Point2D point2D) {
        VerletSystem verletSystem = this.getActiveRide();
        point2D.set(verletSystem.getOrientation().ax.x, verletSystem.getOrientation().ax.y);
    }

    protected final void getRidePosition(Point2D point2D) {
        VerletSystem verletSystem = this.getActiveRide();
        Point3D point3D = Point3D.getLocal();
        verletSystem.getPosition(point3D);
        point2D.set(point3D.x, point3D.y);
        Point3D.freeLocal(point3D);
    }

    protected final void getRidePrevPosition(Point2D point2D) {
        VerletSystem verletSystem = this.getActiveRide();
        Point3D point3D = Point3D.getLocal();
        verletSystem.getPrevPosition(point3D);
        point2D.set(point3D.x, point3D.y);
        Point3D.freeLocal(point3D);
    }

    protected final void getRideVelocity(Point2D point2D) {
        VerletSystem verletSystem = this.getActiveRide();
        Point3D point3D = Point3D.getLocal();
        verletSystem.getVelocity(point3D);
        point2D.set(point3D.x, point3D.y);
        Point3D.freeLocal(point3D);
    }

    protected final int getRideSpeed() {
        VerletSystem verletSystem = this.getActiveRide();
        return verletSystem.getSpeed();
    }

    protected final void pushSystem(int n, int n2, int n3, int n4) {
        int n5 = n;
        Object object = this;
        object = ((Game3d)object).mSystems[n5];
        n2 *= n4;
        n3 *= n4;
        ((VerletSystem)object).push(n2 >>= 10, n3 >>= 10, 0);
    }

    protected final void poseRide(int n, int n2) {
        this.getActiveRide().pose(n, 512);
    }

    protected final void setRideKinematics(Point2D object) {
        Point3D point3D = Point3D.getLocal();
        point3D.set(((Point2D)object).x, ((Point2D)object).y, 0);
        object = this.getActiveRide();
        ((VerletSystem)object).setKinematics(point3D, ((VerletSystem)object).getOrientation(), ((VerletSystem)object).getCenter(), ((VerletSystem)object).getOrientation());
        Point3D.freeLocal(point3D);
    }

    protected final void setRideKinematics(Point2D object, Point2D object2) {
        object = Point3D.getLocal(((Point2D)object).x, ((Point2D)object).y, 0);
        Matrix33 matrix33 = Matrix33.getLocal();
        matrix33.setRotationZ(((Point2D)object2).x, ((Point2D)object2).y);
        object2 = this.getActiveRide();
        ((VerletSystem)object2).setKinematics((Point3D)object, matrix33, ((VerletSystem)object2).getCenter(), ((VerletSystem)object2).getOrientation());
        Matrix33.freeLocal(matrix33);
        Point3D.freeLocal((Point3D)object);
    }

    protected final void setRideOrientation(Point2D object) {
        Matrix33 matrix33 = Matrix33.getLocal();
        matrix33.setRotationZ(((Point2D)object).x, ((Point2D)object).y);
        object = this.getActiveRide();
        ((VerletSystem)object).setOrientation(matrix33);
        Matrix33.freeLocal(matrix33);
    }

    protected final void applyForce(int n, Point2D point2D) {
        Point3D point3D = Point3D.getLocal();
        point3D.set(point2D.x, point2D.y, 0);
        this.getActiveRide().applyForce(n, point3D);
        Point3D.freeLocal(point3D);
    }

    protected final void getRidePosition(int n, int n2, Point2D point2D) {
        Point3D point3D = Point3D.getLocal();
        int n3 = n;
        Game3d game3d = this;
        game3d.mSystems[n3].getPosition(n2, point3D);
        point2D.set(point3D.x, point3D.y);
        Point3D.freeLocal(point3D);
    }

    protected final void getRidePrevPosition(int n, Point2D point2D) {
        Point3D point3D = Point3D.getLocal();
        this.getActiveRide().getPrevPosition(4, point3D);
        point2D.set(point3D.x, point3D.y);
        Point3D.freeLocal(point3D);
    }

    protected final void getRideVelocity(int n, Point2D point2D) {
        Point3D point3D = Point3D.getLocal();
        this.getActiveRide().getVelocity(4, point3D);
        point2D.set(point3D.x, point3D.y);
        Point3D.freeLocal(point3D);
    }

    protected final void poseRide(int n, int n2, int n3) {
        n3 = n;
        Game3d game3d = this;
        game3d.mSystems[n3].pose(n2, 900);
    }

    protected final void poseRide(int n, int n2, int n3, int n4, int n5) {
        n5 = n;
        Game3d game3d = this;
        game3d.mSystems[n5].poseBlended(n2, n3, n4, 900);
    }

    protected final void spawnEffectSparse(int n, int n2, boolean bl) {
        this.spawnEffectSparse(this.getActiveRide(), 5, n2, false);
    }

    public final void playAnim(Player player, int n) {
        this.getRide(player).startAnim(490);
    }

    protected final int getRideRadiusSquared(int n) {
        int n2 = n;
        Game3d game3d = this;
        return game3d.mSystems[n2].getRadiusSquared();
    }

    protected final int getNumRides() {
        return this.mNumRides;
    }

    protected final int getSystemType(int n) {
        int n2 = n;
        Game3d game3d = this;
        return game3d.mSystems[n2].getIdx();
    }

    protected final void inheritSystemTranslation(int n, int n2, int n3) {
        int n4 = n;
        Game3d game3d = this;
        VerletSystem verletSystem = game3d.mSystems[n4];
        n4 = n2;
        game3d = this;
        verletSystem.inheritTranslation(game3d.mSystems[n4], n3);
    }

    protected final boolean isSystemActive(int n) {
        int n2 = n;
        Game3d game3d = this;
        return game3d.mSystems[n2].isActive();
    }

    protected final boolean isSystemDeactivated(int n) {
        int n2 = n;
        Game3d game3d = this;
        return game3d.mSystems[n2].isDeactivated();
    }

    protected final boolean isSystemVisible(int n) {
        int n2 = n;
        Game3d game3d = this;
        return game3d.mSystems[n2].isVisible();
    }

    protected final void linkSystems(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        Game3d game3d = this;
        VerletSystem verletSystem = game3d.mSystems[n8];
        n8 = n2;
        game3d = this;
        verletSystem.linkTo(game3d.mSystems[n8], n3, n4, n5, n6, n7);
    }

    protected final void setSystemActive(int n, boolean bl) {
        int n2 = n;
        Game3d game3d = this;
        game3d.mSystems[n2].setActive(bl);
    }

    protected final void setSystemAdditiveFriction(int n, int n2) {
        n2 = n;
        Game3d game3d = this;
        game3d.mSystems[n2].setAdditiveFriction(24);
    }

    protected final void setSystemDeactivated(int n) {
        int n2 = n;
        Game3d game3d = this;
        game3d.mSystems[n2].deactivate();
    }

    protected final void setSystemRestingEnabled(int n, boolean bl) {
        int n2 = n;
        Game3d game3d = this;
        game3d.mSystems[n2].setRestingEnabled(bl);
    }

    protected final void setSystemVisible(int n, boolean bl) {
        int n2 = n;
        Game3d game3d = this;
        game3d.mSystems[n2].setVisible(bl);
    }

    protected final void inheritSystemKinematics(int n, int n2, int n3) {
        int n4 = n;
        Game3d game3d = this;
        VerletSystem verletSystem = game3d.mSystems[n4];
        n4 = n2;
        game3d = this;
        verletSystem.inheritKinematics(game3d.mSystems[n4], n3);
    }

    protected final boolean isSystemLinked(int n) {
        int n2 = n;
        Game3d game3d = this;
        return game3d.mSystems[n2].isLinked();
    }

    protected final void unlinkSystem(int n) {
        int n2 = n;
        Game3d game3d = this;
        game3d.mSystems[n2].unlink();
    }

    protected final void doRingDetection(Player player) {
        int n;
        int n2;
        Object object = this.getActivePlayer();
        int n3 = ((Player)object).mStateInfo[6];
        if (this.mLastRingTrigger != n3 && this.mLastRingTrigger > -1) {
            n2 = RM.getValue(this.mTriggers, this.mLastRingTrigger, 1);
            Point3D point3D = Point3D.getLocal();
            object = player;
            n = ((Player)object).mRideHandle;
            object = this;
            ((Game3d)object).mSystems[n].getScreenCenter(point3D);
            if (this.mRingScorePossible == 0) {
                if (point3D.x >= n2) {
                    player.scoreAddMove(this.mCurrentMove, false);
                    RM.setBit(this.mTriggerTouchedFlags, this.mLastRingTrigger, true);
                }
            } else if (this.mRingScorePossible == 2 && point3D.x <= n2) {
                player.scoreAddMove(this.mCurrentMove, false);
                RM.setBit(this.mTriggerTouchedFlags, this.mLastRingTrigger, true);
            }
            Point3D.freeLocal(point3D);
            this.mRingScorePossible = 1;
            this.mLastRingTrigger = -1;
        }
        if (n3 >= 0) {
            n2 = RM.getValue(this.mTriggers, n3, 0);
            if (n2 == 2) {
                this.mCurrentMove = 9;
            } else if (n2 == 3) {
                this.mCurrentMove = 8;
            } else {
                return;
            }
            if (this.mRingScorePossible == 1 && !RM.isBitSet(this.mTriggerTouchedFlags, n3)) {
                this.mLastRingTrigger = n3;
                int n4 = RM.getValue(this.mTriggers, n3, 1);
                Point3D point3D = Point3D.getLocal();
                object = player;
                n = ((Player)object).mRideHandle;
                object = this;
                ((Game3d)object).mSystems[n].getScreenCenter(point3D);
                if (point3D.x <= n4) {
                    this.mRingScorePossible = 0;
                } else if (point3D.x >= n4) {
                    this.mRingScorePossible = 2;
                }
                Point3D.freeLocal(point3D);
            }
        }
    }

    public final int updateSoftButtonState(int n) {
        return 0;
    }

    protected final void carApplySpecialConstraits() {
        Object object = this.getActivePlayer();
        Object object2 = ((Player)object).mStateInfo;
        object = this.getActivePlayer();
        int n = ((Player)object).mRideHandle;
        object = this;
        object = ((Game3d)object).mSystems[n];
        Matrix33 matrix33 = Matrix33.getLocal(((VerletSystem)object).getOrientation());
        Point3D point3D = ((VerletSystem)object).getOrientation().ax;
        if (point3D.z != 0) {
            matrix33.ax.z = 0;
            matrix33.ax.unit();
        }
        if (this.isRideHeadDown() && object2[2] > 0) {
            Point3D point3D2 = ((VerletSystem)object).getOrientation().ay;
            object2 = point3D2;
            if (point3D2.z != 0) {
                matrix33.ay.z = 0;
                matrix33.ay.unit();
            }
        }
        ((VerletSystem)object).setOrientation(matrix33);
        Matrix33.freeLocal(matrix33);
    }

    protected final boolean isLoopingAvailable() {
        Object object = this.getActivePlayer();
        int n = ((Player)object).mRideHandle;
        object = this;
        object = ((Game3d)object).mSystems[n].getOrientation().az;
        return GCanvas.mathAbs(((Point3D)object).x) <= 300 && GCanvas.mathAbs(((Point3D)object).y) <= 300;
    }

    protected final void setTutorialVisible(int n) {
        int n2 = RM.getValue(this.mTriggers, n, 4);
        Menu.setOptionBit(50, n2, false);
        RM.setBit(this.mTriggerVisibleFlags, n, true);
        this.triggerUpdateVisibleRepresentations();
        Menu.saveOptions();
    }

    protected final int checkIfRagdollIsInTargetRange$2eb89048(int n) {
        if (this.mMetaScene == -1) {
            return n;
        }
        Point3D point3D = Point3D.getLocal();
        this.mSystems[this.getActiveRideHandle()].getScreenPosition(point3D);
        int n2 = RM.getLink(this.mMetaScene, 0, 4);
        int n3 = RM.getLink(this.mMetaScene, 0, 5);
        if (n2 != -1 && n3 != -1) {
            int n4 = RM.getValue(this.mMetaScene, n2, 1);
            n2 = RM.getValue(this.mMetaScene, n2, 2);
            n3 = n4 - RM.getValue(this.mMetaScene, n3, 1);
            if (point3D.x >= n4 - (n3 = Math.abs(n3)) && point3D.x <= n4 + n3 && point3D.y <= n2 + 2000 && point3D.y >= n2 + -1000) {
                n2 = Math.abs(n4 - point3D.x);
                Player player = this.getActivePlayer();
                this.getActivePlayer().mDistance = n2;
                n2 = 1;
                player = this.getActivePlayer();
                this.getActivePlayer().mExitWasTarget = true;
                n = 1;
            }
        }
        Point3D.freeLocal(point3D);
        return n;
    }

    protected final int missionGetUsedRides(int n) {
        if (n == -1) {
            return 0;
        }
        if ((n = RM.getValue(771, n, 2)) == -1) {
            return 0;
        }
        int n2 = RM.getHeight(n);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = RM.getValue(n, i, 0);
            n4 = RM.getValue(587, n4, 0);
            n3 |= 1 << n4;
        }
        return n3;
    }

    protected final void forceGameCameraReset() {
        Game3d game3d = this;
        this.mAutoCameraType = -1;
        this.calculateView(true);
    }

    public final void init() {
        super.init();
        this.mCamPosition = new Point3D();
        this.mCamTarget = new Point3D();
        this.mCamEaseTarget = new Point3D();
        this.mCamEasePosition = new Point3D();
        this.mPreviewPos = new Point3D();
        this.mExplosionPosition = new Point3D();
        this.mCameraCurrentId = -1;
        this.mCameraCurrentIndex = -1;
        this.mCameraAnimLength = -1;
        this.mCameraLastFrame = 0;
        this.mCameraStartFrame = 0;
        this.mCameraBezierPos = new AutoBezier(200, false);
        this.mCameraBezierTarget = new AutoBezier(200, false);
        this.mCameraTimeScale = 1024;
        this.mAutoCameraType = -1;
        this.mAutoCameraBlendInc = -1;
        this.mAutoCameraFlybyStart = new Point3D();
        this.mAutoCameraFlybyEnd = new Point3D();
        this.mAutoCameraFlybyStartLookAt = new Point3D();
        this.mAutoCameraFlybyEndLookAt = new Point3D();
    }

    protected final void moveSystemTo(int n, Point2D point2D) {
        Point3D point3D = Point3D.getLocal();
        this.mSystems[n].getPosition(point3D);
        point3D.x = point2D.x;
        point3D.y = point2D.y;
        this.mSystems[n].moveTo(point3D);
        Point3D.freeLocal(point3D);
    }

    protected final boolean missionHasTargetZone(int n) {
        return (n = RM.getValue(771, n, 7)) >= 0 && RM.getLink(n, 0, 4) >= 0;
    }

    protected final boolean getRideGlowPosition(int n, Point2D point2D) {
        VerletSystem verletSystem = this.mSystems[n];
        int n2 = verletSystem.getUserData()[0];
        n2 = RM.getValue(583, n2, 10);
        Point3D point3D = Point3D.getLocal();
        if (n2 >= 0) {
            verletSystem.getWorldPosition(n2, point3D);
        } else {
            verletSystem.getScreenCenter(point3D);
        }
        this.mRenderer$1894c531.projectVertex(point3D, point3D);
        point2D.set(point3D.x, point3D.y);
        point2D.x >>= 10;
        point2D.y >>= 10;
        Point3D.freeLocal(point3D);
        return true;
    }
}

