/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.coords.Coords;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenSummary;
import sk.inlogic.table.Table;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenFinalText
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    Table table;
    boolean isComplete;
    boolean needRepaint;
    boolean isArrowUp;
    boolean isArrowDown;
    private Rectangle rectText;
    private static PreparedText preparedText;
    private int textOffsetY;
    public static final int COMP_ID_ON = 0;
    public static final int COMP_ID_OFF = 1;
    public static final int TOTAL_COMP_IDS = 2;
    public static final int SPR_YES = 12;
    public static final int SPR_SCORE2 = 0;
    public static final int SPR_ARROW = 0;
    Rectangle[] rectItems = new Rectangle[3];
    public int coins;
    public int distance;
    public int level;
    public int timerPressed;
    public int timerReleased;
    public int timerSelected;
    public int timerScrolled;
    boolean isSoundOn;
    boolean isLoadAll;
    boolean isLoadingFlag;
    boolean isPressed;
    boolean isReleased;
    boolean isOnBtn;
    boolean fromMenu;
    boolean isUp;
    boolean isDown;
    public int posX;
    public int posYUp;
    public int posYDown;
    public int posXArrow;
    public int posYArrowUp;
    public int posYArrowDown;
    public int page;
    public int tilesX;
    public int tilesY;
    Image imgBg;
    Image imgBtnDown;
    Image imgCircle;
    Sprite sprTable;
    Sprite sprIconUp;
    Sprite sprIconDown;
    Sprite sprArrow;

    public ScreenFinalText(MainCanvas mainCanvas, int coins, int distance, int level, boolean isLoadAll) {
        this.mainCanvas = mainCanvas;
        this.coins = coins;
        this.distance = distance;
        this.level = level;
        this.isLoadAll = isLoadAll;
    }

    public void beforeShow() {
        this.isLoadingFlag = true;
        this.checkLowMem();
        this.coords = new Coords();
        this.table = new Table();
        if (this.isLoadAll) {
            this.loadAll();
        }
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            this.isSoundOn = true;
        } else {
            this.isSoundOn = false;
        }
        if (this.isComplete) {
            this.imgBg = Resources.resImgs[70];
        }
        this.imgBtnDown = Resources.resImgs[73];
        this.imgCircle = Resources.resImgs[75];
        this.sprTable = Resources.resSprs[1];
        this.sprArrow = Resources.resSprs[17];
        this.sprIconUp = Resources.resSprs[15];
        this.sprIconUp.setFrame(0);
        this.sprIconDown = Resources.resSprs[14];
        this.sprIconDown.setFrame(12);
        this.page = 0;
        this.isUp = false;
        this.isDown = false;
        Resources.loadGFont(this.coords.gfontMain2);
        this.calculatePositions();
        this.calculateTable();
        this.calculateContent();
        this.textOffsetY = 0;
        preparedText = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
        preparedText.prepareText(Resources.resTexts[0].getHashedString(8).toUpperCase(), this.rectText.width);
        this.isLoadingFlag = false;
    }

    public void checkLowMem() {
        this.isComplete = true;
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    private void calculatePositions() {
        this.posX = MainCanvas.WIDTH >> 1;
        this.posYDown = MainCanvas.HEIGHT - (this.coords.shiftBtnDown + this.coords.shiftMaster);
        this.tilesX = (MainCanvas.WIDTH - this.sprTable.getWidth()) / this.sprTable.getWidth();
        this.tilesY = !MainCanvas.isRotated ? this.posYDown / this.sprTable.getHeight() : (this.posYDown - this.sprTable.getHeight()) / this.sprTable.getHeight();
        this.posYUp = this.posYDown - this.tilesY * this.sprTable.getHeight() + (this.sprTable.getHeight() >> 2);
    }

    public void calculateTable() {
        int x = MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1;
        int y = this.posYDown - this.tilesY * this.sprTable.getHeight();
        this.table.set(x, y, this.tilesX, this.tilesY, this.sprTable);
    }

    public void calculateContent() {
        int contentYUp = this.posYUp + this.sprIconUp.getHeight() + (this.sprTable.getHeight() >> 2);
        int contentYDown = this.posYDown - (this.imgCircle.getHeight() >> 1) - (this.sprTable.getHeight() >> 2);
        int textMarginLeft = (MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1) + (this.sprTable.getWidth() >> 1);
        int textMarginTop = contentYUp;
        int textWidth = MainCanvas.WIDTH - (textMarginLeft << 1);
        int textHeight = contentYDown - contentYUp;
        this.rectText = new Rectangle(textMarginLeft, textMarginTop, textWidth, textHeight);
        this.posXArrow = MainCanvas.WIDTH - ((MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1) + this.sprTable.getWidth() + this.sprArrow.getWidth());
        this.posYArrowUp = contentYUp - this.sprArrow.getHeight() - (this.sprTable.getHeight() >> 2);
        this.posYArrowDown = contentYDown + (this.sprTable.getHeight() >> 2);
        this.rectItems[0] = new Rectangle(this.posXArrow, this.posYArrowUp, this.sprArrow.getWidth(), this.sprArrow.getHeight());
        this.rectItems[1] = new Rectangle(this.posXArrow, this.posYArrowDown, this.sprArrow.getWidth(), this.sprArrow.getHeight());
        this.rectItems[2] = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYDown - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
    }

    public void update(long lastRunLenght) {
        if (preparedText.getTextHeight() > this.rectText.height) {
            this.needRepaint = false;
            this.textMove();
            if (this.isUp) {
                this.textMoveUp();
            }
            if (this.isDown) {
                this.textMoveDown();
            }
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
    }

    private void textMove() {
        if (Keys.isActionPressed(1)) {
            this.textOffsetY -= Resources.resGFonts[this.coords.gfontMain2].getHeight() >> 1;
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.isArrowUp = false;
                this.isArrowDown = true;
            } else {
                this.isArrowUp = true;
                this.isArrowDown = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = preparedText.getTextHeight() - this.rectText.height;
            this.textOffsetY += Resources.resGFonts[this.coords.gfontMain2].getHeight() >> 1;
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.isArrowUp = true;
                this.isArrowDown = false;
            } else {
                this.isArrowUp = true;
                this.isArrowDown = true;
            }
            this.needRepaint = true;
        }
    }

    private void textMoveUp() {
        this.textOffsetY -= Resources.resGFonts[this.coords.gfontMain2].getHeight() >> 1;
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.isArrowUp = false;
            this.isArrowDown = true;
        } else {
            this.isArrowUp = true;
            this.isArrowDown = true;
        }
        this.needRepaint = true;
    }

    private void textMoveDown() {
        int maxOffsetY = preparedText.getTextHeight() - this.rectText.height;
        this.textOffsetY += Resources.resGFonts[this.coords.gfontMain2].getHeight() >> 1;
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.isArrowUp = true;
            this.isArrowDown = false;
        } else {
            this.isArrowUp = true;
            this.isArrowDown = true;
        }
        this.needRepaint = true;
    }

    public void paint(Graphics g) {
        if (this.isComplete) {
            for (int i = 0; i <= MainCanvas.WIDTH / this.imgBg.getWidth(); ++i) {
                for (int j = 0; j <= MainCanvas.HEIGHT / this.imgBg.getHeight(); ++j) {
                    g.drawImage(this.imgBg, i * this.imgBg.getWidth(), j * this.imgBg.getHeight(), 20);
                }
            }
        } else {
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        this.paintDialog(g);
    }

    public void paintDialog(Graphics g) {
        this.table.draw(g);
        g.drawImage(this.imgCircle, this.posX, this.posYDown + this.coords.shiftDownCircle, 3);
        g.drawImage(this.imgBtnDown, this.posX, this.posYDown, 3);
        this.paintDialogItems(g);
    }

    public void paintDialogItems(Graphics g) {
        this.sprIconUp.setPosition(this.posX - (this.sprIconUp.getWidth() >> 1), this.posYUp);
        this.sprIconUp.paint(g);
        this.sprIconDown.setPosition(this.posX - (this.sprIconDown.getWidth() >> 1), this.posYDown - (this.sprIconDown.getHeight() >> 1));
        this.sprIconDown.paint(g);
        preparedText.drawText(g, this.rectText, this.textOffsetY, 17);
        if (preparedText.getTextHeight() > this.rectText.height) {
            if (this.isArrowUp) {
                this.sprArrow.setFrame(0);
                this.sprArrow.setTransform(3);
                this.sprArrow.setPosition(this.posXArrow, this.posYArrowUp);
                this.sprArrow.paint(g);
            }
            if (this.isArrowDown) {
                this.sprArrow.setFrame(0);
                this.sprArrow.setTransform(0);
                this.sprArrow.setPosition(this.posXArrow, this.posYArrowDown);
                this.sprArrow.paint(g);
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (!(MainCanvas.touchActivated || this.isLoadingFlag || this.isPressed)) {
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.press();
            } else if (Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode)) {
                // empty if block
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (!MainCanvas.touchActivated && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.isOnBtn = true;
            this.release();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.rectItems[2].contains(x, y)) {
            this.isOnBtn = true;
            this.press();
        } else if (this.rectItems[0].contains(x, y)) {
            this.isUp = true;
            this.isDown = false;
        } else if (this.rectItems[1].contains(x, y)) {
            this.isUp = false;
            this.isDown = true;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.rectItems[2].contains(x, y)) {
            this.isUp = false;
            this.isDown = false;
        } else if (this.rectItems[0].contains(x, y)) {
            this.isDown = false;
            this.isOnBtn = false;
            this.release();
        } else if (this.rectItems[1].contains(x, y)) {
            this.isUp = false;
            this.isOnBtn = false;
            this.release();
        } else {
            this.isOnBtn = false;
            this.release();
            this.isUp = false;
            this.isDown = false;
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.rectItems[2].contains(x, y) && this.isPressed && this.isOnBtn) {
            this.release();
        }
        this.isUp = false;
        this.isDown = false;
    }

    public void press() {
        this.isPressed = true;
    }

    public void release() {
        this.isPressed = false;
        this.isReleased = true;
        if (this.isOnBtn) {
            this.confirm();
        }
    }

    public void confirm() {
        this.isReleased = false;
        if (this.page == 0) {
            preparedText.prepareText(Resources.resTexts[0].getHashedString(9).toUpperCase(), this.rectText.width);
            this.textOffsetY = 0;
            this.page = 1;
        } else {
            this.mainCanvas.changeLastActiveScreen(new ScreenSummary(this.mainCanvas, this.coins, this.distance, this.level, false, true));
        }
        this.mainCanvas.repaint();
    }

    public void loadAll() {
        Resources.loadImages(new int[]{76, 73, 75, 1});
        Resources.loadImages(new int[]{72});
        if (this.isComplete) {
            Resources.loadImages(new int[]{70, 71, 74});
        }
        Resources.loadSprites(new int[]{1, 14, 15, 16, 17, 18, 22});
    }
}

