/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.util.Keys;

public class ScreenSplash
implements IScreen {
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_COMPANY_LOGO = 1;
    private static final int MODE_TIME = 3000;
    private MainCanvas mainCanvas;
    private int mode;
    private long modeDelay;
    boolean isComplete;
    Image imgBg;
    int iKeyCode = 9999;

    public ScreenSplash(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        this.mode = 0;
        this.checkLowMem();
        Resources.loadText(0);
        RMSObjects.createRMSConnect(0);
        if (RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counter = 0; counter < 10; ++counter) {
                }
            }
        }
    }

    public void update(long lastRunLenght) {
        switch (this.mode) {
            case 1: {
                if (this.modeDelay > 0L) {
                    this.modeDelay -= lastRunLenght;
                    return;
                }
                this.nextMode();
            }
        }
    }

    public void checkLowMem() {
        this.isComplete = true;
    }

    private void nextMode() {
        switch (this.mode) {
            case 0: {
                Resources.loadImage(1);
                this.modeDelay = 3000L;
                this.mode = 1;
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
                break;
            }
            case 1: {
                Resources.freeImage(1);
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, true));
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
            }
        }
    }

    public void keyPressed(int keyCode) {
        this.iKeyCode = keyCode;
    }

    public void keyReleased(int keyCode) {
        switch (this.mode) {
            case 0: {
                if (Keys.isFKLeftCode(keyCode)) {
                    MainCanvas.soundManager.SetSoundOn(true);
                    Settings.musicOn = true;
                    RMSObjects.rmsConnects[0].save();
                    RMSObjects.freeRMSConnect(0);
                    this.nextMode();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                MainCanvas.soundManager.SetSoundOn(false);
                Settings.musicOn = false;
                RMSObjects.rmsConnects[0].save();
                RMSObjects.freeRMSConnect(0);
                this.nextMode();
                break;
            }
            case 1: {
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.nextMode();
            }
        }
    }

    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                if (this.isComplete) {
                    Resources.loadImage(70);
                    this.imgBg = Resources.resImgs[70];
                    for (int i = 0; i <= MainCanvas.WIDTH / this.imgBg.getWidth(); ++i) {
                        for (int j = 0; j <= MainCanvas.HEIGHT / this.imgBg.getHeight(); ++j) {
                            g.drawImage(this.imgBg, i * this.imgBg.getWidth(), j * this.imgBg.getHeight(), 20);
                        }
                    }
                } else {
                    g.setColor(8345745);
                    g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                }
                g.setColor(0xFFFFFF);
                g.setFont(Font.getDefaultFont());
                g.drawString(Resources.resTexts[0].getHashedString(5), MainCanvas.WIDTH / 2, MainCanvas.HEIGHT / 2, 17);
                g.drawString(Resources.resTexts[0].getHashedString(6), 2, MainCanvas.HEIGHT - Font.getDefaultFont().getHeight() - 3, 20);
                g.drawString(Resources.resTexts[0].getHashedString(7), MainCanvas.WIDTH - 2, MainCanvas.HEIGHT - Font.getDefaultFont().getHeight() - 3, 24);
                break;
            }
            case 1: {
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.setColor(8345745);
                g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.drawImage(Resources.resImgs[1], MainCanvas.WIDTH / 2, MainCanvas.HEIGHT / 2, 3);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this.mode) {
            case 0: {
                if (x < MainCanvas.WIDTH / 2) {
                    this.mainCanvas.keyPressed(-6);
                    break;
                }
                this.mainCanvas.keyPressed(-7);
                break;
            }
            case 1: {
                this.mainCanvas.keyPressed(53);
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        switch (this.mode) {
            case 0: {
                if (x < MainCanvas.WIDTH / 2) {
                    this.mainCanvas.keyReleased(-6);
                    break;
                }
                this.mainCanvas.keyReleased(-7);
                break;
            }
            case 1: {
                if (!Keys.isKeyPressed(53)) break;
                this.mainCanvas.keyReleased(53);
            }
        }
    }
}

