/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.coords.Coords;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenRealyQuit
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    boolean isComplete;
    public static final int COMP_ID_YES = 0;
    public static final int COMP_ID_NO = 1;
    public static final int TOTAL_COMP_IDS = 2;
    public static final int SPR_YES = 12;
    public static final int SPR_NO = 13;
    public static final int SPR_QUIT2 = 4;
    public static final int[] SPR_ITEMS = new int[]{12, 13};
    Rectangle[] rectItems = new Rectangle[2];
    private int selectedItem;
    public int posX;
    public int posYTitle;
    public int posYMaster;
    public int posYBtnUp;
    public int posYBtnMain;
    public int posYBtnDown;
    public int timerPressed;
    public int timerReleased;
    public int timerSelected;
    public int timerScrolled;
    boolean isPressed;
    boolean isOnMainBtn;
    boolean isLoadingFlag;
    Image imgBtnDown;
    Image imgMaster;
    Image imgCircle;
    Sprite sprIconUp;
    Sprite sprIconMain;
    Sprite sprIconDown;

    public ScreenRealyQuit(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        this.isLoadingFlag = true;
        this.checkLowMem();
        this.coords = new Coords();
        this.imgBtnDown = Resources.resImgs[73];
        this.imgMaster = Resources.resImgs[72];
        this.imgCircle = Resources.resImgs[75];
        this.sprIconUp = Resources.resSprs[15];
        this.sprIconMain = Resources.resSprs[14];
        this.sprIconDown = Resources.resSprs[14];
        this.calculatePositions();
        this.isLoadingFlag = false;
    }

    public void checkLowMem() {
        this.isComplete = false;
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    private void calculatePositions() {
        this.selectedItem = 1;
        this.timerPressed = 0;
        this.timerReleased = 0;
        this.timerSelected = 0;
        this.timerScrolled = 0;
        this.isPressed = false;
        this.posX = MainCanvas.WIDTH >> 1;
        this.posYBtnDown = MainCanvas.HEIGHT - (this.coords.shiftBtnDown + this.coords.shiftMaster);
        this.posYBtnMain = MainCanvas.HEIGHT - (this.coords.shiftBtnMain + this.coords.shiftMaster);
        this.posYBtnUp = MainCanvas.HEIGHT - (this.coords.shiftBtnUp + this.coords.shiftMaster);
        this.posYMaster = MainCanvas.HEIGHT - (this.imgMaster.getHeight() + this.coords.shiftMaster);
        if (this.coords.isTitle) {
            this.posYTitle = MainCanvas.HEIGHT - (this.imgMaster.getHeight() + this.coords.shiftMaster + this.coords.shiftTitle);
        }
        if (!this.isComplete) {
            this.rectItems[0] = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYBtnMain - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
        }
        this.rectItems[1] = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYBtnDown - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        if (!this.isComplete) {
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        this.paintDialog(g);
    }

    public void paintDialog(Graphics g) {
        g.drawImage(this.imgMaster, this.posX, this.posYMaster, 17);
        g.drawImage(this.imgBtnDown, this.posX, this.posYBtnDown, 3);
        this.paintDialogItems(g);
    }

    public void paintDialogItems(Graphics g) {
        this.sprIconUp.setFrame(4);
        this.sprIconUp.setPosition(this.posX - (this.sprIconUp.getWidth() >> 1), this.posYBtnUp - (this.sprIconUp.getHeight() >> 1));
        this.sprIconUp.paint(g);
        this.sprIconMain.setFrame(SPR_ITEMS[this.selectedItem]);
        this.sprIconMain.setPosition(this.posX - (this.sprIconMain.getWidth() >> 1), this.posYBtnMain - (this.sprIconMain.getHeight() >> 1));
        this.sprIconMain.paint(g);
        if (this.selectedItem == 1) {
            this.sprIconDown.setFrame(SPR_ITEMS[0]);
        } else {
            this.sprIconDown.setFrame(SPR_ITEMS[this.selectedItem + 1]);
        }
        this.sprIconDown.setPosition(this.posX - (this.sprIconDown.getWidth() >> 1), this.posYBtnDown - (this.sprIconDown.getHeight() >> 1));
        this.sprIconDown.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (!(MainCanvas.touchActivated || this.isLoadingFlag || this.isPressed)) {
            if (Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode)) {
                this.setDown();
            }
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.press();
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (!MainCanvas.touchActivated && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.isOnMainBtn = true;
            this.release();
        }
    }

    public void setDown() {
        this.selectedItem = (this.selectedItem + 1) % 2;
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        if (this.rectItems[0].contains(x, y)) {
            this.isOnMainBtn = true;
            this.press();
        } else if (this.rectItems[1].contains(x, y)) {
            this.setDown();
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[0].contains(x, y)) {
            this.isOnMainBtn = false;
            this.release();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.rectItems[0].contains(x, y) && this.isPressed && this.isOnMainBtn) {
            this.release();
        }
    }

    public void press() {
        this.isPressed = true;
        this.mainCanvas.repaint();
    }

    public void release() {
        this.isPressed = false;
        this.mainCanvas.repaint();
        this.mainCanvas.serviceRepaints();
        if (this.isOnMainBtn) {
            this.select();
        }
    }

    public void select() {
        this.isOnMainBtn = false;
        switch (this.selectedItem) {
            case 0: {
                X.quitApp();
                this.freeAll();
                break;
            }
            case 1: {
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 6, false));
            }
        }
        this.mainCanvas.repaint();
    }

    public void freeAll() {
        Resources.freeImages(new int[]{76, 73, 75, 1});
        Resources.freeImages(new int[]{72});
        Resources.freeSprites(new int[]{1, 14, 15, 16, 17, 18, 22});
    }
}

