/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.text;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.StringTokenizer;
import sk.inlogic.util.Rectangle;

public class PreparedText {
    private Vector textLines = null;
    private Font font = null;
    private GFont gFont = null;
    private int fontColor = 65280;
    Rectangle clip = new Rectangle();

    public PreparedText(Font font) {
        this.font = font;
    }

    public PreparedText(GFont gFont) {
        this.gFont = gFont;
    }

    private void separateTextToLines(Vector lines, String text, int maxLineWidth) {
        String acceptableStr = "";
        String tokenStr = "";
        String tmpStr = "";
        int tmpStrWidth = 0;
        StringTokenizer st = new StringTokenizer(text, " ");
        while (st.hasMoreTokens()) {
            tokenStr = st.nextToken();
            tmpStr = tmpStr + (tmpStr == "" ? "" : " ") + tokenStr;
            if (this.gFont != null) {
                tmpStrWidth = this.gFont.stringWidth(tmpStr.toCharArray());
            } else if (this.font != null) {
                tmpStrWidth = this.font.stringWidth(tmpStr);
            }
            if (tmpStrWidth <= maxLineWidth) {
                acceptableStr = new String(tmpStr);
                continue;
            }
            lines.addElement(new String(acceptableStr));
            tmpStr = tokenStr;
            acceptableStr = tokenStr;
        }
        lines.addElement(new String(acceptableStr));
    }

    public void prepareText(String text, int maxLineWidth) {
        Vector<String> hardLines = new Vector<String>();
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            hardLines.addElement(st.nextToken());
        }
        this.textLines = new Vector();
        int hardLinesCount = hardLines.size();
        for (int i = 0; i < hardLinesCount; ++i) {
            this.separateTextToLines(this.textLines, (String)hardLines.elementAt(i), maxLineWidth);
        }
    }

    public void drawTextRotated(Graphics g, Rectangle bounds, int offsetY, int anchor) {
        int fontHeight = 0;
        this.clip.x = g.getClipX();
        this.clip.y = g.getClipY();
        this.clip.width = g.getClipWidth();
        this.clip.height = g.getClipHeight();
        g.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
        if (this.gFont != null) {
            fontHeight = this.gFont.getHeight();
        } else if (this.font != null) {
            fontHeight = this.font.getHeight();
        }
        int linesCount = this.textLines.size();
        int x = bounds.x;
        int y = bounds.y;
        if ((anchor & 0x20) == 32) {
            y = bounds.getBottom();
        } else if ((anchor & 2) == 2) {
            int max = 0;
            int id = 0;
            for (int i = 0; i < linesCount; ++i) {
                if (this.textLines.elementAt(i).toString().length() <= max) continue;
                max = this.textLines.elementAt(0).toString().length();
                id = i;
            }
            y = max % 2 == 0 ? bounds.getCenterY() - (this.textLines.elementAt(id).toString().length() >> 1) * fontHeight + (fontHeight >> 1) : bounds.getCenterY() - (this.textLines.elementAt(id).toString().length() >> 1) * fontHeight;
        }
        if ((anchor & 8) == 8) {
            x = bounds.getRight();
        } else if ((anchor & 1) == 1) {
            x = bounds.getCenterX();
        }
        for (int i = 0; i < linesCount; ++i) {
            int j;
            if (this.gFont != null) {
                for (j = 0; j < this.textLines.elementAt(i).toString().length(); ++j) {
                    this.gFont.drawString(g, (this.textLines.elementAt(i).toString().charAt(j) + "").toCharArray(), x - i * (fontHeight + (fontHeight >> 2)) - offsetY, y + j * fontHeight, anchor);
                }
                continue;
            }
            if (this.font == null) continue;
            g.setColor(this.fontColor);
            for (j = 0; j < this.textLines.elementAt(i).toString().length(); ++j) {
                g.drawString(this.textLines.elementAt(i).toString().charAt(j) + "", x - i * (fontHeight + (fontHeight >> 2)) - offsetY, y + j * fontHeight, anchor);
            }
        }
        g.setClip(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public void drawText(Graphics g, Rectangle bounds, int offsetY, int anchor) {
        int fontHeight = 0;
        this.clip.x = g.getClipX();
        this.clip.y = g.getClipY();
        this.clip.width = g.getClipWidth();
        this.clip.height = g.getClipHeight();
        g.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
        if (this.gFont != null) {
            fontHeight = this.gFont.getHeight();
        } else if (this.font != null) {
            fontHeight = this.font.getHeight();
        }
        int linesCount = this.textLines.size();
        int x = bounds.x;
        int y = bounds.y;
        if ((anchor & 0x20) == 32) {
            y = bounds.getBottom();
        } else if ((anchor & 2) == 2) {
            y = bounds.getCenterY();
        }
        if ((anchor & 8) == 8) {
            x = bounds.getRight();
        } else if ((anchor & 1) == 1) {
            x = bounds.getCenterX();
        }
        for (int i = 0; i < linesCount; ++i) {
            if (this.gFont != null) {
                this.gFont.drawString(g, ((String)this.textLines.elementAt(i)).toCharArray(), x, y + i * fontHeight - offsetY, anchor);
                continue;
            }
            if (this.font == null) continue;
            g.setColor(this.fontColor);
            g.drawString((String)this.textLines.elementAt(i), x, y + i * fontHeight - offsetY, anchor);
        }
        g.setClip(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public void setFontColor(int color) {
        this.fontColor = color;
    }

    public int getTextHeight() {
        int fontHeight = 0;
        if (this.gFont != null) {
            fontHeight = this.gFont.getHeight();
        } else if (this.font != null) {
            fontHeight = this.font.getHeight();
        }
        return this.textLines.size() * fontHeight;
    }
}

