/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.fx.SoundManager;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenSplash;
import sk.inlogic.util.Keys;

public class MainCanvas
extends GameCanvas
implements Runnable {
    public static final int FPS = 40;
    public static int WIDTH = 0;
    public static int HEIGHT = 0;
    public static int WIDTH_FROM_DC = 0;
    public static int HEIGHT_FROM_DC = 0;
    public int width = 0;
    public int height = 0;
    private static Thread mainThread;
    private static IScreen activeScreen;
    public long lLastRun;
    private boolean interuptionIn;
    private boolean paintIn;
    private boolean paintPaused;
    private boolean bScreenSizeAdjusted;
    public static boolean isRotated;
    public static SoundManager soundManager;
    public static boolean touchActivated;

    public MainCanvas() {
        super(false);
        activeScreen = null;
        this.initCanvas();
        Keys.canvas = this;
        soundManager = new SoundManager(1);
        soundManager.LoadPlayList(Sounds.GAME_SOUND_FILES, Sounds.GAME_SOUND_TYPES, Sounds.GAME_SOUND_FLAGS);
    }

    private void initCanvas() {
        super.setFullScreenMode(true);
        mainThread = new Thread(this);
        mainThread.start();
        this.interuptionIn = false;
        this.paintIn = false;
        this.paintPaused = false;
        this.bScreenSizeAdjusted = false;
        this.lLastRun = 0L;
        isRotated = WIDTH < HEIGHT;
    }

    public void changeLastActiveScreen(IScreen newScreen) {
        if (newScreen == null || activeScreen == null) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        this.paintPaused = true;
        while (this.paintIn) {
            System.out.println("wait");
        }
        activeScreen.afterHide();
        newScreen.beforeShow();
        activeScreen = newScreen;
        this.paintPaused = false;
    }

    public void addActiveScreen(IScreen screen) {
        if (screen == null) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        screen.beforeShow();
        activeScreen = screen;
    }

    public void removeLastActiveScreen() {
        if (activeScreen == null) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        this.paintPaused = true;
        while (this.paintIn) {
            System.out.println("wait");
        }
        activeScreen = null;
        System.gc();
        this.paintPaused = false;
    }

    public void hideNotify() {
        if (this.interuptionIn) {
            return;
        }
        this.interuptionIn = true;
        soundManager.Stop();
        if (activeScreen != null) {
            activeScreen.beforeInteruption();
        }
    }

    public void showNotify() {
        if (!this.interuptionIn) {
            return;
        }
        this.interuptionIn = false;
        if (activeScreen != null) {
            activeScreen.afterInteruption();
        }
        this.repaint();
    }

    public void run() {
        while (Thread.currentThread() == mainThread) {
            Thread.yield();
            long lTick = System.currentTimeMillis() - this.lLastRun;
            if (lTick < 40L) continue;
            if (System.currentTimeMillis() - this.lLastRun > 3000L) {
                this.hideNotify();
                this.showNotify();
            }
            if (activeScreen != null) {
                activeScreen.update(lTick);
            }
            this.lLastRun = System.currentTimeMillis();
        }
    }

    public void paint(Graphics g) {
        if (this.paintPaused) {
            return;
        }
        if (!this.bScreenSizeAdjusted) {
            HEIGHT = g.getClipHeight();
            WIDTH = g.getClipWidth();
            this.bScreenSizeAdjusted = true;
            this.addActiveScreen(new ScreenSplash(this));
        }
        if (WIDTH_FROM_DC < HEIGHT_FROM_DC && WIDTH > HEIGHT || WIDTH_FROM_DC > HEIGHT_FROM_DC && WIDTH < HEIGHT) {
            this.paintResRotation(g);
            return;
        }
        if (activeScreen != null) {
            this.paintIn = true;
            activeScreen.paint(g);
            this.paintIn = false;
        }
    }

    private void paintResRotation(Graphics g) {
        g.setClip(0, 0, WIDTH, HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, WIDTH, HEIGHT);
        if (Resources.resImgs[2] == null) {
            Resources.loadImage(2);
        } else {
            g.drawImage(Resources.resImgs[2], WIDTH / 2, HEIGHT / 2, 3);
        }
    }

    public void keyPressed(int keyCode) {
        Keys.keyPressed(keyCode);
        if (activeScreen != null) {
            activeScreen.keyPressed(keyCode);
        }
    }

    private void onKeyReleased(int keyCode) {
        if (activeScreen != null) {
            activeScreen.keyReleased(keyCode);
        }
        Keys.keyReleased(keyCode);
    }

    public void keyReleased(int keyCode) {
        this.onKeyReleased(keyCode);
    }

    public void pointerPressed(int x, int y) {
        touchActivated = true;
        if (activeScreen != null) {
            activeScreen.pointerPressed(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (activeScreen != null) {
            activeScreen.pointerDragged(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (activeScreen != null) {
            activeScreen.pointerReleased(x, y);
        }
    }

    static {
        touchActivated = false;
        String fullCanvasSize = "176x206";
        try {
            WIDTH = WIDTH_FROM_DC = Integer.valueOf(fullCanvasSize.substring(0, fullCanvasSize.indexOf("x"))).intValue();
            HEIGHT = HEIGHT_FROM_DC = Integer.valueOf(fullCanvasSize.substring(fullCanvasSize.indexOf("x") + 1)).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

