/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.coords.Coords;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.table.Table;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenAchievements
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    Table table;
    boolean isComplete;
    private Rectangle rectTextDragon;
    private Rectangle rectTextBonus;
    private Rectangle rectText1;
    private Rectangle rectText2;
    private Rectangle rectText3;
    private static PreparedText preparedTextDragon;
    private static PreparedText preparedTextBonus;
    private static PreparedText preparedText1;
    private static PreparedText preparedText2;
    private static PreparedText preparedText3;
    public static final int A_GOOD_SLIDES = 15;
    public static final int A_COINS1 = 200;
    public static final int A_COINS2 = 300;
    public static final int A_COINS3 = 500;
    public static final int A_DRAGON_BALLS = 5;
    public static final int A_ACCELERATIONS = 15;
    public static final int A_TIMES = 15;
    public static final int A_SUSHI = 15;
    public static final int A_DISTANCE1 = 5000;
    public static final int A_DISTANCE2 = 15000;
    public static final int SPR_LOCK2 = 5;
    public static final int SPR_YES = 12;
    public static final int SPR_ARROW = 0;
    public static final int SPR_MARKED = 0;
    Rectangle[] rectItems = new Rectangle[3];
    public int posX;
    public int posYUp;
    public int posYDown;
    public int posXArrowLeft;
    public int posXArrowRight;
    public int posYArrows;
    public int posXMarked;
    public int[] posYMarked = new int[3];
    public int tilesX;
    public int tilesY;
    public int achievement1;
    public int achievement2;
    public int achievement3;
    public int aSushi;
    public int aGoodSlides;
    public int aCoins;
    public int aEnergy;
    public int aClocks;
    public int aDragonBalls;
    public int aSegments;
    public int aImpacts;
    public int aInputTime;
    public int aDistance;
    public int dragonLevel;
    public int page;
    public String dragonText;
    public String achievementText1;
    public String achievementText2;
    public String achievementText3;
    Image imgBg;
    Image imgBtnDown;
    Image imgCircle;
    Sprite sprTable;
    Sprite sprArrow;
    Sprite sprIconDown;
    Sprite sprLock;
    Sprite sprMarked;
    Sprite sprPage;
    boolean isPressed;
    boolean isOnBtn;
    boolean isLoadingFlag;
    boolean isHidden;

    public ScreenAchievements(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        this.isLoadingFlag = true;
        this.checkLowMem();
        this.coords = new Coords();
        this.table = new Table();
        this.load();
        if (this.isComplete) {
            this.imgBg = Resources.resImgs[70];
        }
        this.imgBtnDown = Resources.resImgs[73];
        this.imgCircle = Resources.resImgs[75];
        this.sprTable = Resources.resSprs[1];
        this.sprArrow = Resources.resSprs[16];
        this.sprIconDown = Resources.resSprs[14];
        this.sprLock = Resources.resSprs[15];
        this.sprMarked = Resources.resSprs[18];
        this.sprPage = Resources.resSprs[22];
        Resources.loadGFont(this.coords.gfontMain);
        Resources.loadGFont(this.coords.gfontMain2);
        this.loadAchievements();
        this.calculatePositions();
        this.calculateTable();
        this.calculateContent();
        this.prepare();
        this.isLoadingFlag = false;
    }

    public void load() {
        RMSObjects.createRMSConnect(2);
        if (!RMSObjects.rmsConnects[2].load()) {
            RMSObjects.rmsConnects[2].create();
        }
        RMSObjects.freeRMSConnect(2);
        Resources.loadGFont(this.coords.gfontMain);
        Resources.loadGFont(this.coords.gfontMain2);
    }

    public void checkLowMem() {
        this.isComplete = true;
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    public void calculatePositions() {
        this.isHidden = false;
        this.posX = MainCanvas.WIDTH >> 1;
        this.posYDown = MainCanvas.HEIGHT - (this.coords.shiftBtnDown + this.coords.shiftMaster);
        this.tilesX = (MainCanvas.WIDTH - this.sprTable.getWidth()) / this.sprTable.getWidth();
        this.tilesY = !MainCanvas.isRotated ? this.posYDown / this.sprTable.getHeight() : (this.posYDown - this.sprTable.getHeight()) / this.sprTable.getHeight();
        this.posYUp = this.posYDown - this.tilesY * this.sprTable.getHeight() + (this.sprTable.getHeight() >> 2);
        this.calculateArrows();
    }

    public void calculateTable() {
        int x = MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1;
        int y = this.posYDown - this.tilesY * this.sprTable.getHeight();
        this.table.set(x, y, this.tilesX, this.tilesY, this.sprTable);
    }

    public void calculateContent() {
        int fontHeight = Resources.resGFonts[this.coords.gfontMain].getHeight();
        int fontHeight2 = Resources.resGFonts[this.coords.gfontMain2].getHeight();
        int textMarginLeftDragonName = MainCanvas.WIDTH - (this.tilesX - 2) * this.sprTable.getWidth() >> 1;
        int textMarginTopDragonName = this.posYUp;
        int textWidthDragonName = MainCanvas.WIDTH - (textMarginLeftDragonName << 1);
        int textHeightDragonName = fontHeight << 1;
        this.rectTextDragon = new Rectangle(textMarginLeftDragonName, textMarginTopDragonName, textWidthDragonName, textHeightDragonName);
        int textMarginLeftBonus = (MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1) + (this.sprTable.getWidth() >> 1);
        int textMarginTopBonus = textMarginTopDragonName + textHeightDragonName;
        int textWidthBonus = MainCanvas.WIDTH - (textMarginLeftBonus << 1);
        int textHeightBonus = 0;
        if (this.coords.isBonus) {
            textMarginTopBonus = textMarginTopDragonName + textHeightDragonName + (this.sprTable.getHeight() >> 2);
            textHeightBonus = fontHeight2 << 1;
        }
        this.rectTextBonus = new Rectangle(textMarginLeftBonus, textMarginTopBonus, textWidthBonus, textHeightBonus);
        int contentYUp = textMarginTopBonus + textHeightBonus + (this.sprTable.getHeight() >> 2);
        int contentYDown = this.posYDown - (this.imgCircle.getHeight() >> 1) - (this.sprTable.getHeight() >> 2);
        int space = (contentYDown - contentYUp - (fontHeight2 << 2) - (fontHeight2 << 1)) / 4;
        this.posXMarked = MainCanvas.WIDTH - textMarginLeftBonus - this.sprMarked.getWidth();
        this.posYMarked[0] = contentYUp + space;
        this.posYMarked[1] = this.posYMarked[0] + (fontHeight2 << 1) + space;
        this.posYMarked[2] = this.posYMarked[1] + (fontHeight2 << 1) + space;
        int textMarginLeft = textMarginLeftBonus;
        int textMarginTop1 = this.posYMarked[0];
        int textMarginTop2 = this.posYMarked[1];
        int textMarginTop3 = this.posYMarked[2];
        int textWidth = MainCanvas.WIDTH - (textMarginLeft << 1) - this.sprMarked.getWidth() - (this.sprTable.getWidth() >> 2);
        int textHeight = fontHeight2 << 1;
        if (this.isHidden) {
            textWidth = MainCanvas.WIDTH - (textMarginLeft << 1);
        }
        this.rectText1 = new Rectangle(textMarginLeft, textMarginTop1, textWidth, textHeight);
        this.rectText2 = new Rectangle(textMarginLeft, textMarginTop2, textWidth, textHeight);
        this.rectText3 = new Rectangle(textMarginLeft, textMarginTop3, textWidth, textHeight);
    }

    public void calculateArrows() {
        this.posXArrowLeft = (MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1) + this.sprTable.getWidth();
        this.posXArrowRight = MainCanvas.WIDTH - this.posXArrowLeft - this.sprArrow.getWidth();
        this.posYArrows = this.posYDown - this.sprArrow.getHeight() - (this.sprTable.getHeight() >> 2);
        this.rectItems[0] = new Rectangle(this.posXArrowLeft, this.posYArrows, this.sprArrow.getWidth(), this.sprArrow.getHeight());
        this.rectItems[1] = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYDown - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
        this.rectItems[2] = new Rectangle(this.posXArrowRight, this.posYArrows, this.sprArrow.getWidth(), this.sprArrow.getHeight());
    }

    private void prepare() {
        preparedTextDragon = new PreparedText(Resources.resGFonts[this.coords.gfontMain]);
        preparedText1 = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
        preparedText2 = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
        preparedText3 = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
        if (this.coords.isBonus) {
            preparedTextBonus = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
        }
        this.prepareText();
    }

    public void prepareText() {
        this.prepareTextAchievements();
        this.prepareTextDragon();
        preparedTextDragon.prepareText(this.dragonText, this.rectTextDragon.width);
        if (this.coords.isBonus) {
            preparedTextBonus.prepareText(this.prepareTextBonus(), this.rectTextBonus.width);
        }
        preparedText1.prepareText(this.achievementText1, this.rectText1.width);
        preparedText2.prepareText(this.achievementText2, this.rectText2.width);
        preparedText3.prepareText(this.achievementText3, this.rectText3.width);
    }

    private void prepareTextDragon() {
        String text = "";
        text = this.page == 0 ? Resources.resTexts[0].getHashedString(12).toUpperCase() : (this.page == 1 ? Resources.resTexts[0].getHashedString(13).toUpperCase() : (this.page == 2 ? Resources.resTexts[0].getHashedString(14).toUpperCase() : (this.page == 3 ? Resources.resTexts[0].getHashedString(15).toUpperCase() : (this.page == 4 ? Resources.resTexts[0].getHashedString(16).toUpperCase() : Resources.resTexts[0].getHashedString(17).toUpperCase()))));
        this.dragonText = text.toUpperCase();
    }

    private String prepareTextBonus() {
        String text = "";
        text = this.dragonLevel >= this.page ? (this.page == 0 ? Resources.resTexts[0].getHashedString(18).toUpperCase() : (this.page == 1 ? Resources.resTexts[0].getHashedString(19).toUpperCase() : (this.page == 2 ? Resources.resTexts[0].getHashedString(20).toUpperCase() : (this.page == 3 ? Resources.resTexts[0].getHashedString(21).toUpperCase() : (this.page == 4 ? Resources.resTexts[0].getHashedString(22).toUpperCase() : Resources.resTexts[0].getHashedString(23).toUpperCase()))))) : "?";
        return text;
    }

    private void prepareTextAchievements() {
        String text1 = "";
        String text2 = "";
        String text3 = "";
        if (this.dragonLevel >= this.page) {
            this.isHidden = false;
            if (this.page == 0) {
                text1 = this.aGoodSlides < 15 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(48).toUpperCase() + " " + (15 - this.aGoodSlides) + " " + Resources.resTexts[0].getHashedString(49).toUpperCase() : Resources.resTexts[0].getHashedString(24).toUpperCase();
                text2 = Resources.resTexts[0].getHashedString(30).toUpperCase();
                text3 = Resources.resTexts[0].getHashedString(36).toUpperCase();
            } else if (this.page == 1) {
                text1 = this.aCoins < 200 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(50).toUpperCase() + " " + (200 - this.aCoins) + " " + Resources.resTexts[0].getHashedString(51).toUpperCase() : Resources.resTexts[0].getHashedString(25).toUpperCase();
                text2 = this.aDragonBalls < 5 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(60).toUpperCase() + " " + (5 - this.aDragonBalls) + " " + Resources.resTexts[0].getHashedString(61).toUpperCase() : Resources.resTexts[0].getHashedString(31).toUpperCase();
                text3 = this.aEnergy < 15 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(62).toUpperCase() + " " + (15 - this.aEnergy) + " " + Resources.resTexts[0].getHashedString(63).toUpperCase() : Resources.resTexts[0].getHashedString(37).toUpperCase();
            } else if (this.page == 2) {
                text1 = this.aDistance < 5000 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(52).toUpperCase() + " " + (5000 - this.aDistance) + " " + Resources.resTexts[0].getHashedString(53).toUpperCase() : Resources.resTexts[0].getHashedString(26).toUpperCase();
                text2 = Resources.resTexts[0].getHashedString(32).toUpperCase();
                text3 = this.aClocks < 15 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(64).toUpperCase() + " " + (15 - this.aClocks) + " " + Resources.resTexts[0].getHashedString(65).toUpperCase() : Resources.resTexts[0].getHashedString(38).toUpperCase();
            } else if (this.page == 3) {
                text1 = this.aCoins < 300 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(54).toUpperCase() + " " + (300 - this.aCoins) + " " + Resources.resTexts[0].getHashedString(55).toUpperCase() : Resources.resTexts[0].getHashedString(27).toUpperCase();
                text2 = Resources.resTexts[0].getHashedString(33).toUpperCase();
                text3 = this.aSushi < 15 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(66).toUpperCase() + " " + (15 - this.aSushi) + " " + Resources.resTexts[0].getHashedString(67).toUpperCase() : Resources.resTexts[0].getHashedString(39).toUpperCase();
            } else if (this.page == 4) {
                text1 = this.aDistance < 15000 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(56).toUpperCase() + " " + (15000 - this.aDistance) + " " + Resources.resTexts[0].getHashedString(57).toUpperCase() : Resources.resTexts[0].getHashedString(28).toUpperCase();
                text2 = Resources.resTexts[0].getHashedString(34).toUpperCase();
                text3 = Resources.resTexts[0].getHashedString(40).toUpperCase();
            } else {
                text1 = this.aCoins < 500 && this.dragonLevel <= this.page ? Resources.resTexts[0].getHashedString(58).toUpperCase() + " " + (500 - this.aCoins) + " " + Resources.resTexts[0].getHashedString(59).toUpperCase() : Resources.resTexts[0].getHashedString(29).toUpperCase();
                text2 = Resources.resTexts[0].getHashedString(35).toUpperCase();
                text3 = Resources.resTexts[0].getHashedString(41).toUpperCase();
            }
        } else {
            this.isHidden = true;
            text1 = "?";
            text2 = "?";
            text3 = "?";
        }
        this.achievementText1 = text1.toUpperCase();
        this.achievementText2 = text2.toUpperCase();
        this.achievementText3 = text3.toUpperCase();
    }

    public void loadAchievements() {
        RMSObjects.createRMSConnect(2);
        if (!RMSObjects.rmsConnects[2].load()) {
            RMSObjects.rmsConnects[2].create();
        }
        this.achievement1 = RMSObjects.achievements.getAchievement1();
        this.achievement2 = RMSObjects.achievements.getAchievement2();
        this.achievement3 = RMSObjects.achievements.getAchievement3();
        this.aSushi = RMSObjects.achievements.getASushi();
        this.aGoodSlides = RMSObjects.achievements.getAGoodSlides();
        this.aCoins = RMSObjects.achievements.getACoins();
        this.aEnergy = RMSObjects.achievements.getAEnergy();
        this.aClocks = RMSObjects.achievements.getAClocks();
        this.aDragonBalls = RMSObjects.achievements.getADragonBalls();
        this.aSegments = RMSObjects.achievements.getASegments();
        this.aImpacts = RMSObjects.achievements.getAImpacts();
        this.aInputTime = RMSObjects.achievements.getAInputTime();
        this.aDistance = RMSObjects.achievements.getADistance() / 10;
        RMSObjects.freeRMSConnect(2);
        this.dragonLevel = this.min(this.achievement1, this.achievement2, this.achievement3);
        this.page = this.dragonLevel < 6 ? this.dragonLevel : 5;
    }

    public int min(int a, int b, int c) {
        if (a <= b && a <= c) {
            return a;
        }
        if (b <= a && b <= c) {
            return b;
        }
        return c;
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        if (this.isComplete) {
            for (int i = 0; i <= MainCanvas.WIDTH / this.imgBg.getWidth(); ++i) {
                for (int j = 0; j <= MainCanvas.HEIGHT / this.imgBg.getHeight(); ++j) {
                    g.drawImage(this.imgBg, i * this.imgBg.getWidth(), j * this.imgBg.getHeight(), 20);
                }
            }
        } else {
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        this.paintDialog(g);
    }

    private void paintDialog(Graphics g) {
        this.table.draw(g);
        g.drawImage(this.imgCircle, this.posX, this.posYDown + this.coords.shiftDownCircle, 3);
        g.drawImage(this.imgBtnDown, this.posX, this.posYDown, 3);
        this.paintDialogItems(g);
    }

    private void paintDialogItems(Graphics g) {
        this.sprIconDown.setFrame(12);
        this.sprIconDown.setTransform(0);
        this.sprIconDown.setPosition(this.posX - (this.sprIconDown.getWidth() >> 1), this.posYDown - (this.sprIconDown.getHeight() >> 1));
        this.sprIconDown.paint(g);
        if (this.dragonLevel >= this.page) {
            preparedTextDragon.drawText(g, this.rectTextDragon, 0, 17);
            if (this.coords.isBonus) {
                preparedTextBonus.drawText(g, this.rectTextBonus, 0, 17);
            }
        } else {
            this.sprLock.setFrame(5);
            this.sprLock.setTransform(0);
            this.sprLock.setPosition((MainCanvas.WIDTH >> 1) - (this.sprLock.getWidth() >> 1), this.posYUp);
            this.sprLock.paint(g);
            this.sprPage.setFrame(this.page);
            this.sprPage.setPosition((MainCanvas.WIDTH >> 1) - (this.sprPage.getWidth() >> 1), this.posYUp + this.coords.shiftPage);
            this.sprPage.paint(g);
        }
        this.sprArrow.setFrame(0);
        if (this.page == 0) {
            this.sprArrow.setTransform(3);
            this.sprArrow.setPosition(this.posXArrowRight, this.posYArrows);
            this.sprArrow.paint(g);
        } else if (this.page == 5) {
            this.sprArrow.setTransform(0);
            this.sprArrow.setPosition(this.posXArrowLeft, this.posYArrows);
            this.sprArrow.paint(g);
        } else {
            this.sprArrow.setTransform(0);
            this.sprArrow.setPosition(this.posXArrowLeft, this.posYArrows);
            this.sprArrow.paint(g);
            this.sprArrow.setTransform(3);
            this.sprArrow.setPosition(this.posXArrowRight, this.posYArrows);
            this.sprArrow.paint(g);
        }
        this.sprMarked.setFrame(0);
        this.sprMarked.setTransform(0);
        if (this.dragonLevel > this.page) {
            for (int i = 0; i < 3; ++i) {
                this.sprMarked.setPosition(this.posXMarked, this.posYMarked[i]);
                this.sprMarked.paint(g);
            }
        } else if (this.dragonLevel == this.page) {
            if (this.achievement1 > this.dragonLevel) {
                this.sprMarked.setPosition(this.posXMarked, this.posYMarked[0]);
                this.sprMarked.paint(g);
            }
            if (this.achievement2 > this.dragonLevel) {
                this.sprMarked.setPosition(this.posXMarked, this.posYMarked[1]);
                this.sprMarked.paint(g);
            }
            if (this.achievement3 > this.dragonLevel) {
                this.sprMarked.setPosition(this.posXMarked, this.posYMarked[2]);
                this.sprMarked.paint(g);
            }
        }
        int fontHeight2 = Resources.resGFonts[this.coords.gfontMain2].getHeight();
        if (preparedText1.getTextHeight() > fontHeight2) {
            preparedText1.drawText(g, this.rectText1, 0, 17);
        } else {
            preparedText1.drawText(g, this.rectText1, 0, 3);
        }
        if (preparedText2.getTextHeight() > fontHeight2) {
            preparedText2.drawText(g, this.rectText2, 0, 17);
        } else {
            preparedText2.drawText(g, this.rectText2, 0, 3);
        }
        if (preparedText3.getTextHeight() > fontHeight2) {
            preparedText3.drawText(g, this.rectText3, 0, 17);
        } else {
            preparedText3.drawText(g, this.rectText3, 0, 3);
        }
    }

    public void keyPressed(int keyCode) {
        if (!(MainCanvas.touchActivated || this.isLoadingFlag || this.isPressed)) {
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.isOnBtn = true;
                this.press();
            }
            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                this.isOnBtn = false;
                this.confirmLeft();
            }
            if (Keys.isActionGeneratedByKey(4, keyCode)) {
                this.isOnBtn = false;
                this.confirmRight();
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (!MainCanvas.touchActivated && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.isOnBtn = true;
            this.release();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.rectItems[1].contains(x, y)) {
            this.isOnBtn = true;
            this.press();
        } else if (this.rectItems[0].contains(x, y)) {
            this.isOnBtn = false;
            this.confirmLeft();
        } else if (this.rectItems[2].contains(x, y)) {
            this.isOnBtn = false;
            this.confirmRight();
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[1].contains(x, y)) {
            this.isOnBtn = false;
            this.release();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.rectItems[1].contains(x, y) && this.isPressed && this.isOnBtn) {
            this.release();
        }
    }

    public void press() {
        this.isPressed = true;
    }

    public void release() {
        this.isPressed = false;
        if (this.isOnBtn) {
            this.confirm();
        }
    }

    public void confirmLeft() {
        if (this.page > 0) {
            --this.page;
            this.prepareText();
            this.calculateContent();
            this.prepareText();
            this.mainCanvas.repaint();
        }
    }

    public void confirmRight() {
        if (this.page < 5) {
            ++this.page;
            this.prepareText();
            this.calculateContent();
            this.prepareText();
            this.mainCanvas.repaint();
        }
    }

    public void confirm() {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 2, false));
        this.mainCanvas.repaint();
    }
}

