/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.coords.Coords;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenContinue;
import sk.inlogic.screen.ScreenScore;
import sk.inlogic.table.Table;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSummary
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    Table table;
    boolean isComplete;
    String name = "";
    private Rectangle rectText;
    private static PreparedText preparedText1;
    private static PreparedText preparedText2;
    private static PreparedText preparedText3;
    public static final int SPR_YES = 12;
    public static final int SPR_SCORE2 = 0;
    Rectangle rectItems;
    public static final int COINS_MULTIPLE = 10;
    public static final int DISTANCE_MULTIPLE = 1;
    public static final int LEVEL_MULTIPLE = 100;
    public int coins;
    public int distance;
    public int level;
    public int score;
    public int timerPressed;
    public int timerReleased;
    public int timerSelected;
    public int timerScrolled;
    public int tilesX;
    public int tilesY;
    boolean isSoundOn;
    boolean isLoadAll;
    boolean isLoadingFlag;
    boolean isInfinite;
    boolean isPressed;
    boolean isOnBtn;
    boolean fromMenu;
    public int posX;
    public int posYUp;
    public int posYDown;
    Image imgBtnDown;
    Image imgCircle;
    Sprite sprTable;
    Sprite sprIconUp;
    Sprite sprIconDown;

    public ScreenSummary(MainCanvas mainCanvas, int coins, int distance, int level, boolean isLoadAll, boolean isInfinite) {
        this.mainCanvas = mainCanvas;
        this.coins = coins;
        this.distance = distance;
        this.level = level;
        this.isLoadAll = isLoadAll;
        this.isInfinite = isInfinite;
    }

    public void beforeShow() {
        this.isLoadingFlag = true;
        this.checkLowMem();
        this.coords = new Coords();
        this.table = new Table();
        if (this.isLoadAll) {
            this.loadAll();
        }
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            this.isSoundOn = true;
        } else {
            this.isSoundOn = false;
        }
        this.imgBtnDown = Resources.resImgs[73];
        this.imgCircle = Resources.resImgs[75];
        this.sprTable = Resources.resSprs[1];
        this.sprIconUp = Resources.resSprs[15];
        this.sprIconUp.setFrame(0);
        this.sprIconDown = Resources.resSprs[14];
        this.sprIconDown.setFrame(12);
        if (this.coords.isBigScore) {
            Resources.loadGFont(this.coords.gfontMain);
        } else {
            Resources.loadGFont(this.coords.gfontMain2);
        }
        this.calculatePositions();
        this.calculateTable();
        this.calculateContent();
        this.calculateScore();
        this.loadScore();
        this.saveScore();
        if (this.coords.isBigScore) {
            Resources.loadGFont(this.coords.gfontMain);
            preparedText1 = new PreparedText(Resources.resGFonts[this.coords.gfontMain]);
            preparedText2 = new PreparedText(Resources.resGFonts[this.coords.gfontMain]);
            preparedText3 = new PreparedText(Resources.resGFonts[this.coords.gfontMain]);
        } else {
            Resources.loadGFont(this.coords.gfontMain2);
            preparedText1 = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
            preparedText2 = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
            preparedText3 = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
        }
        preparedText1.prepareText(this.prepareText1(), this.rectText.width);
        preparedText2.prepareText(this.prepareText2(), this.rectText.width);
        preparedText3.prepareText(this.prepareText3(), this.rectText.width);
        this.isLoadingFlag = false;
    }

    public void checkLowMem() {
        this.isComplete = false;
    }

    public void calculateScore() {
        this.score = this.coins * 10 + this.distance / 10 * 1 + (this.level + 1) * 100;
    }

    public void loadScore() {
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].load()) {
            RMSObjects.rmsConnects[1].create();
        }
        RMSObjects.freeRMSConnect(1);
    }

    public void saveScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.userName = this.name;
        scoreItem.scoreValue = this.score;
        scoreItem.scorePos = 0;
        scoreItem.facebookId = 0;
        scoreItem.googleId = 0;
        RMSObjects.localScores.insertScoreItem(scoreItem, true);
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].isExist()) {
            RMSObjects.rmsConnects[1].create();
        }
        RMSObjects.rmsConnects[1].save();
        RMSObjects.freeRMSConnect(1);
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    private void calculatePositions() {
        this.posX = MainCanvas.WIDTH >> 1;
        this.posYDown = MainCanvas.HEIGHT - (this.coords.shiftBtnDown + this.coords.shiftMaster);
        this.tilesX = (MainCanvas.WIDTH - this.sprTable.getWidth()) / this.sprTable.getWidth();
        this.tilesY = !MainCanvas.isRotated ? this.posYDown / this.sprTable.getHeight() : (this.posYDown - this.sprTable.getHeight()) / this.sprTable.getHeight();
        this.posYUp = this.posYDown - this.tilesY * this.sprTable.getHeight() + (this.sprTable.getHeight() >> 2);
        this.rectItems = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYDown - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
    }

    public void calculateTable() {
        int x = MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1;
        int y = this.posYDown - this.tilesY * this.sprTable.getHeight();
        this.table.set(x, y, this.tilesX, this.tilesY, this.sprTable);
    }

    public void calculateContent() {
        int contentYUp = this.posYUp + this.sprIconUp.getHeight() + (this.sprTable.getHeight() >> 2);
        int contentYDown = this.posYDown - (this.imgCircle.getHeight() >> 1) - (this.sprTable.getHeight() >> 2);
        int textMarginLeft = (MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1) + (this.sprTable.getWidth() >> 1);
        int textMarginTop = contentYUp;
        int textWidth = MainCanvas.WIDTH - (textMarginLeft << 1);
        int textHeight = contentYDown - contentYUp;
        this.rectText = new Rectangle(textMarginLeft, textMarginTop + this.coords.shiftSummaryUp, textWidth, textHeight + this.coords.shiftSummaryDown);
    }

    private String prepareText1() {
        String text = "";
        text = this.coords.isLongSummary ? Resources.resTexts[0].getHashedString(71).toUpperCase() + ":\n\n" + Resources.resTexts[0].getHashedString(46).toUpperCase() + ":\n\n" + Resources.resTexts[0].getHashedString(72).toUpperCase() + ": \n--------------------\n" + Resources.resTexts[0].getHashedString(73).toUpperCase() + ":" : Resources.resTexts[0].getHashedString(71).toUpperCase() + ":\n\n" + Resources.resTexts[0].getHashedString(46).toUpperCase() + ":\n\n" + Resources.resTexts[0].getHashedString(72).toUpperCase() + ": \n" + Resources.resTexts[0].getHashedString(73).toUpperCase() + ":";
        return text.toUpperCase();
    }

    private String prepareText2() {
        String text = "";
        text = this.coords.isLongSummary ? "\n" + this.coins + " X " + 10 + " =   \n\n" + (this.level + 1) + " X " + 100 + " =   \n\n" + "--------------------" : "\n" + this.coins + " X " + 10 + " =   \n\n" + (this.level + 1) + " X " + 100 + " =   \n\n";
        return text.toUpperCase();
    }

    private String prepareText3() {
        String text = "";
        text = this.coords.isLongSummary ? "\n" + this.coins * 10 + "\n\n" + (this.level + 1) * 100 + "\n" + this.distance / 10 + "\n" + "--------------------\n" + this.score : "\n" + this.coins * 10 + "\n\n" + (this.level + 1) * 100 + "\n" + this.distance / 10 + "\n" + this.score;
        return text.toUpperCase();
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        if (!this.isComplete) {
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        this.paintDialog(g);
    }

    public void paintDialog(Graphics g) {
        this.table.draw(g);
        g.drawImage(this.imgCircle, this.posX, this.posYDown + this.coords.shiftDownCircle, 3);
        g.drawImage(this.imgBtnDown, this.posX, this.posYDown, 3);
        this.paintDialogItems(g);
    }

    public void paintDialogItems(Graphics g) {
        this.sprIconUp.setPosition(this.posX - (this.sprIconUp.getWidth() >> 1), this.posYUp);
        this.sprIconUp.paint(g);
        this.sprIconDown.setPosition(this.posX - (this.sprIconDown.getWidth() >> 1), this.posYDown - (this.sprIconDown.getHeight() >> 1));
        this.sprIconDown.paint(g);
        int rectTextHeight = this.rectText.height;
        int textHeight = preparedText1.getTextHeight();
        int textOffset = 0;
        if (textHeight < rectTextHeight) {
            textOffset = -((rectTextHeight >> 1) - (textHeight >> 1));
        }
        preparedText1.drawText(g, this.rectText, textOffset, 20);
        preparedText2.drawText(g, this.rectText, textOffset, 17);
        preparedText3.drawText(g, this.rectText, textOffset, 24);
    }

    public void keyPressed(int keyCode) {
        if (!MainCanvas.touchActivated && !this.isLoadingFlag && !this.isPressed && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.press();
        }
    }

    public void keyReleased(int keyCode) {
        if (!MainCanvas.touchActivated && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.isOnBtn = true;
            this.release();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.rectItems.contains(x, y)) {
            this.isOnBtn = true;
            this.press();
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems.contains(x, y)) {
            this.isOnBtn = false;
            this.release();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.rectItems.contains(x, y) && this.isPressed && this.isOnBtn) {
            this.release();
        }
    }

    public void press() {
        this.isPressed = true;
    }

    public void release() {
        this.isPressed = false;
        if (this.isOnBtn) {
            this.confirm();
        }
    }

    public void confirm() {
        if (this.isInfinite) {
            this.mainCanvas.changeLastActiveScreen(new ScreenContinue(this.mainCanvas, false));
        } else {
            this.mainCanvas.changeLastActiveScreen(new ScreenScore(this.mainCanvas, false));
        }
        this.mainCanvas.repaint();
    }

    public void loadAll() {
        Resources.loadImages(new int[]{76, 73, 75, 1});
        Resources.loadImages(new int[]{74});
        Resources.loadSprites(new int[]{1, 14, 15, 16, 17, 18, 22});
    }
}

